/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.io.vfs;

public class FileAttributes {
    public static final int ATTR_READ_ONLY = 1;
    public static final int ATTR_HIDDEN = 2;
    public static final int ATTR_SYSTEM = 4;
    public static final int ATTR_DIRECTORY = 16;
    public static final int ATTR_ARCHIVE = 32;
    private int attributes;
    private long creationTime;
    private long lastAccessTime;
    private long lastWriteTime;

    public final void setAttributes(long creationTime, long lastAccessTime, long lastWriteTime, boolean readOnly, boolean hidden, boolean system, boolean archive, boolean directory) {
        this.attributes = (readOnly ? 1 : 0) | (hidden ? 2 : 0) | (system ? 4 : 0) | (archive ? 32 : 0) | (directory ? 16 : 0);
        this.creationTime = creationTime;
        this.lastAccessTime = lastAccessTime;
        this.lastWriteTime = lastWriteTime;
    }

    public final void setAttributes(long creationTime, long lastAccessTime, long lastWriteTime, int attributes) {
        this.attributes = attributes & 0x37;
        this.creationTime = creationTime;
        this.lastAccessTime = lastAccessTime;
        this.lastWriteTime = lastWriteTime;
    }

    public final boolean isReadOnly() {
        return (this.attributes & 1) != 0;
    }

    public final boolean isHidden() {
        return (this.attributes & 2) != 0;
    }

    public final boolean isSystem() {
        return (this.attributes & 4) != 0;
    }

    public final boolean isArchive() {
        return (this.attributes & 0x20) != 0;
    }

    public final boolean isDirectory() {
        return (this.attributes & 0x10) != 0;
    }

    public final int getAttributes() {
        return this.attributes;
    }

    public final long getCreationTime() {
        return this.creationTime;
    }

    public final long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public final long getLastWriteTime() {
        return this.lastWriteTime;
    }
}

