/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.midp;

import java.io.IOException;
import java.io.OutputStream;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.MIDletProxy;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import malik.emulator.fileformats.graphics.pnglib.PNGEncoder;
import malik.emulator.io.cloud.FileOutputStream;
import malik.emulator.media.graphics.GraphicBuffer;
import malik.emulator.midp.ConsoleCommand;

final class ImageCommand
extends ConsoleCommand
implements Runnable,
CommandListener,
ItemCommandListener,
ItemStateListener {
    private boolean terminated;
    private int imageIndex;
    private Image[] allImages;
    private Command commandCancel;
    private Command commandBack;
    private Command commandSaveDialog;
    private Command commandSaveToFile;
    private Gauge itemLoadingProgress;
    private ImageItem itemCurrentImage;
    private Item itemPrevImage;
    private Item itemNextImage;
    private TextField itemFileNamePNG;
    private Alert screenLoading;
    private Form screenImages;
    private Form screenSavePNG;

    ImageCommand() {
        super("\u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f");
    }

    public void run(String[] arguments) {
        this.terminated = false;
        this.getItemLoadingProgress().setValue(0);
        MIDletProxy.getInstance().getEmulatorScreen().setCurrent(this.getScreenLoading());
        new Thread((Runnable)this, "\u041f\u043e\u0438\u0441\u043a \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0439\u2026").start();
    }

    public void run() {
        ImageItem currentImage;
        Gauge progress = this.itemLoadingProgress;
        if (progress == null) {
            return;
        }
        Object[] memory = Memory.getAllObjects();
        int memoryLength = memory.length;
        int imagesCount = 0;
        int i = 0;
        while (i < memoryLength) {
            if (this.terminated) {
                return;
            }
            if (memory[i] instanceof Image) {
                ++imagesCount;
            }
            progress.setValue((i << 4) / memoryLength);
            ++i;
        }
        Image[] imagesList = new Image[imagesCount];
        imagesCount = 0;
        i = 0;
        while (i < memoryLength) {
            if (this.terminated) {
                return;
            }
            Object current = memory[i];
            if (current instanceof Image) {
                imagesList[imagesCount] = (Image)current;
                ++imagesCount;
            }
            progress.setValue((i << 4) / memoryLength + 16);
            ++i;
        }
        progress.setValue(32);
        this.imageIndex = 0;
        this.allImages = imagesList;
        MIDletProxy.getInstance().getEmulatorScreen().setCurrent(this.getScreenImages());
        if (imagesCount > 0 && (currentImage = this.itemCurrentImage) != null) {
            currentImage.setImage(imagesList[0]);
        }
    }

    public void commandAction(Command command, Displayable screen) {
        block9: {
            block8: {
                Display display = MIDletProxy.getInstance().getEmulatorScreen();
                if (screen == this.screenLoading && command == this.commandCancel) {
                    this.terminated = true;
                    this.allImages = null;
                    this.commandCancel = null;
                    this.itemLoadingProgress = null;
                    this.screenLoading = null;
                    display.setCurrent((Displayable)this.getConsoleScreen());
                    return;
                }
                if (screen == this.screenImages) {
                    if (command == this.commandSaveDialog && this.imageIndex < this.allImages.length) {
                        display.setCurrent(this.getScreenSavePNG());
                        return;
                    }
                    if (command == this.commandBack) {
                        this.allImages = null;
                        this.commandCancel = null;
                        this.commandBack = null;
                        this.commandSaveDialog = null;
                        this.commandSaveToFile = null;
                        this.itemLoadingProgress = null;
                        this.itemCurrentImage = null;
                        this.itemPrevImage = null;
                        this.itemNextImage = null;
                        this.itemFileNamePNG = null;
                        this.screenLoading = null;
                        this.screenImages = null;
                        this.screenSavePNG = null;
                        display.setCurrent((Displayable)this.getConsoleScreen());
                    }
                    return;
                }
                if (screen != this.screenSavePNG) break block8;
                display.setCurrent(this.getScreenImages());
                if (command == this.commandSaveToFile) break block9;
            }
            return;
        }
        String fileName = this.itemFileNamePNG.getString();
        int idx = this.imageIndex;
        Image[] list = this.allImages;
        if (idx < this.allImages.length) {
            new SaveThread(list[idx], fileName).start();
        }
    }

    public void commandAction(Command command, Item item) {
        if (command == List.SELECT_COMMAND) {
            Image[] list = this.allImages;
            int len = this.allImages.length;
            if (len > 0) {
                int idx;
                if (item == this.itemPrevImage) {
                    this.imageIndex = idx = (this.imageIndex + len - 1) % len;
                } else if (item == this.itemNextImage) {
                    this.imageIndex = idx = (this.imageIndex + 1) % len;
                } else {
                    return;
                }
                this.itemCurrentImage.setImage(list[idx]);
            }
        }
    }

    public void itemStateChanged(Item item) {
        TextField field = this.itemFileNamePNG;
        if (item == field) {
            String fileName = field.getString();
            if (fileName != null && fileName.length() <= 0) {
                this.screenSavePNG.removeCommand(this.commandSaveToFile);
                return;
            }
            this.screenSavePNG.addCommand(this.commandSaveToFile);
        }
    }

    private Command getCommandCancel() {
        Command result = this.commandCancel;
        if (result == null) {
            result = this.commandCancel = new Command("\u041e\u0442\u043c\u0435\u043d\u0430", 3, 0);
        }
        return result;
    }

    private Command getCommandBack() {
        Command result = this.commandBack;
        if (result == null) {
            result = this.commandBack = new Command("\u041d\u0430\u0437\u0430\u0434", 2, 0);
        }
        return result;
    }

    private Command getCommandSaveDialog() {
        Command result = this.commandSaveDialog;
        if (result == null) {
            result = this.commandSaveDialog = new Command("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c\u2026", 1, 0);
        }
        return result;
    }

    private Command getCommandSaveToFile() {
        Command result = this.commandSaveToFile;
        if (result == null) {
            result = this.commandSaveToFile = new Command("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c", 4, 0);
        }
        return result;
    }

    private Gauge getItemLoadingProgress() {
        Gauge result = this.itemLoadingProgress;
        if (result == null) {
            result = this.itemLoadingProgress = new Gauge(null, false, 32, 0);
        }
        return result;
    }

    private Displayable getScreenLoading() {
        Alert result = this.screenLoading;
        if (result == null) {
            result = this.screenLoading = new Alert("\u041b\u044e\u0431\u0438\u0442\u0435 \u043a\u0440\u0430\u0441\u0438\u0442\u044c \u043f\u0430\u0441\u0445\u0430\u043b\u044c\u043d\u044b\u0435 \u044f\u0439\u0446\u0430?", null, null, this.getCommandCancel(), (CommandListener)this, "\u041f\u043e\u0438\u0441\u043a \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0439\u2026", null, AlertType.INFO, this.getItemLoadingProgress());
        }
        return result;
    }

    private Displayable getScreenImages() {
        Form result = this.screenImages;
        if (result == null) {
            Font font = Font.getFont((int)0, (int)0, (int)0);
            Item[] itemArray = new Item[3];
            this.itemCurrentImage = new ImageItem(null, null, 515, null);
            itemArray[0] = this.itemCurrentImage;
            itemArray[1] = this.itemPrevImage = new StringItem(3, -1, -1, null, null, List.SELECT_COMMAND, (ItemCommandListener)this, "< \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0435\u0435", font, 2);
            itemArray[2] = this.itemNextImage = new StringItem(3, -1, -1, null, null, List.SELECT_COMMAND, (ItemCommandListener)this, "\u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u0435 >", font, 2);
            Item[] items = itemArray;
            Command[] commands = new Command[]{this.getCommandBack(), this.getCommandSaveDialog()};
            result = this.screenImages = new Form("\u0418\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f", null, commands, (CommandListener)this, items, null);
        }
        return result;
    }

    private Displayable getScreenSavePNG() {
        Form result = this.screenSavePNG;
        if (result == null) {
            TextField fileName;
            Item[] itemArray = new Item[1];
            this.itemFileNamePNG = fileName = new TextField("\u0418\u043c\u044f \u0444\u0430\u0439\u043b\u0430", "/\u0438\u043c\u044f.png", 32, 0);
            itemArray[0] = fileName;
            Item[] items = itemArray;
            Command[] commands = new Command[]{this.getCommandSaveToFile(), this.getCommandBack()};
            result = this.screenSavePNG = new Form("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c", null, commands, (CommandListener)this, items, (ItemStateListener)this);
            fileName.setPreferredSize(result.getWidth(), -1);
        }
        return result;
    }

    private static final class SaveThread
    extends Thread {
        private Image image;
        private String fileName;

        SaveThread(Image image, String fileName) {
            super("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f\u2026");
            this.image = image;
            this.fileName = fileName;
        }

        public void run() {
            String fileName = this.fileName;
            GraphicBuffer buf = this.image.getBuffer();
            try {
                System.out.println("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f \u0432 \u0444\u0430\u0439\u043b " + fileName + "\u2026");
                PNGEncoder encoder = new PNGEncoder();
                encoder.setPixels(true, buf.getWidth(), buf.getHeight(), buf.getPixels());
                FileOutputStream file = new FileOutputStream(fileName);
                file.checkOpenError();
                try {
                    encoder.saveToOutputStream((OutputStream)file);
                }
                finally {
                    file.close();
                }
                System.out.println("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f \u0432 \u0444\u0430\u0439\u043b " + fileName + " \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e.");
            }
            catch (IOException e) {
                e.printRealStackTrace();
                System.out.println("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f \u0432 \u0444\u0430\u0439\u043b " + fileName + " \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e \u0441 \u043e\u0448\u0438\u0431\u043a\u0430\u043c\u0438.");
            }
        }
    }
}

