/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.midp.protocol.sms;

import java.util.QueueOfObjects;
import javax.wireless.messaging.BinaryMessage;
import javax.wireless.messaging.Message;
import javax.wireless.messaging.MessageConnection;
import javax.wireless.messaging.MessageListener;
import javax.wireless.messaging.TextMessage;
import malik.emulator.io.j2me.ImplementationManager;
import malik.emulator.io.j2me.InboundConnection;
import malik.emulator.io.j2me.VirtualConnectionFactory;
import malik.emulator.midp.protocol.URLParser;
import malik.emulator.midp.protocol.sms.ClientMessageConnection;
import malik.emulator.midp.protocol.sms.MessageOfBytes;
import malik.emulator.midp.protocol.sms.MessageOfChars;
import malik.emulator.midp.protocol.sms.ServerMessageConnection;

final class MessageDeliveryEvent
implements Runnable {
    private static final String LOCAL_HOST_SMS_ADDRESS = "sms://:1200";
    private ClientMessageConnection sender;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void pushReceivedMessage(ServerMessageConnection recipient, Message receivedMessage) {
        QueueOfObjects messagesQueue;
        QueueOfObjects queueOfObjects = messagesQueue = recipient.incomingMessages;
        synchronized (messagesQueue) {
            messagesQueue.push((Object)receivedMessage);
            messagesQueue.notify();
            // ** MonitorExit[var4_3] (shouldn't be in output)
            MessageListener listener = recipient.listener;
            if (listener != null) {
                listener.notifyIncomingMessage((MessageConnection)recipient);
            }
            return;
        }
    }

    private static ServerMessageConnection getRecipient(String url) {
        ServerMessageConnection result;
        VirtualConnectionFactory factory = ImplementationManager.getConnectionFactory();
        if (url == null) {
            return (ServerMessageConnection)factory.getInboundConnection("sms", 1200);
        }
        try {
            InboundConnection connection;
            URLParser urlParser = new URLParser();
            urlParser.parse(url);
            String protocol = urlParser.getProtocol();
            String remoteHost = urlParser.getHostName();
            int remotePort = urlParser.getPort();
            result = (ServerMessageConnection)(protocol != null && "sms".equalsIgnoreCase(protocol) && (remoteHost == null || remoteHost.length() <= 0) && remotePort >= 0 && remotePort <= 65535 && (connection = factory.getInboundConnection("sms", remotePort)) instanceof ServerMessageConnection ? connection : factory.getInboundConnection("sms", 1200));
        }
        catch (RuntimeException e) {
            e.printRealStackTrace();
            result = (ServerMessageConnection)factory.getInboundConnection("sms", 1200);
        }
        return result;
    }

    private static Message createReceivedMessage(Message sentMessage) {
        if (sentMessage instanceof BinaryMessage) {
            return new MessageOfBytes(LOCAL_HOST_SMS_ADDRESS, ((BinaryMessage)sentMessage).getPayloadData());
        }
        if (sentMessage instanceof TextMessage) {
            return new MessageOfChars(LOCAL_HOST_SMS_ADDRESS, ((TextMessage)sentMessage).getPayloadText());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Message extractSentMessage(ClientMessageConnection sender) {
        Message result;
        QueueOfObjects messagesQueue = sender.outgoingMessages;
        if (messagesQueue.isEmpty()) {
            return null;
        }
        QueueOfObjects queueOfObjects = messagesQueue;
        synchronized (queueOfObjects) {
            result = (Message)messagesQueue.peek();
            messagesQueue.removeTailElement();
        }
        return result;
    }

    MessageDeliveryEvent(ClientMessageConnection sender) {
        this.sender = sender;
    }

    public void run() {
        Message sentMessage = MessageDeliveryEvent.extractSentMessage(this.sender);
        if (sentMessage == null) {
            System.err.println("MessageConnection: \u043d\u0435\u0442 \u0438\u0441\u0445\u043e\u0434\u044f\u0449\u0438\u0445 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439.");
            return;
        }
        Message receivedMessage = MessageDeliveryEvent.createReceivedMessage(sentMessage);
        if (receivedMessage == null) {
            System.err.println("MessageConnection: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u0434\u043b\u044f \u043f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044f.");
            return;
        }
        MessageDeliveryEvent.pushReceivedMessage(MessageDeliveryEvent.getRecipient(sentMessage.getAddress()), receivedMessage);
    }
}

