/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.Screen;
import javax.microedition.lcdui.ScreenGraphics;
import malik.emulator.application.KeyboardEvent;
import malik.emulator.application.PointerEvent;
import malik.emulator.media.graphics.RasterCanvas;
import malik.emulator.microedition.lcdui.MultilinedStringBuilder;
import malik.emulator.util.StringBuilder;

public abstract class Item {
    private static final char LABEL_END = ':';
    private static final int LAYOUT_MASK = -32564;
    public static final int LAYOUT_DEFAULT = 0;
    public static final int LAYOUT_LEFT = 1;
    public static final int LAYOUT_RIGHT = 2;
    public static final int LAYOUT_CENTER = 3;
    public static final int LAYOUT_TOP = 16;
    public static final int LAYOUT_BOTTOM = 32;
    public static final int LAYOUT_VCENTER = 48;
    public static final int LAYOUT_NEWLINE_BEFORE = 256;
    public static final int LAYOUT_NEWLINE_AFTER = 512;
    public static final int LAYOUT_SHRINK = 1024;
    public static final int LAYOUT_EXPAND = 2048;
    public static final int LAYOUT_VSHRINK = 4096;
    public static final int LAYOUT_VEXPAND = 8192;
    public static final int LAYOUT_2 = 16384;
    public static final int PLAIN = 0;
    public static final int HYPERLINK = 1;
    public static final int BUTTON = 2;
    static final int LEFT = 0;
    static final int TOP = 1;
    static final int WIDTH = 2;
    static final int HEIGHT = 3;
    static final int DIR_NONE = 0;
    static final int DIR_UP = 1;
    static final int DIR_DOWN = 6;
    static final int DIR_LEFT = 2;
    static final int DIR_RIGHT = 5;
    private static final long WIDTH_MASK = 0xFFFFFFFFL;
    private static final long HEIGHT_MASK = -4294967296L;
    static final Font LABEL_FONT = Font.getFont(0);
    static final Object OWNER_MONITOR = new Object();
    boolean newLine;
    boolean visible;
    int left;
    int top;
    int width;
    int height;
    int minimumWidth;
    int minimumHeight;
    private int layout;
    private long preferredSize;
    private long copyPreferredSize;
    private long minimumContentSize;
    private long currentContentSize;
    private long previousContentSize;
    private char[] buffer;
    Screen owner;
    private ItemCommandListener listener;
    private String labelAsString;
    private final MultilinedStringBuilder labelAsBuilder;
    private final CommandList commands;

    private static void writeLabel(StringBuilder builder, String label) {
        int len;
        builder.clear();
        if (label != null && (len = label.length()) > 0) {
            builder.append(label);
            if (label.charAt(len - 1) != ':') {
                builder.append(':');
            }
        }
    }

    private static long packSize(int width, int height) {
        return (long)width & 0xFFFFFFFFL | (long)height << 32;
    }

    Item() {
        this(null, 0);
    }

    Item(String label) {
        this(label, 0);
    }

    Item(String label, int layout) {
        MultilinedStringBuilder builder;
        if ((layout & 0xFFFF80CC) != 0) {
            throw new IllegalArgumentException("Item: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 layout \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        this.layout = layout;
        this.preferredSize = -1L;
        this.previousContentSize = -1L;
        this.labelAsString = label;
        this.labelAsBuilder = builder = new MultilinedStringBuilder();
        this.commands = new CommandList();
        Item.writeLabel(builder, label);
    }

    public void notifyStateChanged() {
        Screen owner = this.owner;
        if (owner == null) {
            throw new IllegalStateException("Item.notifyStateChanged: \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u043d\u0435 \u043f\u0440\u0438\u043d\u0430\u0434\u043b\u0435\u0436\u0438\u0442 \u043a\u0430\u043a\u043e\u043c\u0443-\u043b\u0438\u0431\u043e \u044d\u043a\u0440\u0430\u043d\u0443.");
        }
        owner.requestStateChanged(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommand(Command command) {
        Screen owner = this.owner;
        if (owner != null && !owner.focusSupported()) {
            throw new IllegalStateException("Item.addCommand: \u044d\u043a\u0440\u0430\u043d-\u0432\u043b\u0430\u0434\u0435\u043b\u0435\u0446 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0443 \u0444\u043e\u043a\u0443\u0441\u0430 \u0432\u0432\u043e\u0434\u0430 \u043d\u0430 \u044d\u043b\u0435\u043c\u0435\u043d\u0442.");
        }
        if (command == null) {
            throw new NullPointerException("Item.addCommand: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 command \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Object object = Command.MONITOR;
        synchronized (object) {
            this.commands.addCommand(command);
        }
        if (owner != null && owner.isFocused(this)) {
            owner.placeCommands();
            owner.requestPaintAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCommand(Command command) {
        if (command == null) {
            return;
        }
        Object object = Command.MONITOR;
        synchronized (object) {
            this.commands.removeCommand(command);
        }
        Screen owner = this.owner;
        if (owner != null && owner.isFocused(this)) {
            owner.placeCommands();
            owner.requestPaintAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultCommand(Command command) {
        Screen owner = this.owner;
        if (owner != null && !owner.focusSupported()) {
            throw new IllegalStateException("Item.setDefaultCommand: \u044d\u043a\u0440\u0430\u043d-\u0432\u043b\u0430\u0434\u0435\u043b\u0435\u0446 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0443 \u0444\u043e\u043a\u0443\u0441\u0430 \u0432\u0432\u043e\u0434\u0430 \u043d\u0430 \u044d\u043b\u0435\u043c\u0435\u043d\u0442.");
        }
        Object object = Command.MONITOR;
        synchronized (object) {
            this.commands.setDefaultCommand(command);
        }
        if (owner != null && owner.isFocused(this)) {
            owner.placeCommands();
            owner.requestPaintAll();
        }
    }

    public void setItemCommandListener(ItemCommandListener listener) {
        Screen owner = this.owner;
        if (owner != null && !owner.focusSupported()) {
            throw new IllegalStateException("Item.setItemCommandListener: \u044d\u043a\u0440\u0430\u043d-\u0432\u043b\u0430\u0434\u0435\u043b\u0435\u0446 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0443 \u0444\u043e\u043a\u0443\u0441\u0430 \u0432\u0432\u043e\u0434\u0430 \u043d\u0430 \u044d\u043b\u0435\u043c\u0435\u043d\u0442.");
        }
        this.listener = listener;
    }

    public void setPreferredSize(int width, int height) {
        Screen owner = this.owner;
        if (owner != null && !owner.focusSupported()) {
            throw new IllegalStateException("Item.setPreferredSize: \u044d\u043a\u0440\u0430\u043d-\u0432\u043b\u0430\u0434\u0435\u043b\u0435\u0446 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0443 \u0444\u043e\u043a\u0443\u0441\u0430 \u0432\u0432\u043e\u0434\u0430 \u043d\u0430 \u044d\u043b\u0435\u043c\u0435\u043d\u0442.");
        }
        if (width < -1) {
            throw new IllegalArgumentException("Item.setPreferredSize: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 width \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 (-1).");
        }
        if (height < -1) {
            throw new IllegalArgumentException("Item.setPreferredSize: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 height \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 (-1).");
        }
        this.preferredSize = Item.packSize(width, height);
        if (owner != null) {
            owner.requestInvalidate();
        }
    }

    public void setLayout(int layout) {
        Screen owner = this.owner;
        if (owner != null && !owner.focusSupported()) {
            throw new IllegalStateException("Item.setLayout: \u044d\u043a\u0440\u0430\u043d-\u0432\u043b\u0430\u0434\u0435\u043b\u0435\u0446 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0443 \u0444\u043e\u043a\u0443\u0441\u0430 \u0432\u0432\u043e\u0434\u0430 \u043d\u0430 \u044d\u043b\u0435\u043c\u0435\u043d\u0442.");
        }
        if ((layout & 0xFFFF80CC) != 0) {
            throw new IllegalArgumentException("Item.setLayout: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 layout \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        this.layout = layout;
        if (owner != null) {
            owner.requestInvalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLabel(String label) {
        MultilinedStringBuilder builder;
        Screen owner = this.owner;
        if (owner != null && !owner.focusSupported()) {
            throw new IllegalStateException("Item.setLabel: \u044d\u043a\u0440\u0430\u043d-\u0432\u043b\u0430\u0434\u0435\u043b\u0435\u0446 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0443 \u0444\u043e\u043a\u0443\u0441\u0430 \u0432\u0432\u043e\u0434\u0430 \u043d\u0430 \u044d\u043b\u0435\u043c\u0435\u043d\u0442.");
        }
        MultilinedStringBuilder multilinedStringBuilder = builder = this.labelAsBuilder;
        synchronized (builder) {
            this.labelAsString = label;
            Item.writeLabel(builder, label);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (owner != null) {
                owner.requestInvalidate();
            }
            return;
        }
    }

    public int getMinimumWidth() {
        return this.minimumWidth;
    }

    public int getMinimumHeight() {
        return this.minimumHeight;
    }

    public int getPreferredWidth() {
        int result = (int)this.preferredSize;
        return result < 0 ? this.width : result;
    }

    public int getPreferredHeight() {
        int result = (int)(this.preferredSize >> 32);
        return result < 0 ? this.height : result;
    }

    public int getLayout() {
        return this.layout;
    }

    public String getLabel() {
        return this.labelAsString;
    }

    abstract void paint(Graphics var1, int var2, int var3);

    abstract int getMinimumContentWidth();

    abstract int getMinimumContentHeight();

    abstract int getPreferredContentWidth(int var1);

    abstract int getPreferredContentHeight(int var1);

    void onShow() {
    }

    void onHide() {
    }

    void onSizeChanged(int contentWidth, int contentHeight) {
    }

    void onCommandAction(Command command) {
        ItemCommandListener listener = this.listener;
        if (listener != null) {
            listener.commandAction(command, this);
        }
    }

    void onKeyboardEvent(KeyboardEvent event) {
    }

    void onPointerEvent(PointerEvent event) {
    }

    void onFocusLost() {
    }

    boolean onFocusMove(int direction, int viewportWidth, int viewportHeight, int[] visibleRectangle) {
        return false;
    }

    boolean hasRowBreakAfter(int layout, int alignment) {
        int actual;
        return (layout & 0x200) != 0 || (actual = layout & 3) != 0 && actual != alignment;
    }

    boolean hasRowBreakBefore(int layout, int alignment) {
        int actual;
        return (layout & 0x100) != 0 || (actual = layout & 3) != 0 && actual != alignment;
    }

    int getDefaultLayout() {
        return 0;
    }

    final void onPaint(ScreenGraphics render) {
        try {
            int clipLeft = render.getClipX();
            int clipTop = render.getClipY();
            int clipWidth = render.getClipWidth();
            int clipHeight = render.getClipHeight();
            int translateX = render.getTranslateX();
            int translateY = render.getTranslateY();
            long contentSize = this.currentContentSize;
            int contentWidth = (int)contentSize;
            int contentHeight = (int)(contentSize >> 32);
            int labelHeight = this.height - contentHeight;
            if (clipTop < labelHeight) {
                this.paintLabel(render, this.width, labelHeight, clipTop, clipHeight);
            }
            if (contentWidth > 0 && contentHeight > 0 && clipTop + clipHeight > labelHeight && clipLeft < contentWidth) {
                int diff = labelHeight - clipTop;
                if (diff > 0) {
                    clipTop += diff;
                    clipHeight -= diff;
                }
                if (clipLeft + clipWidth > contentWidth) {
                    clipWidth = contentWidth - clipLeft;
                }
                clipTop += translateY;
                render.reset();
                render.restricts(clipLeft += translateX, clipTop, clipWidth, clipHeight);
                render.setStartPoint(translateX, translateY += labelHeight);
                render.setClip(clipLeft, clipTop, clipWidth, clipHeight);
                render.translate(translateX, translateY);
                this.paint(render, contentWidth, contentHeight);
            }
        }
        catch (RuntimeException e) {
            e.printRealStackTrace();
        }
    }

    final void onSizeChanged() {
        long contentSize = this.getContentSize();
        if (this.previousContentSize != contentSize) {
            this.previousContentSize = contentSize;
            this.onSizeChanged((int)contentSize, (int)(contentSize >> 32));
        }
    }

    final void requestPaint() {
        Screen owner = this.owner;
        if (owner != null && this.visible) {
            owner.requestPaint((byte)2);
        }
    }

    final void requestInvalidate() {
        Screen owner = this.owner;
        if (owner != null) {
            owner.requestInvalidate();
        }
    }

    final void requestDefaultCommandAction() {
        Command command;
        Screen owner = this.owner;
        if (owner != null && (command = this.commands.defaultCommand()) != null) {
            owner.requestAction(new Runnable(){

                public void run() {
                    Item.this.onCommandAction(command);
                }
            });
        }
    }

    final void resetContentSize() {
        this.currentContentSize = -1L;
    }

    final void writeContentRectangleTo(int[] rect) {
        long contentSize = this.currentContentSize;
        rect[0] = 0;
        int itemHeight = this.height;
        rect[1] = itemHeight - (int)(contentSize >> 32);
        rect[2] = (int)contentSize;
        rect[3] = itemHeight;
    }

    final boolean hasLabel() {
        return this.labelAsString != null;
    }

    final int suppliedLayout() {
        return this.layout;
    }

    final int suppliedPreferredWidth() {
        long copy = this.copyPreferredSize = this.preferredSize;
        return (int)copy;
    }

    final int suppliedPreferredHeight() {
        return (int)(this.copyPreferredSize >> 32);
    }

    final int computeMinimumWidth() {
        int minLabelWidth = this.getMinimumLabelWidth();
        int minContentWidth = this.getMinimumContentWidth();
        this.minimumContentSize = this.minimumContentSize & 0xFFFFFFFF00000000L | (long)minContentWidth;
        return minLabelWidth < minContentWidth ? minContentWidth : minLabelWidth;
    }

    final int computeMinimumHeight() {
        int minLabelHeight = this.getMinimumLabelHeight();
        int minContentHeight = this.getMinimumContentHeight();
        this.minimumContentSize = this.minimumContentSize & 0xFFFFFFFFL | (long)minContentHeight << 32;
        return minLabelHeight + minContentHeight;
    }

    final int computePreferredWidth(int height) {
        int minSize;
        int prefContentWidth;
        int maxWidth = this.width;
        long prefLabelSize = this.getPreferredLabelSize(height < 0 ? 100 : maxWidth);
        int prefLabelWidth = (int)prefLabelSize;
        int prefLabelHeight = (int)(prefLabelSize >> 32);
        if (height >= 0) {
            int n = height = height > prefLabelHeight ? height - prefLabelHeight : 0;
        }
        if ((prefContentWidth = this.getPreferredContentWidth(height)) < (minSize = (int)this.minimumContentSize)) {
            prefContentWidth = minSize;
        }
        if (height >= 0 && prefContentWidth > maxWidth) {
            prefContentWidth = maxWidth;
        }
        this.currentContentSize = Item.packSize(prefContentWidth, height);
        return prefLabelWidth < prefContentWidth ? prefContentWidth : prefLabelWidth;
    }

    final int computePreferredHeight(int width) {
        int minSize;
        int prefLabelHeight = this.getPreferredLabelHeight(width);
        int prefContentHeight = this.getPreferredContentHeight(width);
        if (prefContentHeight < (minSize = (int)(this.minimumContentSize >> 32))) {
            prefContentHeight = minSize;
        }
        this.currentContentSize = Item.packSize(width, prefContentHeight);
        return prefLabelHeight + prefContentHeight;
    }

    final Command.Owner getCommands() {
        return this.commands;
    }

    final ItemCommandListener getListener() {
        return this.listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintLabel(Graphics render, int labelWidth, int labelHeight, int clipTop, int clipHeight) {
        MultilinedStringBuilder builder;
        Font font = LABEL_FONT;
        int line = font.getHeight();
        int srow = clipTop / line;
        int frow = (clipTop + clipHeight - 1) / line;
        render.setFont(font);
        render.setColor(RasterCanvas.getSystemColor((int)40));
        MultilinedStringBuilder multilinedStringBuilder = builder = this.labelAsBuilder;
        synchronized (builder) {
            char[] lbuf = this.buffer;
            builder.split(font, labelWidth);
            int len = builder.lines();
            int top = srow * line;
            int index = srow;
            while (index <= frow && index < len) {
                int lofs = builder.lineOffset(index);
                int llen = builder.lineLength(index);
                if (lbuf == null || lbuf.length < llen) {
                    lbuf = this.buffer = new char[StringBuilder.optimalCapacity((int)llen)];
                }
                builder.copy(lofs, lofs + llen, lbuf, 0);
                render.drawChars(lbuf, 0, llen, 0, top, 20);
                top += line;
                ++index;
            }
            // ** MonitorExit[var11_11] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getMinimumLabelWidth() {
        MultilinedStringBuilder builder;
        int result = 0;
        MultilinedStringBuilder multilinedStringBuilder = builder = this.labelAsBuilder;
        synchronized (builder) {
            if (!builder.isEmpty()) {
                result = 100;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getMinimumLabelHeight() {
        MultilinedStringBuilder builder;
        int result = 0;
        MultilinedStringBuilder multilinedStringBuilder = builder = this.labelAsBuilder;
        synchronized (builder) {
            if (!builder.isEmpty()) {
                Font font = LABEL_FONT;
                builder.split(font, Integer.MAX_VALUE);
                result = font.getHeight() * builder.lines();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getPreferredLabelHeight(int labelWidth) {
        MultilinedStringBuilder builder;
        int result = 0;
        MultilinedStringBuilder multilinedStringBuilder = builder = this.labelAsBuilder;
        synchronized (builder) {
            if (!builder.isEmpty()) {
                Font font = LABEL_FONT;
                builder.split(font, labelWidth >= 0 ? labelWidth : Integer.MAX_VALUE);
                result = font.getHeight() * builder.lines();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getPreferredLabelSize(int labelWidth) {
        MultilinedStringBuilder builder;
        int width = 0;
        int height = 0;
        MultilinedStringBuilder multilinedStringBuilder = builder = this.labelAsBuilder;
        synchronized (builder) {
            if (!builder.isEmpty()) {
                Font font = LABEL_FONT;
                builder.split(font, labelWidth);
                width = 100;
                int index = builder.lines();
                height = font.getHeight() * index;
                char[] lbuf = this.buffer;
                while (index-- > 0) {
                    int lofs = builder.lineOffset(index);
                    int llen = builder.lineLength(index);
                    if (lbuf == null || lbuf.length < llen) {
                        lbuf = this.buffer = new char[StringBuilder.optimalCapacity((int)llen)];
                    }
                    builder.copy(lofs, lofs + llen, lbuf, 0);
                    int lwid = font.charsWidth(lbuf, 0, llen);
                    if (width >= lwid) continue;
                    width = lwid;
                }
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return Item.packSize(width, height);
        }
    }

    private long getContentSize() {
        long contentSize = this.currentContentSize;
        int contentWidth = (int)contentSize;
        int contentHeight = (int)(contentSize >> 32);
        if (contentWidth < 0) {
            int itemWidth = this.width;
            int itemHeight = this.height;
            long labelSize = this.getPreferredLabelSize(itemWidth);
            int labelWidth = (int)labelSize;
            int labelHeight = (int)(labelSize >> 32);
            if (contentHeight < 0) {
                int n = contentHeight = labelHeight < itemHeight ? itemHeight - labelHeight : 0;
            }
            if (labelWidth < itemWidth) {
                contentWidth = itemWidth;
            } else {
                contentWidth = (int)this.preferredSize;
                int minSize = (int)this.minimumContentSize;
                if (contentWidth < minSize && (contentWidth = this.getPreferredContentWidth(contentHeight)) < minSize) {
                    contentWidth = minSize;
                }
            }
            if (contentWidth > itemWidth) {
                contentWidth = itemWidth;
            }
        } else if (contentHeight < 0) {
            int itemWidth = this.width;
            int itemHeight = this.height;
            int labelHeight = this.getPreferredLabelHeight(itemWidth);
            contentHeight = labelHeight < itemHeight ? itemHeight - labelHeight : 0;
        } else {
            return contentSize;
        }
        this.currentContentSize = Item.packSize(contentWidth, contentHeight);
        return this.currentContentSize;
    }

    private static final class CommandList
    implements Command.Owner {
        private int commandSize;
        private Command[] commandList = new Command[7];
        private Command commandDefault;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isMyOwnedCommand(Command command) {
            boolean result;
            Object object = Command.MONITOR;
            synchronized (object) {
                result = command != null && (command == this.commandDefault || Array.findf((Object[])this.commandList, (int)0, (Object)command) < this.commandSize);
            }
            return result;
        }

        public int size() {
            return this.commandSize;
        }

        public Command commandAt(int index) {
            return index >= 0 && index < this.commandSize ? this.commandList[index] : null;
        }

        public Command defaultCommand() {
            return this.commandDefault;
        }

        public void addCommand(Command command) {
            int len;
            Object[] commands;
            block5: {
                block4: {
                    if (command == null || command == this.commandDefault) break block4;
                    commands = this.commandList;
                    len = this.commandSize;
                    if (Array.findf((Object[])this.commandList, (int)0, (Object)command) >= len) break block5;
                }
                return;
            }
            if (len == commands.length) {
                Object[] objectArray = commands;
                this.commandList = new Command[(len << 1) + 1];
                commands = this.commandList;
                Array.copy((Object[])objectArray, (int)0, (Object[])this.commandList, (int)0, (int)len);
            }
            commands[len++] = command;
            this.commandSize = len;
        }

        public void removeCommand(Command command) {
            int len;
            if (command == null) {
                return;
            }
            if (command == this.commandDefault) {
                this.commandDefault = null;
                return;
            }
            Object[] commands = this.commandList;
            int index = Array.findf((Object[])this.commandList, (int)0, (Object)command);
            if (index > (len = this.commandSize - 1)) {
                return;
            }
            if (index < len) {
                Array.copy((Object[])commands, (int)(index + 1), (Object[])commands, (int)index, (int)(len - index));
            }
            commands[len] = null;
            this.commandSize = len;
        }

        public void setDefaultCommand(Command command) {
            Command previous = this.commandDefault;
            this.commandDefault = null;
            this.addCommand(previous);
            this.removeCommand(command);
            this.commandDefault = command;
        }
    }
}

