/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import malik.emulator.fileformats.graphics.ImageDecoder;
import malik.emulator.io.jar.ResourceNotFoundException;
import malik.emulator.media.graphics.RasterBuffer;
import malik.emulator.microedition.DeviceManager;
import malik.emulator.util.StringBuilder;

public class Image {
    private final boolean mutable;
    final int width;
    final int height;
    private final int[] pixels;
    final RasterBuffer buffer;

    public static Image createImage(int width, int height) {
        if (width <= 0) {
            throw new IllegalArgumentException("Image.createImage: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 width \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        if (height <= 0) {
            throw new IllegalArgumentException("Image.createImage: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 height \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        int area = width * height;
        int[] pixels = new int[area];
        Array.fill((int[])pixels, (int)0, (int)area, (int)-1);
        return new Image(pixels, width, height, true);
    }

    public static Image createImage(byte[] src, int offset, int length) {
        ImageDecoder decoder;
        if (src == null) {
            throw new NullPointerException("Image.createImage: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Array.checkBound((String)"Image.createImage", (int)src.length, (int)offset, (int)length);
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(src, offset, length);
            decoder = DeviceManager.getInstance().openImageDecoder(stream);
            decoder.loadFromInputStream((InputStream)stream);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Image.createImage: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0434\u0435\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435.");
        }
        int width = decoder.getWidth();
        int height = decoder.getHeight();
        int[] pixels = decoder.getPixels();
        if (!decoder.alphaSupported()) {
            int i = width * height;
            while (i-- > 0) {
                int n = i;
                pixels[n] = pixels[n] | 0xFF000000;
            }
        }
        return new Image(pixels, width, height, false);
    }

    public static Image createImage(InputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("Image.createImage: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 stream \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        ImageDecoder decoder = DeviceManager.getInstance().openImageDecoder(stream);
        decoder.loadFromInputStream(stream);
        int width = decoder.getWidth();
        int height = decoder.getHeight();
        int[] pixels = decoder.getPixels();
        if (!decoder.alphaSupported()) {
            int i = width * height;
            while (i-- > 0) {
                int n = i;
                pixels[n] = pixels[n] | 0xFF000000;
            }
        }
        return new Image(pixels, width, height, false);
    }

    public static Image createImage(String resourceName) throws IOException {
        if (resourceName == null) {
            throw new NullPointerException("Image.createImage: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 resourceName \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        InputStream stream = resourceName.getClass().getResourceAsStream(resourceName.length() > 0 && resourceName.charAt(0) == '/' ? resourceName : "/".concat(resourceName));
        if (stream == null) {
            throw new ResourceNotFoundException(new StringBuilder().append("Image.createImage: \u0440\u0435\u0441\u0443\u0440\u0441 ").append(resourceName).append(" \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d.").toString());
        }
        ImageDecoder decoder = DeviceManager.getInstance().openImageDecoder(stream);
        decoder.loadFromInputStream(stream);
        int width = decoder.getWidth();
        int height = decoder.getHeight();
        int[] pixels = decoder.getPixels();
        if (!decoder.alphaSupported()) {
            int i = width * height;
            while (i-- > 0) {
                int n = i;
                pixels[n] = pixels[n] | 0xFF000000;
            }
        }
        return new Image(pixels, width, height, false);
    }

    public static Image createImage(Image source) {
        if (source == null) {
            throw new NullPointerException("Image.createImage: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 source \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (!source.mutable) {
            return source;
        }
        int width = source.width;
        int height = source.height;
        int area = width * height;
        int[] pixels = new int[area];
        Array.copy((int[])source.pixels, (int)0, (int[])pixels, (int)0, (int)area);
        return new Image(pixels, width, height, false);
    }

    public static Image createImage(Image source, int left, int top, int width, int height, int transform) {
        int j;
        int xinc;
        int start;
        int yinc;
        if (source == null) {
            throw new NullPointerException("Image.createImage: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 source \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int srcWidth = source.width;
        int srcHeight = source.height;
        if (!source.mutable && (left | top) == 0 && width == srcWidth && height == srcHeight && transform == 0) {
            return source;
        }
        if (width <= 0) {
            throw new IllegalArgumentException("Image.createImage: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 width \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        if (height <= 0) {
            throw new IllegalArgumentException("Image.createImage: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 height \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        int lim = left + width;
        if (lim > srcWidth || lim < left || left > srcWidth || left < 0 || (lim = top + height) > srcHeight || lim < top || top > srcHeight || top < 0) {
            throw new IllegalArgumentException("Image.createImage: \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0440\u0435\u0433\u0438\u043e\u043d \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u044b \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f.");
        }
        if ((transform & 0xFFFFFFF8) != 0) {
            throw new IllegalArgumentException("Image.createImage: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 transform \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        int[] srcPixels = source.pixels;
        int area = width * height;
        int[] dstPixels = new int[area];
        int i = left + top * srcWidth;
        int j2 = 0;
        int cy = height;
        while (cy-- > 0) {
            Array.copy((int[])srcPixels, (int)i, (int[])dstPixels, (int)j2, (int)width);
            i += srcWidth;
            j2 += width;
        }
        srcPixels = dstPixels;
        dstPixels = new int[area];
        if ((transform & 1) != 0) {
            yinc = -width;
            start = area - width;
        } else {
            yinc = width;
            start = 0;
        }
        if ((transform & 2) != 0) {
            xinc = -1;
            start += width - 1;
        } else {
            xinc = 1;
        }
        if ((transform & 4) != 0) {
            i = 0;
            int cx = width;
            while (cx-- > 0) {
                j = start;
                int cy2 = height;
                while (cy2-- > 0) {
                    dstPixels[i++] = srcPixels[j];
                    j += yinc;
                }
                start += xinc;
            }
            return new Image(dstPixels, height, width, false);
        }
        i = 0;
        int cy3 = height;
        while (cy3-- > 0) {
            j = start;
            int cx = width;
            while (cx-- > 0) {
                dstPixels[i++] = srcPixels[j];
                j += xinc;
            }
            start += yinc;
        }
        return new Image(dstPixels, width, height, false);
    }

    public static Image createRGBImage(int[] pixels, int width, int height, boolean alpha) {
        return Image.createRGBImage(pixels, width, height, alpha, false);
    }

    public static Image createRGBImage(int[] pixels, int width, int height, boolean alpha, boolean mutable) {
        if (pixels == null) {
            throw new NullPointerException("Image.createRGBImage: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 pixels \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (width <= 0) {
            throw new IllegalArgumentException("Image.createRGBImage: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 width \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        if (height <= 0) {
            throw new IllegalArgumentException("Image.createRGBImage: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 height \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        if ((long)pixels.length < (long)width * (long)height) {
            throw new ArrayIndexOutOfBoundsException("Image.createRGBImage: \u0434\u043b\u0438\u043d\u0430 \u043c\u0430\u0441\u0441\u0438\u0432\u0430 pixels \u043c\u0435\u043d\u044c\u0448\u0435 \u0437\u0430\u0434\u0430\u043d\u043d\u043e\u0439 \u043f\u043b\u043e\u0449\u0430\u0434\u0438 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f.");
        }
        int[] nArray = pixels;
        int area = width * height;
        pixels = new int[area];
        Array.copy((int[])nArray, (int)0, (int[])pixels, (int)0, (int)area);
        if (!alpha) {
            int i = area;
            while (i-- > 0) {
                int n = i;
                pixels[n] = pixels[n] | 0xFF000000;
            }
        }
        return new Image(pixels, width, height, mutable);
    }

    private Image(int[] pixels, int width, int height, boolean mutable) {
        this.mutable = mutable;
        this.width = width;
        this.height = height;
        this.pixels = pixels;
        this.buffer = RasterBuffer.create((int[])pixels, (int)0, (int)width, (int)width, (int)height, (boolean)false);
    }

    public void getRGB(int[] pixels, int offset, int scanlength, int left, int top, int width, int height) {
        int pixelsLength;
        int pixelsOffset;
        int srcWidth = this.width;
        int[] srcPixels = this.pixels;
        if (scanlength >= 0) {
            pixelsOffset = offset;
            pixelsLength = width + (height - 1) * scanlength;
        } else {
            pixelsOffset = offset + (height - 1) * scanlength;
            pixelsLength = width + offset - pixelsOffset;
        }
        int lim = left + width;
        int len = srcWidth;
        if (lim > len || lim < left || left > len || left < 0 || (lim = top + height) > (len = this.height) || lim < top || top > len || top < 0) {
            throw new IllegalArgumentException("Image.getRGB: \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0440\u0435\u0433\u0438\u043e\u043d \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u044b \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f.");
        }
        if (scanlength > -width && scanlength < width) {
            throw new IllegalArgumentException("Image.getRGB: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 scanlength \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        if (pixels == null) {
            throw new NullPointerException("Image.getRGB: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 pixels \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Array.checkBound((String)"Image.getRGB", (int)pixels.length, (int)pixelsOffset, (int)pixelsLength);
        int i = left + top * srcWidth;
        int j = offset;
        int cy = height;
        while (cy-- > 0) {
            Array.copy((int[])srcPixels, (int)i, (int[])pixels, (int)j, (int)width);
            i += srcWidth;
            j += scanlength;
        }
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Graphics getGraphics() {
        if (!this.mutable) {
            throw new IllegalStateException("Image.getGraphics: \u043d\u0435\u0438\u0437\u043c\u0435\u043d\u044f\u0435\u043c\u043e\u0435 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435.");
        }
        return new Graphics(this.buffer);
    }
}

