/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.AppearanceModeItem;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import malik.emulator.media.graphics.RasterCanvas;
import malik.emulator.microedition.lcdui.FastMultilinedStringBuilder;
import malik.emulator.microedition.lcdui.MultilinedStringBuilder;
import malik.emulator.util.StringBuilder;

public class StringItem
extends AppearanceModeItem {
    private static final String NEW_LINE = "\n";
    private char[] buffer;
    private Font textFont = Font.getFont(0, 0, 0);
    private String textAsString;
    private final MultilinedStringBuilder textAsBuilder;

    private static void writeText(StringBuilder builder, String text) {
        builder.clear();
        builder.append(text);
        if (text != null) {
            if (text.startsWith(NEW_LINE)) {
                builder.delete(0);
            }
            if (text.endsWith(NEW_LINE) && !builder.isEmpty()) {
                builder.delete(builder.length() - 1);
            }
        }
    }

    public StringItem(String label, String text) {
        this(label, text, 0);
    }

    public StringItem(String label, String text, int appearanceMode) {
        super(label, appearanceMode);
        this.textAsString = text;
        FastMultilinedStringBuilder builder = new FastMultilinedStringBuilder();
        this.textAsBuilder = builder;
        StringItem.writeText(builder, text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String text) {
        MultilinedStringBuilder builder;
        MultilinedStringBuilder multilinedStringBuilder = builder = this.textAsBuilder;
        synchronized (builder) {
            this.textAsString = text;
            StringItem.writeText(builder, this.textAsString);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.requestInvalidate();
            return;
        }
    }

    public void setFont(Font font) {
        this.textFont = font == null ? Font.getFont(0, 0, 0) : font;
        this.requestInvalidate();
    }

    public String getText() {
        return this.textAsString;
    }

    public Font getFont() {
        return this.textFont;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paint(Graphics render, int contentWidth, int contentHeight) {
        MultilinedStringBuilder builder;
        int w;
        int l;
        int t;
        boolean c;
        switch (this.appearanceMode) {
            default: {
                c = false;
                t = 0;
                l = 0;
                w = contentWidth;
                render.setColor(RasterCanvas.getSystemColor((int)40));
                break;
            }
            case 1: {
                c = false;
                boolean p = this.pressed;
                t = p ? 1 : 0;
                l = t;
                int n = w = contentWidth > 1 ? contentWidth - 1 : 0;
                render.setColor(RasterCanvas.getSystemColor((int)(this.focused ? (p ? 37 : 39) : 36)));
                break;
            }
            case 2: {
                c = true;
                boolean f = this.focused;
                boolean p = this.pressed;
                l = (p ? 1 : 0) + (contentWidth >> 1);
                t = p ? 5 : 4;
                int n = w = contentWidth > 8 ? contentWidth - 8 : 0;
                render.drawElement(4, f ? (p ? 1 : 3) : 0, 0, 0, 0, contentWidth, contentHeight);
                render.setColor(RasterCanvas.getSystemColor((int)(f ? (p ? 37 : 39) : 36)));
            }
        }
        Font font = this.textFont;
        render.setFont(font);
        MultilinedStringBuilder multilinedStringBuilder = builder = this.textAsBuilder;
        synchronized (builder) {
            char[] lbuf = this.buffer;
            int clipTop = render.getClipY() - t;
            int line = font.getHeight();
            int srow = clipTop / line;
            int frow = (clipTop + render.getClipHeight() - 1) / line;
            builder.split(font, w);
            int len = builder.lines();
            int top = t + srow * line;
            int index = srow < 0 ? 0 : srow;
            while (index <= frow && index < len) {
                int lofs = builder.lineOffset(index);
                int llen = builder.lineLength(index);
                if (lbuf == null || lbuf.length < llen) {
                    lbuf = this.buffer = new char[StringBuilder.optimalCapacity((int)llen)];
                }
                builder.copy(lofs, lofs + llen, lbuf, 0);
                render.drawChars(lbuf, 0, llen, l, top, c ? 17 : 20);
                top += line;
                ++index;
            }
            // ** MonitorExit[var12_12] (shouldn't be in output)
            return;
        }
    }

    boolean onFocusMove(int direction, int viewportWidth, int viewportHeight, int[] visibleRectangle) {
        if (!super.onFocusMove(direction, viewportWidth, viewportHeight, visibleRectangle)) {
            this.pressed = false;
            return true;
        }
        switch (direction) {
            default: {
                break;
            }
            case 2: {
                int pos1 = visibleRectangle[0];
                if (pos1 <= 0) {
                    return false;
                }
                int delta = viewportWidth >> 1;
                visibleRectangle[0] = pos1 > delta ? pos1 - delta : 0;
                break;
            }
            case 5: {
                int pos1 = visibleRectangle[0];
                int size = visibleRectangle[2];
                int pos2 = pos1 + size;
                int max = this.contentWidth;
                if (pos2 >= max) {
                    return false;
                }
                int delta = viewportWidth >> 1;
                visibleRectangle[0] = pos2 < max - delta ? pos1 + delta : max - size;
                break;
            }
            case 1: {
                int pos1 = visibleRectangle[1];
                if (pos1 <= 0) {
                    return false;
                }
                int delta = this.textFont.getHeight();
                visibleRectangle[1] = pos1 > delta ? pos1 - delta : 0;
                break;
            }
            case 6: {
                int pos1 = visibleRectangle[1];
                int size = visibleRectangle[3];
                int pos2 = pos1 + size;
                int max = this.contentHeight;
                if (pos2 >= max) {
                    return false;
                }
                int delta = this.textFont.getHeight();
                visibleRectangle[1] = pos2 < max - delta ? pos1 + delta : max - size;
            }
        }
        return true;
    }

    boolean hasRowBreakBefore(int layout, int alignment) {
        String text;
        return super.hasRowBreakBefore(layout, alignment) || (text = this.textAsString) != null && text.startsWith(NEW_LINE);
    }

    boolean hasRowBreakAfter(int layout, int alignment) {
        String text;
        return super.hasRowBreakAfter(layout, alignment) || (text = this.textAsString) != null && text.endsWith(NEW_LINE);
    }

    int getDefaultLayout() {
        return this.appearanceMode == 0 ? 2048 : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getMinimumContentWidth() {
        MultilinedStringBuilder builder;
        int result = 0;
        MultilinedStringBuilder multilinedStringBuilder = builder = this.textAsBuilder;
        synchronized (builder) {
            if (!builder.isEmpty()) {
                result = 100;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return result + this.sizeAppendix();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getMinimumContentHeight() {
        MultilinedStringBuilder builder;
        int result = 0;
        MultilinedStringBuilder multilinedStringBuilder = builder = this.textAsBuilder;
        synchronized (builder) {
            if (!builder.isEmpty()) {
                Font font = this.textFont;
                builder.split(font, Integer.MAX_VALUE);
                result = font.getHeight() * builder.lines();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return result + this.sizeAppendix();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getPreferredContentWidth(int contentHeight) {
        MultilinedStringBuilder builder;
        int result = 0;
        int maxWidth = contentHeight >= 0 ? this.width : 100;
        MultilinedStringBuilder multilinedStringBuilder = builder = this.textAsBuilder;
        synchronized (builder) {
            if (!builder.isEmpty()) {
                Font font = this.textFont;
                builder.split(font, maxWidth);
                int index = builder.lines();
                char[] buf = this.buffer;
                while (index-- > 0) {
                    int lofs = builder.lineOffset(index);
                    int llen = builder.lineLength(index);
                    if (buf == null || buf.length < llen) {
                        buf = this.buffer = new char[StringBuilder.optimalCapacity((int)llen)];
                    }
                    builder.copy(lofs, lofs + llen, buf, 0);
                    int lwid = font.charsWidth(buf, 0, llen);
                    if (result >= lwid) continue;
                    result = lwid;
                }
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return result + this.sizeAppendix();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getPreferredContentHeight(int contentWidth) {
        MultilinedStringBuilder builder;
        int result = 0;
        int sapp = this.sizeAppendix();
        MultilinedStringBuilder multilinedStringBuilder = builder = this.textAsBuilder;
        synchronized (builder) {
            if (!builder.isEmpty()) {
                Font font = this.textFont;
                builder.split(font, contentWidth >= sapp ? contentWidth - sapp : Integer.MAX_VALUE);
                result = font.getHeight() * builder.lines();
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return result + sapp;
        }
    }

    private int sizeAppendix() {
        switch (this.appearanceMode) {
            default: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: 
        }
        return 8;
    }
}

