/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui.game;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.TiledLayer;

public class Sprite
extends Layer {
    public static final int TRANS_NONE = 0;
    public static final int TRANS_MIRROR_ROT180 = 1;
    public static final int TRANS_MIRROR = 2;
    public static final int TRANS_ROT180 = 3;
    public static final int TRANS_MIRROR_ROT270 = 4;
    public static final int TRANS_ROT90 = 5;
    public static final int TRANS_ROT270 = 6;
    public static final int TRANS_MIRROR_ROT90 = 7;
    private static final int MAX_SIZE = Short.MAX_VALUE;
    private int referencePointX;
    private int referencePointY;
    private int collisionRectLeft;
    private int collisionRectTop;
    private int collisionRectWidth;
    private int collisionRectHeight;
    private int transformedCollisionRectLeft;
    private int transformedCollisionRectTop;
    private int transformedCollisionRectWidth;
    private int transformedCollisionRectHeight;
    private int transformation;
    private int frameIndex;
    private int frameSetFrameWidth;
    private int frameSetFrameHeight;
    private int frameSetFramesCount;
    private int frameSetFramesPerRow;
    private int[] frameSequenceDefault;
    private int[] frameSequence;
    private Image frameSet;

    private static boolean isPixelCollision(int width, int height, Image image1, int left1, int top1, int transform1, Image image2, int left2, int top2, int transform2) {
        int yinc2;
        int start2;
        int xinc2;
        int yinc1;
        int start1;
        int xinc1;
        int area = width * height;
        int[] pixels1 = new int[area];
        int[] pixels2 = new int[area];
        if ((transform1 & 4) != 0) {
            if ((transform1 & 1) != 0) {
                xinc1 = -height;
                start1 = area - height;
            } else {
                xinc1 = height;
                start1 = 0;
            }
            if ((transform1 & 2) != 0) {
                yinc1 = -1;
                start1 += height - 1;
            } else {
                yinc1 = 1;
            }
            image1.getRGB(pixels1, 0, height, left1, top1, height, width);
        } else {
            if ((transform1 & 1) != 0) {
                yinc1 = -width;
                start1 = area - width;
            } else {
                yinc1 = width;
                start1 = 0;
            }
            if ((transform1 & 2) != 0) {
                xinc1 = -1;
                start1 += width - 1;
            } else {
                xinc1 = 1;
            }
            image1.getRGB(pixels1, 0, width, left1, top1, width, height);
        }
        if ((transform2 & 4) != 0) {
            if ((transform2 & 1) != 0) {
                xinc2 = -height;
                start2 = area - height;
            } else {
                xinc2 = height;
                start2 = 0;
            }
            if ((transform2 & 2) != 0) {
                yinc2 = -1;
                start2 += height - 1;
            } else {
                yinc2 = 1;
            }
            image2.getRGB(pixels2, 0, height, left2, top2, height, width);
        } else {
            if ((transform2 & 1) != 0) {
                yinc2 = -width;
                start2 = area - width;
            } else {
                yinc2 = width;
                start2 = 0;
            }
            if ((transform2 & 2) != 0) {
                xinc2 = -1;
                start2 += width - 1;
            } else {
                xinc2 = 1;
            }
            image2.getRGB(pixels2, 0, width, left2, top2, width, height);
        }
        int startx1 = start1;
        int startx2 = start2;
        int j = height;
        while (j-- > 0) {
            int x1 = startx1;
            int x2 = startx2;
            int i = width;
            while (i-- > 0) {
                if ((pixels1[x1] & 0xFF000000) != 0 && (pixels2[x2] & 0xFF000000) != 0) {
                    return true;
                }
                x1 += xinc1;
                x2 += xinc2;
            }
            startx1 += yinc1;
            startx2 += yinc2;
        }
        return false;
    }

    private static boolean isRectIntersection(int left1, int top1, int right1, int bottom1, int left2, int top2, int right2, int bottom2) {
        return left1 < right2 && left2 < right1 && top1 < bottom2 && top2 < bottom1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sprite(Sprite source) {
        if (source == null) {
            throw new NullPointerException("Sprite: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 source \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Object object = source.monitor;
        synchronized (object) {
            this.visibility = source.visibility;
            this.left = source.left;
            this.top = source.top;
            this.width = source.width;
            this.height = source.height;
            this.referencePointX = source.referencePointX;
            this.referencePointY = source.referencePointY;
            this.collisionRectLeft = source.collisionRectLeft;
            this.collisionRectTop = source.collisionRectTop;
            this.collisionRectWidth = source.collisionRectWidth;
            this.collisionRectHeight = source.collisionRectHeight;
            this.transformedCollisionRectLeft = source.transformedCollisionRectLeft;
            this.transformedCollisionRectTop = source.transformedCollisionRectTop;
            this.transformedCollisionRectWidth = source.transformedCollisionRectWidth;
            this.transformedCollisionRectHeight = source.transformedCollisionRectHeight;
            this.transformation = source.transformation;
            this.frameIndex = source.frameIndex;
            this.frameSetFrameWidth = source.frameSetFrameWidth;
            this.frameSetFrameHeight = source.frameSetFrameHeight;
            this.frameSetFramesCount = source.frameSetFramesCount;
            this.frameSetFramesPerRow = source.frameSetFramesPerRow;
            this.frameSequenceDefault = source.frameSequenceDefault;
            this.frameSequence = source.frameSequence;
            this.frameSet = source.frameSet;
        }
    }

    public Sprite(Image frame) {
        int frameHeight;
        int frameWidth;
        if (frame == null) {
            throw new NullPointerException("Sprite: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 frame \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        this.width = frameWidth = frame.getWidth();
        this.height = frameHeight = frame.getHeight();
        this.collisionRectWidth = frameWidth;
        this.collisionRectHeight = frameHeight;
        this.transformedCollisionRectWidth = frameWidth;
        this.transformedCollisionRectHeight = frameHeight;
        this.frameSetFrameWidth = frameWidth;
        this.frameSetFrameHeight = frameHeight;
        this.frameSetFramesCount = 1;
        this.frameSetFramesPerRow = 1;
        int[] frameSequence = new int[1];
        this.frameSequenceDefault = frameSequence;
        this.frameSequence = frameSequence;
        this.frameSet = frame;
    }

    public Sprite(Image frameSet, int frameWidth, int frameHeight) {
        int framesCount;
        int frameSetHeight;
        if (frameSet == null) {
            throw new NullPointerException("Sprite: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 frameSet \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (frameWidth < 1 || frameWidth > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Sprite: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 frameWidth \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 1 \u0438\u043b\u0438 \u0431\u043e\u043b\u044c\u0448\u0435 32767.");
        }
        if (frameHeight < 1 || frameHeight > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Sprite: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 frameHeight \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 1 \u0438\u043b\u0438 \u0431\u043e\u043b\u044c\u0448\u0435 32767.");
        }
        int frameSetWidth = frameSet.getWidth();
        if (frameSetWidth % frameWidth != 0 || (frameSetHeight = frameSet.getHeight()) % frameHeight != 0) {
            throw new IllegalArgumentException("Sprite: \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u043a\u0430\u0434\u0440\u043e\u0432 \u043e\u0431\u0430 \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c \u0434\u0435\u043b\u0438\u0442\u0435\u043b\u044f\u043c\u0438 \u0440\u0430\u0437\u043c\u0435\u0440\u043e\u0432 \u043d\u0430\u0431\u043e\u0440\u0430 \u043a\u0430\u0434\u0440\u043e\u0432.");
        }
        this.width = frameWidth;
        this.height = frameHeight;
        this.collisionRectWidth = frameWidth;
        this.collisionRectHeight = frameHeight;
        this.transformedCollisionRectWidth = frameWidth;
        this.transformedCollisionRectHeight = frameHeight;
        this.frameSetFrameWidth = frameWidth;
        this.frameSetFrameHeight = frameHeight;
        int framesPerRow = frameSetWidth / frameWidth;
        this.frameSetFramesCount = framesCount = framesPerRow * (frameSetHeight / frameHeight);
        this.frameSetFramesPerRow = framesPerRow;
        int[] frameSequence = new int[framesCount];
        this.frameSequenceDefault = frameSequence;
        this.frameSequence = frameSequence;
        this.frameSet = frameSet;
        int i = framesCount;
        while (i-- > 1) {
            frameSequence[i] = i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextFrame() {
        Object object = this.monitor;
        synchronized (object) {
            this.frameIndex = (this.frameIndex + 1) % this.frameSequence.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prevFrame() {
        Object object = this.monitor;
        synchronized (object) {
            int len = this.frameSequence.length;
            this.frameIndex = (this.frameIndex + len - 1) % len;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defineReferencePixel(int x, int y) {
        Object object = this.monitor;
        synchronized (object) {
            this.referencePointX = x;
            this.referencePointY = y;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defineCollisionRectangle(int left, int top, int width, int height) {
        if (width < 0) {
            throw new IllegalArgumentException("Sprite.defineCollisionRectangle: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 width \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        if (height < 0) {
            throw new IllegalArgumentException("Sprite.defineCollisionRectangle: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 height \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        Object object = this.monitor;
        synchronized (object) {
            this.collisionRectLeft = left;
            this.collisionRectTop = top;
            this.collisionRectWidth = width;
            this.collisionRectHeight = height;
            this.computeTransformedBounds(this.transformation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRefPixelPosition(int x, int y) {
        Object object = this.monitor;
        synchronized (object) {
            int transform = this.transformation;
            this.left = x - this.getTransformedReferencePointX(transform);
            this.top = y - this.getTransformedReferencePointY(transform);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransform(int transform) {
        if ((transform & 0xFFFFFFF8) != 0) {
            throw new IllegalArgumentException("Sprite.setTransform: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 transform \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        Object object = this.monitor;
        synchronized (object) {
            int oldTransform = this.transformation;
            if (transform != oldTransform) {
                this.left += this.getTransformedReferencePointX(oldTransform) - this.getTransformedReferencePointX(transform);
                this.top += this.getTransformedReferencePointY(oldTransform) - this.getTransformedReferencePointY(transform);
                this.computeTransformedBounds(transform);
                this.transformation = transform;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImage(Image frameSet, int frameWidth, int frameHeight) {
        int frameSetHeight;
        if (frameSet == null) {
            throw new NullPointerException("Sprite.setImage: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 frameSet \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (frameWidth < 1 || frameWidth > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Sprite.setImage: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 frameWidth \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 1 \u0438\u043b\u0438 \u0431\u043e\u043b\u044c\u0448\u0435 32767.");
        }
        if (frameHeight < 1 || frameHeight > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Sprite.setImage: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 frameHeight \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 1 \u0438\u043b\u0438 \u0431\u043e\u043b\u044c\u0448\u0435 32767.");
        }
        int frameSetWidth = frameSet.getWidth();
        if (frameSetWidth % frameWidth != 0 || (frameSetHeight = frameSet.getHeight()) % frameHeight != 0) {
            throw new IllegalArgumentException("Sprite.setImage: \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u043a\u0430\u0434\u0440\u043e\u0432 \u043e\u0431\u0430 \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c \u0434\u0435\u043b\u0438\u0442\u0435\u043b\u044f\u043c\u0438 \u0440\u0430\u0437\u043c\u0435\u0440\u043e\u0432 \u043d\u0430\u0431\u043e\u0440\u0430 \u043a\u0430\u0434\u0440\u043e\u0432.");
        }
        int framesPerRow = frameSetWidth / frameWidth;
        int framesCount = framesPerRow * (frameSetHeight / frameHeight);
        Object object = this.monitor;
        synchronized (object) {
            int[] frameSequence;
            if (frameWidth != this.frameSetFrameWidth || frameHeight != this.frameSetFrameHeight) {
                int transform = this.transformation;
                int x = this.left + this.getTransformedReferencePointX(transform);
                int y = this.top + this.getTransformedReferencePointY(transform);
                this.collisionRectLeft = 0;
                this.collisionRectTop = 0;
                this.collisionRectWidth = frameWidth;
                this.collisionRectHeight = frameHeight;
                this.transformedCollisionRectLeft = 0;
                this.transformedCollisionRectTop = 0;
                if ((transform & 4) != 0) {
                    this.transformedCollisionRectWidth = this.width = frameHeight;
                    this.transformedCollisionRectHeight = this.height = frameWidth;
                } else {
                    this.transformedCollisionRectWidth = this.width = frameWidth;
                    this.transformedCollisionRectHeight = this.height = frameHeight;
                }
                this.left = x - this.getTransformedReferencePointX(transform);
                this.top = y - this.getTransformedReferencePointY(transform);
                this.frameSetFrameWidth = frameWidth;
                this.frameSetFrameHeight = frameHeight;
            }
            int oldFramesCount = this.frameSetFramesCount;
            this.frameSetFramesPerRow = framesPerRow;
            this.frameSetFramesCount = framesCount;
            if (oldFramesCount == framesCount) {
                frameSequence = null;
            } else {
                frameSequence = new int[framesCount];
                int i = framesCount;
                while (i-- > 1) {
                    frameSequence[i] = i;
                }
            }
            if (framesCount < oldFramesCount) {
                this.frameIndex = 0;
                this.frameSequence = frameSequence;
            } else if (framesCount > oldFramesCount && this.frameSequence == this.frameSequenceDefault) {
                this.frameSequence = frameSequence;
            }
            this.frameSequenceDefault = frameSequence;
            this.frameSet = frameSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFrameSequence(int[] sequence) {
        int[] frameSequence;
        int len;
        if (sequence == null) {
            len = 0;
            frameSequence = null;
        } else {
            len = sequence.length;
            if (len < 1) {
                throw new IllegalArgumentException("Sprite.setFrameSequence: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 sequence \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0438\u043c\u0435\u0442\u044c \u0434\u043b\u0438\u043d\u0443 \u043c\u0435\u043d\u044c\u0448\u0435 1.");
            }
            frameSequence = new int[len];
            Array.copy((int[])sequence, (int)0, (int[])frameSequence, (int)0, (int)len);
        }
        boolean error = false;
        Object object = this.monitor;
        synchronized (object) {
            block10: {
                if (frameSequence == null) {
                    frameSequence = this.frameSequenceDefault;
                } else {
                    int framesCount = this.frameSetFramesCount;
                    int i = len;
                    while (i-- > 0) {
                        int frame = frameSequence[i];
                        if (frame >= 0 && frame < framesCount) continue;
                        error = true;
                        break block10;
                    }
                }
                this.frameIndex = 0;
                this.frameSequence = frameSequence;
            }
        }
        if (error) {
            throw new ArrayIndexOutOfBoundsException("Sprite.setFrameSequence: \u043e\u0434\u0438\u043d \u0438\u0437 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u0430 sequence \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFrame(int frameIndex) {
        boolean error = false;
        Object object = this.monitor;
        synchronized (object) {
            if (frameIndex < 0 || frameIndex >= this.frameSequence.length) {
                error = true;
            } else {
                this.frameIndex = frameIndex;
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("Sprite.setFrame: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 frameIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRefPixelX() {
        int result;
        Object object = this.monitor;
        synchronized (object) {
            result = this.left + this.getTransformedReferencePointX(this.transformation);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRefPixelY() {
        int result;
        Object object = this.monitor;
        synchronized (object) {
            result = this.top + this.getTransformedReferencePointY(this.transformation);
        }
        return result;
    }

    public int getRawFrameCount() {
        return this.frameSetFramesCount;
    }

    public int getFrameSequenceLength() {
        return this.frameSequence.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void paint(Graphics render) {
        Image frameSetImage;
        int framesPerRow;
        int frameHeight;
        int frameWidth;
        int transform;
        int frame;
        int y;
        int x;
        if (render == null) {
            throw new NullPointerException("Sprite.paint: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 render \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (!this.visibility) {
            return;
        }
        Object object = this.monitor;
        synchronized (object) {
            x = this.left;
            y = this.top;
            frame = this.frameSequence[this.frameIndex];
            transform = this.transformation;
            frameWidth = this.frameSetFrameWidth;
            frameHeight = this.frameSetFrameHeight;
            framesPerRow = this.frameSetFramesPerRow;
            frameSetImage = this.frameSet;
        }
        render.drawRegion(frameSetImage, frame % framesPerRow * frameWidth, frame / framesPerRow * frameHeight, frameWidth, frameHeight, transform, x, y, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean collidesWith(Sprite sprite, boolean pixelLevel) {
        boolean result;
        if (sprite == null) {
            throw new NullPointerException("Sprite.collidesWith: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 sprite \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (!this.visibility || !sprite.visibility) {
            return false;
        }
        Object object = this.monitor;
        synchronized (object) {
            Object object2 = sprite.monitor;
            synchronized (object2) {
                int layer1Left = this.left;
                int layer1Top = this.top;
                int layer1Right = layer1Left + this.width;
                int layer1Bottom = layer1Top + this.height;
                int thisLeft = layer1Left + this.transformedCollisionRectLeft;
                int thisTop = layer1Top + this.transformedCollisionRectTop;
                int thisRight = thisLeft + this.transformedCollisionRectWidth;
                int thisBottom = thisTop + this.transformedCollisionRectHeight;
                int layer2Left = sprite.left;
                int layer2Top = sprite.top;
                int layer2Right = layer2Left + sprite.width;
                int layer2Bottom = layer2Top + sprite.height;
                int spriteLeft = layer2Left + sprite.transformedCollisionRectLeft;
                int spriteTop = layer2Top + sprite.transformedCollisionRectTop;
                int spriteRight = spriteLeft + sprite.transformedCollisionRectWidth;
                int spriteBottom = spriteTop + sprite.transformedCollisionRectHeight;
                if (!Sprite.isRectIntersection(thisLeft, thisTop, thisRight, thisBottom, spriteLeft, spriteTop, spriteRight, spriteBottom)) {
                    result = false;
                } else if (!pixelLevel) {
                    result = true;
                } else {
                    int resultHeight;
                    int resultLeft = Math.max(Math.max(layer1Left, thisLeft), Math.max(layer2Left, spriteLeft));
                    int resultTop = Math.max(Math.max(layer1Top, thisTop), Math.max(layer2Top, spriteTop));
                    int resultRight = Math.min(Math.min(layer1Right, thisRight), Math.min(layer2Right, spriteRight));
                    int resultBottom = Math.min(Math.min(layer1Bottom, thisBottom), Math.min(layer2Bottom, spriteBottom));
                    int resultWidth = resultRight - resultLeft;
                    if (resultWidth <= 0 || (resultHeight = resultBottom - resultTop) <= 0) {
                        result = false;
                    } else {
                        int thisFrameSetLeft = this.getFrameSetLeft(resultLeft, resultTop, resultRight, resultBottom);
                        int thisFrameSetTop = this.getFrameSetTop(resultLeft, resultTop, resultRight, resultBottom);
                        int spriteFrameSetLeft = sprite.getFrameSetLeft(resultLeft, resultTop, resultRight, resultBottom);
                        int spriteFrameSetTop = sprite.getFrameSetTop(resultLeft, resultTop, resultRight, resultBottom);
                        result = Sprite.isPixelCollision(resultWidth, resultHeight, this.frameSet, thisFrameSetLeft, thisFrameSetTop, this.transformation, sprite.frameSet, spriteFrameSetLeft, spriteFrameSetTop, sprite.transformation);
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean collidesWith(TiledLayer tiles, boolean pixelLevel) {
        boolean result;
        if (tiles == null) {
            throw new NullPointerException("Sprite.collidesWith: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 tiles \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (!this.visibility || !tiles.visibility) {
            return false;
        }
        Object object = this.monitor;
        synchronized (object) {
            Object object2 = tiles.monitor;
            synchronized (object2) {
                block25: {
                    int layer1Left = this.left;
                    int layer1Top = this.top;
                    int layer1Right = layer1Left + this.width;
                    int layer1Bottom = layer1Top + this.height;
                    int thisLeft = layer1Left + this.transformedCollisionRectLeft;
                    int thisTop = layer1Top + this.transformedCollisionRectTop;
                    int thisRight = thisLeft + this.transformedCollisionRectWidth;
                    int thisBottom = thisTop + this.transformedCollisionRectHeight;
                    int layer2Left = tiles.left;
                    int layer2Top = tiles.top;
                    int layer2Right = layer2Left + tiles.width;
                    int layer2Bottom = layer2Top + tiles.height;
                    if (!Sprite.isRectIntersection(thisLeft, thisTop, thisRight, thisBottom, layer2Left, layer2Top, layer2Right, layer2Bottom)) {
                        result = false;
                    } else {
                        int resultLeft = Math.max(Math.max(layer1Left, thisLeft), layer2Left);
                        int resultTop = Math.max(Math.max(layer1Top, thisTop), layer2Top);
                        int resultRight = Math.min(Math.min(layer1Right, thisRight), layer2Right);
                        int resultBottom = Math.min(Math.min(layer1Bottom, thisBottom), layer2Bottom);
                        if (resultRight - resultLeft <= 0 || resultBottom - resultTop <= 0) {
                            result = false;
                        } else {
                            int cellsWidth = tiles.tileSetCellWidth;
                            int cellsHeight = tiles.tileSetCellHeight;
                            int cellLeft = (resultLeft - layer2Left) / cellsWidth;
                            int cellTop = (resultTop - layer2Top) / cellsHeight;
                            int cellRight = (resultRight - layer2Right - 1) / cellsWidth;
                            int cellBottom = (resultBottom - layer2Bottom - 1) / cellsHeight;
                            if (!pixelLevel) {
                                int row = cellTop;
                                while (row <= cellBottom) {
                                    int col = cellLeft;
                                    while (col <= cellRight) {
                                        if (tiles.getTileIndex(col, row) != 0) {
                                            result = true;
                                            break block25;
                                        }
                                        ++col;
                                    }
                                    ++row;
                                }
                                result = false;
                            } else {
                                int cellsPerRow = tiles.tileSetCellsPerRow;
                                int transform = this.transformation;
                                Image frameSet = this.frameSet;
                                Image tileSet = tiles.tileSet;
                                int row = cellTop;
                                while (row <= cellBottom) {
                                    int col = cellLeft;
                                    while (col <= cellRight) {
                                        int cell = tiles.getTileIndex(col, row);
                                        if (cell != 0) {
                                            int frameSetTop;
                                            int spriteBottom;
                                            int spriteRight;
                                            int frameSetLeft;
                                            int tileX = --cell % cellsPerRow * cellsWidth;
                                            int tileY = cell / cellsPerRow * cellsHeight;
                                            int spriteLeft = layer2Left + col * cellsWidth;
                                            int spriteTop = layer2Top + row * cellsHeight;
                                            int spriteWidth = cellsWidth;
                                            int spriteHeight = cellsHeight;
                                            int delta = resultLeft - spriteLeft;
                                            if (delta > 0) {
                                                tileX += delta;
                                                spriteLeft += delta;
                                                spriteWidth -= delta;
                                            }
                                            if ((delta = spriteLeft + spriteWidth - resultRight) > 0) {
                                                spriteWidth -= delta;
                                            }
                                            if ((delta = resultTop - spriteTop) > 0) {
                                                tileY += delta;
                                                spriteTop += delta;
                                                spriteHeight -= delta;
                                            }
                                            if ((delta = spriteTop + spriteHeight - resultBottom) > 0) {
                                                spriteHeight -= delta;
                                            }
                                            if (Sprite.isPixelCollision(spriteWidth, spriteHeight, frameSet, frameSetLeft = this.getFrameSetLeft(spriteLeft, spriteTop, spriteRight = spriteLeft + spriteWidth, spriteBottom = spriteTop + spriteHeight), frameSetTop = this.getFrameSetTop(spriteLeft, spriteTop, spriteRight, spriteBottom), transform, tileSet, tileX, tileY, 0)) {
                                                result = true;
                                                break block25;
                                            }
                                        }
                                        ++col;
                                    }
                                    ++row;
                                }
                                result = false;
                            }
                        }
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean collidesWith(Image image, int left, int top, boolean pixelLevel) {
        boolean result;
        if (image == null) {
            throw new NullPointerException("Sprite.collidesWith: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 image \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (!this.visibility) {
            return false;
        }
        Object object = this.monitor;
        synchronized (object) {
            int layerLeft = this.left;
            int layerTop = this.top;
            int layerRight = layerLeft + this.width;
            int layerBottom = layerTop + this.height;
            int thisLeft = layerLeft + this.transformedCollisionRectLeft;
            int thisTop = layerTop + this.transformedCollisionRectTop;
            int thisRight = thisLeft + this.transformedCollisionRectWidth;
            int thisBottom = thisTop + this.transformedCollisionRectHeight;
            int srcLeft = left;
            int srcTop = top;
            int srcRight = srcLeft + image.getWidth();
            int srcBottom = srcTop + image.getHeight();
            if (!Sprite.isRectIntersection(thisLeft, thisTop, thisRight, thisBottom, srcLeft, srcTop, srcRight, srcBottom)) {
                result = false;
            } else if (!pixelLevel) {
                result = true;
            } else {
                int resultHeight;
                int resultLeft = Math.max(Math.max(layerLeft, thisLeft), srcLeft);
                int resultTop = Math.max(Math.max(layerTop, thisTop), srcTop);
                int resultRight = Math.min(Math.min(layerRight, thisRight), srcRight);
                int resultBottom = Math.min(Math.min(layerBottom, thisBottom), srcBottom);
                int resultWidth = resultRight - resultLeft;
                if (resultWidth <= 0 || (resultHeight = resultBottom - resultTop) <= 0) {
                    result = false;
                } else {
                    int frameSetLeft = this.getFrameSetLeft(resultLeft, resultTop, resultRight, resultBottom);
                    int frameSetTop = this.getFrameSetTop(resultLeft, resultTop, resultRight, resultBottom);
                    result = Sprite.isPixelCollision(resultWidth, resultHeight, this.frameSet, frameSetLeft, frameSetTop, this.transformation, image, resultLeft - srcLeft, resultTop - srcTop, 0);
                }
            }
        }
        return result;
    }

    public final int getFrame() {
        return this.frameIndex;
    }

    private void computeTransformedBounds(int transform) {
        switch (transform) {
            default: {
                this.width = this.frameSetFrameWidth;
                this.height = this.frameSetFrameHeight;
                this.transformedCollisionRectLeft = this.collisionRectLeft;
                this.transformedCollisionRectTop = this.collisionRectTop;
                this.transformedCollisionRectWidth = this.collisionRectWidth;
                this.transformedCollisionRectHeight = this.collisionRectHeight;
                break;
            }
            case 5: {
                int fh = this.frameSetFrameHeight;
                int crh = this.collisionRectHeight;
                this.width = fh;
                this.height = this.frameSetFrameWidth;
                this.transformedCollisionRectLeft = fh - crh - this.collisionRectTop;
                this.transformedCollisionRectTop = this.collisionRectLeft;
                this.transformedCollisionRectWidth = crh;
                this.transformedCollisionRectHeight = this.collisionRectWidth;
                break;
            }
            case 3: {
                int fw = this.frameSetFrameWidth;
                int fh = this.frameSetFrameHeight;
                int crw = this.collisionRectWidth;
                int crh = this.collisionRectHeight;
                this.width = fw;
                this.height = fh;
                this.transformedCollisionRectLeft = fw - crw - this.collisionRectLeft;
                this.transformedCollisionRectTop = fh - crh - this.collisionRectTop;
                this.transformedCollisionRectWidth = crw;
                this.transformedCollisionRectHeight = crh;
                break;
            }
            case 6: {
                int fw = this.frameSetFrameWidth;
                int crw = this.collisionRectWidth;
                this.width = this.frameSetFrameHeight;
                this.height = fw;
                this.transformedCollisionRectLeft = this.collisionRectTop;
                this.transformedCollisionRectTop = fw - crw - this.collisionRectLeft;
                this.transformedCollisionRectWidth = this.collisionRectHeight;
                this.transformedCollisionRectHeight = crw;
                break;
            }
            case 2: {
                int fw = this.frameSetFrameWidth;
                int crw = this.collisionRectWidth;
                this.width = fw;
                this.height = this.frameSetFrameHeight;
                this.transformedCollisionRectLeft = fw - crw - this.collisionRectLeft;
                this.transformedCollisionRectTop = this.collisionRectTop;
                this.transformedCollisionRectWidth = crw;
                this.transformedCollisionRectHeight = this.collisionRectHeight;
                break;
            }
            case 7: {
                int fw = this.frameSetFrameWidth;
                int fh = this.frameSetFrameHeight;
                int crw = this.collisionRectWidth;
                int crh = this.collisionRectHeight;
                this.width = fh;
                this.height = fw;
                this.transformedCollisionRectLeft = fh - crh - this.collisionRectTop;
                this.transformedCollisionRectTop = fw - crw - this.collisionRectLeft;
                this.transformedCollisionRectWidth = crh;
                this.transformedCollisionRectHeight = crw;
                break;
            }
            case 1: {
                int fh = this.frameSetFrameHeight;
                int crh = this.collisionRectHeight;
                this.width = this.frameSetFrameWidth;
                this.height = fh;
                this.transformedCollisionRectLeft = this.collisionRectLeft;
                this.transformedCollisionRectTop = fh - crh - this.collisionRectTop;
                this.transformedCollisionRectWidth = this.collisionRectWidth;
                this.transformedCollisionRectHeight = crh;
                break;
            }
            case 4: {
                this.width = this.frameSetFrameHeight;
                this.height = this.frameSetFrameWidth;
                this.transformedCollisionRectLeft = this.collisionRectTop;
                this.transformedCollisionRectTop = this.collisionRectLeft;
                this.transformedCollisionRectWidth = this.collisionRectHeight;
                this.transformedCollisionRectHeight = this.collisionRectWidth;
            }
        }
    }

    private int getTransformedReferencePointX(int transform) {
        switch (transform) {
            default: {
                return this.referencePointX;
            }
            case 5: 
            case 7: {
                return this.frameSetFrameHeight - this.referencePointY - 1;
            }
            case 2: 
            case 3: {
                return this.frameSetFrameWidth - this.referencePointX - 1;
            }
            case 4: 
            case 6: 
        }
        return this.referencePointY;
    }

    private int getTransformedReferencePointY(int transform) {
        switch (transform) {
            default: {
                return this.referencePointY;
            }
            case 4: 
            case 5: {
                return this.referencePointX;
            }
            case 1: 
            case 3: {
                return this.frameSetFrameHeight - this.referencePointY - 1;
            }
            case 6: 
            case 7: 
        }
        return this.frameSetFrameWidth - this.referencePointX - 1;
    }

    private int getFrameSetLeft(int left, int top, int right, int bottom) {
        int result;
        switch (this.transformation) {
            default: {
                result = left - this.left;
                break;
            }
            case 4: 
            case 5: {
                result = top - this.top;
                break;
            }
            case 2: 
            case 3: {
                result = this.left + this.width - right;
                break;
            }
            case 6: 
            case 7: {
                result = this.top + this.height - bottom;
            }
        }
        return result + this.frameSequence[this.frameIndex] % this.frameSetFramesPerRow * this.frameSetFrameWidth;
    }

    private int getFrameSetTop(int left, int top, int right, int bottom) {
        int result;
        switch (this.transformation) {
            default: {
                result = top - this.top;
                break;
            }
            case 5: 
            case 7: {
                result = this.left + this.width - right;
                break;
            }
            case 1: 
            case 3: {
                result = this.top + this.height - bottom;
                break;
            }
            case 4: 
            case 6: {
                result = left - this.left;
            }
        }
        return result + this.frameSequence[this.frameIndex] / this.frameSetFramesPerRow * this.frameSetFrameHeight;
    }
}

