/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.microedition.lcdui;

import javax.microedition.lcdui.CustomSurfaceScreen;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.ScrollBar;
import malik.emulator.application.KeyboardEvent;
import malik.emulator.application.PointerEvent;
import malik.emulator.media.graphics.RasterCanvas;
import malik.emulator.microedition.DeviceManager;
import malik.emulator.microedition.DeviceSettings;
import malik.emulator.microedition.lcdui.ScrollBarStyle;

public class CharacterList
extends CustomSurfaceScreen {
    private int selected;
    private char[] chars;
    private Font font;
    private final Object monitor;

    public CharacterList(String title, ScrollBarStyle style) {
        super(title, 0, true, style);
        this.chars = new char[0];
        this.font = Font.getFont(0, 0, 0);
        this.monitor = new Object();
        this.correctScrollBarRange(0);
    }

    public CharacterList(String title, ScrollBarStyle style, char[] list) {
        super(title, 0, true, style);
        char[] chars;
        if (list != null) {
            int len = list.length;
            chars = new char[len];
            Array.copy((char[])list, (int)0, (char[])chars, (int)0, (int)len);
        } else {
            chars = new char[]{};
        }
        this.chars = chars;
        this.font = Font.getFont(0, 0, 0);
        this.monitor = new Object();
        this.correctScrollBarRange(chars.length);
    }

    public CharacterList(String title, ScrollBarStyle style, String list) {
        super(title, 0, true, style);
        char[] chars = list == null ? new char[]{} : list.toCharArray();
        this.chars = chars;
        this.font = Font.getFont(0, 0, 0);
        this.monitor = new Object();
        this.correctScrollBarRange(chars.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedIndex(int index) {
        Object object = this.monitor;
        synchronized (object) {
            char[] list = this.chars;
            int lim = this.chars.length - 1;
            if (index > lim) {
                index = lim;
            }
            if (index < 0) {
                index = 0;
            }
            this.selected = index;
            this.correctScrollBarPosition(list, this.selected);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setList(char[] list) {
        int len;
        if (list != null) {
            char[] cArray = list;
            len = list.length;
            list = new char[len];
            Array.copy((char[])cArray, (int)0, (char[])list, (int)0, (int)len);
        } else {
            len = 0;
            list = new char[]{};
        }
        Object object = this.monitor;
        synchronized (object) {
            int index = this.selected;
            int lim = len - 1;
            if (index > lim) {
                index = lim;
            }
            if (index < 0) {
                index = 0;
            }
            this.correctScrollBarRange(list.length);
            this.chars = list;
            this.selected = index;
            this.correctScrollBarPosition(list, this.selected);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setList(String list) {
        char[] clist = list == null ? new char[]{} : list.toCharArray();
        Object object = this.monitor;
        synchronized (object) {
            int index = this.selected;
            int lim = clist.length - 1;
            if (index > lim) {
                index = lim;
            }
            if (index < 0) {
                index = 0;
            }
            this.correctScrollBarRange(clist.length);
            this.chars = clist;
            this.selected = index;
            this.correctScrollBarPosition(clist, this.selected);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFont(Font font) {
        if (font == null) {
            font = Font.getFont(0, 0, 0);
        }
        Object object = this.monitor;
        synchronized (object) {
            this.font = font;
            char[] list = this.chars;
            this.correctScrollBarRange(this.chars.length);
            this.correctScrollBarPosition(list, this.selected);
        }
    }

    public char getChar(int index) {
        char[] list;
        block3: {
            block2: {
                if (index < 0) break block2;
                list = this.chars;
                if (index < this.chars.length) break block3;
            }
            throw new IndexOutOfBoundsException("CharacterList.getChar: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 index \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return list[index];
    }

    public char getSelectedChar() {
        char[] list = this.chars;
        int lim = this.chars.length - 1;
        if (lim < 0) {
            throw new IndexOutOfBoundsException("CharacterList.getSelectedChar: \u0441\u043f\u0438\u0441\u043e\u043a \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432 \u043f\u0443\u0441\u0442.");
        }
        int index = this.selected;
        if (index > lim) {
            index = lim;
        }
        if (index < 0) {
            index = 0;
        }
        return list[index];
    }

    public int getSelectedIndex() {
        return this.chars.length <= 0 ? -1 : this.selected;
    }

    public int getSize() {
        return this.chars.length;
    }

    public char[] getList() {
        char[] result = this.chars;
        int len = result.length;
        result = new char[len];
        Array.copy((char[])this.chars, (int)0, (char[])result, (int)0, (int)len);
        return result;
    }

    public Font getFont() {
        return this.font;
    }

    protected void paint(Graphics render) {
        int selected = this.selected;
        char[] chars = this.chars;
        Font font = this.font;
        int cols = super.getWidth() / 32;
        int line = font.getHeight() + 8;
        int temp = render.getClipY();
        int srow = temp / line;
        int frow = (temp + render.getClipHeight() - 1) / line;
        int length = chars.length;
        if (cols < 1) {
            cols = 1;
        }
        render.setFont(font);
        int index = srow * cols;
        int top = srow * line;
        int row = srow;
        block0: while (row <= frow) {
            int left = 0;
            int col = 0;
            while (col < cols) {
                if (index >= length) break block0;
                if (index != selected) {
                    render.setColor(RasterCanvas.getSystemColor((int)7));
                } else {
                    render.setColor(RasterCanvas.getSystemColor((int)13));
                    render.fillRect(left, top, 32, line);
                    render.setColor(RasterCanvas.getSystemColor((int)14));
                }
                render.drawChar(chars[index], left + 16, top + 4, 17);
                ++index;
                left += 32;
                ++col;
            }
            top += line;
            ++row;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void keyboardNotify(KeyboardEvent event) {
        int key = event.getKey();
        DeviceSettings settings = DeviceManager.getInstance().getSettings();
        switch (event.getAction()) {
            case 5: 
            case 6: {
                if (settings.getKeyUsedAs(38) == key) {
                    int cols = super.getWidth() / 32;
                    if (cols < 1) {
                        cols = 1;
                    }
                    Object object = this.monitor;
                    synchronized (object) {
                        int index = this.selected;
                        if (index >= cols) {
                            index -= cols;
                        }
                        this.selected = index;
                        this.correctScrollBarPosition(this.chars, this.selected, cols);
                        break;
                    }
                }
                if (settings.getKeyUsedAs(36) == key) {
                    int cols = super.getWidth() / 32;
                    if (cols < 1) {
                        cols = 1;
                    }
                    Object object = this.monitor;
                    synchronized (object) {
                        int index = this.selected;
                        char[] list = this.chars;
                        if (index < this.chars.length - cols) {
                            index += cols;
                        }
                        this.selected = index;
                        this.correctScrollBarPosition(list, this.selected, cols);
                        break;
                    }
                }
                if (settings.getKeyUsedAs(40) == key) {
                    Object object = this.monitor;
                    synchronized (object) {
                        int index = this.selected;
                        if (index > 0) {
                            --index;
                        }
                        this.selected = index;
                        this.correctScrollBarPosition(this.chars, this.selected);
                        break;
                    }
                }
                if (settings.getKeyUsedAs(41) != key) break;
                Object object = this.monitor;
                synchronized (object) {
                    int index = this.selected;
                    char[] list = this.chars;
                    int lim = this.chars.length - 1;
                    index = index < lim ? ++index : lim;
                    this.selected = index;
                    this.correctScrollBarPosition(list, this.selected);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pointerNotify(PointerEvent event) {
        int action = event.getAction();
        if (event.isButtonPressed(0) || (action == 15 || action == 11) && event.getButton() == 0) {
            int cols = super.getWidth() / 32;
            Object object = this.monitor;
            synchronized (object) {
                int line = this.font.getHeight() + 8;
                int index = event.getX() / 32 + event.getY() / line * (cols < 1 ? 1 : cols);
                char[] list = this.chars;
                int lim = this.chars.length - 1;
                if (index > lim) {
                    index = lim;
                }
                if (index < 0) {
                    index = 0;
                }
                this.selected = index;
                this.correctScrollBarPosition(list, this.selected);
            }
        }
    }

    private void correctScrollBarRange(int chars) {
        int cols = super.getWidth() / 32;
        int line = this.font.getHeight() + 8;
        cols = cols < 1 ? 1 : cols;
        int rows = chars / cols + (chars % cols <= 0 ? 0 : 1);
        super.getScrollBar().setRange(rows * line);
    }

    private void correctScrollBarPosition(char[] chars, int selected) {
        this.correctScrollBarPosition(chars, selected, super.getWidth() / 32);
    }

    private void correctScrollBarPosition(char[] chars, int selected, int cols) {
        int line = this.font.getHeight() + 8;
        int top1 = selected / (cols < 1 ? 1 : cols) * line;
        int top2 = line + top1;
        ScrollBar scroll = super.getScrollBar();
        int pos = scroll.getPosition();
        if (top1 < pos) {
            scroll.setPosition(top1);
        } else {
            int page = scroll.getPage();
            if (top2 > pos + page) {
                scroll.setPosition(top2 - page);
            } else {
                this.repaint();
            }
        }
    }
}

