/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;
import malik.emulator.io.jar.ResourceNotFoundException;

public class AudioClip {
    public static final int TYPE_MMF = 1;
    public static final int TYPE_MP3 = 2;
    public static final int TYPE_MIDI = 3;
    private static final String[] MIME_TYPES = new String[]{"application/vnd.smaf", "audio/mpeg", "audio/midi"};
    private Player implement;
    private VolumeControl volume;

    public static boolean isSupported() {
        return true;
    }

    public AudioClip(int type, byte[] src, int offset, int length) {
        VolumeControl volume;
        Player implement;
        if (--type < 0 || type >= MIME_TYPES.length) {
            throw new IllegalArgumentException("AudioClip: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 type.");
        }
        if (src == null) {
            throw new NullPointerException("AudioClip: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int lim = offset + length;
        int len = src.length;
        if (lim > len || lim < offset || offset > len || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("AudioClip: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        try {
            implement = Manager.createPlayer((InputStream)new ByteArrayInputStream(src, offset, length), (String)MIME_TYPES[type]);
            implement.prefetch();
            volume = (VolumeControl)implement.getControl("VolumeControl");
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("AudioClip: \u0442\u0438\u043f \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0433\u043e " + MIME_TYPES[type] + " \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u043e\u0439.");
        }
        this.implement = implement;
        this.volume = volume;
    }

    public AudioClip(int type, String resourceName) throws IOException {
        VolumeControl volume;
        Player implement;
        InputStream source;
        if (--type < 0 || type >= MIME_TYPES.length) {
            throw new IllegalArgumentException("AudioClip: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 type.");
        }
        if (resourceName == null) {
            throw new NullPointerException("AudioClip: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 resourceName \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (resourceName.length() <= 0 || resourceName.charAt(0) != '/') {
            resourceName = "/".concat(resourceName);
        }
        if ((source = this.getClass().getResourceAsStream(resourceName)) == null) {
            throw new ResourceNotFoundException("AudioClip: \u0440\u0435\u0441\u0443\u0440\u0441 " + resourceName + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d.");
        }
        try {
            implement = Manager.createPlayer((InputStream)source, (String)MIME_TYPES[type]);
            implement.prefetch();
            volume = (VolumeControl)implement.getControl("VolumeControl");
        }
        catch (MediaException mediaException) {
            throw new IllegalArgumentException("AudioClip: \u0442\u0438\u043f \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0433\u043e " + MIME_TYPES[type] + " \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u043e\u0439.");
        }
        this.implement = implement;
        this.volume = volume;
    }

    public void play(int loopCount, int volumeLevel) {
        if (loopCount < 0 || loopCount > 255) {
            throw new IllegalArgumentException("AudioClip.play: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 loopCount.");
        }
        if (volumeLevel < 0 || volumeLevel > 5) {
            throw new IllegalArgumentException("AudioClip.play: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 volumeLevel.");
        }
        if (loopCount == 0) {
            loopCount = -1;
        }
        try {
            VolumeControl volume;
            Player implement = this.implement;
            if (implement != null) {
                implement.stop();
                implement.setLoopCount(loopCount);
                implement.start();
            }
            if ((volume = this.volume) != null) {
                volume.setLevel(20 * volumeLevel);
            }
        }
        catch (MediaException e) {
            e.printRealStackTrace();
        }
    }

    public void resume() {
        try {
            Player implement = this.implement;
            if (implement != null) {
                implement.start();
            }
        }
        catch (MediaException e) {
            e.printRealStackTrace();
        }
    }

    public void pause() {
        try {
            Player implement = this.implement;
            if (implement != null) {
                implement.stop();
            }
        }
        catch (MediaException e) {
            e.printRealStackTrace();
        }
    }

    public void stop() {
        try {
            Player implement = this.implement;
            if (implement != null) {
                implement.stop();
                implement.setMediaTime(0L);
            }
        }
        catch (MediaException e) {
            e.printRealStackTrace();
        }
    }

    protected void $finalize$() {
        Player implement = this.implement;
        if (implement != null) {
            implement.close();
        }
    }
}

