/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.compression.zlib;

import malik.emulator.compression.zlib.Checksum32;

public class Adler32
extends Checksum32 {
    private static final int NMAX = 5552;
    private static final long BASE = 65521L;

    public Adler32() {
        super(1);
    }

    public Adler32(int value) {
        super(value);
    }

    public void reset() {
        this.value = 1;
    }

    public void update(byte[] src, int offset, int length) {
        int a = this.value;
        long s1 = a & 0xFFFF;
        long s2 = a >>> 16;
        while (length > 0) {
            int k = length < 5552 ? length : 5552;
            length -= k;
            while (k-- > 0) {
                s2 += (s1 += (long)(src[offset++] & 0xFF));
            }
            s1 %= 65521L;
            s2 %= 65521L;
        }
        this.value = (int)s1 | (int)(s2 << 16);
    }

    public Checksum32 copy() {
        return new Adler32(this.value);
    }
}

