/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.compression.zlib;

import malik.emulator.compression.zlib.CRC32;
import malik.emulator.compression.zlib.Config;
import malik.emulator.compression.zlib.GZIPHeader;
import malik.emulator.compression.zlib.StaticTree;
import malik.emulator.compression.zlib.Tree;
import malik.emulator.compression.zlib.ZStream;
import malik.emulator.compression.zlib.Zlib;

final class Deflate
extends Zlib {
    private static final int NEED_MORE = 0;
    private static final int BLOCK_DONE = 1;
    private static final int FINISH_STARTED = 2;
    private static final int FINISH_DONE = 3;
    private static final int PRESET_DICT = 32;
    private static final int INIT_STATE = 42;
    private static final int BUSY_STATE = 113;
    private static final int FINISH_STATE = 666;
    private static final int Z_DEFLATED = 8;
    private static final int STORED_BLOCK = 0;
    private static final int STATIC_TREES = 1;
    private static final int DYN_TREES = 2;
    private static final int Z_BINARY = 0;
    private static final int Z_ASCII = 1;
    private static final int Z_UNKNOWN = 2;
    private static final int BUF_SIZE = 16;
    private static final int REP_3_6 = 16;
    private static final int REPZ_3_10 = 17;
    private static final int REPZ_11_138 = 18;
    private static final int MIN_MATCH = 3;
    private static final int MAX_MATCH = 258;
    private static final int MIN_LOOKAHEAD = 262;
    private static final int MAX_BITS = 15;
    private static final int D_CODES = 30;
    private static final int BL_CODES = 19;
    private static final int LENGTH_CODES = 29;
    private static final int LITERALS = 256;
    private static final int L_CODES = 286;
    private static final int HEAP_SIZE = 573;
    private static final int END_BLOCK = 256;
    private static final int MAX_MEM_LEVEL = 9;
    private static final int DEF_MEM_LEVEL = 8;
    private static final int STORED = 0;
    private static final int FAST = 1;
    private static final int SLOW = 2;
    private static final byte[] DIST_CODE;
    private static final byte[] BL_ORDER;
    private static final byte[] LENGTH_CODE;
    private static final int[] BASE_LENGTH;
    private static final int[] BASE_DIST;
    private static final Config[] CONFIG_TABLE;
    private static final String[] ERROR_MESSAGE;
    public int pendingOut;
    public int pending;
    public int wrap = 1;
    public int level;
    public int heapLen;
    public int heapMax;
    public int optLen;
    public int staticLen;
    private int status;
    private int pendingBufSize;
    private int dataType;
    private int lastFlush;
    private int wSize;
    private int wBits;
    private int wMask;
    private int windowSize;
    private int insh;
    private int hashSize;
    private int hashBits;
    private int hashMask;
    private int hashShift;
    private int blockStart;
    private int matchLength;
    private int prevMatch;
    private int matchAvailable;
    private int strStart;
    private int matchStart;
    private int lookahead;
    private int prevLength;
    private int maxChainLength;
    private int maxLazyMatch;
    private int strategy;
    private int goodMatch;
    private int niceMatch;
    private int litBufSize;
    private int lastLit;
    private int matches;
    private int lastEobLen;
    private int lBuf;
    private int dBuf;
    private int biBuf;
    private int biValid;
    public byte[] pendingBuf;
    public byte[] depth = new byte[573];
    private byte[] window;
    public int[] blCount = new int[16];
    public int[] heap = new int[573];
    private int[] prev;
    private int[] head;
    private int[] dynLtree = new int[1146];
    private int[] dynDtree = new int[122];
    private int[] blTree = new int[78];
    private Tree lDesc = new Tree();
    private Tree dDesc = new Tree();
    private Tree blDesc = new Tree();
    private GZIPHeader gheader;
    private ZStream stream;

    static {
        byte[] byArray = new byte[512];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 4;
        byArray[5] = 4;
        byArray[6] = 5;
        byArray[7] = 5;
        byArray[8] = 6;
        byArray[9] = 6;
        byArray[10] = 6;
        byArray[11] = 6;
        byArray[12] = 7;
        byArray[13] = 7;
        byArray[14] = 7;
        byArray[15] = 7;
        byArray[16] = 8;
        byArray[17] = 8;
        byArray[18] = 8;
        byArray[19] = 8;
        byArray[20] = 8;
        byArray[21] = 8;
        byArray[22] = 8;
        byArray[23] = 8;
        byArray[24] = 9;
        byArray[25] = 9;
        byArray[26] = 9;
        byArray[27] = 9;
        byArray[28] = 9;
        byArray[29] = 9;
        byArray[30] = 9;
        byArray[31] = 9;
        byArray[32] = 10;
        byArray[33] = 10;
        byArray[34] = 10;
        byArray[35] = 10;
        byArray[36] = 10;
        byArray[37] = 10;
        byArray[38] = 10;
        byArray[39] = 10;
        byArray[40] = 10;
        byArray[41] = 10;
        byArray[42] = 10;
        byArray[43] = 10;
        byArray[44] = 10;
        byArray[45] = 10;
        byArray[46] = 10;
        byArray[47] = 10;
        byArray[48] = 11;
        byArray[49] = 11;
        byArray[50] = 11;
        byArray[51] = 11;
        byArray[52] = 11;
        byArray[53] = 11;
        byArray[54] = 11;
        byArray[55] = 11;
        byArray[56] = 11;
        byArray[57] = 11;
        byArray[58] = 11;
        byArray[59] = 11;
        byArray[60] = 11;
        byArray[61] = 11;
        byArray[62] = 11;
        byArray[63] = 11;
        byArray[64] = 12;
        byArray[65] = 12;
        byArray[66] = 12;
        byArray[67] = 12;
        byArray[68] = 12;
        byArray[69] = 12;
        byArray[70] = 12;
        byArray[71] = 12;
        byArray[72] = 12;
        byArray[73] = 12;
        byArray[74] = 12;
        byArray[75] = 12;
        byArray[76] = 12;
        byArray[77] = 12;
        byArray[78] = 12;
        byArray[79] = 12;
        byArray[80] = 12;
        byArray[81] = 12;
        byArray[82] = 12;
        byArray[83] = 12;
        byArray[84] = 12;
        byArray[85] = 12;
        byArray[86] = 12;
        byArray[87] = 12;
        byArray[88] = 12;
        byArray[89] = 12;
        byArray[90] = 12;
        byArray[91] = 12;
        byArray[92] = 12;
        byArray[93] = 12;
        byArray[94] = 12;
        byArray[95] = 12;
        byArray[96] = 13;
        byArray[97] = 13;
        byArray[98] = 13;
        byArray[99] = 13;
        byArray[100] = 13;
        byArray[101] = 13;
        byArray[102] = 13;
        byArray[103] = 13;
        byArray[104] = 13;
        byArray[105] = 13;
        byArray[106] = 13;
        byArray[107] = 13;
        byArray[108] = 13;
        byArray[109] = 13;
        byArray[110] = 13;
        byArray[111] = 13;
        byArray[112] = 13;
        byArray[113] = 13;
        byArray[114] = 13;
        byArray[115] = 13;
        byArray[116] = 13;
        byArray[117] = 13;
        byArray[118] = 13;
        byArray[119] = 13;
        byArray[120] = 13;
        byArray[121] = 13;
        byArray[122] = 13;
        byArray[123] = 13;
        byArray[124] = 13;
        byArray[125] = 13;
        byArray[126] = 13;
        byArray[127] = 13;
        byArray[128] = 14;
        byArray[129] = 14;
        byArray[130] = 14;
        byArray[131] = 14;
        byArray[132] = 14;
        byArray[133] = 14;
        byArray[134] = 14;
        byArray[135] = 14;
        byArray[136] = 14;
        byArray[137] = 14;
        byArray[138] = 14;
        byArray[139] = 14;
        byArray[140] = 14;
        byArray[141] = 14;
        byArray[142] = 14;
        byArray[143] = 14;
        byArray[144] = 14;
        byArray[145] = 14;
        byArray[146] = 14;
        byArray[147] = 14;
        byArray[148] = 14;
        byArray[149] = 14;
        byArray[150] = 14;
        byArray[151] = 14;
        byArray[152] = 14;
        byArray[153] = 14;
        byArray[154] = 14;
        byArray[155] = 14;
        byArray[156] = 14;
        byArray[157] = 14;
        byArray[158] = 14;
        byArray[159] = 14;
        byArray[160] = 14;
        byArray[161] = 14;
        byArray[162] = 14;
        byArray[163] = 14;
        byArray[164] = 14;
        byArray[165] = 14;
        byArray[166] = 14;
        byArray[167] = 14;
        byArray[168] = 14;
        byArray[169] = 14;
        byArray[170] = 14;
        byArray[171] = 14;
        byArray[172] = 14;
        byArray[173] = 14;
        byArray[174] = 14;
        byArray[175] = 14;
        byArray[176] = 14;
        byArray[177] = 14;
        byArray[178] = 14;
        byArray[179] = 14;
        byArray[180] = 14;
        byArray[181] = 14;
        byArray[182] = 14;
        byArray[183] = 14;
        byArray[184] = 14;
        byArray[185] = 14;
        byArray[186] = 14;
        byArray[187] = 14;
        byArray[188] = 14;
        byArray[189] = 14;
        byArray[190] = 14;
        byArray[191] = 14;
        byArray[192] = 15;
        byArray[193] = 15;
        byArray[194] = 15;
        byArray[195] = 15;
        byArray[196] = 15;
        byArray[197] = 15;
        byArray[198] = 15;
        byArray[199] = 15;
        byArray[200] = 15;
        byArray[201] = 15;
        byArray[202] = 15;
        byArray[203] = 15;
        byArray[204] = 15;
        byArray[205] = 15;
        byArray[206] = 15;
        byArray[207] = 15;
        byArray[208] = 15;
        byArray[209] = 15;
        byArray[210] = 15;
        byArray[211] = 15;
        byArray[212] = 15;
        byArray[213] = 15;
        byArray[214] = 15;
        byArray[215] = 15;
        byArray[216] = 15;
        byArray[217] = 15;
        byArray[218] = 15;
        byArray[219] = 15;
        byArray[220] = 15;
        byArray[221] = 15;
        byArray[222] = 15;
        byArray[223] = 15;
        byArray[224] = 15;
        byArray[225] = 15;
        byArray[226] = 15;
        byArray[227] = 15;
        byArray[228] = 15;
        byArray[229] = 15;
        byArray[230] = 15;
        byArray[231] = 15;
        byArray[232] = 15;
        byArray[233] = 15;
        byArray[234] = 15;
        byArray[235] = 15;
        byArray[236] = 15;
        byArray[237] = 15;
        byArray[238] = 15;
        byArray[239] = 15;
        byArray[240] = 15;
        byArray[241] = 15;
        byArray[242] = 15;
        byArray[243] = 15;
        byArray[244] = 15;
        byArray[245] = 15;
        byArray[246] = 15;
        byArray[247] = 15;
        byArray[248] = 15;
        byArray[249] = 15;
        byArray[250] = 15;
        byArray[251] = 15;
        byArray[252] = 15;
        byArray[253] = 15;
        byArray[254] = 15;
        byArray[255] = 15;
        byArray[258] = 16;
        byArray[259] = 17;
        byArray[260] = 18;
        byArray[261] = 18;
        byArray[262] = 19;
        byArray[263] = 19;
        byArray[264] = 20;
        byArray[265] = 20;
        byArray[266] = 20;
        byArray[267] = 20;
        byArray[268] = 21;
        byArray[269] = 21;
        byArray[270] = 21;
        byArray[271] = 21;
        byArray[272] = 22;
        byArray[273] = 22;
        byArray[274] = 22;
        byArray[275] = 22;
        byArray[276] = 22;
        byArray[277] = 22;
        byArray[278] = 22;
        byArray[279] = 22;
        byArray[280] = 23;
        byArray[281] = 23;
        byArray[282] = 23;
        byArray[283] = 23;
        byArray[284] = 23;
        byArray[285] = 23;
        byArray[286] = 23;
        byArray[287] = 23;
        byArray[288] = 24;
        byArray[289] = 24;
        byArray[290] = 24;
        byArray[291] = 24;
        byArray[292] = 24;
        byArray[293] = 24;
        byArray[294] = 24;
        byArray[295] = 24;
        byArray[296] = 24;
        byArray[297] = 24;
        byArray[298] = 24;
        byArray[299] = 24;
        byArray[300] = 24;
        byArray[301] = 24;
        byArray[302] = 24;
        byArray[303] = 24;
        byArray[304] = 25;
        byArray[305] = 25;
        byArray[306] = 25;
        byArray[307] = 25;
        byArray[308] = 25;
        byArray[309] = 25;
        byArray[310] = 25;
        byArray[311] = 25;
        byArray[312] = 25;
        byArray[313] = 25;
        byArray[314] = 25;
        byArray[315] = 25;
        byArray[316] = 25;
        byArray[317] = 25;
        byArray[318] = 25;
        byArray[319] = 25;
        byArray[320] = 26;
        byArray[321] = 26;
        byArray[322] = 26;
        byArray[323] = 26;
        byArray[324] = 26;
        byArray[325] = 26;
        byArray[326] = 26;
        byArray[327] = 26;
        byArray[328] = 26;
        byArray[329] = 26;
        byArray[330] = 26;
        byArray[331] = 26;
        byArray[332] = 26;
        byArray[333] = 26;
        byArray[334] = 26;
        byArray[335] = 26;
        byArray[336] = 26;
        byArray[337] = 26;
        byArray[338] = 26;
        byArray[339] = 26;
        byArray[340] = 26;
        byArray[341] = 26;
        byArray[342] = 26;
        byArray[343] = 26;
        byArray[344] = 26;
        byArray[345] = 26;
        byArray[346] = 26;
        byArray[347] = 26;
        byArray[348] = 26;
        byArray[349] = 26;
        byArray[350] = 26;
        byArray[351] = 26;
        byArray[352] = 27;
        byArray[353] = 27;
        byArray[354] = 27;
        byArray[355] = 27;
        byArray[356] = 27;
        byArray[357] = 27;
        byArray[358] = 27;
        byArray[359] = 27;
        byArray[360] = 27;
        byArray[361] = 27;
        byArray[362] = 27;
        byArray[363] = 27;
        byArray[364] = 27;
        byArray[365] = 27;
        byArray[366] = 27;
        byArray[367] = 27;
        byArray[368] = 27;
        byArray[369] = 27;
        byArray[370] = 27;
        byArray[371] = 27;
        byArray[372] = 27;
        byArray[373] = 27;
        byArray[374] = 27;
        byArray[375] = 27;
        byArray[376] = 27;
        byArray[377] = 27;
        byArray[378] = 27;
        byArray[379] = 27;
        byArray[380] = 27;
        byArray[381] = 27;
        byArray[382] = 27;
        byArray[383] = 27;
        byArray[384] = 28;
        byArray[385] = 28;
        byArray[386] = 28;
        byArray[387] = 28;
        byArray[388] = 28;
        byArray[389] = 28;
        byArray[390] = 28;
        byArray[391] = 28;
        byArray[392] = 28;
        byArray[393] = 28;
        byArray[394] = 28;
        byArray[395] = 28;
        byArray[396] = 28;
        byArray[397] = 28;
        byArray[398] = 28;
        byArray[399] = 28;
        byArray[400] = 28;
        byArray[401] = 28;
        byArray[402] = 28;
        byArray[403] = 28;
        byArray[404] = 28;
        byArray[405] = 28;
        byArray[406] = 28;
        byArray[407] = 28;
        byArray[408] = 28;
        byArray[409] = 28;
        byArray[410] = 28;
        byArray[411] = 28;
        byArray[412] = 28;
        byArray[413] = 28;
        byArray[414] = 28;
        byArray[415] = 28;
        byArray[416] = 28;
        byArray[417] = 28;
        byArray[418] = 28;
        byArray[419] = 28;
        byArray[420] = 28;
        byArray[421] = 28;
        byArray[422] = 28;
        byArray[423] = 28;
        byArray[424] = 28;
        byArray[425] = 28;
        byArray[426] = 28;
        byArray[427] = 28;
        byArray[428] = 28;
        byArray[429] = 28;
        byArray[430] = 28;
        byArray[431] = 28;
        byArray[432] = 28;
        byArray[433] = 28;
        byArray[434] = 28;
        byArray[435] = 28;
        byArray[436] = 28;
        byArray[437] = 28;
        byArray[438] = 28;
        byArray[439] = 28;
        byArray[440] = 28;
        byArray[441] = 28;
        byArray[442] = 28;
        byArray[443] = 28;
        byArray[444] = 28;
        byArray[445] = 28;
        byArray[446] = 28;
        byArray[447] = 28;
        byArray[448] = 29;
        byArray[449] = 29;
        byArray[450] = 29;
        byArray[451] = 29;
        byArray[452] = 29;
        byArray[453] = 29;
        byArray[454] = 29;
        byArray[455] = 29;
        byArray[456] = 29;
        byArray[457] = 29;
        byArray[458] = 29;
        byArray[459] = 29;
        byArray[460] = 29;
        byArray[461] = 29;
        byArray[462] = 29;
        byArray[463] = 29;
        byArray[464] = 29;
        byArray[465] = 29;
        byArray[466] = 29;
        byArray[467] = 29;
        byArray[468] = 29;
        byArray[469] = 29;
        byArray[470] = 29;
        byArray[471] = 29;
        byArray[472] = 29;
        byArray[473] = 29;
        byArray[474] = 29;
        byArray[475] = 29;
        byArray[476] = 29;
        byArray[477] = 29;
        byArray[478] = 29;
        byArray[479] = 29;
        byArray[480] = 29;
        byArray[481] = 29;
        byArray[482] = 29;
        byArray[483] = 29;
        byArray[484] = 29;
        byArray[485] = 29;
        byArray[486] = 29;
        byArray[487] = 29;
        byArray[488] = 29;
        byArray[489] = 29;
        byArray[490] = 29;
        byArray[491] = 29;
        byArray[492] = 29;
        byArray[493] = 29;
        byArray[494] = 29;
        byArray[495] = 29;
        byArray[496] = 29;
        byArray[497] = 29;
        byArray[498] = 29;
        byArray[499] = 29;
        byArray[500] = 29;
        byArray[501] = 29;
        byArray[502] = 29;
        byArray[503] = 29;
        byArray[504] = 29;
        byArray[505] = 29;
        byArray[506] = 29;
        byArray[507] = 29;
        byArray[508] = 29;
        byArray[509] = 29;
        byArray[510] = 29;
        byArray[511] = 29;
        DIST_CODE = byArray;
        byte[] byArray2 = new byte[19];
        byArray2[0] = 16;
        byArray2[1] = 17;
        byArray2[2] = 18;
        byArray2[4] = 8;
        byArray2[5] = 7;
        byArray2[6] = 9;
        byArray2[7] = 6;
        byArray2[8] = 10;
        byArray2[9] = 5;
        byArray2[10] = 11;
        byArray2[11] = 4;
        byArray2[12] = 12;
        byArray2[13] = 3;
        byArray2[14] = 13;
        byArray2[15] = 2;
        byArray2[16] = 14;
        byArray2[17] = 1;
        byArray2[18] = 15;
        BL_ORDER = byArray2;
        byte[] byArray3 = new byte[256];
        byArray3[1] = 1;
        byArray3[2] = 2;
        byArray3[3] = 3;
        byArray3[4] = 4;
        byArray3[5] = 5;
        byArray3[6] = 6;
        byArray3[7] = 7;
        byArray3[8] = 8;
        byArray3[9] = 8;
        byArray3[10] = 9;
        byArray3[11] = 9;
        byArray3[12] = 10;
        byArray3[13] = 10;
        byArray3[14] = 11;
        byArray3[15] = 11;
        byArray3[16] = 12;
        byArray3[17] = 12;
        byArray3[18] = 12;
        byArray3[19] = 12;
        byArray3[20] = 13;
        byArray3[21] = 13;
        byArray3[22] = 13;
        byArray3[23] = 13;
        byArray3[24] = 14;
        byArray3[25] = 14;
        byArray3[26] = 14;
        byArray3[27] = 14;
        byArray3[28] = 15;
        byArray3[29] = 15;
        byArray3[30] = 15;
        byArray3[31] = 15;
        byArray3[32] = 16;
        byArray3[33] = 16;
        byArray3[34] = 16;
        byArray3[35] = 16;
        byArray3[36] = 16;
        byArray3[37] = 16;
        byArray3[38] = 16;
        byArray3[39] = 16;
        byArray3[40] = 17;
        byArray3[41] = 17;
        byArray3[42] = 17;
        byArray3[43] = 17;
        byArray3[44] = 17;
        byArray3[45] = 17;
        byArray3[46] = 17;
        byArray3[47] = 17;
        byArray3[48] = 18;
        byArray3[49] = 18;
        byArray3[50] = 18;
        byArray3[51] = 18;
        byArray3[52] = 18;
        byArray3[53] = 18;
        byArray3[54] = 18;
        byArray3[55] = 18;
        byArray3[56] = 19;
        byArray3[57] = 19;
        byArray3[58] = 19;
        byArray3[59] = 19;
        byArray3[60] = 19;
        byArray3[61] = 19;
        byArray3[62] = 19;
        byArray3[63] = 19;
        byArray3[64] = 20;
        byArray3[65] = 20;
        byArray3[66] = 20;
        byArray3[67] = 20;
        byArray3[68] = 20;
        byArray3[69] = 20;
        byArray3[70] = 20;
        byArray3[71] = 20;
        byArray3[72] = 20;
        byArray3[73] = 20;
        byArray3[74] = 20;
        byArray3[75] = 20;
        byArray3[76] = 20;
        byArray3[77] = 20;
        byArray3[78] = 20;
        byArray3[79] = 20;
        byArray3[80] = 21;
        byArray3[81] = 21;
        byArray3[82] = 21;
        byArray3[83] = 21;
        byArray3[84] = 21;
        byArray3[85] = 21;
        byArray3[86] = 21;
        byArray3[87] = 21;
        byArray3[88] = 21;
        byArray3[89] = 21;
        byArray3[90] = 21;
        byArray3[91] = 21;
        byArray3[92] = 21;
        byArray3[93] = 21;
        byArray3[94] = 21;
        byArray3[95] = 21;
        byArray3[96] = 22;
        byArray3[97] = 22;
        byArray3[98] = 22;
        byArray3[99] = 22;
        byArray3[100] = 22;
        byArray3[101] = 22;
        byArray3[102] = 22;
        byArray3[103] = 22;
        byArray3[104] = 22;
        byArray3[105] = 22;
        byArray3[106] = 22;
        byArray3[107] = 22;
        byArray3[108] = 22;
        byArray3[109] = 22;
        byArray3[110] = 22;
        byArray3[111] = 22;
        byArray3[112] = 23;
        byArray3[113] = 23;
        byArray3[114] = 23;
        byArray3[115] = 23;
        byArray3[116] = 23;
        byArray3[117] = 23;
        byArray3[118] = 23;
        byArray3[119] = 23;
        byArray3[120] = 23;
        byArray3[121] = 23;
        byArray3[122] = 23;
        byArray3[123] = 23;
        byArray3[124] = 23;
        byArray3[125] = 23;
        byArray3[126] = 23;
        byArray3[127] = 23;
        byArray3[128] = 24;
        byArray3[129] = 24;
        byArray3[130] = 24;
        byArray3[131] = 24;
        byArray3[132] = 24;
        byArray3[133] = 24;
        byArray3[134] = 24;
        byArray3[135] = 24;
        byArray3[136] = 24;
        byArray3[137] = 24;
        byArray3[138] = 24;
        byArray3[139] = 24;
        byArray3[140] = 24;
        byArray3[141] = 24;
        byArray3[142] = 24;
        byArray3[143] = 24;
        byArray3[144] = 24;
        byArray3[145] = 24;
        byArray3[146] = 24;
        byArray3[147] = 24;
        byArray3[148] = 24;
        byArray3[149] = 24;
        byArray3[150] = 24;
        byArray3[151] = 24;
        byArray3[152] = 24;
        byArray3[153] = 24;
        byArray3[154] = 24;
        byArray3[155] = 24;
        byArray3[156] = 24;
        byArray3[157] = 24;
        byArray3[158] = 24;
        byArray3[159] = 24;
        byArray3[160] = 25;
        byArray3[161] = 25;
        byArray3[162] = 25;
        byArray3[163] = 25;
        byArray3[164] = 25;
        byArray3[165] = 25;
        byArray3[166] = 25;
        byArray3[167] = 25;
        byArray3[168] = 25;
        byArray3[169] = 25;
        byArray3[170] = 25;
        byArray3[171] = 25;
        byArray3[172] = 25;
        byArray3[173] = 25;
        byArray3[174] = 25;
        byArray3[175] = 25;
        byArray3[176] = 25;
        byArray3[177] = 25;
        byArray3[178] = 25;
        byArray3[179] = 25;
        byArray3[180] = 25;
        byArray3[181] = 25;
        byArray3[182] = 25;
        byArray3[183] = 25;
        byArray3[184] = 25;
        byArray3[185] = 25;
        byArray3[186] = 25;
        byArray3[187] = 25;
        byArray3[188] = 25;
        byArray3[189] = 25;
        byArray3[190] = 25;
        byArray3[191] = 25;
        byArray3[192] = 26;
        byArray3[193] = 26;
        byArray3[194] = 26;
        byArray3[195] = 26;
        byArray3[196] = 26;
        byArray3[197] = 26;
        byArray3[198] = 26;
        byArray3[199] = 26;
        byArray3[200] = 26;
        byArray3[201] = 26;
        byArray3[202] = 26;
        byArray3[203] = 26;
        byArray3[204] = 26;
        byArray3[205] = 26;
        byArray3[206] = 26;
        byArray3[207] = 26;
        byArray3[208] = 26;
        byArray3[209] = 26;
        byArray3[210] = 26;
        byArray3[211] = 26;
        byArray3[212] = 26;
        byArray3[213] = 26;
        byArray3[214] = 26;
        byArray3[215] = 26;
        byArray3[216] = 26;
        byArray3[217] = 26;
        byArray3[218] = 26;
        byArray3[219] = 26;
        byArray3[220] = 26;
        byArray3[221] = 26;
        byArray3[222] = 26;
        byArray3[223] = 26;
        byArray3[224] = 27;
        byArray3[225] = 27;
        byArray3[226] = 27;
        byArray3[227] = 27;
        byArray3[228] = 27;
        byArray3[229] = 27;
        byArray3[230] = 27;
        byArray3[231] = 27;
        byArray3[232] = 27;
        byArray3[233] = 27;
        byArray3[234] = 27;
        byArray3[235] = 27;
        byArray3[236] = 27;
        byArray3[237] = 27;
        byArray3[238] = 27;
        byArray3[239] = 27;
        byArray3[240] = 27;
        byArray3[241] = 27;
        byArray3[242] = 27;
        byArray3[243] = 27;
        byArray3[244] = 27;
        byArray3[245] = 27;
        byArray3[246] = 27;
        byArray3[247] = 27;
        byArray3[248] = 27;
        byArray3[249] = 27;
        byArray3[250] = 27;
        byArray3[251] = 27;
        byArray3[252] = 27;
        byArray3[253] = 27;
        byArray3[254] = 27;
        byArray3[255] = 28;
        LENGTH_CODE = byArray3;
        int[] nArray = new int[29];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[8] = 8;
        nArray[9] = 10;
        nArray[10] = 12;
        nArray[11] = 14;
        nArray[12] = 16;
        nArray[13] = 20;
        nArray[14] = 24;
        nArray[15] = 28;
        nArray[16] = 32;
        nArray[17] = 40;
        nArray[18] = 48;
        nArray[19] = 56;
        nArray[20] = 64;
        nArray[21] = 80;
        nArray[22] = 96;
        nArray[23] = 112;
        nArray[24] = 128;
        nArray[25] = 160;
        nArray[26] = 192;
        nArray[27] = 224;
        BASE_LENGTH = nArray;
        int[] nArray2 = new int[30];
        nArray2[1] = 1;
        nArray2[2] = 2;
        nArray2[3] = 3;
        nArray2[4] = 4;
        nArray2[5] = 6;
        nArray2[6] = 8;
        nArray2[7] = 12;
        nArray2[8] = 16;
        nArray2[9] = 24;
        nArray2[10] = 32;
        nArray2[11] = 48;
        nArray2[12] = 64;
        nArray2[13] = 96;
        nArray2[14] = 128;
        nArray2[15] = 192;
        nArray2[16] = 256;
        nArray2[17] = 384;
        nArray2[18] = 512;
        nArray2[19] = 768;
        nArray2[20] = 1024;
        nArray2[21] = 1536;
        nArray2[22] = 2048;
        nArray2[23] = 3072;
        nArray2[24] = 4096;
        nArray2[25] = 6144;
        nArray2[26] = 8192;
        nArray2[27] = 12288;
        nArray2[28] = 16384;
        nArray2[29] = 24576;
        BASE_DIST = nArray2;
        CONFIG_TABLE = new Config[]{new Config(0, 0, 0, 0, 0), new Config(4, 4, 8, 4, 1), new Config(4, 5, 16, 8, 1), new Config(4, 6, 32, 32, 1), new Config(4, 4, 16, 16, 2), new Config(8, 16, 32, 32, 2), new Config(8, 16, 128, 128, 2), new Config(8, 32, 128, 256, 2), new Config(32, 128, 258, 1024, 2), new Config(32, 258, 258, 4096, 2)};
        ERROR_MESSAGE = new String[]{"need dictionary", "stream end", "", "file error", "stream error", "data error", "insufficient memory", "buffer error", "incompatible version", ""};
    }

    public static boolean smaller(int[] tree, int n, int m, byte[] depth) {
        int tn2 = tree[n * 2];
        int tm2 = tree[m * 2];
        return tn2 < tm2 || tn2 == tm2 && depth[n] <= depth[m];
    }

    public static int deflateCopy(ZStream dst, ZStream src) {
        if (src.dstate == null) {
            return -2;
        }
        byte[] next = src.nextIn;
        if (src.nextIn != null) {
            dst.nextIn = Deflate.dup(next);
        }
        dst.nextInIndex = src.nextInIndex;
        dst.availIn = src.availIn;
        dst.totalIn = src.totalIn;
        next = src.nextOut;
        if (src.nextOut != null) {
            dst.nextOut = Deflate.dup(next);
        }
        dst.nextOutIndex = src.nextOutIndex;
        dst.availOut = src.availOut;
        dst.totalOut = src.totalOut;
        dst.message = src.message;
        dst.dataType = src.dataType;
        dst.adler = src.adler.copy();
        dst.dstate = (Deflate)src.dstate.clone();
        ((Deflate)src.dstate.clone()).stream = dst;
        return 0;
    }

    private static int dcode(int dist) {
        return dist < 256 ? DIST_CODE[dist] : DIST_CODE[256 + (dist >>> 7)];
    }

    private static byte[] dup(byte[] buf) {
        int len = buf.length;
        byte[] result = new byte[len];
        Array.copy((byte[])buf, (int)0, (byte[])result, (int)0, (int)len);
        return result;
    }

    private static int[] dup(int[] buf) {
        int len = buf.length;
        int[] result = new int[len];
        Array.copy((int[])buf, (int)0, (int[])result, (int)0, (int)len);
        return result;
    }

    public Deflate(ZStream stream) {
        this.stream = stream;
    }

    public void pqDownHeap(int[] tree, int k) {
        int heapLen = this.heapLen;
        byte[] depth = this.depth;
        int[] heap = this.heap;
        int v = this.heap[k];
        int j = k << 1;
        while (j <= heapLen) {
            if (j < heapLen && Deflate.smaller(tree, heap[j + 1], heap[j], depth)) {
                ++j;
            }
            if (Deflate.smaller(tree, v, heap[j], depth)) break;
            heap[k] = heap[j];
            k = j;
            j <<= 1;
        }
        heap[k] = v;
    }

    public void putBytes(byte[] data, int offset, int length) {
        Array.copy((byte[])data, (int)offset, (byte[])this.pendingBuf, (int)this.pending, (int)length);
        this.pending += length;
    }

    public void putByte(byte c) {
        this.pendingBuf[this.pending++] = c;
    }

    public void putShort(int w) {
        this.putByte((byte)w);
        this.putByte((byte)(w >>> 8));
    }

    public int deflateInit(int level, int bits, int memlevel) {
        return this.deflateInit(level, 8, bits, memlevel, 0);
    }

    public int deflateInit(int level, int bits) {
        return this.deflateInit(level, 8, bits, 8, 0);
    }

    public int deflateInit(int level) {
        return this.deflateInit(level, 15);
    }

    public int deflateParams(int lvl, int strtg) {
        int err = 0;
        if (lvl == -1) {
            lvl = 6;
        }
        if (lvl < 0 || lvl > 9 || strtg < 0 || strtg > 2) {
            return -2;
        }
        if (Deflate.CONFIG_TABLE[this.level].func != Deflate.CONFIG_TABLE[lvl].func && this.stream.totalIn != 0L) {
            err = this.stream.deflate(1);
        }
        if (this.level != lvl) {
            Config config = CONFIG_TABLE[this.level];
            this.level = lvl;
            this.maxLazyMatch = config.maxLazy;
            this.goodMatch = config.goodLength;
            this.niceMatch = config.niceLength;
            this.maxChainLength = config.maxChain;
        }
        this.strategy = strtg;
        return err;
    }

    public int deflateSetDictionary(byte[] dictionary, int dictLength) {
        int index = 0;
        int length = dictLength;
        if (dictionary == null || this.status != 42) {
            return -2;
        }
        this.stream.adler.update(dictionary, 0, dictLength);
        if (length < 3) {
            return 0;
        }
        if (length > this.wSize - 262) {
            length = this.wSize - 262;
            index = dictLength - length;
        }
        Array.copy((byte[])dictionary, (int)index, (byte[])this.window, (int)0, (int)length);
        this.strStart = length;
        this.blockStart = length;
        this.insh = this.window[0] & 0xFF;
        this.insh = (this.insh << this.hashShift ^ this.window[1] & 0xFF) & this.hashMask;
        int n = 0;
        while (n <= length - 3) {
            this.insh = (this.insh << this.hashShift ^ this.window[n + 2] & 0xFF) & this.hashMask;
            this.prev[n & this.wMask] = this.head[this.insh];
            this.head[this.insh] = (short)n;
            ++n;
        }
        return 0;
    }

    public int deflate(int flush) {
        int adler;
        if (flush > 4 || flush < 0) {
            return -2;
        }
        if (this.stream.nextOut == null || this.stream.nextIn == null && this.stream.availIn != 0 || this.status == 666 && flush != 4) {
            this.stream.message = ERROR_MESSAGE[4];
            return -2;
        }
        if (this.stream.availOut == 0) {
            this.stream.message = ERROR_MESSAGE[7];
            return -5;
        }
        int oldFlush = this.lastFlush;
        this.lastFlush = flush;
        if (this.status == 42) {
            if (this.wrap == 2) {
                this.getGZIPHeader().put(this);
                this.status = 113;
                this.stream.adler.reset();
            } else {
                int header = 8 + (this.wBits - 8 << 4) << 8;
                int levelFlags = (this.level - 1 & 0xFF) >> 1;
                if (levelFlags > 3) {
                    levelFlags = 3;
                }
                header |= levelFlags << 6;
                if (this.strStart != 0) {
                    header |= 0x20;
                }
                header += 31 - header % 31;
                this.status = 113;
                this.putShortMSB(header);
                if (this.strStart != 0) {
                    int adler2 = this.stream.adler.value();
                    this.putShortMSB(adler2 >>> 16);
                    this.putShortMSB(adler2 & 0xFFFF);
                }
                this.stream.adler.reset();
            }
        }
        if (this.pending != 0) {
            this.stream.flushPending();
            if (this.stream.availOut == 0) {
                this.lastFlush = -1;
                return 0;
            }
        } else if (this.stream.availIn == 0 && flush <= oldFlush && flush != 4) {
            this.stream.message = ERROR_MESSAGE[7];
            return -5;
        }
        if (this.status == 666 && this.stream.availIn != 0) {
            this.stream.message = ERROR_MESSAGE[7];
            return -5;
        }
        if (this.stream.availIn != 0 || this.lookahead != 0 || flush != 0 && this.status != 666) {
            int bstate = -1;
            switch (Deflate.CONFIG_TABLE[this.level].func) {
                default: {
                    break;
                }
                case 0: {
                    bstate = this.deflateStored(flush);
                    break;
                }
                case 1: {
                    bstate = this.deflateFast(flush);
                    break;
                }
                case 2: {
                    bstate = this.deflateSlow(flush);
                }
            }
            if (bstate == 2 || bstate == 3) {
                this.status = 666;
            }
            if (bstate == 0 || bstate == 2) {
                if (this.stream.availOut == 0) {
                    this.lastFlush = -1;
                }
                return 0;
            }
            if (bstate == 1) {
                if (flush == 1) {
                    this.trAlign();
                } else {
                    this.trStoredBlock(0, 0, false);
                    if (flush == 3) {
                        int i = 0;
                        while (i < this.hashSize) {
                            this.head[i] = 0;
                            ++i;
                        }
                    }
                }
                this.stream.flushPending();
                if (this.stream.availOut == 0) {
                    this.lastFlush = -1;
                    return 0;
                }
            }
        }
        if (flush != 4) {
            return 0;
        }
        if (this.wrap <= 0) {
            return 1;
        }
        if (this.wrap == 2) {
            adler = this.stream.adler.value();
            int totalIn = (int)this.stream.totalIn;
            this.putByte((byte)adler);
            this.putByte((byte)(adler >> 8));
            this.putByte((byte)(adler >> 16));
            this.putByte((byte)(adler >> 24));
            this.putByte((byte)totalIn);
            this.putByte((byte)(totalIn >> 8));
            this.putByte((byte)(totalIn >> 16));
            this.putByte((byte)(totalIn >> 24));
            this.getGZIPHeader().setCRC(adler);
        } else {
            adler = this.stream.adler.value();
            this.putShortMSB(adler >>> 16);
            this.putShortMSB(adler & 0xFFFF);
        }
        this.stream.flushPending();
        if (this.wrap > 0) {
            this.wrap = -this.wrap;
        }
        return this.pending != 0 ? 0 : 1;
    }

    public int deflateEnd() {
        int status = this.status;
        if (status != 42 && status != 113 && status != 666) {
            return -2;
        }
        this.pendingBuf = null;
        this.head = null;
        this.prev = null;
        this.window = null;
        return status == 113 ? -3 : 0;
    }

    private void lmInit() {
        this.windowSize = 2 * this.wSize;
        this.head[this.hashSize - 1] = 0;
        int i = 0;
        while (i < this.hashSize - 1) {
            this.head[i] = 0;
            ++i;
        }
        Config config = CONFIG_TABLE[this.level];
        this.maxLazyMatch = config.maxLazy;
        this.goodMatch = config.goodLength;
        this.niceMatch = config.niceLength;
        this.maxChainLength = config.maxChain;
        this.strStart = 0;
        this.blockStart = 0;
        this.lookahead = 0;
        this.prevLength = 2;
        this.matchLength = 2;
        this.matchAvailable = 0;
        this.insh = 0;
    }

    private void trInit() {
        this.lDesc.dynTree = this.dynLtree;
        this.lDesc.statDesc = StaticTree.STATIC_L_DESC;
        this.dDesc.dynTree = this.dynDtree;
        this.dDesc.statDesc = StaticTree.STATIC_D_DESC;
        this.blDesc.dynTree = this.blTree;
        this.blDesc.statDesc = StaticTree.STATIC_BL_DESC;
        this.biBuf = 0;
        this.biValid = 0;
        this.lastEobLen = 8;
        this.initBlock();
    }

    private void initBlock() {
        int i = 0;
        while (i < 286) {
            this.dynLtree[i * 2] = 0;
            ++i;
        }
        i = 0;
        while (i < 30) {
            this.dynDtree[i * 2] = 0;
            ++i;
        }
        i = 0;
        while (i < 19) {
            this.blTree[i * 2] = 0;
            ++i;
        }
        this.dynLtree[512] = 1;
        this.staticLen = 0;
        this.optLen = 0;
        this.matches = 0;
        this.lastLit = 0;
    }

    private void scanTree(int[] tree, int maxCode) {
        int prevlen = -1;
        int nextlen = tree[1];
        int count = 0;
        int maxCount = 7;
        int minCount = 4;
        if (nextlen == 0) {
            maxCount = 138;
            minCount = 3;
        }
        tree[(maxCode + 1) * 2 + 1] = -1;
        int n = 0;
        while (n <= maxCode) {
            int curlen = nextlen;
            nextlen = tree[(n + 1) * 2 + 1];
            if (++count >= maxCount || curlen != nextlen) {
                if (count < minCount) {
                    int n2 = curlen * 2;
                    this.blTree[n2] = this.blTree[n2] + count;
                } else if (curlen != 0) {
                    if (curlen != prevlen) {
                        int n3 = curlen * 2;
                        this.blTree[n3] = this.blTree[n3] + 1;
                    }
                    this.blTree[32] = this.blTree[32] + 1;
                } else if (count <= 10) {
                    this.blTree[34] = this.blTree[34] + 1;
                } else {
                    this.blTree[36] = this.blTree[36] + 1;
                }
                count = 0;
                prevlen = curlen;
                if (nextlen == 0) {
                    maxCount = 138;
                    minCount = 3;
                } else if (curlen == nextlen) {
                    maxCount = 6;
                    minCount = 3;
                } else {
                    maxCount = 7;
                    minCount = 4;
                }
            }
            ++n;
        }
    }

    private void sendAllTrees(int lcodes, int dcodes, int blcodes) {
        this.sendBits(lcodes - 257, 5);
        this.sendBits(dcodes - 1, 5);
        this.sendBits(blcodes - 4, 4);
        int rank = 0;
        while (rank < blcodes) {
            this.sendBits(this.blTree[BL_ORDER[rank] * 2 + 1], 3);
            ++rank;
        }
        this.sendTree(this.dynLtree, lcodes - 1);
        this.sendTree(this.dynDtree, dcodes - 1);
    }

    private void sendTree(int[] tree, int maxCode) {
        int prevlen = -1;
        int nextlen = tree[1];
        int count = 0;
        int maxCount = 7;
        int minCount = 4;
        if (nextlen == 0) {
            maxCount = 138;
            minCount = 3;
        }
        int n = 0;
        while (n <= maxCode) {
            int curlen = nextlen;
            nextlen = tree[(n + 1) * 2 + 1];
            if (++count >= maxCount || curlen != nextlen) {
                if (count < minCount) {
                    do {
                        this.sendCode(curlen, this.blTree);
                    } while (--count != 0);
                } else if (curlen != 0) {
                    if (curlen != prevlen) {
                        this.sendCode(curlen, this.blTree);
                        --count;
                    }
                    this.sendCode(16, this.blTree);
                    this.sendBits(count - 3, 2);
                } else if (count <= 10) {
                    this.sendCode(17, this.blTree);
                    this.sendBits(count - 3, 3);
                } else {
                    this.sendCode(18, this.blTree);
                    this.sendBits(count - 11, 7);
                }
                count = 0;
                prevlen = curlen;
                if (nextlen == 0) {
                    maxCount = 138;
                    minCount = 3;
                } else if (curlen == nextlen) {
                    maxCount = 6;
                    minCount = 3;
                } else {
                    maxCount = 7;
                    minCount = 4;
                }
            }
            ++n;
        }
    }

    private void sendCode(int c, int[] tree) {
        int c2 = c * 2;
        this.sendBits(tree[c2] & 0xFFFF, tree[c2 + 1] & 0xFFFF);
    }

    private void sendBits(int value, int length) {
        int len = length;
        if (this.biValid > 16 - len) {
            int val = value;
            this.biBuf |= val << this.biValid & 0xFFFF;
            this.putShort(this.biBuf);
            this.biBuf = (short)(val >>> 16 - this.biValid);
            this.biValid += len - 16;
        } else {
            this.biBuf |= value << this.biValid & 0xFFFF;
            this.biValid += len;
        }
    }

    private void putShortMSB(int b) {
        this.putByte((byte)(b >> 8));
        this.putByte((byte)b);
    }

    private void trAlign() {
        this.sendBits(2, 3);
        this.sendCode(256, StaticTree.STATIC_LTREE);
        this.biFlush();
        if (this.lastEobLen - this.biValid < -2) {
            this.sendBits(2, 3);
            this.sendCode(256, StaticTree.STATIC_LTREE);
            this.biFlush();
        }
        this.lastEobLen = 7;
    }

    private void compressBlock(int[] ltree, int[] dtree) {
        int lx = 0;
        if (this.lastLit != 0) {
            do {
                int dist = (this.pendingBuf[this.dBuf + lx * 2] & 0xFF) << 8 | this.pendingBuf[this.dBuf + lx * 2 + 1] & 0xFF;
                int lc = this.pendingBuf[this.lBuf + lx] & 0xFF;
                ++lx;
                if (dist == 0) {
                    this.sendCode(lc, ltree);
                    continue;
                }
                int code = LENGTH_CODE[lc];
                this.sendCode(code + 256 + 1, ltree);
                int extra = StaticTree.EXTRA_LBITS[code];
                if (extra != 0) {
                    this.sendBits(lc -= BASE_LENGTH[code], extra);
                }
                code = Deflate.dcode(--dist);
                this.sendCode(code, dtree);
                extra = StaticTree.EXTRA_DBITS[code];
                if (extra == 0) continue;
                this.sendBits(dist -= BASE_DIST[code], extra);
            } while (lx < this.lastLit);
        }
        this.sendCode(256, ltree);
        this.lastEobLen = ltree[513];
    }

    private void setDataType() {
        int n = 0;
        int asciiFreq = 0;
        int binFreq = 0;
        while (n < 7) {
            binFreq += this.dynLtree[n * 2];
            ++n;
        }
        while (n < 128) {
            asciiFreq += this.dynLtree[n * 2];
            ++n;
        }
        while (n < 256) {
            binFreq += this.dynLtree[n * 2];
            ++n;
        }
        this.dataType = binFreq > asciiFreq >>> 2 ? 0 : 1;
    }

    private void biFlush() {
        if (this.biValid == 16) {
            this.putShort(this.biBuf);
            this.biBuf = 0;
            this.biValid = 0;
        } else if (this.biValid >= 8) {
            this.putByte((byte)this.biBuf);
            this.biBuf >>>= 8;
            this.biValid -= 8;
        }
    }

    private void biWindup() {
        if (this.biValid > 8) {
            this.putShort(this.biBuf);
        } else if (this.biValid > 0) {
            this.putByte((byte)this.biBuf);
        }
        this.biBuf = 0;
        this.biValid = 0;
    }

    private void copyBlock(int buf, int len, boolean header) {
        this.biWindup();
        this.lastEobLen = 8;
        if (header) {
            this.putShort((short)len);
            this.putShort((short)(~len));
        }
        this.putBytes(this.window, buf, len);
    }

    private void flushBlockOnly(boolean eof) {
        this.trFlushBlock(this.blockStart >= 0 ? this.blockStart : -1, this.strStart - this.blockStart, eof);
        this.blockStart = this.strStart;
        this.stream.flushPending();
    }

    private void trStoredBlock(int buf, int storedLen, boolean eof) {
        this.sendBits(0 + (eof ? 1 : 0), 3);
        this.copyBlock(buf, storedLen, true);
    }

    private void trFlushBlock(int buf, int storedLen, boolean eof) {
        int staticLenb;
        int optLenb;
        int maxBlindex = 0;
        if (this.level > 0) {
            if (this.dataType == 2) {
                this.setDataType();
            }
            this.lDesc.buildTree(this);
            this.dDesc.buildTree(this);
            maxBlindex = this.buildBlTree();
            optLenb = this.optLen + 10 >>> 3;
            staticLenb = this.staticLen + 10 >>> 3;
            if (staticLenb <= optLenb) {
                optLenb = staticLenb;
            }
        } else {
            optLenb = staticLenb = storedLen + 5;
        }
        if (storedLen + 4 <= optLenb && buf != -1) {
            this.trStoredBlock(buf, storedLen, eof);
        } else if (staticLenb == optLenb) {
            this.sendBits(2 + (eof ? 1 : 0), 3);
            this.compressBlock(StaticTree.STATIC_LTREE, StaticTree.STATIC_DTREE);
        } else {
            this.sendBits(4 + (eof ? 1 : 0), 3);
            this.sendAllTrees(this.lDesc.maxCode + 1, this.dDesc.maxCode + 1, maxBlindex + 1);
            this.compressBlock(this.dynLtree, this.dynDtree);
        }
        this.initBlock();
        if (eof) {
            this.biWindup();
        }
    }

    private void fillWindow() {
        do {
            int n;
            int more;
            if ((more = this.windowSize - this.lookahead - this.strStart) == 0 && this.strStart == 0 && this.lookahead == 0) {
                more = this.wSize;
            } else if (more == -1) {
                --more;
            } else if (this.strStart >= (this.wSize << 1) - 262) {
                int m;
                Array.copy((byte[])this.window, (int)this.wSize, (byte[])this.window, (int)0, (int)this.wSize);
                this.matchStart -= this.wSize;
                this.strStart -= this.wSize;
                this.blockStart -= this.wSize;
                int p = n = this.hashSize;
                do {
                    int n2 = this.head[p] = (m = this.head[--p] & 0xFFFF) >= this.wSize ? (int)(m - this.wSize) : 0;
                } while (--n != 0);
                p = n = this.wSize;
                do {
                    int n3 = this.prev[p] = (m = this.prev[--p] & 0xFFFF) >= this.wSize ? (int)(m - this.wSize) : 0;
                } while (--n != 0);
                more += this.wSize;
            }
            if (this.stream.availIn == 0) {
                return;
            }
            n = this.stream.readBuf(this.window, this.strStart + this.lookahead, more);
            this.lookahead += n;
            if (this.lookahead < 3) continue;
            this.insh = this.window[this.strStart] & 0xFF;
            this.insh = (this.insh << this.hashShift ^ this.window[this.strStart + 1] & 0xFF) & this.hashMask;
        } while (this.lookahead < 262 && this.stream.availIn != 0);
    }

    private boolean trTally(int dst, int lc) {
        this.pendingBuf[this.dBuf + this.lastLit * 2] = (byte)(dst >>> 8);
        this.pendingBuf[this.dBuf + this.lastLit * 2 + 1] = (byte)dst;
        this.pendingBuf[this.lBuf + this.lastLit] = (byte)lc;
        ++this.lastLit;
        if (dst == 0) {
            int n = lc * 2;
            this.dynLtree[n] = this.dynLtree[n] + 1;
        } else {
            ++this.matches;
            int n = (LENGTH_CODE[lc] + 256 + 1) * 2;
            this.dynLtree[n] = this.dynLtree[n] + 1;
            int n2 = Deflate.dcode(--dst) * 2;
            this.dynDtree[n2] = this.dynDtree[n2] + 1;
        }
        if ((this.lastLit & 0x1FFF) == 0 && this.level > 2) {
            int outLength = this.lastLit * 8;
            int inLength = this.strStart - this.blockStart;
            int dcode = 0;
            while (dcode < 30) {
                outLength = (int)((long)outLength + (long)this.dynDtree[dcode * 2] * (5L + (long)StaticTree.EXTRA_DBITS[dcode]));
                ++dcode;
            }
            if (this.matches < this.lastLit / 2 && (outLength >>>= 3) < inLength / 2) {
                return true;
            }
        }
        return this.lastLit == this.litBufSize - 1;
    }

    private int buildBlTree() {
        this.scanTree(this.dynLtree, this.lDesc.maxCode);
        this.scanTree(this.dynDtree, this.dDesc.maxCode);
        this.blDesc.buildTree(this);
        int maxBlindex = 18;
        while (maxBlindex >= 3) {
            if (this.blTree[BL_ORDER[maxBlindex] * 2 + 1] != 0) break;
            --maxBlindex;
        }
        this.optLen += 3 * (maxBlindex + 1) + 14;
        return maxBlindex;
    }

    private int deflateInit(int level, int method, int windowBits, int memLevel, int strategy) {
        int wraplocal = 1;
        this.stream.message = null;
        if (level == -1) {
            level = 6;
        }
        if (windowBits < 0) {
            wraplocal = 0;
            windowBits = -windowBits;
        } else if (windowBits > 15) {
            wraplocal = 2;
            windowBits -= 16;
            this.stream.adler = new CRC32();
        }
        if (memLevel < 1 || memLevel > 9 || method != 8 || windowBits < 9 || windowBits > 15 || level < 0 || level > 9 || strategy < 0 || strategy > 2) {
            return -2;
        }
        this.wrap = wraplocal;
        this.wBits = windowBits;
        this.wSize = 1 << this.wBits;
        this.wMask = this.wSize - 1;
        this.hashBits = memLevel + 7;
        this.hashSize = 1 << this.hashBits;
        this.hashMask = this.hashSize - 1;
        this.hashShift = (this.hashBits + 3 - 1) / 3;
        this.window = new byte[this.wSize * 2];
        this.prev = new int[this.wSize];
        this.head = new int[this.hashSize];
        this.litBufSize = 1 << memLevel + 6;
        this.pendingBuf = new byte[this.litBufSize * 4];
        this.pendingBufSize = this.litBufSize * 4;
        this.dBuf = this.litBufSize / 2;
        this.lBuf = 3 * this.litBufSize;
        this.level = level;
        this.strategy = strategy;
        return this.deflateReset();
    }

    private int deflateStored(int flush) {
        block6: {
            int maxBlockSize = 65535;
            if (maxBlockSize > this.pendingBufSize - 5) {
                maxBlockSize = this.pendingBufSize - 5;
            }
            while (true) {
                if (this.lookahead <= 1) {
                    this.fillWindow();
                    if (this.lookahead == 0 && flush == 0) {
                        return 0;
                    }
                    if (this.lookahead == 0) break block6;
                }
                this.strStart += this.lookahead;
                this.lookahead = 0;
                int maxStart = this.blockStart + maxBlockSize;
                if (this.strStart == 0 || this.strStart >= maxStart) {
                    this.lookahead = this.strStart - maxStart;
                    this.strStart = maxStart;
                    this.flushBlockOnly(false);
                    if (this.stream.availOut == 0) {
                        return 0;
                    }
                }
                if (this.strStart - this.blockStart < this.wSize - 262) continue;
                this.flushBlockOnly(false);
                if (this.stream.availOut == 0) break;
            }
            return 0;
        }
        this.flushBlockOnly(flush == 4);
        return this.stream.availOut == 0 ? (flush == 4 ? 2 : 0) : (flush == 4 ? 3 : 1);
    }

    private int deflateFast(int flush) {
        block10: {
            int hashHead = 0;
            while (true) {
                boolean bflush;
                if (this.lookahead < 262) {
                    this.fillWindow();
                    if (this.lookahead < 262 && flush == 0) {
                        return 0;
                    }
                    if (this.lookahead == 0) break block10;
                }
                if (this.lookahead >= 3) {
                    this.insh = (this.insh << this.hashShift ^ this.window[this.strStart + 2] & 0xFF) & this.hashMask;
                    hashHead = this.head[this.insh] & 0xFFFF;
                    this.prev[this.strStart & this.wMask] = this.head[this.insh];
                    this.head[this.insh] = (short)this.strStart;
                }
                if ((long)hashHead != 0L && (this.strStart - hashHead & 0xFFFF) <= this.wSize - 262 && this.strategy != 2) {
                    this.matchLength = this.longestMatch(hashHead);
                }
                if (this.matchLength >= 3) {
                    bflush = this.trTally(this.strStart - this.matchStart, this.matchLength - 3);
                    this.lookahead -= this.matchLength;
                    if (this.matchLength <= this.maxLazyMatch && this.lookahead >= 3) {
                        --this.matchLength;
                        do {
                            ++this.strStart;
                            this.insh = (this.insh << this.hashShift ^ this.window[this.strStart + 2] & 0xFF) & this.hashMask;
                            hashHead = this.head[this.insh] & 0xFFFF;
                            this.prev[this.strStart & this.wMask] = this.head[this.insh];
                            this.head[this.insh] = (short)this.strStart;
                        } while (--this.matchLength != 0);
                        ++this.strStart;
                    } else {
                        this.strStart += this.matchLength;
                        this.matchLength = 0;
                        this.insh = this.window[this.strStart] & 0xFF;
                        this.insh = (this.insh << this.hashShift ^ this.window[this.strStart + 1] & 0xFF) & this.hashMask;
                    }
                } else {
                    bflush = this.trTally(0, this.window[this.strStart] & 0xFF);
                    --this.lookahead;
                    ++this.strStart;
                }
                if (!bflush) continue;
                this.flushBlockOnly(false);
                if (this.stream.availOut == 0) break;
            }
            return 0;
        }
        this.flushBlockOnly(flush == 4);
        return this.stream.availOut == 0 ? (flush == 4 ? 2 : 0) : (flush == 4 ? 3 : 1);
    }

    private int deflateSlow(int flush) {
        boolean bflush;
        int hashHead = 0;
        while (true) {
            if (this.lookahead < 262) {
                this.fillWindow();
                if (this.lookahead < 262 && flush == 0) {
                    return 0;
                }
                if (this.lookahead == 0) break;
            }
            if (this.lookahead >= 3) {
                this.insh = (this.insh << this.hashShift ^ this.window[this.strStart + 2] & 0xFF) & this.hashMask;
                hashHead = this.head[this.insh] & 0xFFFF;
                this.prev[this.strStart & this.wMask] = this.head[this.insh];
                this.head[this.insh] = (short)this.strStart;
            }
            this.prevLength = this.matchLength;
            this.prevMatch = this.matchStart;
            this.matchLength = 2;
            if (hashHead != 0 && this.prevLength < this.maxLazyMatch && (this.strStart - hashHead & 0xFFFF) <= this.wSize - 262) {
                if (this.strategy != 2) {
                    this.matchLength = this.longestMatch(hashHead);
                }
                if (this.matchLength <= 5 && (this.strategy == 1 || this.matchLength == 3 && this.strStart - this.matchStart > 4096)) {
                    this.matchLength = 2;
                }
            }
            if (this.prevLength >= 3 && this.matchLength <= this.prevLength) {
                int maxInsert = this.strStart + this.lookahead - 3;
                bflush = this.trTally(this.strStart - 1 - this.prevMatch, this.prevLength - 3);
                this.lookahead -= this.prevLength - 1;
                this.prevLength -= 2;
                do {
                    if (++this.strStart > maxInsert) continue;
                    this.insh = (this.insh << this.hashShift ^ this.window[this.strStart + 2] & 0xFF) & this.hashMask;
                    hashHead = this.head[this.insh] & 0xFFFF;
                    this.prev[this.strStart & this.wMask] = this.head[this.insh];
                    this.head[this.insh] = (short)this.strStart;
                } while (--this.prevLength != 0);
                this.matchAvailable = 0;
                this.matchLength = 2;
                ++this.strStart;
                if (!bflush) continue;
                this.flushBlockOnly(false);
                if (this.stream.availOut != 0) continue;
                return 0;
            }
            if (this.matchAvailable != 0) {
                bflush = this.trTally(0, this.window[this.strStart - 1] & 0xFF);
                if (bflush) {
                    this.flushBlockOnly(false);
                }
                ++this.strStart;
                --this.lookahead;
                if (this.stream.availOut != 0) continue;
                return 0;
            }
            this.matchAvailable = 1;
            ++this.strStart;
            --this.lookahead;
        }
        if (this.matchAvailable != 0) {
            bflush = this.trTally(0, this.window[this.strStart - 1] & 0xFF);
            this.matchAvailable = 0;
        }
        this.flushBlockOnly(flush == 4);
        return this.stream.availOut == 0 ? (flush == 4 ? 2 : 0) : (flush == 4 ? 3 : 1);
    }

    private int deflateReset() {
        this.stream.totalOut = 0L;
        this.stream.totalIn = 0L;
        this.stream.message = null;
        this.stream.dataType = 2;
        this.pending = 0;
        this.pendingOut = 0;
        if (this.wrap < 0) {
            this.wrap = -this.wrap;
        }
        this.status = this.wrap == 0 ? 113 : 42;
        this.stream.adler.reset();
        this.lastFlush = 0;
        this.trInit();
        this.lmInit();
        return 0;
    }

    private int longestMatch(int curMatch) {
        int chainLength = this.maxChainLength;
        int scan = this.strStart;
        int bestLen = this.prevLength;
        int limit = this.strStart > this.wSize - 262 ? this.strStart - (this.wSize - 262) : 0;
        int niceMatchLocal = this.niceMatch;
        int wmask = this.wMask;
        int strend = this.strStart + 258;
        byte scanEnd1 = this.window[scan + bestLen - 1];
        byte scanEnd = this.window[scan + bestLen];
        if (this.prevLength >= this.goodMatch) {
            chainLength >>= 2;
        }
        if (niceMatchLocal > this.lookahead) {
            niceMatchLocal = this.lookahead;
        }
        do {
            int match;
            if (this.window[(match = curMatch) + bestLen] != scanEnd || this.window[match + bestLen - 1] != scanEnd1 || this.window[match] != this.window[scan] || this.window[++match] != this.window[scan + 1]) continue;
            scan += 2;
            ++match;
            while (this.window[++scan] == this.window[++match] && this.window[++scan] == this.window[++match] && this.window[++scan] == this.window[++match] && this.window[++scan] == this.window[++match] && this.window[++scan] == this.window[++match] && this.window[++scan] == this.window[++match] && this.window[++scan] == this.window[++match] && this.window[++scan] == this.window[++match] && scan < strend) {
            }
            int len = 258 - (strend - scan);
            scan = strend - 258;
            if (len <= bestLen) continue;
            this.matchStart = curMatch;
            bestLen = len;
            if (len >= niceMatchLocal) break;
            scanEnd1 = this.window[scan + bestLen - 1];
            scanEnd = this.window[scan + bestLen];
        } while ((curMatch = this.prev[curMatch & wmask] & 0xFFFF) > limit && --chainLength != 0);
        return bestLen <= this.lookahead ? bestLen : this.lookahead;
    }

    private Object clone() {
        Deflate dst = new Deflate(this.stream);
        dst.pendingBuf = Deflate.dup(dst.pendingBuf);
        dst.window = Deflate.dup(dst.window);
        dst.prev = Deflate.dup(dst.prev);
        dst.head = Deflate.dup(dst.head);
        dst.dynLtree = Deflate.dup(dst.dynLtree);
        dst.dynDtree = Deflate.dup(dst.dynDtree);
        dst.blTree = Deflate.dup(dst.blTree);
        dst.blCount = Deflate.dup(dst.blCount);
        dst.heap = Deflate.dup(dst.heap);
        dst.depth = Deflate.dup(dst.depth);
        dst.lDesc.dynTree = dst.dynLtree;
        dst.dDesc.dynTree = dst.dynDtree;
        dst.blDesc.dynTree = dst.blTree;
        if (dst.gheader != null) {
            dst.gheader = (GZIPHeader)dst.gheader.clone();
        }
        return dst;
    }

    private GZIPHeader getGZIPHeader() {
        GZIPHeader result = this.gheader;
        if (result == null) {
            this.gheader = result = new GZIPHeader();
        }
        return result;
    }
}

