/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.compression.zlib;

import malik.emulator.compression.zlib.GZIPException;
import malik.emulator.compression.zlib.Inflate;
import malik.emulator.compression.zlib.ZStream;

public final class Inflater
extends ZStream {
    public Inflater() {
        this.init();
    }

    public Inflater(int wbits) throws GZIPException {
        this(wbits, false);
    }

    public Inflater(int wbits, boolean nowrap) throws GZIPException {
        int ret = this.init(wbits, nowrap);
        if (ret != 0) {
            throw new GZIPException(String.valueOf(ret) + ": " + this.message);
        }
    }

    public int inflate(int flush) {
        return super.inflate(flush);
    }

    public boolean finished() {
        return this.istate.mode == 12;
    }

    public int init() {
        return this.init(15);
    }

    public int init(boolean nowrap) {
        return this.init(15, nowrap);
    }

    public int init(int wbits) {
        return this.init(wbits, false);
    }

    public int init(int wbits, boolean nowrap) {
        this.istate = new Inflate(this);
        return this.istate.inflateInit(nowrap ? -wbits : wbits);
    }

    public int sync() {
        return this.istate == null ? -2 : this.istate.inflateSync();
    }

    public int syncPoint() {
        return this.istate == null ? -2 : this.istate.inflateSyncPoint();
    }

    public int setDictionary(byte[] dictionary, int dictLength) {
        return this.istate == null ? -2 : this.istate.inflateSetDictionary(dictionary, dictLength);
    }

    public int end() {
        if (this.istate == null) {
            return -2;
        }
        int result = this.istate.inflateEnd();
        this.istate = null;
        return result;
    }
}

