/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.fileformats.graphics.jpeg;

import java.io.IOException;
import java.io.InputStream;
import malik.emulator.fileformats.ExtendedDataInputStream;
import malik.emulator.fileformats.InvalidDataFormatException;
import malik.emulator.fileformats.UnsupportedDataException;
import malik.emulator.fileformats.graphics.ImageDecoder;
import malik.emulator.fileformats.graphics.jpeg.ChaffmanTable;
import malik.emulator.fileformats.graphics.jpeg.ChaffmanTableSetChunk;
import malik.emulator.fileformats.graphics.jpeg.Chunk;
import malik.emulator.fileformats.graphics.jpeg.Component;
import malik.emulator.fileformats.graphics.jpeg.ImageHeaderChunk;
import malik.emulator.fileformats.graphics.jpeg.QuantizationTableSetChunk;
import malik.emulator.fileformats.graphics.jpeg.ScanDecoder;
import malik.emulator.fileformats.graphics.jpeg.StartOfScanChunk;
import malik.emulator.fileformats.graphics.jpeg.TableSetChunk;

public class JPEGDecoder
implements ImageDecoder {
    public static final long SIGNATURE = 65496L;
    static final int DC = 0;
    static final int AC = 1;
    static final int MIN = 65280;
    static final int SOF0 = 65472;
    static final int SOF1 = 65473;
    static final int SOF2 = 65474;
    static final int SOF3 = 65475;
    static final int DHT = 65476;
    static final int SOF5 = 65477;
    static final int SOF6 = 65478;
    static final int SOF7 = 65479;
    static final int JPG = 65480;
    static final int SOF9 = 65481;
    static final int SOF10 = 65482;
    static final int SOF11 = 65483;
    static final int DAC = 65484;
    static final int SOF13 = 65485;
    static final int SOF14 = 65486;
    static final int SOF15 = 65487;
    static final int RST0 = 65488;
    static final int RST1 = 65489;
    static final int RST2 = 65490;
    static final int RST3 = 65491;
    static final int RST4 = 65492;
    static final int RST5 = 65493;
    static final int RST6 = 65494;
    static final int RST7 = 65495;
    static final int EOI = 65497;
    static final int SOS = 65498;
    static final int DQT = 65499;
    static final int DNL = 65500;
    static final int DRI = 65501;
    static final int DHP = 65502;
    static final int EXP = 65503;
    static final int APP0 = 65504;
    static final int APP1 = 65505;
    static final int APP2 = 65506;
    static final int APP3 = 65507;
    static final int APP4 = 65508;
    static final int APP5 = 65509;
    static final int APP6 = 65510;
    static final int APP7 = 65511;
    static final int APP8 = 65512;
    static final int APP9 = 65513;
    static final int APP10 = 65514;
    static final int APP11 = 65515;
    static final int APP12 = 65516;
    static final int APP13 = 65517;
    static final int APP14 = 65518;
    static final int APP15 = 65519;
    static final int COM = 65534;
    static final int MAX = 65535;
    static final int MAX_COMPONENTS = 3;
    static final byte[] ORDER_ZIGZAG_INVERTED;
    private static final int ONE_SQRT_2 = 5793;
    private static final int COS_1_16_PI = 4017;
    private static final int SIN_6_16_PI = 3784;
    private static final int COS_3_16_PI = 3406;
    private static final int HALF_SQRT_2 = 2896;
    private static final int SIN_3_16_PI = 2276;
    private static final int COS_6_16_PI = 1567;
    private static final int SIN_1_16_PI = 799;
    private int width;
    private int height;
    private int[] pixels;

    static {
        byte[] byArray = new byte[64];
        byArray[1] = 1;
        byArray[2] = 8;
        byArray[3] = 16;
        byArray[4] = 9;
        byArray[5] = 2;
        byArray[6] = 3;
        byArray[7] = 10;
        byArray[8] = 17;
        byArray[9] = 24;
        byArray[10] = 32;
        byArray[11] = 25;
        byArray[12] = 18;
        byArray[13] = 11;
        byArray[14] = 4;
        byArray[15] = 5;
        byArray[16] = 12;
        byArray[17] = 19;
        byArray[18] = 26;
        byArray[19] = 33;
        byArray[20] = 40;
        byArray[21] = 48;
        byArray[22] = 41;
        byArray[23] = 34;
        byArray[24] = 27;
        byArray[25] = 20;
        byArray[26] = 13;
        byArray[27] = 6;
        byArray[28] = 7;
        byArray[29] = 14;
        byArray[30] = 21;
        byArray[31] = 28;
        byArray[32] = 35;
        byArray[33] = 42;
        byArray[34] = 49;
        byArray[35] = 56;
        byArray[36] = 57;
        byArray[37] = 50;
        byArray[38] = 43;
        byArray[39] = 36;
        byArray[40] = 29;
        byArray[41] = 22;
        byArray[42] = 15;
        byArray[43] = 23;
        byArray[44] = 30;
        byArray[45] = 37;
        byArray[46] = 44;
        byArray[47] = 51;
        byArray[48] = 58;
        byArray[49] = 59;
        byArray[50] = 52;
        byArray[51] = 45;
        byArray[52] = 38;
        byArray[53] = 31;
        byArray[54] = 39;
        byArray[55] = 46;
        byArray[56] = 53;
        byArray[57] = 60;
        byArray[58] = 61;
        byArray[59] = 54;
        byArray[60] = 47;
        byArray[61] = 55;
        byArray[62] = 62;
        byArray[63] = 63;
        ORDER_ZIGZAG_INVERTED = byArray;
    }

    private static void translateY(ImageHeaderChunk header, Component[] components, int width, int height, int[] pixels) {
        Component componentY = components[0];
        int horzSizeY = componentY.horzSize;
        int[] blocksY = componentY.blocks;
        int index = 0;
        int iy = 0;
        while (iy < height) {
            int ix = 0;
            while (ix < width) {
                int col = ix >> 3;
                int row = iy >> 3;
                int vrt = iy & 7;
                int hrz = ix & 7;
                int y = blocksY[col + row * horzSizeY << 6 | vrt << 3 | hrz];
                if (y < 0) {
                    y = 0;
                } else if (y > 255) {
                    y = 255;
                }
                pixels[index++] = y << 16 | y << 8 | y;
                ++ix;
            }
            ++iy;
        }
    }

    private static void translateYCbCr(ImageHeaderChunk header, Component[] components, int width, int height, int[] pixels) {
        Component componentY = components[0];
        Component componentCb = components[1];
        Component componentCr = components[2];
        int horzScaleY = componentY.horzFactor;
        int horzScaleCb = componentCb.horzFactor;
        int horzScaleCr = componentCr.horzFactor;
        int horzScaleMax = header.maxHorzFactor;
        int vertScaleY = componentY.vertFactor;
        int vertScaleCb = componentCb.vertFactor;
        int vertScaleCr = componentCr.vertFactor;
        int vertScaleMax = header.maxVertFactor;
        int horzSizeY = componentY.horzSize;
        int horzSizeCb = componentCb.horzSize;
        int horzSizeCr = componentCr.horzSize;
        int[] blocksY = componentY.blocks;
        int[] blocksCb = componentCb.blocks;
        int[] blocksCr = componentCr.blocks;
        int index = 0;
        int iy = 0;
        while (iy < height) {
            int ix = 0;
            while (ix < width) {
                int sx = ix * horzScaleY / horzScaleMax;
                int col = sx >> 3;
                int sy = iy * vertScaleY / vertScaleMax;
                int row = sy >> 3;
                int hrz = sx & 7;
                int vrt = sy & 7;
                int y = blocksY[col + row * horzSizeY << 6 | vrt << 3 | hrz] << 12;
                sx = ix * horzScaleCb / horzScaleMax;
                col = sx >> 3;
                sy = iy * vertScaleCb / vertScaleMax;
                row = sy >> 3;
                hrz = sx & 7;
                vrt = sy & 7;
                int cb = blocksCb[col + row * horzSizeCb << 6 | vrt << 3 | hrz] - 128;
                sx = ix * horzScaleCr / horzScaleMax;
                col = sx >> 3;
                sy = iy * vertScaleCr / vertScaleMax;
                row = sy >> 3;
                hrz = sx & 7;
                vrt = sy & 7;
                int cr = blocksCr[col + row * horzSizeCr << 6 | vrt << 3 | hrz] - 128;
                int r = y + cr * 5743 >> 12;
                int g = y - cb * 1410 - cr * 2925 >> 12;
                int b = y + cb * 7258 >> 12;
                pixels[index++] = (r < 0 ? 0 : (r > 255 ? 255 : r)) << 16 | (g < 0 ? 0 : (g > 255 ? 255 : g)) << 8 | (b < 0 ? 0 : (b > 255 ? 255 : b));
                ++ix;
            }
            ++iy;
        }
    }

    private static int[] buildImage(ImageHeaderChunk header, int[][] quantizationTables, int width, int height) throws InvalidDataFormatException {
        int[] p = new int[64];
        int[] result = new int[width * height];
        int componentsCount = header.getComponentsCount();
        Component[] components = new Component[componentsCount];
        int componentIndex = componentsCount;
        while (componentIndex-- > 0) {
            Component component = components[componentIndex] = header.getComponent(header.getComponentId(componentIndex));
            int[] q = quantizationTables[component.quantizationTableID];
            if (q == null) {
                throw new InvalidDataFormatException("JPEGDecoder.loadFromInputStream: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u043d\u043d\u044b\u0445.");
            }
            int[] b = component.blocks;
            int blen = component.blocks.length;
            int offset = 0;
            while (offset < blen) {
                int t;
                int v7;
                int v4;
                int v6;
                int v5;
                int v3;
                int v2;
                int v1;
                int v0;
                int index = 0;
                while (index < 64) {
                    p[index] = b[offset + index] * q[index];
                    ++index;
                }
                int r = 0;
                while (r < 64) {
                    if ((p[r + 1] | p[r + 2] | p[r + 3] | p[r + 4] | p[r + 5] | p[r + 6] | p[r + 7]) == 0) {
                        Array.fill((int[])p, (int)r, (int)8, (int)(5793 * p[r] + 512 >> 10));
                    } else {
                        v0 = 5793 * p[r] + 128 >> 8;
                        v1 = 5793 * p[r + 4] + 128 >> 8;
                        v2 = p[r + 2];
                        v3 = p[r + 6];
                        v5 = p[r + 1];
                        v6 = p[r + 7];
                        v4 = 2896 * (v5 - v6) + 128 >> 8;
                        v7 = 2896 * (v5 + v6) + 128 >> 8;
                        v5 = p[r + 3] << 4;
                        v6 = p[r + 5] << 4;
                        t = v0 - v1 + 1 >> 1;
                        v0 = v0 + v1 + 1 >> 1;
                        v1 = t;
                        t = v2 * 3784 + v3 * 1567 + 128 >> 8;
                        v2 = v2 * 1567 - v3 * 3784 + 128 >> 8;
                        v3 = t;
                        t = v4 - v6 + 1 >> 1;
                        v4 = v4 + v6 + 1 >> 1;
                        v6 = t;
                        t = v7 + v5 + 1 >> 1;
                        v5 = v7 - v5 + 1 >> 1;
                        v7 = t;
                        t = v0 - v3 + 1 >> 1;
                        v0 = v0 + v3 + 1 >> 1;
                        v3 = t;
                        t = v1 - v2 + 1 >> 1;
                        v1 = v1 + v2 + 1 >> 1;
                        v2 = t;
                        t = v4 * 2276 + v7 * 3406 + 2048 >> 12;
                        v4 = v4 * 3406 - v7 * 2276 + 2048 >> 12;
                        v7 = t;
                        t = v5 * 799 + v6 * 4017 + 2048 >> 12;
                        v5 = v5 * 4017 - v6 * 799 + 2048 >> 12;
                        v6 = t;
                        p[r] = v0 + v7;
                        p[r + 7] = v0 - v7;
                        p[r + 1] = v1 + v6;
                        p[r + 6] = v1 - v6;
                        p[r + 2] = v2 + v5;
                        p[r + 5] = v2 - v5;
                        p[r + 3] = v3 + v4;
                        p[r + 4] = v3 - v4;
                    }
                    r += 8;
                }
                int c = 0;
                while (c < 8) {
                    if ((p[c + 8] | p[c + 16] | p[c + 24] | p[c + 32] | p[c + 40] | p[c + 48] | p[c + 56]) == 0) {
                        p[c] = t = 5793 * p[c] + 8192 >> 14;
                        p[c + 8] = t;
                        p[c + 16] = t;
                        p[c + 24] = t;
                        p[c + 32] = t;
                        p[c + 40] = t;
                        p[c + 48] = t;
                        p[c + 56] = t;
                    } else {
                        v0 = 5793 * p[c] + 2048 >> 12;
                        v1 = 5793 * p[c + 32] + 2048 >> 12;
                        v2 = p[c + 16];
                        v3 = p[c + 48];
                        v5 = p[c + 8];
                        v6 = p[c + 56];
                        v4 = 2896 * (v5 - v6) + 2048 >> 12;
                        v7 = 2896 * (v5 + v6) + 2048 >> 12;
                        v5 = p[c + 24];
                        v6 = p[c + 40];
                        t = v0 - v1 + 1 >> 1;
                        v0 = v0 + v1 + 1 >> 1;
                        v1 = t;
                        t = v2 * 3784 + v3 * 1567 + 2048 >> 12;
                        v2 = v2 * 1567 - v3 * 3784 + 2048 >> 12;
                        v3 = t;
                        t = v4 - v6 + 1 >> 1;
                        v4 = v4 + v6 + 1 >> 1;
                        v6 = t;
                        t = v7 + v5 + 1 >> 1;
                        v5 = v7 - v5 + 1 >> 1;
                        v7 = t;
                        t = v0 - v3 + 1 >> 1;
                        v0 = v0 + v3 + 1 >> 1;
                        v3 = t;
                        t = v1 - v2 + 1 >> 1;
                        v1 = v1 + v2 + 1 >> 1;
                        v2 = t;
                        t = v4 * 2276 + v7 * 3406 + 2048 >> 12;
                        v4 = v4 * 3406 - v7 * 2276 + 2048 >> 12;
                        v7 = t;
                        t = v5 * 799 + v6 * 4017 + 2048 >> 12;
                        v5 = v5 * 4017 - v6 * 799 + 2048 >> 12;
                        v6 = t;
                        p[c] = v0 + v7;
                        p[c + 56] = v0 - v7;
                        p[c + 8] = v1 + v6;
                        p[c + 48] = v1 - v6;
                        p[c + 16] = v2 + v5;
                        p[c + 40] = v2 - v5;
                        p[c + 24] = v3 + v4;
                        p[c + 32] = v3 - v4;
                    }
                    ++c;
                }
                index = 0;
                while (index < 64) {
                    b[offset + index] = (p[index] + 8 >> 4) + 128;
                    ++index;
                }
                offset += 64;
            }
        }
        switch (componentsCount) {
            case 1: 
            case 2: {
                JPEGDecoder.translateY(header, components, width, height, result);
                break;
            }
            case 3: {
                JPEGDecoder.translateYCbCr(header, components, width, height, result);
            }
        }
        return result;
    }

    public void loadFromInputStream(InputStream stream) throws IOException {
        this.loadFromDataStream(new ExtendedDataInputStream(stream));
    }

    public void loadFromDataStream(ExtendedDataInputStream stream) throws IOException {
        int chunkName;
        int restartInterval = 0;
        int imageWidth = 0;
        int imageHeight = 0;
        int[] imagePixels = null;
        int[][] quantizationTables = new int[16][];
        ChaffmanTable[] chaffmanTables = new ChaffmanTable[32];
        StartOfScanChunk scan = new StartOfScanChunk();
        ImageHeaderChunk header = null;
        ScanDecoder decoder = null;
        block8: do {
            chunkName = stream.readUnsignedShort();
            switch (chunkName) {
                default: {
                    if (chunkName < 65280 || chunkName > 65535) {
                        throw new InvalidDataFormatException("JPEGDecoder.loadFromInputStream: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u043d\u043d\u044b\u0445.");
                    }
                    throw new UnsupportedDataException("JPEGDecoder.loadFromInputStream: \u043d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435.");
                }
                case 65472: 
                case 65473: 
                case 65474: {
                    if (header != null) {
                        throw new InvalidDataFormatException("JPEGDecoder.loadFromInputStream: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u043d\u043d\u044b\u0445.");
                    }
                    header = new ImageHeaderChunk(chunkName);
                    ((Chunk)header).loadFromDataStream(stream);
                    imageWidth = header.width;
                    imageHeight = header.height;
                    break;
                }
                case 65476: 
                case 65499: {
                    TableSetChunk chunk;
                    Object tables;
                    if (chunkName == 65499) {
                        tables = quantizationTables;
                        chunk = new QuantizationTableSetChunk();
                    } else {
                        tables = chaffmanTables;
                        chunk = new ChaffmanTableSetChunk();
                    }
                    ((Chunk)chunk).loadFromDataStream(stream);
                    int i = chunk.getTablesCount();
                    while (i-- > 0) {
                        int id = chunk.getTableId(i);
                        tables[id] = (int[])chunk.getTable(i);
                    }
                    continue block8;
                }
                case 65497: {
                    if (header != null) continue block8;
                    throw new InvalidDataFormatException("JPEGDecoder.loadFromInputStream: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u043d\u043d\u044b\u0445.");
                }
                case 65498: {
                    if (header == null) {
                        throw new InvalidDataFormatException("JPEGDecoder.loadFromInputStream: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u043d\u043d\u044b\u0445.");
                    }
                    if (decoder == null) {
                        decoder = new ScanDecoder(stream.getSourceStream(), header);
                    }
                    ((Chunk)scan).loadFromDataStream(stream);
                    int i = scan.getComponentsCount();
                    while (i-- > 0) {
                        ChaffmanTable dc;
                        ChaffmanTable ac;
                        Component component = header.getComponent(scan.getComponentId(i));
                        component.chaffmanTableAC = ac = chaffmanTables[scan.getComponentChaffmanTableId(i, 1)];
                        component.chaffmanTableDC = dc = chaffmanTables[scan.getComponentChaffmanTableId(i, 0)];
                        if (ac != null && dc != null) continue;
                        throw new InvalidDataFormatException("JPEGDecoder.loadFromInputStream: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u043d\u043d\u044b\u0445.");
                    }
                    decoder.decodeScan(restartInterval, scan);
                    break;
                }
                case 65501: {
                    restartInterval = stream.readInt() & 0xFFFF;
                    break;
                }
                case 65504: 
                case 65505: 
                case 65506: 
                case 65507: 
                case 65508: 
                case 65509: 
                case 65510: 
                case 65511: 
                case 65512: 
                case 65513: 
                case 65514: 
                case 65515: 
                case 65516: 
                case 65517: 
                case 65518: 
                case 65519: 
                case 65534: {
                    int len = stream.readUnsignedShort() - 2;
                    if (len >= 0 && stream.skipBytes(len) == len) continue block8;
                    throw new InvalidDataFormatException("JPEGDecoder.loadFromInputStream: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u043d\u043d\u044b\u0445.");
                }
            }
        } while (chunkName != 65497);
        imagePixels = JPEGDecoder.buildImage(header, quantizationTables, imageWidth, imageHeight);
        this.width = imageWidth;
        this.height = imageHeight;
        this.pixels = imagePixels;
    }

    public void clear() {
        this.width = 0;
        this.height = 0;
        this.pixels = null;
    }

    public boolean isEmpty() {
        return (this.width | this.height) == 0 && this.pixels == null;
    }

    public boolean alphaSupported() {
        return false;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int[] getPixels() {
        int[] result = this.pixels;
        if (this.pixels == null) {
            return null;
        }
        int[] nArray = result;
        int len = result.length;
        result = new int[len];
        Array.copy((int[])nArray, (int)0, (int[])result, (int)0, (int)len);
        return result;
    }
}

