/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.fileformats.sound.synthetic.midi;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import javax.microedition.media.Control;
import javax.microedition.media.control.MetaDataControl;
import malik.emulator.fileformats.ExtendedDataInputStream;
import malik.emulator.fileformats.InvalidDataFormatException;
import malik.emulator.fileformats.UnsupportedDataException;
import malik.emulator.fileformats.sound.synthetic.SyntheticSoundDecoder;
import malik.emulator.microedition.media.ControlList;
import malik.emulator.microedition.media.SyntheticPlayerDecoder;

public final class MIDIDecoder
extends ControlList
implements SyntheticSoundDecoder,
SyntheticPlayerDecoder {
    public static final long SIGNATURE = 1297377380L;
    public static final String MIME_TYPE = "audio/midi";
    private static final double DEFAULT_TEMPO = 500000.0;
    private static final int MAXIMUM_TRACKS = 128;
    private static final int MTRK = 1297379947;
    private boolean stopped;
    private long[] messages;
    private final MetaData info;

    public MIDIDecoder() {
        MetaData info = new MetaData();
        this.controls = new Control[]{info};
        this.info = info;
    }

    public void loadFromInputStream(InputStream stream) throws IOException {
        this.loadFromDataStream(new ExtendedDataInputStream(stream));
    }

    public void loadFromDataStream(ExtendedDataInputStream stream) throws IOException {
        this.checkStopped();
        if (stream.readInt() != 6) {
            throw new InvalidDataFormatException("MIDIDecoder.loadFromInputStream: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u043d\u043d\u044b\u0445.");
        }
        stream.readUnsignedShort();
        int ntracks = stream.readUnsignedShort();
        if (ntracks > 128) {
            throw new UnsupportedDataException("MIDIDecoder.loadFromInputStream: \u043d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435.");
        }
        if (ntracks <= 0) {
            throw new InvalidDataFormatException("MIDIDecoder.loadFromInputStream: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u043d\u043d\u044b\u0445.");
        }
        short ippqn = stream.readShort();
        if (ippqn <= 0) {
            throw new UnsupportedDataException("MIDIDecoder.loadFromInputStream: \u043d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435.");
        }
        Track[] tracks = new Track[ntracks];
        int i = 0;
        while (i < ntracks) {
            this.checkStopped();
            int chunkName = stream.readInt();
            int chunkSize = stream.readInt();
            if (chunkName != 1297379947) {
                stream.skip((long)chunkSize & 0xFFFFFFFFL);
            } else {
                if (chunkSize < 0) {
                    throw new UnsupportedDataException("MIDIDecoder.loadFromInputStream: \u043d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435.");
                }
                byte[] trackData = new byte[chunkSize];
                stream.readFully(trackData);
                tracks[i] = new Track(trackData);
            }
            ++i;
        }
        this.checkStopped();
        double ppqn = 1000.0 * (double)ippqn;
        double tempo = 500000.0;
        double currentTimeInMillis = 0.0;
        int len = 1;
        int ntracksEnds = 0;
        long currentTimeInDelta = 0L;
        long[] messages = new long[15];
        String copyright = null;
        i = ntracks;
        while (i-- > 0) {
            this.checkStopped();
            tracks[i].readTimeInDelta();
        }
        block8: while (true) {
            long offsetTimeInDelta;
            int dataByte2;
            int dataByte1;
            this.checkStopped();
            Track currentTrack = tracks[0];
            long minTimeInDelta = currentTrack.eventTimeInDelta;
            int i2 = 1;
            while (i2 < ntracks) {
                this.checkStopped();
                Track thisTrack = tracks[i2];
                long thisTimeInDelta = thisTrack.eventTimeInDelta;
                if (thisTimeInDelta < minTimeInDelta) {
                    currentTrack = thisTrack;
                    minTimeInDelta = thisTimeInDelta;
                }
                ++i2;
            }
            int statusByte = currentTrack.read();
            if (statusByte < 0) break;
            if ((statusByte & 0x80) == 0) {
                statusByte = currentTrack.lastStatusByte;
                currentTrack.seek(-1);
            } else if (statusByte != 255) {
                currentTrack.lastStatusByte = statusByte;
            }
            if (statusByte >= 128 && statusByte < 192 || statusByte >= 224 && statusByte < 240) {
                dataByte1 = currentTrack.read();
                dataByte2 = currentTrack.read();
            } else if (statusByte >= 192 && statusByte < 224) {
                dataByte1 = currentTrack.read();
                dataByte2 = 0;
            } else {
                if (statusByte == 240 || statusByte == 247) {
                    currentTrack.seek(currentTrack.readVolatileLengthValue());
                    currentTrack.readTimeInDelta();
                    continue;
                }
                if (statusByte == 241 || statusByte == 243) {
                    currentTrack.seek(1);
                    currentTrack.readTimeInDelta();
                    continue;
                }
                if (statusByte == 242) {
                    currentTrack.seek(2);
                    currentTrack.readTimeInDelta();
                    continue;
                }
                if (statusByte != 255) {
                    currentTrack.readTimeInDelta();
                    continue;
                }
                switch (currentTrack.read()) {
                    default: {
                        currentTrack.seek(currentTrack.readVolatileLengthValue());
                        currentTrack.readTimeInDelta();
                        continue block8;
                    }
                    case -1: {
                        break block8;
                    }
                    case 2: {
                        copyright = currentTrack.readText();
                        currentTrack.readTimeInDelta();
                        continue block8;
                    }
                    case 47: {
                        if (currentTrack.read() != 0) break block8;
                        break;
                    }
                    case 81: {
                        int dataByte3;
                        int dataByte12;
                        statusByte = currentTrack.readVolatileLengthValue();
                        if (statusByte < 3 || ((dataByte12 = currentTrack.read()) | (dataByte2 = currentTrack.read()) | (dataByte3 = currentTrack.read())) < 0) break block8;
                        tempo = dataByte12 << 16 | dataByte2 << 8 | dataByte3;
                        currentTrack.seek(statusByte - 3);
                        currentTrack.readTimeInDelta();
                        continue block8;
                    }
                }
                if (++ntracksEnds < ntracks) {
                    currentTrack.endOfTrack();
                    continue;
                }
                offsetTimeInDelta = currentTrack.eventTimeInDelta - currentTimeInDelta;
                double offsetTimeInMillis = (double)offsetTimeInDelta * tempo / ppqn;
                currentTimeInDelta += offsetTimeInDelta;
                currentTimeInMillis += offsetTimeInMillis;
                if (len == messages.length) {
                    long[] lArray = messages;
                    messages = new long[(len << 1) + 1];
                    Array.copy((long[])lArray, (int)0, (long[])messages, (int)0, (int)len);
                }
                messages[len++] = (long)currentTimeInMillis << 24 | 0xFF2F00L;
                break;
            }
            offsetTimeInDelta = currentTrack.eventTimeInDelta - currentTimeInDelta;
            double offsetTimeInMillis = (double)offsetTimeInDelta * tempo / ppqn;
            currentTimeInDelta += offsetTimeInDelta;
            currentTimeInMillis += offsetTimeInMillis;
            if (len == messages.length) {
                long[] lArray = messages;
                messages = new long[(len << 1) + 1];
                Array.copy((long[])lArray, (int)0, (long[])messages, (int)0, (int)len);
            }
            messages[len++] = (long)currentTimeInMillis << 24 | (long)(statusByte << 16 | dataByte1 << 8 | dataByte2);
            currentTrack.readTimeInDelta();
        }
        if (len < messages.length) {
            long[] lArray = messages;
            messages = new long[len];
            Array.copy((long[])lArray, (int)0, (long[])messages, (int)0, (int)len);
        }
        this.messages = messages;
        this.info.copyright = copyright;
    }

    public void stopDecoding() {
        this.stopped = true;
    }

    public void clear() {
        this.stopped = false;
        this.messages = null;
        this.info.copyright = null;
    }

    public boolean isEmpty() {
        return this.messages == null && this.info.copyright == null;
    }

    public long[] getMessages() {
        long[] result = this.messages;
        if (this.messages == null) {
            return null;
        }
        long[] lArray = result;
        int len = result.length;
        result = new long[len];
        Array.copy((long[])lArray, (int)0, (long[])result, (int)0, (int)len);
        return result;
    }

    public String getContentType() {
        return MIME_TYPE;
    }

    private void checkStopped() throws InterruptedIOException {
        if (this.stopped) {
            this.stopped = false;
            throw new InterruptedIOException("MIDIDecoder.loadFromInputStream: \u043f\u0440\u043e\u0446\u0435\u0441\u0441 \u0434\u0435\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0431\u044b\u043b \u043f\u0440\u0435\u0440\u0432\u0430\u043d.");
        }
    }

    private static final class MetaData
    implements Control,
    MetaDataControl {
        public String copyright;

        public String[] getKeys() {
            return new String[]{"copyright"};
        }

        public String getKeyValue(String key) {
            if ("copyright".equals(key)) {
                return this.copyright;
            }
            throw new IllegalArgumentException("MetaDataControl.getKeyValue: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 key \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
    }

    private static final class Track
    extends ByteArrayInputStream {
        public int lastStatusByte;
        public long eventTimeInDelta;

        public Track(byte[] buffer) {
            super(buffer);
        }

        public void seek(int delta) {
            this.pos += delta;
        }

        public void endOfTrack() {
            this.eventTimeInDelta = Long.MAX_VALUE;
        }

        public void readTimeInDelta() {
            this.eventTimeInDelta += (long)this.readVolatileLengthValue();
        }

        public int readVolatileLengthValue() {
            int result = 0;
            int position = this.pos;
            byte[] buffer = this.buf;
            int len = buffer != null ? buffer.length : 0;
            int i = 4;
            while (position >= 0 && position < len && i-- > 0) {
                int b = buffer[position++] & 0xFF;
                result = result << 7 | b & 0x7F;
                if ((b & 0x80) == 0) break;
            }
            this.pos = position;
            return result;
        }

        public String readText() {
            int len = this.readVolatileLengthValue();
            byte[] bytes = new byte[len];
            this.read(bytes, 0, len);
            char[] chars = new char[len];
            int i = len;
            while (i-- > 0) {
                chars[i] = (char)(bytes[i] & 0xFF);
            }
            return new String(chars);
        }
    }
}

