/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.fileformats.sound.synthetic.midi;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import malik.emulator.fileformats.EmptyAdapterException;
import malik.emulator.fileformats.ExtendedDataOutputStream;
import malik.emulator.fileformats.InvalidDataFormatException;
import malik.emulator.fileformats.UnsupportedDataException;
import malik.emulator.fileformats.sound.synthetic.SyntheticSoundEncoder;

public final class MIDIEncoder
implements SyntheticSoundEncoder {
    public static final long SIGNATURE = 1297377380L;
    private static final int PPQN = 100;
    private static final int TEMPO = 100000;
    private static final int MTRK = 1297379947;
    private long[] messages;

    public void saveToOutputStream(OutputStream stream) throws IOException {
        this.saveToDataStream(new ExtendedDataOutputStream(stream));
    }

    public void saveToDataStream(ExtendedDataOutputStream stream) throws IOException {
        long[] trackMessages = this.messages;
        if (trackMessages == null) {
            throw new EmptyAdapterException("MIDIEncoder.saveToOutputStream: \u043a\u043e\u0434\u0435\u0440 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0434\u0430\u043d\u043d\u044b\u0435.");
        }
        Track track = new Track();
        track.writeVolatileLengthValue(0);
        track.write(255);
        track.write(81);
        track.write(3);
        track.write(1);
        track.write(390);
        track.write(100000);
        long prevTime = 0L;
        int prevStatusByte = 0;
        int len = trackMessages.length;
        int i = 0;
        while (i < len) {
            long longMsg = trackMessages[i];
            long currTime = longMsg >> 24;
            int shortMsg = (int)longMsg & 0xFFFFFF;
            int deltaTime = (int)(currTime - prevTime);
            int statusByte = shortMsg >> 16;
            int dataByte1 = shortMsg >> 8 & 0xFF;
            int dataByte2 = shortMsg & 0xFF;
            if (statusByte >= 128 && statusByte < 240) {
                prevTime = currTime;
                track.writeVolatileLengthValue(deltaTime);
                if (statusByte != prevStatusByte || dataByte1 >= 128) {
                    prevStatusByte = statusByte;
                    track.write(prevStatusByte);
                }
                track.write(dataByte1);
                if (statusByte < 192 || statusByte >= 224) {
                    track.write(dataByte2);
                }
            } else if (shortMsg == 0xFF2F00) {
                track.writeVolatileLengthValue(deltaTime);
                track.write(255);
                track.write(47);
                track.write(0);
                break;
            }
            ++i;
        }
        stream.writeInt(1297377380);
        stream.writeInt(6);
        stream.writeShort(0);
        stream.writeShort(1);
        stream.writeShort(100);
        stream.writeInt(1297379947);
        byte[] trackData = track.toByteArray();
        stream.writeInt(trackData.length);
        stream.write(trackData);
    }

    public void clear() {
        this.messages = null;
    }

    public void setMessages(long[] messages) throws InvalidDataFormatException, UnsupportedDataException {
        if (messages == null) {
            throw new NullPointerException("MIDIEncoder.setMessages: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 messages \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        long[] lArray = messages;
        int len = messages.length;
        messages = new long[len];
        Array.copy((long[])lArray, (int)0, (long[])messages, (int)0, (int)len);
        long prevTime = 0L;
        int lim = len - 1;
        int i = 0;
        while (i < len) {
            long longMsg = messages[i];
            int shortMsg = (int)longMsg & 0xFFFFFF;
            if (i == lim && shortMsg != 0xFF2F00) {
                throw new InvalidDataFormatException("MIDIEncoder.setMessages: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u043d\u043d\u044b\u0445.");
            }
            if ((shortMsg & 0x800000) != 0) {
                long currTime = longMsg >> 24;
                long deltaTime = currTime - prevTime;
                if (deltaTime < 0L || deltaTime >= 0x10000000L) {
                    throw new UnsupportedDataException("MIDIEncoder.setMessages: \u043d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435.");
                }
                prevTime = currTime;
            }
            ++i;
        }
        this.messages = messages;
    }

    public boolean isEmpty() {
        return this.messages == null;
    }

    private static final class Track
    extends ByteArrayOutputStream {
        public void writeVolatileLengthValue(int intData) {
            if (intData >= 0 && intData < 128) {
                this.write(intData);
                return;
            }
            if (intData >= 128 && intData < 16384) {
                this.write(intData >> 7 | 0x80);
                this.write(intData & 0x7F);
                return;
            }
            if (intData >= 16384 && intData < 0x200000) {
                this.write(intData >> 14 | 0x80);
                this.write(intData >> 7 | 0x80);
                this.write(intData & 0x7F);
                return;
            }
            if (intData >= 0x200000 && intData < 0x10000000) {
                this.write(intData >> 21 | 0x80);
                this.write(intData >> 14 | 0x80);
                this.write(intData >> 7 | 0x80);
                this.write(intData & 0x7F);
                return;
            }
            this.write(0);
        }
    }
}

