/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.compression.zlib;

import malik.emulator.compression.zlib.Checksum32;
import malik.emulator.compression.zlib.Zlib;

public class Adler32
extends Zlib
implements Checksum32 {
    private static final int BASE = 65521;
    private static final int NMAX = 5552;
    private int adler;

    public Adler32() {
        this.adler = 1;
    }

    public Adler32(int adler) {
        this.adler = adler;
    }

    public void update(byte[] src, int offset, int length) {
        int a = this.adler;
        long s1 = a & 0xFFFF;
        long s2 = a >>> 16;
        while (length > 0) {
            int k = length < 5552 ? length : 5552;
            length -= k;
            while (k-- > 0) {
                s2 += (s1 += (long)(src[offset++] & 0xFF));
            }
            s1 %= 65521L;
            s2 %= 65521L;
        }
        this.adler = (int)s1 | (int)(s2 << 16);
    }

    public void reset(int init) {
        this.adler = init;
    }

    public void reset() {
        this.adler = 1;
    }

    public int getValue() {
        return this.adler;
    }

    public Checksum32 copy() {
        return new Adler32(this.adler);
    }
}

