/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.compression.zlib;

import java.io.ByteArrayOutputStream;
import malik.emulator.compression.zlib.ZStream;

public class Zlib {
    public static final String VERSION = "1.1.0";
    public static final int MAX_WBITS = 15;
    public static final int DEF_WBITS = 15;
    public static final int NO_COMPRESSION = 0;
    public static final int BEST_SPEED = 1;
    public static final int OPTIMAL_SPEED_COMPRESSION = 7;
    public static final int BEST_COMPRESSION = 9;
    public static final int DEFAULT_COMPRESSION = -1;
    public static final int FILTERED = 1;
    public static final int HUFFMAN_ONLY = 2;
    public static final int DEFAULT_STRATEGY = 0;
    public static final int NO_FLUSH = 0;
    public static final int PARTIAL_FLUSH = 1;
    public static final int SYNC_FLUSH = 2;
    public static final int FULL_FLUSH = 3;
    public static final int FINISH = 4;
    public static final int OK = 0;
    public static final int STREAM_END = 1;
    public static final int NEED_DICT = 2;
    public static final int ERRNO = -1;
    public static final int STREAM_ERROR = -2;
    public static final int DATA_ERROR = -3;
    public static final int MEM_ERROR = -4;
    public static final int BUF_ERROR = -5;
    public static final int VERSION_ERROR = -6;

    public static byte[] compress(byte[] src) {
        return Zlib.compress(src, 0, src.length, 7, true);
    }

    public static byte[] compress(byte[] src, int offset, int length) {
        return Zlib.compress(src, offset, length, 7, true);
    }

    public static byte[] compress(byte[] src, boolean defaultInit) {
        return Zlib.compress(src, 0, src.length, 7, defaultInit);
    }

    public static byte[] compress(byte[] src, int offset, int length, boolean defaultInit) {
        return Zlib.compress(src, offset, length, 7, defaultInit);
    }

    public static byte[] compress(byte[] src, int level) {
        return Zlib.compress(src, 0, src.length, level, true);
    }

    public static byte[] compress(byte[] src, int offset, int length, int level) {
        return Zlib.compress(src, offset, length, level, true);
    }

    public static byte[] compress(byte[] src, int level, boolean defaultInit) {
        return Zlib.compress(src, 0, src.length, level, defaultInit);
    }

    public static byte[] compress(byte[] src, int offset, int length, int level, boolean defaultInit) {
        long totalOut = 0L;
        byte[] result = new byte[65536];
        ZStream compressor = new ZStream();
        ByteArrayOutputStream tempStream = new ByteArrayOutputStream();
        if (defaultInit) {
            compressor.deflateInit(level);
        } else {
            compressor.deflateInit(level, -15);
        }
        compressor.setInput(src, offset, length, false);
        while (true) {
            compressor.setOutput(result);
            int zlibResult = compressor.deflate(4);
            tempStream.write(result, 0, (int)(compressor.getTotalOut() - totalOut));
            if (zlibResult == 1) break;
            totalOut = compressor.getTotalOut();
        }
        compressor.deflateEnd();
        return tempStream.toByteArray();
    }

    public static byte[] decompress(byte[] src) {
        return Zlib.decompress(src, 0, src.length, true);
    }

    public static byte[] decompress(byte[] src, int offset, int length) {
        return Zlib.decompress(src, offset, length, true);
    }

    public static byte[] decompress(byte[] src, boolean defaultInit) {
        return Zlib.decompress(src, 0, src.length, defaultInit);
    }

    public static byte[] decompress(byte[] src, int offset, int length, boolean defaultInit) {
        long totalOut = 0L;
        byte[] result = new byte[65536];
        ZStream decompressor = new ZStream();
        ByteArrayOutputStream tempStream = new ByteArrayOutputStream();
        if (defaultInit) {
            decompressor.inflateInit();
        } else {
            decompressor.inflateInit(-15);
        }
        decompressor.setInput(src, offset, length, false);
        while (true) {
            decompressor.setOutput(result);
            int zlibResult = decompressor.inflate(0);
            tempStream.write(result, 0, (int)(decompressor.getTotalOut() - totalOut));
            if (zlibResult == 1 || zlibResult < 0) break;
            totalOut = decompressor.getTotalOut();
        }
        decompressor.inflateEnd();
        return tempStream.toByteArray();
    }

    Zlib() {
    }
}

