/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.fileformats.graphics.pnglib;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import malik.emulator.compression.zlib.Zlib;
import malik.emulator.fileformats.DataDecoder;
import malik.emulator.fileformats.DataHolder;
import malik.emulator.fileformats.InputAdapter;
import malik.emulator.fileformats.InvalidDataFormatException;
import malik.emulator.fileformats.graphics.ImageDecoder;
import malik.emulator.fileformats.graphics.pnglib.DecodeMethod;
import malik.emulator.fileformats.graphics.pnglib.Unwrap16bitPC;
import malik.emulator.fileformats.graphics.pnglib.Unwrap1bitPC;
import malik.emulator.fileformats.graphics.pnglib.Unwrap1bitPP;
import malik.emulator.fileformats.graphics.pnglib.Unwrap2bitPC;
import malik.emulator.fileformats.graphics.pnglib.Unwrap2bitPP;
import malik.emulator.fileformats.graphics.pnglib.Unwrap4bitPC;
import malik.emulator.fileformats.graphics.pnglib.Unwrap4bitPP;
import malik.emulator.fileformats.graphics.pnglib.Unwrap8bitPC;
import malik.emulator.fileformats.graphics.pnglib.UnwrapMethod;

public final class PNGDecoder
implements InputAdapter,
DataHolder,
DataDecoder,
ImageDecoder {
    public static final long PNG_SIGNATURE = -8552249625308161526L;
    private static final int HEADER_SIGNATURE = 1229472850;
    private static final int GAMMA_SIGNATURE = 1732332865;
    private static final int PALETTE_SIGNATURE = 1347179589;
    private static final int TRANSPARENCY_SIGNATURE = 1951551059;
    private static final int DATA_SIGNATURE = 1229209940;
    private static final int END_SIGNATURE = 1229278788;
    private boolean useGrayscale;
    private boolean usePalette;
    private boolean useAlpha;
    private int width;
    private int height;
    private int bitDepth;
    private int components;
    private byte[] data;
    private int[] gamma;
    private int[] palette;

    private static void copyBytes(InputStream input, OutputStream output, long bytesCount) throws IOException {
        long fragments = bytesCount >> 16;
        byte[] buffer = new byte[65536];
        long fragment = 0L;
        while (fragment < fragments) {
            output.write(buffer, 0, input.read(buffer));
            ++fragment;
        }
        int remainder = (int)bytesCount & 0xFFFF;
        if (remainder > 0) {
            output.write(buffer, 0, input.read(buffer, 0, remainder));
        }
    }

    private static double power(double base, double exponent) {
        return Double.isNaN(base) || Double.isNaN(exponent) ? Double.NaN : (base > 0.0 ? Math.pow2((double)(exponent * Math.log2((double)base))) : 0.0);
    }

    private static int paethPredictor(int a, int b, int c) {
        int p = a + b - c;
        int pa = Math.abs(p - a);
        int pb = Math.abs(p - b);
        int pc = Math.abs(p - c);
        return pa <= pb && pa <= pc ? a : (pb <= pc ? b : c);
    }

    public PNGDecoder() {
        this.clear();
    }

    public void loadFromInputStream(InputStream stream) throws IOException, InvalidDataFormatException {
        this.loadFromDataStream(new DataInputStream(stream));
    }

    public void loadFromDataStream(DataInputStream stream) throws IOException, InvalidDataFormatException {
        int chunkStart;
        boolean headerHandled = false;
        boolean gammaHandled = false;
        boolean paletteHandled = false;
        boolean transparencyHandled = false;
        int pixelType = -1;
        int imgw = 0;
        int imgh = 0;
        int cmpn = 0;
        DecodeMethod d = null;
        ByteArrayOutputStream compressedData = null;
        this.clear();
        do {
            int chunkLength = stream.readInt();
            chunkStart = stream.readInt();
            switch (chunkStart) {
                default: {
                    stream.skip((long)chunkLength & 0xFFFFFFFFL);
                    break;
                }
                case 1229472850: {
                    if (headerHandled || chunkLength != 13) {
                        this.invalidChunkOrder();
                    }
                    int w = stream.readInt();
                    int h = stream.readInt();
                    byte bd = stream.readByte();
                    byte pt = stream.readByte();
                    byte cm = stream.readByte();
                    byte fm = stream.readByte();
                    byte im = stream.readByte();
                    long area = ((long)w & 0xFFFFFFFFL) * ((long)h & 0xFFFFFFFFL);
                    if (area <= 0L || area > 1000000L || cm != 0 || fm != 0 || im != 0 && im != 1 || (pt != 0 || bd != 1 && bd != 2 && bd != 4 && bd != 8 && bd != 16) && (pt != 3 || bd != 1 && bd != 2 && bd != 4 && bd != 8) && (pt != 2 && pt != 4 && pt != 6 || bd != 8 && bd != 16)) {
                        this.invalidChunkOrder();
                    }
                    pixelType = pt;
                    this.useGrayscale = pt == 0 || pt == 4;
                    this.usePalette = pt == 3;
                    this.useAlpha = pt == 4 || pt == 6;
                    this.width = imgw = w;
                    this.height = imgh = h;
                    this.bitDepth = bd;
                    switch (pt) {
                        default: {
                            break;
                        }
                        case 0: 
                        case 3: {
                            cmpn = 1;
                            this.components = 1;
                            break;
                        }
                        case 4: {
                            cmpn = 2;
                            this.components = 2;
                            break;
                        }
                        case 2: {
                            cmpn = 3;
                            this.components = 3;
                            break;
                        }
                        case 6: {
                            cmpn = 4;
                            this.components = 4;
                        }
                    }
                    switch (im) {
                        default: {
                            break;
                        }
                        case 0: {
                            d = new DecodeNormal();
                            break;
                        }
                        case 1: {
                            d = new DecodeAdam7();
                        }
                    }
                    headerHandled = true;
                    break;
                }
                case 1732332865: {
                    if (!headerHandled || gammaHandled || chunkLength != 4) {
                        this.invalidChunkOrder();
                    }
                    int[] gm = this.gamma;
                    double gammaValue = stream.readInt();
                    double exponent = 100000.0 / (2.2 * gammaValue);
                    int i = 0;
                    while (i <= 255) {
                        gm[i] = (int)Math.round(255.0 * PNGDecoder.power((double)i / 255.0, exponent));
                        ++i;
                    }
                    gammaHandled = true;
                    break;
                }
                case 1347179589: {
                    if (!headerHandled || paletteHandled || chunkLength < 0 || chunkLength > 768 || chunkLength % 3 != 0) {
                        this.invalidChunkOrder();
                    }
                    int lim = chunkLength / 3;
                    int[] p = this.palette;
                    int i = 0;
                    while (i < lim) {
                        int r = stream.readUnsignedByte();
                        int g = stream.readUnsignedByte();
                        int b = stream.readUnsignedByte();
                        p[i] = 0xFF000000 | r << 16 | g << 8 | b;
                        ++i;
                    }
                    paletteHandled = true;
                    break;
                }
                case 1951551059: {
                    int i;
                    if (!headerHandled || transparencyHandled || chunkLength < 0 || chunkLength > 256) {
                        this.invalidChunkOrder();
                    }
                    if (this.usePalette) {
                        int[] p = this.palette;
                        i = 0;
                        while (i < chunkLength) {
                            p[i] = p[i] & 0xFFFFFF | stream.readUnsignedByte() << 24;
                            ++i;
                        }
                    } else {
                        stream.skipBytes(chunkLength);
                    }
                    transparencyHandled = true;
                    break;
                }
                case 1229209940: {
                    if (!headerHandled || chunkLength < 0) {
                        this.invalidChunkOrder();
                    }
                    PNGDecoder.copyBytes(stream, compressedData == null ? new ByteArrayOutputStream() : compressedData, chunkLength);
                    break;
                }
                case 1229278788: {
                    if (!headerHandled || chunkLength != 0 || compressedData == null) {
                        this.invalidChunkOrder();
                    }
                    this.data = new byte[imgw * imgh * cmpn];
                    d.decode(Zlib.decompress(compressedData.toByteArray()), 0, pixelType, this.data, imgw, imgh);
                }
            }
            stream.skipBytes(4);
        } while (chunkStart != 1229278788);
    }

    public void clear() {
        this.useGrayscale = false;
        this.usePalette = false;
        this.useAlpha = false;
        this.width = 0;
        this.height = 0;
        this.components = 0;
        this.bitDepth = 0;
        this.data = null;
        int[] g = this.gamma;
        if (this.gamma == null) {
            g = this.gamma = new int[256];
        }
        int[] p = this.palette;
        if (this.palette == null) {
            p = this.palette = new int[256];
        }
        int i = 0;
        while (i <= 255) {
            g[i] = i;
            p[i] = 0;
            ++i;
        }
    }

    public boolean isEmpty() {
        return this.data == null;
    }

    public boolean isAlphaSupported() {
        return true;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int[] getPixels() {
        if (this.data == null) {
            return null;
        }
        int offset = 0;
        int step = this.components;
        int size = this.width * this.height;
        int[] result = new int[size];
        int i = 0;
        while (i < size) {
            result[i] = this.readPixel(offset);
            offset += step;
            ++i;
        }
        return result;
    }

    int decodeNormal(byte[] stream, int startIndex, int pixelType, byte[] imageData, int imageWidth, int imageHeight) {
        int result = startIndex;
        int f = this.getFilterOffset(pixelType);
        int ofs = 0;
        int total = imageWidth * this.components;
        int lineSize = this.getLineSize(imageWidth, pixelType);
        UnwrapMethod u = null;
        int k = lineSize + 1;
        if (this.usePalette) {
            switch (this.bitDepth) {
                default: {
                    break;
                }
                case 1: {
                    u = new Unwrap1bitPP();
                    break;
                }
                case 2: {
                    u = new Unwrap2bitPP();
                    break;
                }
                case 4: {
                    u = new Unwrap4bitPP();
                    break;
                }
                case 8: {
                    u = new Unwrap8bitPC();
                    break;
                }
            }
        } else {
            switch (this.bitDepth) {
                default: {
                    break;
                }
                case 1: {
                    u = new Unwrap1bitPC();
                    break;
                }
                case 2: {
                    u = new Unwrap2bitPC();
                    break;
                }
                case 4: {
                    u = new Unwrap4bitPC();
                    break;
                }
                case 8: {
                    u = new Unwrap8bitPC();
                    break;
                }
                case 16: {
                    u = new Unwrap16bitPC();
                }
            }
        }
        int i = 0;
        while (i < imageHeight) {
            switch (stream[result++]) {
                default: {
                    break;
                }
                case 1: {
                    int lim = result + lineSize;
                    int j = result + f;
                    while (j < lim) {
                        stream[j] = (byte)(stream[j] + stream[j - f]);
                        ++j;
                    }
                    break;
                }
                case 2: {
                    if (i <= 0) break;
                    int lim = result + lineSize;
                    int j = result;
                    while (j < lim) {
                        stream[j] = (byte)(stream[j] + stream[j - k]);
                        ++j;
                    }
                    break;
                }
                case 3: {
                    int j;
                    int lim;
                    if (i > 0) {
                        lim = result + f;
                        j = result;
                        while (j < lim) {
                            stream[j] = (byte)(stream[j] + ((stream[j - k] & 0xFF) >> 1));
                            ++j;
                        }
                        lim = result + lineSize;
                        while (j < lim) {
                            stream[j] = (byte)(stream[j] + ((stream[j - f] & 0xFF) + (stream[j - k] & 0xFF) >> 1));
                            ++j;
                        }
                    } else {
                        lim = result + lineSize;
                        j = result + f;
                        while (j < lim) {
                            stream[j] = (byte)(stream[j] + ((stream[j - f] & 0xFF) >> 1));
                            ++j;
                        }
                    }
                    break;
                }
                case 4: {
                    int j;
                    int lim;
                    if (i > 0) {
                        lim = result + f;
                        j = result;
                        while (j < lim) {
                            stream[j] = (byte)(stream[j] + PNGDecoder.paethPredictor(0, stream[j - k] & 0xFF, 0));
                            ++j;
                        }
                        lim = result + lineSize;
                        while (j < lim) {
                            stream[j] = (byte)(stream[j] + PNGDecoder.paethPredictor(stream[j - f] & 0xFF, stream[j - k] & 0xFF, stream[j - f - k] & 0xFF));
                            ++j;
                        }
                    } else {
                        lim = result + f;
                        j = result;
                        while (j < lim) {
                            stream[j] = (byte)(stream[j] + PNGDecoder.paethPredictor(0, 0, 0));
                            ++j;
                        }
                        lim = result + lineSize;
                        while (j < lim) {
                            stream[j] = (byte)(stream[j] + PNGDecoder.paethPredictor(stream[j - f] & 0xFF, 0, 0));
                            ++j;
                        }
                        break block13;
                    }
                }
            }
            u.unwrap(stream, result, imageData, ofs, total);
            ofs += total;
            result += lineSize;
            ++i;
        }
        return result;
    }

    int decodeAdam7(byte[] stream, int startIndex, int pixelType, byte[] imageData, int imageWidth, int imageHeight) {
        int result = startIndex;
        int c = this.components;
        int[] adam7interlacing = new int[]{136, 16520, 1096, 8260, 548, 4130, 274};
        int lim = adam7interlacing.length;
        int currentPassage = 0;
        while (currentPassage < lim) {
            int currentInterlacing = adam7interlacing[currentPassage];
            int xstart = currentInterlacing >> 12 & 0xF;
            int ystart = currentInterlacing >> 8 & 0xF;
            int xinc = currentInterlacing >> 4 & 0xF;
            int yinc = currentInterlacing & 0xF;
            int width = (imageWidth - xstart + xinc - 1) / xinc;
            int height = (imageHeight - ystart + yinc - 1) / yinc;
            byte[] data = new byte[width * height * c];
            result = this.decodeNormal(stream, result, pixelType, data, width, height);
            int y0 = 0;
            int y = ystart;
            while (y < imageHeight) {
                int x0 = 0;
                int x = xstart;
                while (x < imageWidth) {
                    Array.copy((byte[])data, (int)((y0 * width + x0) * c), (byte[])imageData, (int)((y * imageWidth + x) * c), (int)c);
                    ++x0;
                    x += xinc;
                }
                ++y0;
                y += yinc;
            }
            ++currentPassage;
        }
        return result;
    }

    private void invalidChunkOrder() throws InvalidDataFormatException {
        this.clear();
        throw new InvalidDataFormatException("\u0414\u0435\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 PNG-\u0444\u0430\u0439\u043b\u043e\u0432: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0444\u0430\u0439\u043b\u0430.");
    }

    private int getLineSize(int width, int pixelType) {
        return (pixelType == 0 || pixelType == 3 ? width * this.bitDepth + 7 : width * this.bitDepth * this.components) >> 3;
    }

    private int getFilterOffset(int pixelType) {
        return pixelType == 0 || pixelType == 3 ? (this.bitDepth < 16 ? 1 : 2) : this.bitDepth * this.components >> 3;
    }

    private int readPixel(int offset) {
        int b;
        int g;
        int r;
        int a;
        byte[] d = this.data;
        int[] gm = this.gamma;
        if (this.usePalette) {
            int p = this.palette[d[offset] & 0xFF];
            a = p >> 24;
            r = p >> 16 & 0xFF;
            g = p >> 8 & 0xFF;
            b = p & 0xFF;
        } else if (this.useAlpha) {
            if (this.useGrayscale) {
                a = d[offset + 1];
                g = b = d[offset] & 0xFF;
                r = b;
            } else {
                a = d[offset + 3];
                r = d[offset] & 0xFF;
                g = d[offset + 1] & 0xFF;
                b = d[offset + 2] & 0xFF;
            }
        } else {
            a = 255;
            if (this.useGrayscale) {
                g = b = d[offset] & 0xFF;
                r = b;
            } else {
                r = d[offset] & 0xFF;
                g = d[offset + 1] & 0xFF;
                b = d[offset + 2] & 0xFF;
            }
        }
        return a << 24 | gm[r] << 16 | gm[g] << 8 | gm[b];
    }

    private final class DecodeAdam7
    implements DecodeMethod {
        DecodeAdam7() {
        }

        public int decode(byte[] stream, int startIndex, int pixelType, byte[] imageData, int imageWidth, int imageHeight) {
            return PNGDecoder.this.decodeAdam7(stream, startIndex, pixelType, imageData, imageWidth, imageHeight);
        }
    }

    private final class DecodeNormal
    implements DecodeMethod {
        DecodeNormal() {
        }

        public int decode(byte[] stream, int startIndex, int pixelType, byte[] imageData, int imageWidth, int imageHeight) {
            return PNGDecoder.this.decodeNormal(stream, startIndex, pixelType, imageData, imageWidth, imageHeight);
        }
    }
}

