/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class Vector {
    protected int capacityIncrement;
    protected int elementCount;
    protected Object[] elementData;
    private Object lock;

    public Vector() {
        this(15, 0);
    }

    public Vector(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public Vector(int initialCapacity, int capacityIncrement) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Vector: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 initialCapacity \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        this.capacityIncrement = capacityIncrement;
        this.elementData = new Object[initialCapacity];
        this.lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer result = new StringBuffer(91);
        Object object = this.lock;
        synchronized (object) {
            int c = this.elementCount - 1;
            Object[] d = this.elementData;
            int i = 0;
            while (i <= c) {
                result.append(d[i]);
                if (i < c) {
                    result.append(", ");
                }
                ++i;
            }
        }
        return result.append(']').toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimToSize() {
        Object object = this.lock;
        synchronized (object) {
            int c = this.elementCount;
            Object[] d = this.elementData;
            if (c < this.elementData.length) {
                this.elementData = new Object[c];
                Array.copy(d, 0, this.elementData, 0, c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyInto(Object[] dst) {
        if (dst == null) {
            throw new NullPointerException("Vector.copyInto: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Object object = this.lock;
        synchronized (object) {
            Object[] d = this.elementData;
            int i = this.elementCount;
            while (i-- > 0) {
                dst[i] = d[i];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureCapacity(int minimumCapacity) {
        Object object = this.lock;
        synchronized (object) {
            if (minimumCapacity > this.elementData.length) {
                this.ensureCapacityHelper(minimumCapacity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllElements() {
        Object object = this.lock;
        synchronized (object) {
            Object[] d = this.elementData;
            int i = this.elementCount;
            while (i-- > 0) {
                d[i] = null;
            }
            this.elementCount = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeElementAt(int index) {
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            int c = this.elementCount - 1;
            if (index > c || index < 0) {
                error = true;
            } else {
                Object[] d = this.elementData;
                int i = c - index;
                if (i > 0) {
                    Array.copy(d, index + 1, d, index, i);
                }
                this.elementCount = c;
                d[this.elementCount] = null;
            }
        }
        if (error) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertElementAt(Object element, int index) {
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            int c = this.elementCount;
            if (index > c || index < 0) {
                error = true;
            } else {
                int i;
                Object[] d = this.elementData;
                if (c == this.elementData.length) {
                    d = this.ensureCapacityHelper(c + 1);
                }
                if ((i = c - index) > 0) {
                    Array.copy(d, index, d, index + 1, i);
                }
                d[index] = element;
                this.elementCount = c + 1;
            }
        }
        if (error) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addElement(Object element) {
        Object object = this.lock;
        synchronized (object) {
            int c = this.elementCount;
            Object[] d = this.elementData;
            if (c == this.elementData.length) {
                d = this.ensureCapacityHelper(c + 1);
            }
            d[c] = element;
            this.elementCount = c + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setElementAt(Object element, int index) {
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            if (index >= this.elementCount || index < 0) {
                error = true;
            } else {
                this.elementData[index] = element;
            }
        }
        if (error) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSize(int newSize) {
        Object object = this.lock;
        synchronized (object) {
            int c;
            Object[] d = this.elementData;
            if (newSize > this.elementData.length) {
                d = this.ensureCapacityHelper(newSize);
            }
            if (newSize >= (c = this.elementCount)) {
                int i = newSize;
                while (i-- > c) {
                    d[i] = null;
                }
            } else {
                int i = c;
                while (i-- > newSize) {
                    d[i] = null;
                }
            }
            this.elementCount = newSize;
        }
    }

    public boolean isEmpty() {
        return this.elementCount <= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object element) {
        boolean result;
        Object object = this.lock;
        synchronized (object) {
            block7: {
                Object[] d = this.elementData;
                if (element == null) {
                    int i = this.elementCount;
                    while (i-- > 0) {
                        if (d[i] != null) continue;
                        result = true;
                        break block7;
                    }
                } else {
                    int i = this.elementCount;
                    while (i-- > 0) {
                        if (!element.equals(d[i])) continue;
                        result = true;
                        break block7;
                    }
                }
                result = false;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeElement(Object element) {
        boolean result;
        block11: {
            Object object = this.lock;
            synchronized (object) {
                int i;
                Object[] d;
                int c;
                block10: {
                    c = this.elementCount;
                    d = this.elementData;
                    if (element == null) {
                        i = 0;
                        while (i < c) {
                            if (d[i] == null) {
                                result = true;
                                break block10;
                            }
                            ++i;
                        }
                    } else {
                        i = 0;
                        while (i < c) {
                            if (element.equals(d[i])) {
                                result = true;
                                break block10;
                            }
                            ++i;
                        }
                    }
                    result = false;
                    break block11;
                }
                int index = i;
                i = --c - index;
                if (i > 0) {
                    Array.copy(d, index + 1, d, index, i);
                }
                this.elementCount = c;
                d[this.elementCount] = null;
            }
        }
        return result;
    }

    public int capacity() {
        return this.elementData.length;
    }

    public int size() {
        return this.elementCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(Object element) {
        int result;
        Object object = this.lock;
        synchronized (object) {
            block9: {
                int c = this.elementCount;
                Object[] d = this.elementData;
                if (element == null) {
                    int i = 0;
                    while (i < c) {
                        if (d[i] == null) {
                            result = i;
                            break block9;
                        }
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < c) {
                        if (element.equals(d[i])) {
                            result = i;
                            break block9;
                        }
                        ++i;
                    }
                }
                result = -1;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(Object element, int fromIndex) {
        int result;
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        Object object = this.lock;
        synchronized (object) {
            block10: {
                int c = this.elementCount;
                Object[] d = this.elementData;
                if (element == null) {
                    int i = fromIndex;
                    while (i < c) {
                        if (d[i] == null) {
                            result = i;
                            break block10;
                        }
                        ++i;
                    }
                } else {
                    int i = fromIndex;
                    while (i < c) {
                        if (element.equals(d[i])) {
                            result = i;
                            break block10;
                        }
                        ++i;
                    }
                }
                result = -1;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int lastIndexOf(Object element) {
        int result;
        Object object = this.lock;
        synchronized (object) {
            block7: {
                Object[] d = this.elementData;
                if (element == null) {
                    int i = this.elementCount;
                    while (i-- > 0) {
                        if (d[i] != null) continue;
                        result = i;
                        break block7;
                    }
                } else {
                    int i = this.elementCount;
                    while (i-- > 0) {
                        if (!element.equals(d[i])) continue;
                        result = i;
                        break block7;
                    }
                }
                result = -1;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int lastIndexOf(Object element, int fromIndex) {
        int result;
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            block10: {
                if (fromIndex++ >= this.elementCount) {
                    error = true;
                    result = 0;
                } else {
                    Object[] d = this.elementData;
                    if (element == null) {
                        int i = fromIndex;
                        while (i-- > 0) {
                            if (d[i] != null) continue;
                            result = i;
                            break block10;
                        }
                    } else {
                        int i = fromIndex;
                        while (i-- > 0) {
                            if (!element.equals(d[i])) continue;
                            result = i;
                            break block10;
                        }
                    }
                    result = -1;
                }
            }
        }
        if (error) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object firstElement() {
        Object result;
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.elementCount <= 0) {
                error = true;
                result = null;
            } else {
                result = this.elementData[0];
            }
        }
        if (error) {
            throw new NoSuchElementException("Vector.firstElement: \u0432\u0435\u043a\u0442\u043e\u0440 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lastElement() {
        Object result;
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            int c = this.elementCount;
            if (c <= 0) {
                error = true;
                result = null;
            } else {
                result = this.elementData[c - 1];
            }
        }
        if (error) {
            throw new NoSuchElementException("Vector.lastElement: \u0432\u0435\u043a\u0442\u043e\u0440 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object elementAt(int index) {
        Object result;
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            if (index >= this.elementCount || index < 0) {
                error = true;
                result = null;
            } else {
                result = this.elementData[index];
            }
        }
        if (error) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return result;
    }

    public Enumeration elements() {
        return new Enumerator();
    }

    final Object getMonitor() {
        return this.lock;
    }

    private Object[] ensureCapacityHelper(int minimumCapacity) {
        Object[] result = this.elementData;
        int oc = this.elementData.length;
        int i = this.capacityIncrement;
        int nc = i <= 0 ? (oc << 1) + 1 : oc + i;
        if (nc < minimumCapacity) {
            nc = minimumCapacity;
        }
        Object[] objectArray = result;
        this.elementData = new Object[nc];
        result = this.elementData;
        Array.copy(objectArray, 0, this.elementData, 0, this.elementCount);
        return result;
    }

    private class Enumerator
    implements Enumeration {
        private int index;

        Enumerator() {
        }

        public boolean hasMoreElements() {
            return this.index < Vector.this.elementCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object nextElement() {
            Object result;
            boolean error = false;
            Vector thisVector = Vector.this;
            Object object = thisVector.getMonitor();
            synchronized (object) {
                int i = this.index;
                if (i >= thisVector.elementCount) {
                    error = true;
                    result = null;
                } else {
                    this.index = i + 1;
                    result = thisVector.elementData[i];
                }
            }
            if (error) {
                throw new NoSuchElementException("Vector: \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435 \u043e\u0441\u0442\u0430\u043b\u043e\u0441\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u0434\u043b\u044f \u043f\u0435\u0440\u0435\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f.");
            }
            return result;
        }
    }
}

