/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.i18n.encoding.system;

import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import malik.emulator.i18n.StreamReader;

public class UTF_8_Reader
extends StreamReader {
    private static final int NO_BYTE = -2;
    private boolean newRead;
    private int[] readAhead = new int[]{-2, -2, -2};

    public void reset() throws IOException {
        throw new IOException("Reader.reset: \u043a\u043b\u0430\u0441\u0441 " + this.getClass().getName() + " \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u043c\u0435\u0442\u043e\u0434 reset.");
    }

    public void mark(int readlimit) throws IOException {
        throw new IOException("Reader.mark: \u043a\u043b\u0430\u0441\u0441 " + this.getClass().getName() + " \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u043c\u0435\u0442\u043e\u0434 mark.");
    }

    public boolean markSupported() {
        return false;
    }

    public int read(char[] dst, int offset, int length) throws IOException {
        InputStream stream = this.ensureOpen();
        if (length == 0) {
            return 0;
        }
        this.newRead = true;
        int result = 0;
        while (result < length) {
            int currentChar;
            int extraByte;
            int firstByte = this.getByteOfCurrentChar(stream, 0);
            if (firstByte < 0) {
                return firstByte == -1 && result == 0 ? -1 : result;
            }
            switch (firstByte >> 4) {
                default: {
                    throw new UTFDataFormatException("InputStreamReader.read: \u043e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0434\u0430\u043d\u043d\u044b\u0445, \u0437\u0430\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0445 \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u043e\u0439 UTF-8.");
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    extraByte = 1;
                    currentChar = firstByte;
                    break;
                }
                case 12: 
                case 13: {
                    extraByte = 2;
                    currentChar = firstByte & 0x1F;
                    break;
                }
                case 14: {
                    extraByte = 3;
                    currentChar = firstByte & 0xF;
                }
            }
            int i = 1;
            while (i < extraByte) {
                int nextByte = this.getByteOfCurrentChar(stream, i);
                if (nextByte == -2) {
                    return result;
                }
                if (nextByte == -1 || (nextByte & 0xC0) != 128) {
                    throw new UTFDataFormatException("InputStreamReader.read: \u043e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0434\u0430\u043d\u043d\u044b\u0445, \u0437\u0430\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0445 \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u043e\u0439 UTF-8.");
                }
                currentChar = (currentChar << 6) + (nextByte & 0x3F);
                ++i;
            }
            dst[offset + result] = (char)currentChar;
            this.prepareForNextChar();
            ++result;
        }
        return result;
    }

    public int sizeOf(byte[] src, int offset, int length) {
        int result = 0;
        int end = offset + length;
        while (end > offset) {
            switch ((src[offset] & 0xFF) >> 4) {
                default: {
                    return result + 1;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++offset;
                    break;
                }
                case 12: 
                case 13: {
                    offset += 2;
                    break;
                }
                case 14: {
                    offset += 3;
                }
            }
            ++result;
        }
        return result;
    }

    private void prepareForNextChar() {
        int[] ahead = this.readAhead;
        this.readAhead[0] = -2;
        ahead[1] = -2;
        ahead[2] = -2;
    }

    private int getByteOfCurrentChar(InputStream stream, int byteOfChar) throws IOException {
        int[] ahead = this.readAhead;
        int result = this.readAhead[byteOfChar];
        if (result != -2) {
            return result;
        }
        if (this.newRead || stream.available() > 0) {
            ahead[byteOfChar] = result = stream.read();
            this.newRead = false;
            return result;
        }
        return -2;
    }
}

