/*
 * Decompiled with CFR 0.152.
 */
package javax.bluetooth;

public class UUID {
    private final long loHalf;
    private final long hiHalf;

    public UUID(long value) {
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("UUID: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 value \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        this.loHalf = value;
        this.hiHalf = 0L;
    }

    public UUID(String value, boolean isShort) {
        if (value == null) {
            throw new NullPointerException("UUID: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 value \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int len = value.length();
        if (len <= 0 || len > (isShort ? 8 : 32)) {
            throw new IllegalArgumentException("UUID: \u0434\u043b\u0438\u043d\u0430 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u0430 value \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        char[] digits = new char[32];
        int offset = 32 - len;
        Array.fill((char[])digits, (int)0, (int)offset, (int)48);
        value.getChars(0, len, digits, offset);
        long hiHalf = 0L;
        long loHalf = 0L;
        int bits = 0;
        int i = 32;
        while (i-- > 0) {
            long mask;
            char digit = digits[i];
            if (digit >= '0' && digit <= '9') {
                mask = (long)(digit - 48) << bits;
            } else if (digit >= 'a' && digit <= 'f') {
                mask = (long)(digit - 87) << bits;
            } else if (digit >= 'A' && digit <= 'F') {
                mask = (long)(digit - 55) << bits;
            } else {
                throw new NumberFormatException("UUID: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0447\u0438\u0441\u043b\u0430.");
            }
            if (bits >= 64) {
                hiHalf |= mask;
            } else {
                loHalf |= mask;
            }
            bits += 4;
        }
        this.loHalf = loHalf;
        this.hiHalf = hiHalf;
    }

    public boolean equals(Object anot) {
        if (anot instanceof UUID) {
            UUID uuid = (UUID)anot;
            if (this.loHalf == uuid.loHalf && this.hiHalf == uuid.hiHalf) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        long half = this.loHalf;
        long l = half ^ half >> 32;
        half = this.hiHalf;
        return (int)(l ^ half ^ half >> 32);
    }

    public String toString() {
        int offset = 31;
        long loHalf = this.loHalf;
        long hiHalf = this.hiHalf;
        char[] digits = new char[32];
        int bits = 0;
        int i = 32;
        while (i-- > 0) {
            int digit = (int)((bits >= 64 ? hiHalf : loHalf) >> bits) & 0xF;
            digits[i] = (char)(digit >= 10 ? digit + 55 : digit + 48);
            bits += 4;
        }
        int i2 = 0;
        while (i2 < 31) {
            if (digits[i2] != '0') {
                offset = i2;
                break;
            }
            ++i2;
        }
        return new String(digits, offset, 32 - offset);
    }

    final boolean realEquals(UUID uuid) {
        return uuid != null && this.loHalf == uuid.loHalf && this.hiHalf == uuid.hiHalf;
    }
}

