/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.microedition.system.protocol.obex;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import javax.obex.HeaderSet;

public abstract class CustomHeaderSet
implements HeaderSet {
    private static final byte[] HEADER_IDS = new byte[]{1, 5, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 66, 68, 70, 71, 74, 76, 79, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, -80, -79, -78, -77, -76, -75, -74, -73, -72, -71, -70, -69, -68, -67, -66, -65, -64, -61, -60, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, -6, -5, -4, -3, -2, -1};
    private final Object[] values = new Object[HEADER_IDS.length];

    private static int indexOf(int headerID) {
        return headerID < 0 || headerID > 255 ? -1 : Array.findb((byte[])HEADER_IDS, (int)(HEADER_IDS.length - 1), (int)headerID);
    }

    protected CustomHeaderSet() {
    }

    public abstract int getResponseCode() throws IOException;

    public void createAuthenticationChallenge(String realm, boolean userID, boolean access) {
    }

    public void setHeader(int headerID, Object headerValue) {
        int index = CustomHeaderSet.indexOf(headerID);
        if (index < 0) {
            throw new IllegalArgumentException("HeaderSet.setHeader: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 headerID \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        if (headerValue != null) {
            long value;
            if (headerID >= 1 && headerID <= 66) {
                if (!(headerValue instanceof String)) {
                    throw new IllegalArgumentException("HeaderSet.setHeader: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 headerValue \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
                }
            } else if (headerID == 68 || headerID == 196) {
                if (!(headerValue instanceof Calendar)) {
                    throw new IllegalArgumentException("HeaderSet.setHeader: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 headerValue \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
                }
                headerValue = ((Calendar)headerValue).getTime();
            } else if (headerID >= 70 && headerID <= 127) {
                if (!(headerValue instanceof byte[])) {
                    throw new IllegalArgumentException("HeaderSet.setHeader: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 headerValue \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
                }
                byte[] byArray = (byte[])headerValue;
                byte[] value2 = byArray;
                int len = value2.length;
                value2 = new byte[len];
                Array.copy((byte[])byArray, (int)0, (byte[])value2, (int)0, (int)len);
                headerValue = value2;
            } else if (headerID >= 176 && headerID <= 191 ? !(headerValue instanceof Byte) : !(headerValue instanceof Long) || (value = ((Long)headerValue).longValue()) < 0L || value > 0xFFFFFFFFL) {
                throw new IllegalArgumentException("HeaderSet.setHeader: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 headerValue \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
            }
        }
        this.values[index] = headerValue;
    }

    public int[] getHeaderList() throws IOException {
        int pos = 0;
        int len = HEADER_IDS.length;
        int[] result = new int[len];
        Object[] values = this.values;
        int i = 0;
        while (i < len) {
            if (values[i] != null) {
                result[pos++] = HEADER_IDS[i] & 0xFF;
            }
            ++i;
        }
        if (pos < len) {
            int[] nArray = result;
            result = new int[pos];
            Array.copy((int[])nArray, (int)0, (int[])result, (int)0, (int)pos);
        }
        return result;
    }

    public Object getHeader(int headerID) throws IOException {
        int index = CustomHeaderSet.indexOf(headerID);
        if (index < 0) {
            throw new IllegalArgumentException("HeaderSet.getHeader: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 headerID \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        Object result = this.values[index];
        if (result instanceof Date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)result);
            result = calendar;
        } else if (result instanceof byte[]) {
            byte[] byArray = (byte[])result;
            byte[] value = byArray;
            int len = value.length;
            value = new byte[len];
            Array.copy((byte[])byArray, (int)0, (byte[])value, (int)0, (int)len);
            result = value;
        }
        return result;
    }
}

