/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.microedition.system;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import javax.microedition.io.Connection;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.Connector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Choice;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Input;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.MIDletDisplay;
import javax.microedition.lcdui.Spacer;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.SurfaceTextViewer;
import javax.microedition.lcdui.TextField;
import javax.microedition.lcdui.Ticker;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.protocol.DataSource;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import malik.emulator.application.KeyboardEvent;
import malik.emulator.application.Run;
import malik.emulator.fileformats.InvalidDataFormatException;
import malik.emulator.fileformats.graphics.ImageDecoder;
import malik.emulator.fileformats.graphics.jpeg.JPEGDecoder;
import malik.emulator.fileformats.graphics.png.PNGDecoder;
import malik.emulator.fileformats.sound.sampled.wave.WaveDecoder;
import malik.emulator.fileformats.sound.synthetic.midi.MIDIDecoder;
import malik.emulator.io.cloud.CloudFileSystem;
import malik.emulator.io.cloud.FileInputStream;
import malik.emulator.media.graphics.RasterCanvas;
import malik.emulator.media.graphics.SystemFont;
import malik.emulator.microedition.DeviceManager;
import malik.emulator.microedition.DeviceSettings;
import malik.emulator.microedition.media.CustomPlayer;
import malik.emulator.microedition.media.SampledPlayerDecoder;
import malik.emulator.microedition.media.SyntheticPlayerDecoder;
import malik.emulator.microedition.system.BackgroundConsoleCommand;
import malik.emulator.microedition.system.BlackScreen;
import malik.emulator.microedition.system.ButtonSet;
import malik.emulator.microedition.system.Console;
import malik.emulator.microedition.system.ConsoleCommand;
import malik.emulator.microedition.system.DefaultMessageHandler;
import malik.emulator.microedition.system.ImagesSearchConsoleCommand;
import malik.emulator.microedition.system.KeyCodeSet;
import malik.emulator.microedition.system.ManagerSettingList;
import malik.emulator.microedition.system.ManagerStringList;
import malik.emulator.microedition.system.SettingsForm;
import malik.emulator.microedition.system.SoundsSearchConsoleCommand;
import malik.emulator.microedition.system.SystemSettingList;
import malik.emulator.microedition.system.SystemStringItem;
import malik.emulator.microedition.system.player.SampledPlayer;
import malik.emulator.microedition.system.player.SyntheticPlayer;
import malik.emulator.microedition.system.protocol.InboundConnections;
import malik.emulator.microedition.system.protocol.file.VFSConnection;
import malik.emulator.microedition.system.protocol.resource.ResourceConnection;
import malik.emulator.microedition.system.protocol.sms.ClientMessageConnection;
import malik.emulator.microedition.system.protocol.sms.ServerMessageConnection;
import malik.emulator.util.StringBuilder;
import malik.emulator.util.ThreadTerminationListener;

public class SystemManager
extends DeviceManager
implements CommandListener,
ItemCommandListener,
ItemStateListener,
ThreadTerminationListener {
    public static final int MIDLET_NAME = 0;
    public static final int MIDLET_ICON = 1;
    public static final int MIDLET_CLASS = 2;
    private static final int[] FONT_SIZES;
    private static final int[] DEVICE_KEYS;
    private static final int[] KEYBOARD_KEYS;
    private static final KeyCodeSet[] KEY_CODE_SETS;
    private static final String[] EMPTY_STRING_ARRAY;
    private boolean firstConnectionOpened;
    private boolean consoleGreetingPrinted;
    private int saveSettingsElementIndex;
    private String[] supportedProtocols;
    private String[] supportedContentTypes;
    private String[] applicationClassNames;
    private final SettingsForm[] screenSettings;
    private ChoiceGroup itemKeyCodeSets;
    private ButtonSet itemDeviceButtons;
    private StringItem itemRecordProperties;
    private StringItem itemKeyDescription;
    private StringItem itemKeyEquivalent;
    private StringItem itemErrorInfo;
    private Command commandNo;
    private Command commandYes;
    private Command commandExit;
    private Command commandBack;
    private Command commandApply;
    private Command commandClear;
    private Command commandDelete;
    private Command commandLaunch;
    private Command commandUpdate;
    private Command commandSettings;
    private Command commandProperties;
    private Command commandAboutApplication;
    private Command commandAboutImplementation;
    private List screenRecordsList;
    private List screenSettingsList;
    private List screenApplicationList;
    private Form screenApplicationError;
    private Form screenAboutApplication;
    private Form screenAboutImplementation;
    private Form screenRecordProperties;
    private Form screenDeviceButtonsView;
    private Alert screenError;
    private Alert screenExitApplication;
    private Alert screenRecordsClearConfirm;
    private Alert screenRecordDeleteConfirm;
    private Displayable screenBackground;
    private SettingsForm screenSettingFonts;
    private SettingsForm screenSettingSystem;
    private SettingsForm screenSettingControls;
    private SettingsForm screenSettingKeyCodes;
    private SurfaceTextViewer screenLongOperation;
    private final MIDletDisplay applicationDisplay;
    private final BackgroundConsoleCommand imagesCommand;
    private final BackgroundConsoleCommand soundsCommand;
    final Console console;

    static {
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[2] = 2;
        FONT_SIZES = nArray;
        DEVICE_KEYS = new int[]{38, 36, 40, 41, 43, 37, 39, 44, 46, 49, 50, 51, 52, 53, 54, 55, 56, 57, 42, 48, 35};
        int[] nArray2 = new int[41];
        nArray2[1] = 27;
        nArray2[2] = 112;
        nArray2[3] = 113;
        nArray2[4] = 114;
        nArray2[5] = 115;
        nArray2[6] = 116;
        nArray2[7] = 117;
        nArray2[8] = 118;
        nArray2[9] = 119;
        nArray2[10] = 120;
        nArray2[11] = 121;
        nArray2[12] = 122;
        nArray2[13] = 123;
        nArray2[14] = 13;
        nArray2[15] = 32;
        nArray2[16] = 45;
        nArray2[17] = 46;
        nArray2[18] = 36;
        nArray2[19] = 35;
        nArray2[20] = 33;
        nArray2[21] = 34;
        nArray2[22] = 38;
        nArray2[23] = 40;
        nArray2[24] = 37;
        nArray2[25] = 39;
        nArray2[26] = 107;
        nArray2[27] = 109;
        nArray2[28] = 106;
        nArray2[29] = 111;
        nArray2[30] = 110;
        nArray2[31] = 96;
        nArray2[32] = 97;
        nArray2[33] = 98;
        nArray2[34] = 99;
        nArray2[35] = 100;
        nArray2[36] = 101;
        nArray2[37] = 102;
        nArray2[38] = 103;
        nArray2[39] = 104;
        nArray2[40] = 105;
        KEYBOARD_KEYS = nArray2;
        KEY_CODE_SETS = new KeyCodeSet[]{new KeyCodeSet("\u0421\u0432\u043e\u0438 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438", 0, 0, 0, 0, 0, 0, 0), new KeyCodeSet("Motorola", -1, -6, -2, -5, -20, -21, -22), new KeyCodeSet("Nokia (\u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e)", -1, -2, -3, -4, -5, -6, -7), new KeyCodeSet("Siemens", -59, -60, -61, -62, -26, -1, -4)};
        EMPTY_STRING_ARRAY = new String[0];
    }

    public static boolean containsString(String[] array, String string) {
        int len;
        if (array == null || (len = array.length) <= 0) {
            return false;
        }
        if (string == null) {
            return Array.findf((Object[])array, (int)0, null) < len;
        }
        int i = len;
        while (i-- > 0) {
            if (!string.equals(array[i])) continue;
            return true;
        }
        return false;
    }

    public static String deviceKeyToString(int deviceKey) {
        switch (deviceKey) {
            case 44: {
                return "\u0412\u044b\u0437\u043e\u0432 \u043a\u043e\u043d\u0441\u043e\u043b\u0438";
            }
            case 46: {
                return "\u0412\u044b\u0445\u043e\u0434 \u0438\u0437 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f";
            }
        }
        DeviceSettings settings = DeviceManager.getInstance().getSettings();
        return settings.getKeyName(settings.getKeyCodeFor(deviceKey));
    }

    public static String calendarToString(Calendar calendar) {
        StringBuilder result = new StringBuilder();
        switch (calendar.get(7)) {
            case 2: {
                result.append("\u043f\u043e\u043d\u0435\u0434\u0435\u043b\u044c\u043d\u0438\u043a, ");
                break;
            }
            case 3: {
                result.append("\u0432\u0442\u043e\u0440\u043d\u0438\u043a, ");
                break;
            }
            case 4: {
                result.append("\u0441\u0440\u0435\u0434\u0430, ");
                break;
            }
            case 5: {
                result.append("\u0447\u0435\u0442\u0432\u0435\u0440\u0433, ");
                break;
            }
            case 6: {
                result.append("\u043f\u044f\u0442\u043d\u0438\u0446\u0430, ");
                break;
            }
            case 7: {
                result.append("\u0441\u0443\u0431\u0431\u043e\u0442\u0430, ");
                break;
            }
            case 1: {
                result.append("\u0432\u043e\u0441\u043a\u0440\u0435\u0441\u0435\u043d\u044c\u0435, ");
            }
        }
        result.append(calendar.get(5));
        switch (calendar.get(2)) {
            case 0: {
                result.append(" \u044f\u043d\u0432\u0430\u0440\u044f ");
                break;
            }
            case 1: {
                result.append(" \u0444\u0435\u0432\u0440\u0430\u043b\u044f ");
                break;
            }
            case 2: {
                result.append(" \u043c\u0430\u0440\u0442\u0430 ");
                break;
            }
            case 3: {
                result.append(" \u0430\u043f\u0440\u0435\u043b\u044f ");
                break;
            }
            case 4: {
                result.append(" \u043c\u0430\u044f ");
                break;
            }
            case 5: {
                result.append(" \u0438\u044e\u043d\u044f ");
                break;
            }
            case 6: {
                result.append(" \u0438\u044e\u043b\u044f ");
                break;
            }
            case 7: {
                result.append(" \u0430\u0432\u0433\u0443\u0441\u0442\u0430 ");
                break;
            }
            case 8: {
                result.append(" \u0441\u0435\u043d\u0442\u044f\u0431\u0440\u044f ");
                break;
            }
            case 9: {
                result.append(" \u043e\u043a\u0442\u044f\u0431\u0440\u044f ");
                break;
            }
            case 10: {
                result.append(" \u043d\u043e\u044f\u0431\u0440\u044f ");
                break;
            }
            case 11: {
                result.append(" \u0434\u0435\u043a\u0430\u0431\u0440\u044f ");
            }
        }
        return result.append(calendar.get(1)).append(", ").append(calendar.get(11)).append(':').append(calendar.get(12)).append(' ').append((Object)calendar.getTimeZone()).toString();
    }

    public static Image loadImageFromFile(String fileName) {
        Image result;
        try {
            FileInputStream stream = new FileInputStream(fileName);
            stream.checkOpenError();
            try {
                result = Image.createImage((InputStream)stream);
            }
            finally {
                stream.close();
            }
        }
        catch (IOException e) {
            e.printRealStackTrace();
            result = null;
        }
        return result;
    }

    public static Image loadApplicationIcon() {
        String resourceName = DeviceManager.getInstance().getSettings().getMIDletProperty("MIDlet-Icon");
        if (resourceName == null) {
            return null;
        }
        if (resourceName.length() > 0 && resourceName.charAt(0) == '/') {
            resourceName = resourceName.substring(1);
        }
        return SystemManager.loadImageFromFile("/res/".concat(resourceName));
    }

    private static void fillKeysList(Choice list) {
        int[] keys = KEYBOARD_KEYS;
        list.deleteAll();
        int len = keys.length;
        int i = 0;
        while (i < len) {
            int key = keys[i];
            list.append(key == 0 ? "\u0421\u0432\u043e\u0438 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438" : DeviceSettings.keyToString((int)key), null);
            ++i;
        }
    }

    private static int indexOfKey(int key) {
        int[] keys = KEYBOARD_KEYS;
        int index = Array.findb((int[])KEYBOARD_KEYS, (int)(keys.length - 1), (int)key);
        return index <= 0 ? 0 : index;
    }

    private static int indexOfString(Choice list, String string) {
        int i = list.size();
        while (i-- > 0) {
            if (!list.getString(i).equals(string)) continue;
            return i;
        }
        return -1;
    }

    private static MIDletDisplay createDefaultApplicationDisplay() {
        RasterCanvas screen = RasterCanvas.screen;
        return new MIDletDisplay(false, screen.getWidth(), screen.getHeight());
    }

    public SystemManager() {
        String value;
        Console console;
        Run.instance.setThreadTerminationListener((ThreadTerminationListener)this);
        this.screenSettings = new SettingsForm[4];
        MIDletDisplay ref1 = this.createApplicationDisplay();
        this.applicationDisplay = ref1 == null ? SystemManager.createDefaultApplicationDisplay() : ref1;
        ImagesSearchConsoleCommand cmd1 = new ImagesSearchConsoleCommand(this);
        this.imagesCommand = cmd1;
        SoundsSearchConsoleCommand cmd2 = new SoundsSearchConsoleCommand(this);
        this.soundsCommand = cmd2;
        this.console = console = new Console("\u041a\u043e\u043d\u0441\u043e\u043b\u044c J2ME", null, false, this);
        console.addConsoleCommand(cmd1);
        console.addConsoleCommand(cmd2);
        int i = 1;
        while ((value = System.getSystemProperty((String)"malik.emulator.microedition.console.command.".concat(Integer.toString(i)))) != null) {
            try {
                console.addConsoleCommand((ConsoleCommand)Class.forName(value).newInstance());
            }
            catch (Exception e) {
                e.printRealStackTrace();
            }
            ++i;
        }
    }

    public void playTone(int note, int duration, int volume) throws MediaException {
        super.playTone(note, duration > 10000 ? 10000 : duration, volume);
    }

    public void applicationStarted(Display display) {
        super.applicationStarted(display);
        super.getMainDisplay().setCurrent((Displayable)this.console);
    }

    public void applicationStopped(Display display) {
        super.applicationStopped(display);
        Run.instance.terminate();
    }

    public String[] getSupportedContentTypes(String protocol) {
        String[] protocols = this.supportedProtocols;
        if (this.supportedProtocols == null) {
            this.supportedProtocols = this.getSupportedProtocols();
            protocols = this.supportedProtocols;
            if (this.supportedProtocols == null || protocols.length <= 0) {
                this.supportedProtocols = this.getSystemSupportedProtocols();
                protocols = this.supportedProtocols;
            }
        }
        Object[] contentTypes = this.supportedContentTypes;
        if (this.supportedContentTypes == null) {
            this.supportedContentTypes = this.getSupportedContentTypes();
            contentTypes = this.supportedContentTypes;
            if (this.supportedContentTypes == null || contentTypes.length <= 0) {
                this.supportedContentTypes = this.getSystemSupportedContentTypes();
                contentTypes = this.supportedContentTypes;
            }
        }
        if (protocol == null || SystemManager.containsString(protocols, protocol)) {
            int len = contentTypes.length;
            Object[] result = new String[len];
            Array.copy((Object[])contentTypes, (int)0, (Object[])result, (int)0, (int)len);
            return result;
        }
        return EMPTY_STRING_ARRAY;
    }

    public String[] getSupportedProtocols(String contentType) {
        Object[] protocols = this.supportedProtocols;
        if (this.supportedProtocols == null) {
            this.supportedProtocols = this.getSupportedProtocols();
            protocols = this.supportedProtocols;
            if (this.supportedProtocols == null || protocols.length <= 0) {
                this.supportedProtocols = this.getSystemSupportedProtocols();
                protocols = this.supportedProtocols;
            }
        }
        String[] contentTypes = this.supportedContentTypes;
        if (this.supportedContentTypes == null) {
            this.supportedContentTypes = this.getSupportedContentTypes();
            contentTypes = this.supportedContentTypes;
            if (this.supportedContentTypes == null || contentTypes.length <= 0) {
                this.supportedContentTypes = this.getSystemSupportedContentTypes();
                contentTypes = this.supportedContentTypes;
            }
        }
        if (contentType == null || SystemManager.containsString(contentTypes, contentType)) {
            int len = protocols.length;
            Object[] result = new String[len];
            Array.copy((Object[])protocols, (int)0, (Object[])result, (int)0, (int)len);
            return result;
        }
        return EMPTY_STRING_ARRAY;
    }

    public Player createPlayer(String locator) throws IOException, MediaException {
        InputStream stream = Connector.openInputStream((String)locator);
        if (stream != null) {
            CustomPlayer result = null;
            try {
                long signature = (long)new DataInputStream(stream).readInt() & 0xFFFFFFFFL;
                if (1380533830L == signature) {
                    result = new SampledPlayer((SampledPlayerDecoder)new WaveDecoder(), stream, true);
                }
                if (1297377380L == signature) {
                    result = new SyntheticPlayer((SyntheticPlayerDecoder)new MIDIDecoder(), stream, true);
                }
            }
            finally {
                if (result == null) {
                    stream.close();
                }
            }
            if (result != null) {
                return result;
            }
        }
        throw new MediaException("Manager.createPlayer: \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c.");
    }

    public Player createPlayer(DataSource source) throws IOException, MediaException {
        throw new MediaException("Manager.createPlayer: \u044d\u0442\u0430 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u0435\u0439 \u0438\u0437 DataSource.");
    }

    public Player createPlayer(InputStream stream, String contentType) throws IOException, MediaException {
        long signature = (long)new DataInputStream(stream).readInt() & 0xFFFFFFFFL;
        if (1380533830L == signature) {
            return new SampledPlayer((SampledPlayerDecoder)new WaveDecoder(), stream, false);
        }
        if (1297377380L == signature) {
            return new SyntheticPlayer((SyntheticPlayerDecoder)new MIDIDecoder(), stream, false);
        }
        throw new MediaException("Manager.createPlayer: \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection openConnection(String url, int mode, boolean timeouts) throws IOException {
        String loc = url.toLowerCase();
        SettingsForm[] settingsFormArray = this.screenSettings;
        synchronized (this.screenSettings) {
            block17: {
                if (!this.firstConnectionOpened && loc.startsWith("sms://")) {
                    this.firstConnectionOpened = true;
                    InboundConnections.instance.registerLocalPort(1, 1200);
                    ServerMessageConnection ourMessageServer = new ServerMessageConnection("sms://:1200", 1200);
                    ourMessageServer.setMessageListener(new DefaultMessageHandler(ourMessageServer));
                }
                // ** MonitorExit[var7_5] (shouldn't be in output)
                if (loc.startsWith("sms://")) {
                    String address = url.substring("sms://".length());
                    if (!address.startsWith(":")) {
                        return new ClientMessageConnection(url);
                    }
                    int localPort = Integer.parseInt(address.substring(1));
                    if (localPort < 0 || localPort > 65535) {
                        throw new NumberFormatException("Connector.open: \u043d\u043e\u043c\u0435\u0440 \u043f\u043e\u0440\u0442\u0430 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
                    }
                    InboundConnections.instance.registerLocalPort(1, localPort);
                    return new ServerMessageConnection(url, localPort);
                }
                if (loc.startsWith("file://")) {
                    String address = url.substring("file://".length());
                    if (!address.startsWith("/")) {
                        address = "/".concat(address);
                        url = "file://".concat(address);
                    }
                    if (address.indexOf("//") >= 0) {
                        throw new IllegalArgumentException("Connector.open: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 url \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442.");
                    }
                    if (VFSConnection.isForbiddenPath(null, address)) {
                        throw new SecurityException("Connector.open: \u0434\u043e\u0441\u0442\u0443\u043f \u043a \u0437\u0430\u0434\u0430\u043d\u043d\u043e\u043c\u0443 \u043e\u0431\u044a\u0435\u043a\u0442\u0443 \u0437\u0430\u043f\u0440\u0435\u0449\u0451\u043d \u0434\u043b\u044f \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b\u0430 file.");
                    }
                    return new VFSConnection(url, null, address, mode);
                }
                if (loc.startsWith("resource://")) {
                    if (mode != 1) {
                        throw new IllegalArgumentException("Connector.open: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 mode \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e READ \u0434\u043b\u044f \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b\u0430 resource.");
                    }
                    String address = url.substring("resource://".length());
                    if (!address.startsWith("/")) {
                        address = "/".concat(address);
                        url = "resource://".concat(address);
                    }
                    if (address.indexOf("//") >= 0) {
                        throw new IllegalArgumentException("Connector.open: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 url \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442.");
                    }
                    try {
                        CloudFileSystem.instance.readAttributes("/res".concat(address), null);
                    }
                    catch (IOException e) {
                        e.printRealStackTrace();
                        break block17;
                    }
                    return new ResourceConnection(url, address);
                }
            }
            throw new ConnectionNotFoundException("Connector.open: \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e: ".concat(url));
        }
    }

    public ImageDecoder openImageDecoder(InputStream stream) throws IOException {
        DataInputStream data = new DataInputStream(stream);
        long signature = data.readUnsignedShort();
        if (65496L == signature) {
            return new JPEGDecoder();
        }
        if (-8552249625308161526L == (signature = signature << 48 | (long)data.readUnsignedShort() << 32 | (long)data.readInt() & 0xFFFFFFFFL)) {
            return new PNGDecoder();
        }
        throw new InvalidDataFormatException("SystemManager.openImageDecoder: \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f.");
    }

    public void commandAction(Command command, Displayable screen) {
        final Display display = super.getMainDisplay();
        SettingsForm[] settingsForms = this.screenSettings;
        if (Array.findb((Object[])this.screenSettings, (int)(settingsForms.length - 1), (Object)screen) >= 0) {
            if (command == this.commandApply) {
                this.settingApply((SettingsForm)screen);
            }
            display.setCurrent((Displayable)this.getScreenSettingsList());
            return;
        }
        if (screen == this.screenExitApplication) {
            if (command == this.commandYes) {
                this.applicationDisplay.applicationStop(true);
                return;
            }
            if (command == this.commandNo) {
                this.switchToApplicationDisplay();
            }
            return;
        }
        List screenList = this.screenSettingsList;
        if (screen == screenList) {
            if (command == List.SELECT_COMMAND) {
                int settingIndex = screenList.getSelectedIndex();
                this.settingSelect(settingIndex, screenList.getString(settingIndex));
                return;
            }
            if (command == this.commandBack) {
                display.setCurrent((Displayable)this.getScreenApplicationList());
            }
            return;
        }
        screenList = this.screenRecordsList;
        if (screen == screenList) {
            if (command == this.commandClear) {
                display.setCurrent((Displayable)this.getScreenRecordsClearConfirm());
                return;
            }
            if (command == this.commandDelete) {
                display.setCurrent((Displayable)this.getScreenRecordDeleteConfirm(screenList.getString(screenList.getSelectedIndex())));
                return;
            }
            if (command == this.commandUpdate) {
                this.fillRecordsList(screenList);
                return;
            }
            if (command == this.commandProperties) {
                display.setCurrent((Displayable)this.getScreenRecordProperties(screenList.getString(screenList.getSelectedIndex())));
                return;
            }
            if (command == this.commandBack) {
                display.setCurrent((Displayable)this.getScreenSettingsList());
            }
            return;
        }
        if (screen == this.screenRecordsClearConfirm) {
            if (command == this.commandYes) {
                final Runnable nextTask = new Runnable(){

                    public void run() {
                        display.setCurrent((Displayable)SystemManager.this.getScreenRecordsList());
                    }
                };
                display.setCurrent((Displayable)this.getScreenLongOperation("\u041e\u0447\u0438\u0441\u0442\u043a\u0430 \u0437\u0430\u043f\u0438\u0441\u0435\u0439\u2026"));
                new Thread("\u041e\u0447\u0438\u0441\u0442\u043a\u0430 \u0437\u0430\u043f\u0438\u0441\u0435\u0439\u2026"){

                    public void run() {
                        String[] recordStores = RecordStore.listRecordStores();
                        int i = recordStores.length;
                        while (i-- > 0) {
                            try {
                                RecordStore.deleteRecordStore((String)recordStores[i]);
                            }
                            catch (RecordStoreException e) {
                                e.printRealStackTrace();
                            }
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            e.printRealStackTrace();
                        }
                        display.callSerially(nextTask);
                    }
                }.start();
                return;
            }
            if (command == this.commandNo) {
                display.setCurrent((Displayable)this.screenRecordsList);
            }
            return;
        }
        if (screen == this.screenRecordDeleteConfirm) {
            if (command == this.commandYes) {
                try {
                    screenList = this.screenRecordsList;
                    RecordStore.deleteRecordStore((String)screenList.getString(screenList.getSelectedIndex()));
                    this.fillRecordsList(screenList);
                }
                catch (RecordStoreException e) {
                    e.printRealStackTrace();
                    this.fillRecordsList(screenList);
                    display.setCurrent((Displayable)this.getScreenError("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 \u0437\u0430\u043f\u0438\u0441\u0438.\n\n".concat(e.getRealMessage())));
                    return;
                }
            }
            display.setCurrent((Displayable)this.screenRecordsList);
            return;
        }
        if (screen == this.screenRecordProperties) {
            if (command == this.commandBack) {
                display.setCurrent((Displayable)this.screenRecordsList);
            }
            return;
        }
        if (screen == this.screenDeviceButtonsView) {
            if (command == this.commandBack) {
                display.setCurrent((Displayable)this.getScreenSettingsList());
            }
            return;
        }
        if (screen == this.screenAboutApplication || screen == this.screenAboutImplementation) {
            if (command == this.commandBack) {
                display.setCurrent((Displayable)this.getScreenApplicationList());
            }
            return;
        }
        if (screen == this.screenApplicationError) {
            if (command == this.commandExit) {
                Run.instance.terminate();
            }
            return;
        }
        screenList = this.screenApplicationList;
        if (screen == screenList) {
            if (command == this.commandLaunch) {
                String applicationClassName = this.applicationClassNames[screenList.getSelectedIndex()];
                display.setCurrent((Displayable)this.getScreenLongOperation("\u041f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u0437\u0430\u043f\u0443\u0441\u043a\u0430\u0435\u0442\u0441\u044f\u2026"));
                this.clearFields();
                this.prepareForApplicationLaunch(this.console);
                this.applicationDisplay.applicationStart(applicationClassName);
                return;
            }
            if (command == this.commandSettings) {
                display.setCurrent((Displayable)this.getScreenSettingsList());
                return;
            }
            if (command == this.commandAboutApplication) {
                display.setCurrent((Displayable)this.getScreenAboutApplication());
                return;
            }
            if (command == this.commandAboutImplementation) {
                display.setCurrent((Displayable)this.getScreenAboutImplementation());
                return;
            }
            if (command == this.commandExit) {
                Run.instance.terminate();
            }
        }
    }

    public void commandAction(Command command, Item item) {
        Display display = super.getMainDisplay();
        SettingsForm[] settingsForms = this.screenSettings;
        int i = this.screenSettings.length;
        while (i-- > 0) {
            SettingsForm screen = settingsForms[i];
            if (screen == null) continue;
            if (item == screen.getApplyButton()) {
                this.settingApply(screen);
                display.setCurrent((Displayable)this.getScreenSettingsList());
                break;
            }
            if (item != screen.getBackButton()) continue;
            display.setCurrent((Displayable)this.getScreenSettingsList());
            break;
        }
    }

    public void itemStateChanged(Item item) {
        ChoiceGroup itemChoiceGroup = this.itemKeyCodeSets;
        if (item == itemChoiceGroup) {
            int index = itemChoiceGroup.getSelectedIndex();
            if (index > 0) {
                int j;
                int[] keys = KEY_CODE_SETS[index].getKeyCodesAsArray();
                SettingsForm screen = this.screenSettingKeyCodes;
                int i = j = screen.size() - 1;
                while (i-- > 0) {
                    ((Input)screen.get(j)).setString(Integer.toString(keys[i]));
                    --j;
                }
            }
            return;
        }
        ButtonSet itemButtonSet = this.itemDeviceButtons;
        if (item == itemButtonSet) {
            DeviceSettings settings = super.getSettings();
            int deviceKey = itemButtonSet.getPressedButtonID();
            switch (deviceKey) {
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    int keyCode = settings.getKeyCodeFor(deviceKey);
                    this.itemKeyDescription.setText(new StringBuilder().append(settings.getKeyName(keyCode)).append("\n\u041a\u043e\u0434 \u043a\u043b\u0430\u0432\u0438\u0448\u0438: ").append(keyCode).append("\n\u041d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435: \u043f\u043e\u0441\u044b\u043b\u0430\u0435\u0442 \u0432 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u043a\u043e\u0434 \u043a\u043b\u0430\u0432\u0438\u0448\u0438.").toString());
                    break;
                }
                case 35: {
                    int keyCode = settings.getKeyCodeFor(deviceKey);
                    this.itemKeyDescription.setText(new StringBuilder().append(settings.getKeyName(keyCode)).append("\n\u041a\u043e\u0434 \u043a\u043b\u0430\u0432\u0438\u0448\u0438: ").append(keyCode).append("\n\u041d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435: \u043f\u043e\u0441\u044b\u043b\u0430\u0435\u0442 \u0432 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u043a\u043e\u0434 \u043a\u043b\u0430\u0432\u0438\u0448\u0438.\n\u041f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0435: \u044d\u0442\u0430 \u043a\u043b\u0430\u0432\u0438\u0448\u0430 \u043f\u043e\u0437\u0432\u043e\u043b\u044f\u0435\u0442 \u043f\u043e\u043b\u043d\u043e\u0441\u0442\u044c\u044e \u043f\u0440\u043e\u0441\u043c\u043e\u0442\u0440\u0435\u0442\u044c \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0438\u0441\u043a\u0430. \u0415\u0441\u043b\u0438 \u043d\u0430 \u044d\u043a\u0440\u0430\u043d\u0435 \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0435\u0442\u0441\u044f \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u044b\u0439 \u0441\u043f\u0438\u0441\u043e\u043a \u043a\u0430\u043a\u0438\u0445-\u043b\u0438\u0431\u043e \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0441\u0440\u0435\u0434\u0438 \u043d\u0438\u0445 \u0435\u0441\u0442\u044c \u0442\u0430\u043a\u0438\u0435, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0437\u0430\u043a\u0430\u043d\u0447\u0438\u0432\u0430\u044e\u0442\u0441\u044f \u043d\u0430 \u043c\u043d\u043e\u0433\u043e\u0442\u043e\u0447\u0438\u0435 (\u00ab\u2026\u00bb), \u0432\u044b\u0434\u0435\u043b\u0438\u0442\u0435 \u0442\u0430\u043a\u043e\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0438 \u043d\u0430\u0436\u043c\u0438\u0442\u0435 \u044d\u0442\u0443 \u043a\u043b\u0430\u0432\u0438\u0448\u0443. \u041f\u043e\u043a\u0430 \u0432\u044b \u0435\u0451 \u0443\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0435, \u043d\u0430 \u044d\u043a\u0440\u0430\u043d\u0435 \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0435\u0442\u0441\u044f \u043f\u043e\u043b\u043d\u044b\u0439 \u0442\u0435\u043a\u0441\u0442 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0433\u043e \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430, \u0431\u0435\u0437 \u043c\u043d\u043e\u0433\u043e\u0442\u043e\u0447\u0438\u044f.").toString());
                    break;
                }
                case 44: {
                    this.itemKeyDescription.setText("\u0412\u044b\u0437\u043e\u0432 \u043a\u043e\u043d\u0441\u043e\u043b\u0438\n\u041d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435: \u0432\u044b\u0437\u044b\u0432\u0430\u0435\u0442 \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u0443\u044e \u043a\u043e\u043d\u0441\u043e\u043b\u044c (\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u0432\u043e \u0432\u0440\u0435\u043c\u044f \u0440\u0430\u0431\u043e\u0442\u044b \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f).");
                    break;
                }
                case 46: {
                    this.itemKeyDescription.setText("\u0412\u044b\u0445\u043e\u0434 \u0438\u0437 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f\n\u041d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435: \u0432\u044b\u0437\u044b\u0432\u0430\u0435\u0442 \u0434\u0438\u0430\u043b\u043e\u0433 \u0432\u044b\u0445\u043e\u0434\u0430 \u0438\u0437 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f (\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u0432\u043e \u0432\u0440\u0435\u043c\u044f \u0440\u0430\u0431\u043e\u0442\u044b \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f).");
                    break;
                }
                default: {
                    return;
                }
            }
            this.itemKeyEquivalent.setText(DeviceSettings.keyToString((int)settings.getKeyUsedAs(deviceKey)));
        }
    }

    public void threadTerminated(Thread terminatedThread, Throwable exitThrowable) {
        if (exitThrowable != null) {
            Display main = super.getMainDisplay();
            Display curr = super.getCurrentDisplay();
            RecordStore.closeAllRecordStores();
            exitThrowable.printRealStackTrace();
            this.getItemErrorInfo().setText(new StringBuilder().append(exitThrowable.getRealMessage()).append("\n\n \u2013 ").append(exitThrowable.getClass().getCanonicalName()).toString());
            main.setCurrent((Displayable)this.getScreenApplicationError());
            if (curr != main) {
                super.setCurrentDisplay(main);
            }
        }
    }

    public final MIDletDisplay getApplicationDisplay() {
        return this.applicationDisplay;
    }

    protected void showStartScreen(Display display) {
        display.setCurrent((Displayable)this.getScreenApplicationList());
    }

    protected void showConsoleScreen(Display display) {
        Console console = this.console;
        if (!this.consoleGreetingPrinted) {
            this.consoleGreetingPrinted = true;
            console.println(new StringBuilder().append("\u0414\u043e\u0431\u0440\u043e \u043f\u043e\u0436\u0430\u043b\u043e\u0432\u0430\u0442\u044c \u0432 ").append(console.getTitle()).append("!\n\u041d\u0430\u0431\u0435\u0440\u0438\u0442\u0435 \u043d\u0430 \u043a\u043e\u043d\u0441\u043e\u043b\u0438 \u043a\u043e\u043c\u0430\u043d\u0434\u0443\n ?\n\u0447\u0442\u043e\u0431\u044b \u0443\u0432\u0438\u0434\u0435\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0445 \u043a\u043e\u043c\u0430\u043d\u0434.").toString());
        }
        display.setCurrent((Displayable)console);
    }

    protected void showExitAppScreen(Display display) {
        display.setCurrent(this.getScreenExitApplication(), this.getScreenBackground());
    }

    protected void keyboardEvent(KeyboardEvent event) {
        super.keyboardEvent(event);
        if (super.getCurrentDisplay() instanceof MIDletDisplay && event.getAction() == 6) {
            switch (event.getKey()) {
                case 116: {
                    if (this.isKeyUsed(116)) break;
                    this.imagesCommand.executeInBackground();
                    break;
                }
                case 117: {
                    if (this.isKeyUsed(117)) break;
                    this.soundsCommand.executeInBackground();
                }
            }
        }
    }

    protected void buildAuthorList(ManagerStringList authors) {
    }

    protected void buildLicenseList(ManagerStringList licenses) {
    }

    protected void buildSpecificationList(ManagerStringList specifications) {
    }

    protected void buildSettingList(ManagerSettingList settings) {
    }

    protected void settingSelected(int settingIndex, String settingName, Display display) {
    }

    protected void prepareForApplicationLaunch(Console console) {
    }

    protected String[] getSupportedContentTypes() {
        return this.getSystemSupportedContentTypes();
    }

    protected String[] getSupportedProtocols() {
        return this.getSystemSupportedProtocols();
    }

    protected MIDletDisplay createApplicationDisplay() {
        return null;
    }

    protected final void returnToSettingsScreen() {
        super.getMainDisplay().setCurrent((Displayable)this.getScreenSettingsList());
    }

    final void switchToApplicationDisplay() {
        super.setCurrentDisplay((Display)this.applicationDisplay);
    }

    final void switchToSystemDisplay() {
        super.setCurrentDisplay(super.getMainDisplay());
    }

    final List getScreenRecordsList() {
        List result = this.screenRecordsList;
        if (result == null) {
            result = this.screenRecordsList = new List("\u0417\u0430\u043f\u0438\u0441\u0438", null, false, null, 3, "(\u043d\u0435\u0442 \u0437\u0430\u043f\u0438\u0441\u0435\u0439)", new String[0], null);
            this.screenRecordsList.setCommandListener((CommandListener)this);
            result.setSelectCommand(this.getCommandProperties());
            result.addCommand(this.getCommandUpdate());
            result.addCommand(this.getCommandBack());
        }
        this.fillRecordsList(result);
        return result;
    }

    private void clearFields() {
        this.applicationClassNames = null;
        this.itemKeyCodeSets = null;
        this.itemDeviceButtons = null;
        this.itemRecordProperties = null;
        this.itemKeyDescription = null;
        this.itemKeyEquivalent = null;
        this.commandBack = null;
        this.commandApply = null;
        this.commandClear = null;
        this.commandDelete = null;
        this.commandLaunch = null;
        this.commandUpdate = null;
        this.commandSettings = null;
        this.commandProperties = null;
        this.commandAboutApplication = null;
        this.commandAboutImplementation = null;
        this.screenRecordsList = null;
        this.screenSettingsList = null;
        this.screenApplicationList = null;
        this.screenAboutApplication = null;
        this.screenAboutImplementation = null;
        this.screenRecordProperties = null;
        this.screenDeviceButtonsView = null;
        this.screenError = null;
        this.screenRecordsClearConfirm = null;
        this.screenRecordDeleteConfirm = null;
        this.screenSettingFonts = null;
        this.screenSettingSystem = null;
        this.screenSettingControls = null;
        this.screenSettingKeyCodes = null;
        this.screenLongOperation = null;
        SettingsForm[] array = this.screenSettings;
        Array.fill((Object[])this.screenSettings, (int)0, (int)array.length, null);
    }

    private void fillRecordsList(List list) {
        String[] records = RecordStore.listRecordStores();
        int len = records.length;
        int selected = list.getSelectedIndex();
        list.deleteAll();
        int i = 0;
        while (i < len) {
            list.append(records[i], null);
            ++i;
        }
        if (selected >= 0 && len > 0) {
            if (selected >= len) {
                selected = len - 1;
            }
            list.setSelectedIndex(selected, true);
        }
        if (len > 0) {
            list.addCommand(this.getCommandClear());
            list.addCommand(this.getCommandDelete());
            list.addCommand(this.getCommandProperties());
            return;
        }
        list.removeCommand(this.getCommandClear());
        list.removeCommand(this.getCommandDelete());
        list.removeCommand(this.getCommandProperties());
    }

    private void settingSelect(int settingIndex, String settingName) {
        final Display display = super.getMainDisplay();
        if (settingIndex == this.saveSettingsElementIndex) {
            final DeviceSettings settings = super.getSettings();
            List nextScreen = this.getScreenApplicationList();
            display.setCurrent((Displayable)this.getScreenLongOperation("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a\u2026"));
            new Thread("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a\u2026", (Displayable)nextScreen){
                private final /* synthetic */ Displayable val$nextScreen;
                {
                    this.val$nextScreen = displayable;
                }

                public void run() {
                    settings.saveMIDletProperties();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printRealStackTrace();
                    }
                    display.setCurrent(this.val$nextScreen);
                }
            }.start();
            return;
        }
        switch (settingIndex) {
            case 0: {
                display.setCurrent((Displayable)this.getScreenSettingControls());
                break;
            }
            case 1: {
                display.setCurrent((Displayable)this.getScreenSettingKeyCodes());
                break;
            }
            case 2: {
                display.setCurrent((Displayable)this.getScreenSettingFonts());
                break;
            }
            case 3: {
                display.setCurrent((Displayable)this.getScreenSettingSystem());
                break;
            }
            case 4: {
                display.setCurrent((Displayable)this.getScreenRecordsList());
                break;
            }
            case 5: {
                display.setCurrent((Displayable)this.getScreenDeviceButtonsView());
                break;
            }
            default: {
                this.settingSelected(settingIndex, settingName, display);
            }
        }
    }

    private void settingApply(SettingsForm settingForm) {
        DeviceSettings settings = super.getSettings();
        if (settingForm == this.screenSettingControls) {
            int[] deviceKeys = DEVICE_KEYS;
            int[] keybrdKeys = KEYBOARD_KEYS;
            int i = settingForm.size();
            while (i-- > 0) {
                int key = keybrdKeys[((Choice)settingForm.get(i)).getSelectedIndex()];
                if (key == 0) continue;
                settings.setKeyUsedAs(deviceKeys[i], key);
            }
            return;
        }
        if (settingForm == this.screenSettingKeyCodes) {
            int j;
            int[] deviceKeys = DEVICE_KEYS;
            int i = j = settingForm.size() - 1;
            while (i-- > 0) {
                try {
                    int keyCode = Integer.parseInt(((TextField)settingForm.get(j)).getString());
                    settings.setKeyCodeFor(deviceKeys[i], keyCode);
                }
                catch (NumberFormatException numberFormatException) {}
                --j;
            }
            return;
        }
        if (settingForm == this.screenSettingFonts) {
            int[] sizes = FONT_SIZES;
            int i = settingForm.size();
            while (i-- > 0) {
                Choice list = (Choice)settingForm.get(i);
                settings.setFont(i & 3, sizes[i >> 2], SystemFont.get((String)list.getString(list.getSelectedIndex())));
            }
            return;
        }
        if (settingForm == this.screenSettingSystem) {
            settings.setMaximumFrequency(((Gauge)settingForm.get(0)).getValue());
            Choice list = (Choice)settingForm.get(1);
            settings.setEnableStackTrace(list.isSelected(0));
            settings.setKeyRepeatedEvent(list.isSelected(1));
        }
    }

    private boolean isKeyUsed(int key) {
        DeviceSettings settings = super.getSettings();
        int[] deviceKeys = DEVICE_KEYS;
        int i = DEVICE_KEYS.length;
        while (i-- > 0) {
            if (settings.getKeyUsedAs(deviceKeys[i]) != key) continue;
            return true;
        }
        return false;
    }

    private String[] buildApplicationList(List dest) {
        String[] attributes;
        int len = 0;
        Object[] result = new String[1];
        DeviceSettings settings = super.getSettings();
        dest.setTitle(settings.getMIDletProperty("MIDlet-Name"));
        dest.deleteAll();
        int i = 0;
        while ((attributes = settings.getMIDletAttributes("MIDlet-".concat(Integer.toString(i + 1)))) != null && attributes.length >= 3) {
            Image icon = null;
            String appName = attributes[0];
            String iconName = attributes[1];
            String className = attributes[2];
            if (appName != null && className != null && className.length() > 0) {
                if (iconName != null && iconName.length() > 0) {
                    if (iconName.charAt(0) == '/') {
                        iconName = iconName.substring(1);
                    }
                    icon = SystemManager.loadImageFromFile("/res/".concat(iconName));
                }
                if (len == result.length) {
                    Object[] objectArray = result;
                    result = new String[(len << 1) + 1];
                    Array.copy((Object[])objectArray, (int)0, (Object[])result, (int)0, (int)len);
                }
                dest.append(appName, icon);
                result[len++] = className;
            }
            ++i;
        }
        if (len != result.length) {
            Object[] objectArray = result;
            result = new String[len];
            Array.copy((Object[])objectArray, (int)0, (Object[])result, (int)0, (int)len);
        }
        return result;
    }

    private String[] getSystemSupportedContentTypes() {
        return new String[]{"audio/midi", "audio/x-wav"};
    }

    private String[] getSystemSupportedProtocols() {
        return new String[]{"file", "resource"};
    }

    private ChoiceGroup getItemKeyCodeSets() {
        ChoiceGroup result = this.itemKeyCodeSets;
        if (result == null) {
            KeyCodeSet[] sets = KEY_CODE_SETS;
            int len = KEY_CODE_SETS.length;
            String[] names = new String[len];
            int i = len;
            while (i-- > 0) {
                names[i] = sets[i].getName();
            }
            result = this.itemKeyCodeSets = new ChoiceGroup("\u041f\u0440\u0435\u0434\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438", 4, names, null);
            this.itemKeyCodeSets.setLayout(2048);
        }
        return result;
    }

    private ButtonSet getItemDeviceButtons() {
        ButtonSet result = this.itemDeviceButtons;
        if (result == null) {
            Image background = SystemManager.loadImageFromFile("/ui/keypad.png");
            if (background == null) {
                throw new RuntimeException("SystemManager.getItemDeviceButtons: \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 /ui/keypad.png.");
            }
            result = this.itemDeviceButtons = new ButtonSet(null, background);
            this.itemDeviceButtons.setLayout(515);
            try {
                FileInputStream input = new FileInputStream("/ui/keypad.dat");
                input.checkOpenError();
                try {
                    DataInputStream stream = new DataInputStream((InputStream)input);
                    while (stream.available() >= 5) {
                        int buttonID = stream.readUnsignedByte();
                        int left = stream.readUnsignedByte();
                        int top = stream.readUnsignedByte();
                        int width = stream.readUnsignedByte();
                        int height = stream.readUnsignedByte();
                        result.setButton(buttonID, left, top, width, height);
                    }
                }
                finally {
                    input.close();
                }
            }
            catch (IOException e) {
                e.printRealStackTrace();
                throw new RuntimeException("SystemManager.getItemDeviceButtons: \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 /ui/keypad.dat.");
            }
        }
        return result;
    }

    private StringItem getItemRecordProperties() {
        StringItem result = this.itemRecordProperties;
        if (result == null) {
            result = this.itemRecordProperties = new StringItem(null, null);
            this.itemRecordProperties.setLayout(2048);
            result.setFont(Font.getFont((int)0, (int)0, (int)0));
        }
        return result;
    }

    private StringItem getItemKeyDescription() {
        StringItem result = this.itemKeyDescription;
        if (result == null) {
            result = this.itemKeyDescription = new StringItem("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435", "\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043a\u043b\u0430\u0432\u0438\u0448\u0443 \u043d\u0430 \u044d\u0442\u043e\u0439 \u0432\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u043e\u0439 \u043a\u043b\u0430\u0432\u0438\u0430\u0442\u0443\u0440\u0435, \u0447\u0442\u043e\u0431\u044b \u0443\u0432\u0438\u0434\u0435\u0442\u044c \u0435\u0451 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0437\u0434\u0435\u0441\u044c.");
            this.itemKeyDescription.setLayout(2560);
        }
        return result;
    }

    private StringItem getItemKeyEquivalent() {
        StringItem result = this.itemKeyEquivalent;
        if (result == null) {
            result = this.itemKeyEquivalent = new StringItem("\u042d\u043a\u0432\u0438\u0432\u0430\u043b\u0435\u043d\u0442\u043d\u0430\u044f \u043a\u043b\u0430\u0432\u0438\u0448\u0430", "(\u041a\u043b\u0430\u0432\u0438\u0448\u0430 \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u0430)");
            this.itemKeyEquivalent.setLayout(2560);
        }
        return result;
    }

    private StringItem getItemErrorInfo() {
        StringItem result = this.itemErrorInfo;
        if (result == null) {
            result = this.itemErrorInfo = new StringItem(null, null);
            this.itemErrorInfo.setLayout(2048);
            result.setFont(Font.getFont((int)0, (int)0, (int)8));
        }
        return result;
    }

    private Command getCommandNo() {
        Command result = this.commandNo;
        if (result == null) {
            result = this.commandNo = new Command("\u041d\u0435\u0442", 2, 0);
        }
        return result;
    }

    private Command getCommandYes() {
        Command result = this.commandYes;
        if (result == null) {
            result = this.commandYes = new Command("\u0414\u0430", 4, 0);
        }
        return result;
    }

    private Command getCommandExit() {
        Command result = this.commandExit;
        if (result == null) {
            result = this.commandExit = new Command("\u0412\u044b\u0445\u043e\u0434", 7, 0);
        }
        return result;
    }

    private Command getCommandBack() {
        Command result = this.commandBack;
        if (result == null) {
            result = this.commandBack = new Command("\u041d\u0430\u0437\u0430\u0434", 2, 0);
        }
        return result;
    }

    private Command getCommandApply() {
        Command result = this.commandApply;
        if (result == null) {
            result = this.commandApply = new Command("\u041f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c", 1, Integer.MAX_VALUE);
        }
        return result;
    }

    private Command getCommandClear() {
        Command result = this.commandClear;
        if (result == null) {
            result = this.commandClear = new Command("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u0441\u0435", 1, 3);
        }
        return result;
    }

    private Command getCommandDelete() {
        Command result = this.commandDelete;
        if (result == null) {
            result = this.commandDelete = new Command("\u0423\u0434\u0430\u043b\u0438\u0442\u044c", 1, 2);
        }
        return result;
    }

    private Command getCommandLaunch() {
        Command result = this.commandLaunch;
        if (result == null) {
            result = this.commandLaunch = new Command("\u0417\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c", 4, 0);
        }
        return result;
    }

    private Command getCommandUpdate() {
        Command result = this.commandUpdate;
        if (result == null) {
            result = this.commandUpdate = new Command("\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c", 1, 1);
        }
        return result;
    }

    private Command getCommandSettings() {
        Command result = this.commandSettings;
        if (result == null) {
            result = this.commandSettings = new Command("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438\u2026", 1, 1);
        }
        return result;
    }

    private Command getCommandProperties() {
        Command result = this.commandProperties;
        if (result == null) {
            result = this.commandProperties = new Command("\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430", 4, 0);
        }
        return result;
    }

    private Command getCommandAboutApplication() {
        Command result = this.commandAboutApplication;
        if (result == null) {
            result = this.commandAboutApplication = new Command("\u041e \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0438\u2026", 1, 2);
        }
        return result;
    }

    private Command getCommandAboutImplementation() {
        Command result = this.commandAboutImplementation;
        if (result == null) {
            result = this.commandAboutImplementation = new Command("\u041e \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438\u2026", 1, 3);
        }
        return result;
    }

    private List getScreenSettingsList() {
        List result = this.screenSettingsList;
        if (result == null) {
            Ticker ticker = new Ticker("\u042d\u0442\u043e \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f. \u0412\u0410\u0416\u041d\u041e: \u043d\u0435 \u0437\u0430\u0431\u0443\u0434\u044c\u0442\u0435 \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438. \u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0448\u0440\u0438\u0444\u0442\u043e\u0432 \u043f\u0440\u0438\u043c\u0435\u043d\u044f\u044e\u0442\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u0441\u043b\u0435 \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u043a\u0430 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b.");
            SystemSettingList settings = new SystemSettingList("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438", ticker, false, null, null);
            this.screenSettingsList = settings;
            result = settings;
            settings.setCommandListener(this);
            settings.addCommand(this.getCommandBack());
            settings.append("\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435", null);
            settings.append("\u041a\u043e\u0434\u044b \u043a\u043b\u0430\u0432\u0438\u0448", null);
            settings.append("\u0428\u0440\u0438\u0444\u0442\u044b", null);
            settings.append("\u0421\u0438\u0441\u0442\u0435\u043c\u0430", null);
            settings.append("\u0417\u0430\u043f\u0438\u0441\u0438", null);
            settings.append("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u043a\u043b\u0430\u0432\u0438\u0430\u0442\u0443\u0440\u0443", null);
            this.buildSettingList(settings);
            this.saveSettingsElementIndex = settings.append("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438", null);
        }
        return result;
    }

    private List getScreenApplicationList() {
        List result = this.screenApplicationList;
        if (result == null) {
            result = this.screenApplicationList = new List(null, 3);
            this.screenApplicationList.setCommandListener((CommandListener)this);
            this.applicationClassNames = this.buildApplicationList(result);
            result.setTicker(new Ticker("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u0438 \u043d\u0430\u0436\u043c\u0438\u0442\u0435 \u043a\u043d\u043e\u043f\u043a\u0443 \u00ab\u0417\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c\u00bb. \u0415\u0441\u043b\u0438 \u0445\u043e\u0442\u0438\u0442\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0438\u0442\u044c \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435, \u0442\u043e \u0441\u043f\u0435\u0440\u0432\u0430 \u043d\u0430\u0436\u043c\u0438\u0442\u0435 \u043a\u043d\u043e\u043f\u043a\u0443 \u00ab\u041c\u0435\u043d\u044e\u00bb \u0438 \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u00ab\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438\u2026\u00bb."));
            result.addCommand(this.getCommandExit());
            result.addCommand(this.getCommandSettings());
            result.addCommand(this.getCommandAboutApplication());
            result.addCommand(this.getCommandAboutImplementation());
            result.setSelectCommand(this.getCommandLaunch());
        }
        return result;
    }

    private Form getScreenApplicationError() {
        Form result = this.screenApplicationError;
        if (result == null) {
            result = this.screenApplicationError = new Form("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f", new Item[]{this.getItemErrorInfo()});
            this.screenApplicationError.setCommandListener((CommandListener)this);
            result.addCommand(this.getCommandExit());
            result.getHorizontalScrollBar().hide();
        }
        return result;
    }

    private Form getScreenAboutApplication() {
        Form result = this.screenAboutApplication;
        if (result == null) {
            DeviceSettings settings = super.getSettings();
            Font font = Font.getFont((int)0, (int)0, (int)8);
            String site1 = settings.getMIDletProperty("MIDlet-Info-URL");
            String site2 = settings.getMIDletProperty("SiteURL");
            ImageItem icon = new ImageItem(null, SystemManager.loadApplicationIcon(), 48, null);
            Spacer space = new Spacer(4, 1);
            StringItem name = new StringItem(null, settings.getMIDletProperty("MIDlet-Name"));
            StringItem version = new StringItem("\u0412\u0435\u0440\u0441\u0438\u044f", " ".concat(settings.getMIDletProperty("MIDlet-Version")));
            StringItem vendor = new StringItem("\u041f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a", " ".concat(settings.getMIDletProperty("MIDlet-Vendor")));
            StringItem config = new StringItem("\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f", " ".concat(settings.getMIDletProperty("MicroEdition-Configuration")));
            StringItem profile = new StringItem("\u041f\u0440\u043e\u0444\u0438\u043b\u044c", " ".concat(settings.getMIDletProperty("MicroEdition-Profile")));
            SystemStringItem midlets = new SystemStringItem("\u041a\u043b\u0430\u0441\u0441 \u043c\u0438\u0434\u043b\u0435\u0442\u0430");
            StringItem internet = site1 != null && site1.length() > 0 ? new StringItem("\u0418\u043d\u0442\u0435\u0440\u043d\u0435\u0442", " ".concat(site1)) : (site2 != null && site2.length() > 0 ? new StringItem("\u0418\u043d\u0442\u0435\u0440\u043d\u0435\u0442", " ".concat(site2)) : null);
            name.setLayout(2608);
            name.setFont(Font.getFont((int)0, (int)0, (int)0));
            String[] classes = this.applicationClassNames;
            int len = this.applicationClassNames.length;
            int i = 0;
            while (i < len) {
                midlets.add(classes[i]);
                ++i;
            }
            Item[] items = internet == null ? new Item[]{icon, space, name, version, vendor, config, profile, midlets} : new Item[]{icon, space, name, version, vendor, internet, config, profile, midlets};
            int i2 = items.length;
            while (i2-- > 0) {
                Item item = items[i2];
                if (item == name || !(item instanceof StringItem)) continue;
                item.setLayout(2560);
                ((StringItem)item).setFont(font);
            }
            result = this.screenAboutApplication = new Form("\u041e \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0438", items);
            this.screenAboutApplication.setCommandListener((CommandListener)this);
            result.addCommand(this.getCommandBack());
            result.getHorizontalScrollBar().hide();
        }
        return result;
    }

    private Form getScreenAboutImplementation() {
        Form result = this.screenAboutImplementation;
        if (result == null) {
            Font font = Font.getFont((int)0, (int)0, (int)8);
            String softwareVersion = System.getProperty("software.version");
            String configuration = System.getProperty("microedition.configuration");
            String profiles = System.getProperty("microedition.profiles");
            StringItem version = new StringItem("\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0432\u0435\u0440\u0441\u0438\u0438", new StringBuilder().append(" \u0412\u0435\u0440\u0441\u0438\u044f: ").append(softwareVersion).append("\n \u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f: ").append(configuration).append("\n \u041f\u0440\u043e\u0444\u0438\u043b\u0438: ").append(profiles).toString());
            StringItem classList = new StringItem("\u0412\u0430\u0436\u043d\u044b\u0435 \u043a\u043b\u0430\u0441\u0441\u044b", new StringBuilder().append(' ').append(super.getSettings().getClass().getCanonicalName()).append("\n ").append(super.getClass().getCanonicalName()).toString());
            SystemStringItem specList = new SystemStringItem("\u041f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0435 \u0441\u043f\u0435\u0446\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438");
            SystemStringItem authorList = new SystemStringItem("\u0410\u0432\u0442\u043e\u0440\u044b");
            SystemStringItem licenseList = new SystemStringItem("\u041b\u0438\u0446\u0435\u043d\u0437\u0438\u0438");
            StringItem[] items = new StringItem[]{version, specList, classList, authorList, licenseList};
            int i = items.length;
            while (i-- > 0) {
                StringItem item = items[i];
                item.setLayout(2560);
                item.setFont(font);
            }
            specList.add("WMA 1.1 (JSR-120)");
            specList.add("MMAPI 1.2 (JSR-135)");
            specList.add("File connection (JSR-75)");
            specList.add("Nokia UI API 1.1");
            specList.add("Samsung API");
            this.buildSpecificationList(specList);
            authorList.add("\u041c\u0430\u043b\u0438\u043a \u0420\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a (malik-elaborarer@protonmail.com)");
            this.buildAuthorList(authorList);
            licenseList.add("GNU LGPL 3");
            licenseList.add("ZLib");
            this.buildLicenseList(licenseList);
            licenseList.add("\u041e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u043a \u0438\u0441\u0445\u043e\u0434\u043d\u043e\u043c\u0443 \u043a\u043e\u0434\u0443 \u0437\u0430 \u043f\u043e\u0434\u0440\u043e\u0431\u043d\u043e\u0441\u0442\u044f\u043c\u0438.");
            result = this.screenAboutImplementation = new Form("\u041e \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438", (Item[])items);
            this.screenAboutImplementation.setCommandListener((CommandListener)this);
            result.addCommand(this.getCommandBack());
            result.getHorizontalScrollBar().hide();
        }
        return result;
    }

    private Form getScreenRecordProperties(String recordStoreName) {
        Form result = this.screenRecordProperties;
        if (result == null) {
            result = this.screenRecordProperties = new Form(null, new Item[]{this.getItemRecordProperties()});
            this.screenRecordProperties.setCommandListener((CommandListener)this);
            result.addCommand(this.getCommandBack());
            result.getHorizontalScrollBar().hide();
        }
        result.setTitle("\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430: ".concat(recordStoreName));
        try {
            RecordStore store = RecordStore.openRecordStore((String)recordStoreName, (boolean)false);
            try {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new Date(store.getLastModified()));
                this.itemRecordProperties.setText(new StringBuilder().append(" \u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435: ").append(recordStoreName).append("\n \u0420\u0430\u0437\u043c\u0435\u0440: ").append(store.getSize()).append(" \u0431\u0430\u0439\u0442\n \u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u043e\u0434\u0437\u0430\u043f\u0438\u0441\u0435\u0439: ").append(store.getNumRecords()).append("\n \u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435: ").append(SystemManager.calendarToString(calendar)).append("\n \u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439: ").append(store.getVersion()).toString());
            }
            finally {
                store.closeRecordStore();
            }
        }
        catch (RecordStoreException e) {
            e.printRealStackTrace();
            this.itemRecordProperties.setText("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043f\u0440\u0438 \u0447\u0442\u0435\u043d\u0438\u0438 \u0441\u0432\u043e\u0439\u0441\u0442\u0432 \u0437\u0430\u043f\u0438\u0441\u0438.\n\n".concat(e.getRealMessage()));
        }
        return result;
    }

    private Form getScreenDeviceButtonsView() {
        Form result = this.screenDeviceButtonsView;
        if (result == null) {
            try {
                result = this.screenDeviceButtonsView = new Form("\u041a\u043b\u0430\u0432\u0438\u0430\u0442\u0443\u0440\u0430", new Item[]{this.getItemDeviceButtons(), this.getItemKeyDescription(), this.getItemKeyEquivalent()});
                this.screenDeviceButtonsView.setCommandListener((CommandListener)this);
                result.setItemStateListener((ItemStateListener)this);
                result.addCommand(this.getCommandBack());
                result.getHorizontalScrollBar().hide();
            }
            catch (RuntimeException e) {
                this.threadTerminated(Thread.currentThread(), e);
                throw e;
            }
        }
        return result;
    }

    private Alert getScreenError(String message) {
        Alert result = this.screenError;
        if (result == null) {
            result = this.screenError = new Alert(null, null, null, AlertType.ERROR);
        }
        result.setString(message);
        return result;
    }

    private Alert getScreenExitApplication() {
        Alert result = this.screenExitApplication;
        if (result == null) {
            String applicationName = super.getSettings().getMIDletProperty("MIDlet-Name");
            result = this.screenExitApplication = new Alert(null, new StringBuilder().append("\u0412\u044b\u0439\u0442\u0438 \u0438\u0437 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f ").append(applicationName).append("? \u0412\u0441\u0435 \u043d\u0435\u0441\u043e\u0445\u0440\u0430\u043d\u0451\u043d\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u0431\u0443\u0434\u0443\u0442 \u0443\u0442\u0435\u0440\u044f\u043d\u044b.").toString(), null, AlertType.CONFIRMATION);
            this.screenExitApplication.setCommandListener((CommandListener)this);
            result.addCommand(this.getCommandYes());
            result.addCommand(this.getCommandNo());
        }
        return result;
    }

    private Alert getScreenRecordsClearConfirm() {
        Alert result = this.screenRecordsClearConfirm;
        if (result == null) {
            result = this.screenRecordsClearConfirm = new Alert(null, "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0432\u0441\u0435\u0445 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 \u043f\u0440\u0438\u0432\u0435\u0434\u0451\u0442 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u043a \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044e, \u0432 \u043a\u043e\u0442\u043e\u0440\u043e\u043c \u043e\u043d\u043e \u043d\u0430\u0445\u043e\u0434\u0438\u043b\u043e\u0441\u044c \u0441\u0440\u0430\u0437\u0443 \u043f\u043e\u0441\u043b\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438. \u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u0441\u0435 \u0437\u0430\u043f\u0438\u0441\u0438?", null, AlertType.CONFIRMATION);
            this.screenRecordsClearConfirm.setCommandListener((CommandListener)this);
            result.addCommand(this.getCommandYes());
            result.addCommand(this.getCommandNo());
        }
        return result;
    }

    private Alert getScreenRecordDeleteConfirm(String recordStoreName) {
        Alert result = this.screenRecordDeleteConfirm;
        if (result == null) {
            result = this.screenRecordDeleteConfirm = new Alert(null, null, null, AlertType.WARNING);
            this.screenRecordDeleteConfirm.setCommandListener((CommandListener)this);
            result.addCommand(this.getCommandYes());
            result.addCommand(this.getCommandNo());
        }
        result.setString(new StringBuilder().append("\u041e\u0441\u0442\u043e\u0440\u043e\u0436\u043d\u043e: \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043e\u0434\u043d\u043e\u0439 \u0437\u0430\u043f\u0438\u0441\u0438 \u043c\u043e\u0436\u0435\u0442 \u043f\u0440\u0438\u0432\u0435\u0441\u0442\u0438 \u043a \u043e\u0448\u0438\u0431\u043a\u0430\u043c \u0432 \u0440\u0430\u0431\u043e\u0442\u0435 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f. \u0423\u0434\u0430\u043b\u044f\u0439\u0442\u0435 \u0437\u0430\u043f\u0438\u0441\u0438 \u0442\u043e\u043b\u044c\u043a\u043e \u0435\u0441\u043b\u0438 \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0432\u0441\u0451 \u0434\u0435\u043b\u0430\u0435\u0442\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e. \u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0437\u0430\u043f\u0438\u0441\u044c ").append(recordStoreName).append('?').toString());
        return result;
    }

    private Displayable getScreenBackground() {
        Object result = this.screenBackground;
        if (result == null) {
            result = this.screenBackground = new BlackScreen();
        }
        return result;
    }

    private SettingsForm getScreenSettingFonts() {
        SettingsForm result = this.screenSettingFonts;
        if (result == null) {
            String[] fontTypes = new String[]{"\u041c\u0435\u043b\u043a\u0438\u0439 \u043d\u043e\u0440\u043c\u0430\u043b\u044c\u043d\u044b\u0439", "\u041c\u0435\u043b\u043a\u0438\u0439 \u0436\u0438\u0440\u043d\u044b\u0439", "\u041c\u0435\u043b\u043a\u0438\u0439 \u043a\u0443\u0440\u0441\u0438\u0432", "\u041c\u0435\u043b\u043a\u0438\u0439 \u0436\u0438\u0440\u043d\u044b\u0439 \u043a\u0443\u0440\u0441\u0438\u0432", "\u0421\u0440\u0435\u0434\u043d\u0438\u0439 \u043d\u043e\u0440\u043c\u0430\u043b\u044c\u043d\u044b\u0439", "\u0421\u0440\u0435\u0434\u043d\u0438\u0439 \u0436\u0438\u0440\u043d\u044b\u0439", "\u0421\u0440\u0435\u0434\u043d\u0438\u0439 \u043a\u0443\u0440\u0441\u0438\u0432", "\u0421\u0440\u0435\u0434\u043d\u0438\u0439 \u0436\u0438\u0440\u043d\u044b\u0439 \u043a\u0443\u0440\u0441\u0438\u0432", "\u041a\u0440\u0443\u043f\u043d\u044b\u0439 \u043d\u043e\u0440\u043c\u0430\u043b\u044c\u043d\u044b\u0439", "\u041a\u0440\u0443\u043f\u043d\u044b\u0439 \u0436\u0438\u0440\u043d\u044b\u0439", "\u041a\u0440\u0443\u043f\u043d\u044b\u0439 \u043a\u0443\u0440\u0441\u0438\u0432", "\u041a\u0440\u0443\u043f\u043d\u044b\u0439 \u0436\u0438\u0440\u043d\u044b\u0439 \u043a\u0443\u0440\u0441\u0438\u0432"};
            int len = fontTypes.length;
            ChoiceGroup[] items = new ChoiceGroup[len];
            int i = len;
            while (i-- > 0) {
                ChoiceGroup list;
                items[i] = list = new ChoiceGroup(fontTypes[i], 4);
                list.setLayout(18432);
                list.setPreferredSize(150, -1);
                Enumeration e = SystemFont.systemFonts();
                while (e.hasMoreElements()) {
                    SystemFont sysFont = (SystemFont)e.nextElement();
                    Font midpFont = Font.getFont((SystemFont)sysFont, (int)0, (int)0, (int)0);
                    list.setFont(list.append(sysFont.getName(), null), midpFont);
                }
            }
            this.screenSettings[2] = this.screenSettingFonts = new SettingsForm("\u0428\u0440\u0438\u0444\u0442\u044b", (Item[])items);
            result = this.screenSettingFonts;
            this.screenSettingFonts.setCommandListener(this);
            result.setButtonListener(this);
            result.setHelpContents("\u0417\u0434\u0435\u0441\u044c \u043c\u043e\u0436\u043d\u043e \u0437\u0430\u0434\u0430\u0442\u044c \u0448\u0440\u0438\u0444\u0442\u044b, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u0431\u0443\u0434\u0435\u0442 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0434\u043b\u044f \u0432\u044b\u0432\u043e\u0434\u0430 \u0442\u0435\u043a\u0441\u0442\u0430.\n\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0448\u0440\u0438\u0444\u0442\u043e\u0432 \u0432\u0441\u0442\u0443\u043f\u044f\u0442 \u0432 \u0441\u0438\u043b\u0443 \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u0441\u043b\u0435 \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u043a\u0430 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b. \u0414\u043e \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u043a\u0430 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b \u043d\u0430\u0434\u043f\u0438\u0441\u0438 \u043d\u0430 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430\u0445 \u043c\u043e\u0433\u0443\u0442 \u0431\u044b\u0442\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u044b \u043d\u0435 \u0442\u0435\u043c \u0448\u0440\u0438\u0444\u0442\u043e\u043c, \u0447\u0442\u043e \u0431\u044b\u043b \u0437\u0430\u0434\u0430\u043d \u0437\u0434\u0435\u0441\u044c.");
            result.addCommand(this.getCommandBack());
            result.addCommand(this.getCommandApply());
            result.getHorizontalScrollBar().hide();
        }
        int[] sizes = FONT_SIZES;
        DeviceSettings proxy = super.getSettings();
        int i = result.size();
        while (i-- > 0) {
            Choice list = (Choice)result.get(i);
            list.setSelectedIndex(SystemManager.indexOfString(list, proxy.getFont(i & 3, sizes[i >> 2]).getName()), true);
        }
        return result;
    }

    private SettingsForm getScreenSettingSystem() {
        SettingsForm result = this.screenSettingSystem;
        if (result == null) {
            Font font = Font.getFont((int)0, (int)0, (int)8);
            Gauge frequency = new Gauge("\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u0430\u044f \u0447\u0430\u0441\u0442\u043e\u0442\u0430 \u043a\u0430\u0434\u0440\u043e\u0432 \u0432 \u0441\u0435\u043a\u0443\u043d\u0434\u0443", true, 99, 0);
            ChoiceGroup system = new ChoiceGroup("\u041f\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u0435 \u0441\u0438\u0441\u0442\u0435\u043c\u044b", 2, new String[]{"\u0422\u0440\u0430\u0441\u0441\u0438\u0440\u043e\u0432\u043a\u0430 \u0441\u0442\u0430\u043a\u0430 \u0432 \u0438\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f\u0445\n\n\u041e\u0442\u043a\u043b\u044e\u0447\u0438\u0442\u0435 \u044d\u0442\u0443 \u043e\u043f\u0446\u0438\u044e, \u0435\u0441\u043b\u0438 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442 \u0441 \u043e\u0448\u0438\u0431\u043a\u0430\u043c\u0438 \u0438 \u0433\u0435\u043d\u0435\u0440\u0438\u0440\u0443\u0435\u0442 \u043c\u043d\u043e\u0433\u043e \u0438\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0439, \u0443\u0432\u0435\u043b\u0438\u0447\u0438\u0432\u0430\u044f \u0440\u0430\u0437\u043c\u0435\u0440 \u0444\u0430\u0439\u043b\u0430 /err.txt. \u0412 \u043f\u0440\u043e\u0442\u0438\u0432\u043d\u043e\u043c \u0441\u043b\u0443\u0447\u0430\u0435 \u044d\u0442\u0443 \u043e\u043f\u0446\u0438\u044e \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u0442\u0441\u044f \u0432\u043a\u043b\u044e\u0447\u0438\u0442\u044c (\u0434\u043b\u044f \u043e\u0442\u0441\u043b\u0435\u0436\u0438\u0432\u0430\u043d\u0438\u044f \u043e\u0448\u0438\u0431\u043e\u043a \u0432 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0435).", "\u0412\u044b\u0437\u043e\u0432 \u043c\u0435\u0442\u043e\u0434\u0430 Canvas.keyRepeated(int)\n\n\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044f \u044d\u0442\u043e\u0433\u043e \u0444\u043b\u0430\u0433\u0430 \u043c\u043e\u0436\u0435\u0442 \u043f\u0440\u0438\u0432\u0435\u0441\u0442\u0438 \u043a \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u043f\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u0432 \u0442\u043e\u0442 \u043c\u043e\u043c\u0435\u043d\u0442, \u043a\u043e\u0433\u0434\u0430 \u0432\u044b \u0443\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0435 \u043d\u0430\u0436\u0430\u0442\u043e\u0439 \u043a\u0430\u043a\u0443\u044e-\u043b\u0438\u0431\u043e \u043a\u043b\u0430\u0432\u0438\u0448\u0443. \u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 \u0438\u043b\u0438 \u0441\u043d\u0438\u043c\u0438\u0442\u0435 \u044d\u0442\u043e\u0442 \u0444\u043b\u0430\u0433 \u0432 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0438 \u0441 \u0432\u0430\u0448\u0438\u043c\u0438 \u043f\u0440\u0435\u0434\u043f\u043e\u0447\u0442\u0435\u043d\u0438\u044f\u043c\u0438."}, null);
            frequency.setLayout(2048);
            system.setLayout(2048);
            int i = system.size();
            while (i-- > 0) {
                system.setFont(i, font);
            }
            this.screenSettings[3] = this.screenSettingSystem = new SettingsForm("\u0421\u0438\u0441\u0442\u0435\u043c\u0430", new Item[]{frequency, system});
            result = this.screenSettingSystem;
            this.screenSettingSystem.setCommandListener(this);
            result.setButtonListener(this);
            result.setHelpContents("\u0417\u0434\u0435\u0441\u044c \u043c\u043e\u0436\u043d\u043e \u043d\u0430\u0441\u0442\u0440\u043e\u0438\u0442\u044c \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u0443\u044e \u0447\u0430\u0441\u0442\u043e\u0442\u0443 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u044d\u043a\u0440\u0430\u043d\u0430 \u0438 \u043f\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u0435 \u0441\u0438\u0441\u0442\u0435\u043c\u044b.\n\u0420\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u043c\u044b\u0439 \u043c\u0430\u043a\u0441\u0438\u043c\u0443\u043c \u0447\u0430\u0441\u0442\u043e\u0442\u044b \u2013 25 \u043a\u0430\u0434\u0440\u043e\u0432 \u0432 \u0441\u0435\u043a\u0443\u043d\u0434\u0443. \u0411\u043e\u043b\u044c\u0448\u0438\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043c\u043e\u0433\u0443\u0442 \u043f\u0440\u0438\u0432\u0435\u0441\u0442\u0438 \u043a \u00ab\u043f\u043e\u0434\u0432\u0438\u0441\u0430\u043d\u0438\u044e\u00bb \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b \u0438 \u043f\u0440\u043e\u043f\u0443\u0441\u043a\u0443 \u043d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u043a\u0430\u0434\u0440\u043e\u0432. \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u0442\u0430\u043a\u0436\u0435 \u043c\u0430\u043a\u0441\u0438\u043c\u0443\u043c \u043a\u0430\u0434\u0440\u043e\u0432 \u0432 \u0441\u0435\u043a\u0443\u043d\u0434\u0443 \u0432 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430\u0445 \u0441\u0430\u043c\u043e\u0433\u043e \u041c\u0430\u043b\u0438\u043a \u042d\u043c\u0443\u043b\u044f\u0442\u043e\u0440\u0430.\n\u0412 \u043e\u043f\u0446\u0438\u044f\u0445 \u043f\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u043f\u0446\u0438\u044e, \u043d\u0430\u0436\u043c\u0438\u0442\u0435 \u0438 \u0443\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0439\u0442\u0435 \u043a\u043b\u0430\u0432\u0438\u0448\u0443 #, \u0447\u0442\u043e\u0431\u044b \u0443\u0432\u0438\u0434\u0435\u0442\u044c \u043f\u043e\u0434\u0440\u043e\u0431\u043d\u043e\u0435 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u0439 \u043e\u043f\u0446\u0438\u0438.");
            result.addCommand(this.getCommandBack());
            result.addCommand(this.getCommandApply());
            result.getHorizontalScrollBar().hide();
        }
        DeviceSettings proxy = super.getSettings();
        ((Gauge)result.get(0)).setValue(proxy.getMaximumFrequency());
        Choice list = (Choice)result.get(1);
        list.setSelectedIndex(0, proxy.isEnableStackTrace());
        list.setSelectedIndex(1, proxy.isKeyRepeatedEvent());
        return result;
    }

    private SettingsForm getScreenSettingControls() {
        int[] keys = DEVICE_KEYS;
        int len = DEVICE_KEYS.length;
        SettingsForm result = this.screenSettingControls;
        if (result == null) {
            ChoiceGroup[] items = new ChoiceGroup[len];
            int i = len;
            while (i-- > 0) {
                ChoiceGroup list;
                items[i] = list = new ChoiceGroup(SystemManager.deviceKeyToString(keys[i]), 4);
                SystemManager.fillKeysList((Choice)list);
                list.setLayout(18432);
                list.setPreferredSize(150, -1);
            }
            this.screenSettings[0] = this.screenSettingControls = new SettingsForm("\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435", (Item[])items);
            result = this.screenSettingControls;
            this.screenSettingControls.setCommandListener(this);
            result.setButtonListener(this);
            result.setHelpContents("\u0417\u0434\u0435\u0441\u044c \u043c\u043e\u0436\u043d\u043e \u0437\u0430\u0434\u0430\u0442\u044c \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0435 \u043c\u0435\u0436\u0434\u0443 \u043a\u043b\u0430\u0432\u0438\u0448\u0430\u043c\u0438 \u0432\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 \u0438 \u043a\u043b\u0430\u0432\u0438\u0448\u0430\u043c\u0438 \u043a\u043e\u043c\u043f\u044c\u044e\u0442\u0435\u0440\u0430.\n\u0412\u0410\u0416\u041d\u041e: \u0441\u043b\u0435\u0434\u0438\u0442\u0435, \u0447\u0442\u043e\u0431\u044b \u0432 \u0440\u0430\u0437\u043d\u044b\u0445 \u043f\u043e\u043b\u044f\u0445 \u0431\u044b\u043b\u0438 \u0440\u0430\u0437\u043d\u044b\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u044f \u043a\u043b\u0430\u0432\u0438\u0448 \u043a\u043e\u043c\u043f\u044c\u044e\u0442\u0435\u0440\u0430, \u0442\u0430\u043a \u043a\u0430\u043a \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430 \u044d\u0442\u043e\u0433\u043e \u043d\u0435 \u043f\u0440\u043e\u0432\u0435\u0440\u044f\u0435\u0442.\n\u0420\u0430\u0441\u0448\u0438\u0444\u0440\u043e\u0432\u043a\u0430 \u043d\u0435\u043f\u043e\u043d\u044f\u0442\u043d\u044b\u0445 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0439 \u043a\u043b\u0430\u0432\u0438\u0448 \u043a\u043e\u043c\u043f\u044c\u044e\u0442\u0435\u0440\u0430:\n  UP \u2013 \u2191\n  DOWN \u2013 \u2193\n  LEFT \u2013 \u2190\n  RIGHT \u2013 \u2192\n  NUM_PLUS \u2013 Num +\n  NUM_MINUS \u2013 Num -\n  NUM_STAR \u2013 Num *\n  NUM_DIVIDE \u2013 Num /\n  NUM_DECIMAL \u2013 Num .\n\u041e\u043f\u0446\u0438\u044f \u00ab\u0421\u0432\u043e\u0438 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438\u00bb \u043d\u0435 \u0438\u0437\u043c\u0435\u043d\u044f\u0435\u0442 \u0437\u0430\u0434\u0430\u043d\u043d\u0443\u044e \u043a\u043b\u0430\u0432\u0438\u0448\u0443 \u043a\u043e\u043c\u043f\u044c\u044e\u0442\u0435\u0440\u0430 \u043f\u0440\u0438 \u043d\u0430\u0436\u0430\u0442\u0438\u0438 \u043a\u043d\u043e\u043f\u043a\u0438 \u00ab\u041f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c\u00bb, \u043e\u0441\u0442\u0430\u0432\u043b\u044f\u044f \u0440\u0430\u043d\u043d\u0435\u0435 \u0437\u0430\u0434\u0430\u043d\u043d\u0443\u044e \u043a\u043b\u0430\u0432\u0438\u0448\u0443. \u042d\u0442\u0430 \u043e\u043f\u0446\u0438\u044f \u0431\u044b\u043b\u0430 \u0441\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u043e \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0430 \u043d\u0430 \u0441\u043b\u0443\u0447\u0430\u0439, \u043a\u043e\u0433\u0434\u0430 \u0444\u0430\u0439\u043b \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a /midlet.properties \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043b\u0441\u044f \u0432\u0440\u0443\u0447\u043d\u0443\u044e.");
            result.addCommand(this.getCommandBack());
            result.addCommand(this.getCommandApply());
            result.getHorizontalScrollBar().hide();
        }
        DeviceSettings proxy = super.getSettings();
        int i = len;
        while (i-- > 0) {
            ((Choice)result.get(i)).setSelectedIndex(SystemManager.indexOfKey(proxy.getKeyUsedAs(keys[i])), true);
        }
        return result;
    }

    private SettingsForm getScreenSettingKeyCodes() {
        int j;
        int[] keys = DEVICE_KEYS;
        DeviceSettings proxy = super.getSettings();
        SettingsForm result = this.screenSettingKeyCodes;
        if (result == null) {
            int j2;
            Item[] itemArray = new Item[8];
            Item[] items = itemArray;
            itemArray[0] = this.getItemKeyCodeSets();
            int i = j2 = items.length - 1;
            while (i-- > 0) {
                TextField field = new TextField(proxy.getKeyName(proxy.getKeyCodeFor(keys[i])), null, 11, 2);
                items[j2] = field;
                field.setLayout(18432);
                field.setPreferredSize(150, -1);
                --j2;
            }
            this.screenSettings[1] = this.screenSettingKeyCodes = new SettingsForm("\u041a\u043e\u0434\u044b \u043a\u043b\u0430\u0432\u0438\u0448", items);
            result = this.screenSettingKeyCodes;
            this.screenSettingKeyCodes.setCommandListener(this);
            result.setItemStateListener(this);
            result.setButtonListener(this);
            result.setHelpContents("\u0417\u0434\u0435\u0441\u044c \u043c\u043e\u0436\u043d\u043e \u0437\u0430\u0434\u0430\u0442\u044c \u043a\u043e\u0434\u044b \u0442\u0435\u0445 \u043a\u043b\u0430\u0432\u0438\u0448, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043d\u0435 \u0431\u044b\u043b\u0438 \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u044b \u0441\u043f\u0435\u0446\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0435\u0439 MIDP, \u0432 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0435 \u0447\u0435\u0433\u043e \u043a\u043e\u0434\u044b \u044d\u0442\u0438\u0445 \u043a\u043b\u0430\u0432\u0438\u0448 \u0441\u0442\u0430\u043b\u0438 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u044b\u043c\u0438 \u043e\u0442 \u043a\u043e\u043d\u043a\u0440\u0435\u0442\u043d\u044b\u0445 \u043c\u043e\u0434\u0435\u043b\u0435\u0439 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432. \u041e\u0441\u043e\u0431\u0435\u043d\u043d\u043e \u044d\u0442\u043e \u043a\u0430\u0441\u0430\u0435\u0442\u0441\u044f \u0442\u0435\u0445 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0439, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0440\u0430\u0431\u043e\u0442\u0430\u044e\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u043d\u0430 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430\u0445 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0451\u043d\u043d\u044b\u0445 \u043c\u043e\u0434\u0435\u043b\u0435\u0439. \u0412\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u0437\u0430\u0434\u0430\u0442\u044c \u043e\u0441\u043e\u0431\u044b\u0435 \u0447\u0438\u0441\u043b\u043e\u0432\u044b\u0435 \u043a\u043e\u0434\u044b \u0434\u043b\u044f \u043a\u043b\u0430\u0432\u0438\u0448 \u0438\u043b\u0438 \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u043f\u0440\u0435\u0434\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0435 \u043a\u043e\u0434\u044b \u043a\u043b\u0430\u0432\u0438\u0448 \u0434\u043b\u044f \u043d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u043c\u043e\u0434\u0435\u043b\u0435\u0439 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432.");
            result.addCommand(this.getCommandBack());
            result.addCommand(this.getCommandApply());
            result.getHorizontalScrollBar().hide();
        }
        int i = j = result.size() - 1;
        while (i-- > 0) {
            ((Input)result.get(j)).setString(Integer.toString(proxy.getKeyCodeFor(keys[i])));
            --j;
        }
        return result;
    }

    private SurfaceTextViewer getScreenLongOperation(String message) {
        SurfaceTextViewer result = this.screenLongOperation;
        if (result == null) {
            result = this.screenLongOperation = new SurfaceTextViewer(null, Font.getDefaultFont());
            this.screenLongOperation.getScrollBar().hide();
        }
        result.setText(message);
        return result;
    }
}

