/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.microedition.system.protocol.file;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.microedition.io.file.IllegalModeException;
import malik.emulator.io.IOStream;
import malik.emulator.io.cloud.CloudFileSystem;
import malik.emulator.io.vfs.ClosedFileException;
import malik.emulator.io.vfs.FileNotFoundException;
import malik.emulator.io.vfs.VirtualFileSystemReadOnly;
import malik.emulator.io.vfs.VirtualFileSystemReadWrite;
import malik.emulator.util.StringBuilder;

final class File {
    public static final int READ = 1;
    public static final int WRITE = 2;
    public static final int READ_WRITE = 3;
    private static final Hashtable OPENED = new Hashtable();
    boolean closed;
    boolean hasInputStream;
    boolean hasOutputStream;
    private final int mode;
    private final String path;
    private IOStream openedIOStream;
    private LocalInputStream openedInputStream;
    private LocalOutputStream openedOutputStream;
    private final VirtualFileSystemReadOnly place;
    final Object monitor;

    public static File getOpened(VirtualFileSystemReadOnly place, String path) {
        return (File)OPENED.get(new PlacePathPair(place, path));
    }

    public static File open(VirtualFileSystemReadOnly place, String path, int mode) throws IOException {
        OutputStream destinationOutputStream;
        InputStream sourceInputStream;
        IOStream openedIOStream;
        if (place == null) {
            place = CloudFileSystem.instance;
        }
        if (path == null) {
            throw new NullPointerException("File.open: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 path \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (mode < 1 || mode > 3) {
            throw new IllegalArgumentException("File.open: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 mode \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        if ((mode & 2) != 0 && !(place instanceof VirtualFileSystemReadWrite)) {
            throw new IllegalArgumentException("File.open: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 place \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        PlacePathPair pair = new PlacePathPair(place, path);
        if (OPENED.get(pair) != null) {
            throw new FileNotFoundException(new StringBuilder().append("File.open: \u0444\u0430\u0439\u043b ").append(path).append(" \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0438\u043b\u0438 \u0437\u0430\u043d\u044f\u0442.").toString(), path);
        }
        if (mode == 1) {
            openedIOStream = null;
            sourceInputStream = place.openFileForRead(path);
            destinationOutputStream = null;
        } else {
            openedIOStream = ((VirtualFileSystemReadWrite)place).openFileForReadWrite(path);
            sourceInputStream = mode == 3 ? openedIOStream.getInputStream() : null;
            destinationOutputStream = openedIOStream.getOutputStream();
        }
        File result = new File(place, path, mode);
        new File(place, path, mode).openedIOStream = openedIOStream;
        if (sourceInputStream != null) {
            File file = result;
            file.getClass();
            result.openedInputStream = file.new LocalInputStream(sourceInputStream);
        }
        if (destinationOutputStream != null) {
            File file = result;
            file.getClass();
            result.openedOutputStream = file.new LocalOutputStream(destinationOutputStream);
        }
        OPENED.put(pair, result);
        return result;
    }

    private File(VirtualFileSystemReadOnly place, String path, int mode) {
        this.mode = mode;
        this.path = path;
        this.place = place;
        this.monitor = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.monitor;
        synchronized (object) {
            if (!this.closed) {
                this.fastClose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncate(long position) throws IOException {
        int error = 0;
        IOStream stream = null;
        Object object = this.monitor;
        synchronized (object) {
            if (this.closed) {
                error = 1;
            } else if ((this.mode & 2) == 0) {
                error = 2;
            } else {
                stream = this.openedIOStream;
            }
        }
        switch (error) {
            case 1: {
                throw new ClosedFileException("FileConnection.truncate: \u0444\u0430\u0439\u043b \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            case 2: {
                throw new IllegalModeException("FileConnection.truncate: \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0434\u043e\u0441\u0442\u0443\u043f \u0434\u043b\u044f \u0437\u0430\u043f\u0438\u0441\u0438.");
            }
        }
        long pos = stream.position();
        stream.resetOutputStream();
        stream.position(position);
        stream.truncate();
        stream.resetOutputStream();
        stream.position(pos);
    }

    public int getMode() {
        return this.mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream openInputStream() throws IOException {
        LocalInputStream result;
        int error = 0;
        Object object = this.monitor;
        synchronized (object) {
            if (this.closed) {
                error = 1;
                result = null;
            } else if ((this.mode & 1) == 0) {
                error = 2;
                result = null;
            } else if (this.hasInputStream) {
                error = 3;
                result = null;
            } else {
                IOStream stream = this.openedIOStream;
                if (stream != null) {
                    stream.resetInputStream();
                }
                this.hasInputStream = true;
                result = this.openedInputStream;
            }
        }
        switch (error) {
            case 1: {
                throw new ClosedFileException("FileConnection.openInputStream: \u0444\u0430\u0439\u043b \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            case 2: {
                throw new IllegalModeException("FileConnection.openInputStream: \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0434\u043e\u0441\u0442\u0443\u043f \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f.");
            }
            case 3: {
                throw new IOException("FileConnection.openInputStream: \u043f\u043e\u0442\u043e\u043a \u0432\u0432\u043e\u0434\u0430 \u0443\u0436\u0435 \u0431\u044b\u043b \u043e\u0442\u043a\u0440\u044b\u0442 \u0440\u0430\u043d\u043d\u0435\u0435.");
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream openOutputStream() throws IOException {
        LocalOutputStream result;
        int error = 0;
        Object object = this.monitor;
        synchronized (object) {
            if (this.closed) {
                error = 1;
                result = null;
            } else if ((this.mode & 2) == 0) {
                error = 2;
                result = null;
            } else if (this.hasOutputStream) {
                error = 3;
                result = null;
            } else {
                this.openedIOStream.resetOutputStream();
                this.hasOutputStream = true;
                result = this.openedOutputStream;
            }
        }
        switch (error) {
            case 1: {
                throw new ClosedFileException("FileConnection.openOutputStream: \u0444\u0430\u0439\u043b \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            case 2: {
                throw new IllegalModeException("FileConnection.openOutputStream: \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0434\u043e\u0441\u0442\u0443\u043f \u0434\u043b\u044f \u0437\u0430\u043f\u0438\u0441\u0438.");
            }
            case 3: {
                throw new IOException("FileConnection.openOutputStream: \u043f\u043e\u0442\u043e\u043a \u0432\u044b\u0432\u043e\u0434\u0430 \u0443\u0436\u0435 \u0431\u044b\u043b \u043e\u0442\u043a\u0440\u044b\u0442 \u0440\u0430\u043d\u043d\u0435\u0435.");
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream openInputStream(long position) throws IOException {
        LocalInputStream result;
        int error = 0;
        Object object = this.monitor;
        synchronized (object) {
            if (this.closed) {
                error = 1;
                result = null;
            } else if ((this.mode & 1) == 0) {
                error = 2;
                result = null;
            } else if (this.hasInputStream) {
                error = 3;
                result = null;
            } else {
                IOStream stream = this.openedIOStream;
                if (stream != null) {
                    stream.resetInputStream();
                }
                this.hasInputStream = true;
                result = this.openedInputStream;
                ((InputStream)result).skip(position);
            }
        }
        switch (error) {
            case 1: {
                throw new ClosedFileException("FileConnection.openInputStream: \u0444\u0430\u0439\u043b \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            case 2: {
                throw new IllegalModeException("FileConnection.openInputStream: \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0434\u043e\u0441\u0442\u0443\u043f \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f.");
            }
            case 3: {
                throw new IOException("FileConnection.openInputStream: \u043f\u043e\u0442\u043e\u043a \u0432\u0432\u043e\u0434\u0430 \u0443\u0436\u0435 \u0431\u044b\u043b \u043e\u0442\u043a\u0440\u044b\u0442 \u0440\u0430\u043d\u043d\u0435\u0435.");
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream openOutputStream(long position) throws IOException {
        LocalOutputStream result;
        int error = 0;
        Object object = this.monitor;
        synchronized (object) {
            if (this.closed) {
                error = 1;
                result = null;
            } else if ((this.mode & 2) == 0) {
                error = 2;
                result = null;
            } else if (this.hasOutputStream) {
                error = 3;
                result = null;
            } else {
                IOStream stream = this.openedIOStream;
                stream.resetOutputStream();
                stream.position(position);
                this.hasOutputStream = true;
                result = this.openedOutputStream;
            }
        }
        switch (error) {
            case 1: {
                throw new ClosedFileException("FileConnection.openOutputStream: \u0444\u0430\u0439\u043b \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            case 2: {
                throw new IllegalModeException("FileConnection.openOutputStream: \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0434\u043e\u0441\u0442\u0443\u043f \u0434\u043b\u044f \u0437\u0430\u043f\u0438\u0441\u0438.");
            }
            case 3: {
                throw new IOException("FileConnection.openOutputStream: \u043f\u043e\u0442\u043e\u043a \u0432\u044b\u0432\u043e\u0434\u0430 \u0443\u0436\u0435 \u0431\u044b\u043b \u043e\u0442\u043a\u0440\u044b\u0442 \u0440\u0430\u043d\u043d\u0435\u0435.");
            }
        }
        return result;
    }

    public String getPath() {
        return this.path;
    }

    public InputStream getInputStream() {
        return this.hasInputStream ? this.openedInputStream : null;
    }

    public OutputStream getOutputStream() {
        return this.hasOutputStream ? this.openedOutputStream : null;
    }

    public VirtualFileSystemReadOnly getPlace() {
        return this.place;
    }

    void fastClose() throws IOException {
        IOStream io = this.openedIOStream;
        LocalInputStream in = this.openedInputStream;
        OPENED.remove(new PlacePathPair(this.place, this.path));
        this.closed = true;
        this.hasInputStream = false;
        this.hasOutputStream = false;
        this.openedIOStream = null;
        this.openedInputStream = null;
        this.openedOutputStream = null;
        if (io != null) {
            io.close();
        } else {
            in.stream.close();
        }
    }

    private final class LocalInputStream
    extends InputStream {
        final InputStream stream;

        public LocalInputStream(InputStream stream) {
            this.stream = stream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            File owner = File.this;
            Object object = owner.monitor;
            synchronized (object) {
                if (owner.hasInputStream) {
                    owner.hasInputStream = false;
                    if (!owner.hasOutputStream) {
                        owner.fastClose();
                    }
                }
            }
        }

        public void reset() throws IOException {
            if (!File.this.hasInputStream) {
                throw new IOException("InputStream.reset: \u043f\u043e\u0442\u043e\u043a \u0432\u0432\u043e\u0434\u0430 \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            this.stream.reset();
        }

        public void mark(int readLimit) {
            this.stream.mark(readLimit);
        }

        public boolean markSupported() {
            return this.stream.markSupported();
        }

        public int available() throws IOException {
            if (!File.this.hasInputStream) {
                throw new IOException("InputStream.available: \u043f\u043e\u0442\u043e\u043a \u0432\u0432\u043e\u0434\u0430 \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            return this.stream.available();
        }

        public int read() throws IOException {
            if (!File.this.hasInputStream) {
                throw new IOException("InputStream.read: \u043f\u043e\u0442\u043e\u043a \u0432\u0432\u043e\u0434\u0430 \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            return this.stream.read();
        }

        public int read(byte[] dst) throws IOException {
            if (!File.this.hasInputStream) {
                throw new IOException("InputStream.read: \u043f\u043e\u0442\u043e\u043a \u0432\u0432\u043e\u0434\u0430 \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            return this.stream.read(dst);
        }

        public int read(byte[] dst, int offset, int length) throws IOException {
            if (!File.this.hasInputStream) {
                throw new IOException("InputStream.read: \u043f\u043e\u0442\u043e\u043a \u0432\u0432\u043e\u0434\u0430 \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            return this.stream.read(dst, offset, length);
        }

        public long skip(long quantity) throws IOException {
            if (!File.this.hasInputStream) {
                throw new IOException("InputStream.skip: \u043f\u043e\u0442\u043e\u043a \u0432\u0432\u043e\u0434\u0430 \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            return this.stream.skip(quantity);
        }

        public String toString() {
            return this.stream.toString();
        }
    }

    private final class LocalOutputStream
    extends OutputStream {
        final OutputStream stream;

        public LocalOutputStream(OutputStream stream) {
            this.stream = stream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            File owner = File.this;
            Object object = owner.monitor;
            synchronized (object) {
                if (owner.hasOutputStream) {
                    owner.hasOutputStream = false;
                    if (!owner.hasInputStream) {
                        owner.fastClose();
                    }
                }
            }
        }

        public void flush() throws IOException {
            if (!File.this.hasOutputStream) {
                throw new IOException("OutputStream.flush: \u043f\u043e\u0442\u043e\u043a \u0432\u044b\u0432\u043e\u0434\u0430 \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            this.stream.flush();
        }

        public void write(int byteData) throws IOException {
            if (!File.this.hasOutputStream) {
                throw new IOException("OutputStream.write: \u043f\u043e\u0442\u043e\u043a \u0432\u044b\u0432\u043e\u0434\u0430 \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            this.stream.write(byteData);
        }

        public void write(byte[] src) throws IOException {
            if (!File.this.hasOutputStream) {
                throw new IOException("OutputStream.write: \u043f\u043e\u0442\u043e\u043a \u0432\u044b\u0432\u043e\u0434\u0430 \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            this.stream.write(src);
        }

        public void write(byte[] src, int offset, int length) throws IOException {
            if (!File.this.hasOutputStream) {
                throw new IOException("OutputStream.write: \u043f\u043e\u0442\u043e\u043a \u0432\u044b\u0432\u043e\u0434\u0430 \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            this.stream.write(src, offset, length);
        }

        public String toString() {
            return this.stream.toString();
        }
    }

    private static final class PlacePathPair {
        public final Object place;
        public final String path;

        public PlacePathPair(Object place, String path) {
            this.place = place;
            this.path = path;
        }

        public boolean equals(Object anot) {
            if (anot instanceof PlacePathPair) {
                PlacePathPair ppp = (PlacePathPair)anot;
                if (this.place == ppp.place && this.path.equals(ppp.path)) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return System.identityHashCode(this.place) ^ this.path.hashCode();
        }
    }
}

