/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.microedition.system.protocol.sms;

import java.io.IOException;
import java.io.InterruptedIOException;
import javax.wireless.messaging.Message;
import javax.wireless.messaging.MessageConnection;
import javax.wireless.messaging.MessageListener;
import malik.emulator.microedition.io.ConnectionClosedException;
import malik.emulator.microedition.system.protocol.InboundConnection;
import malik.emulator.microedition.system.protocol.InboundConnections;
import malik.emulator.microedition.system.protocol.sms.BinaryShortMessage;
import malik.emulator.microedition.system.protocol.sms.ClientMessageConnection;
import malik.emulator.microedition.system.protocol.sms.TextShortMessage;
import malik.emulator.util.ObjectQueue;

public class ServerMessageConnection
extends ClientMessageConnection
implements InboundConnection {
    private final int localPort;
    private MessageListener listener;
    private final ObjectQueue inboundMessages;

    public ServerMessageConnection(String localAddress, int localPort) {
        super(localAddress);
        this.localPort = localPort;
        this.inboundMessages = new ObjectQueue();
        InboundConnections.instance.registerInboundConnection(1, localPort, this);
    }

    public void setMessageListener(MessageListener listener) throws IOException {
        if (this.isConnectionClosed()) {
            throw new ConnectionClosedException("MessageConnection.setMessageListener: \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u043e.");
        }
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receive() throws IOException {
        ObjectQueue queue;
        if (this.isConnectionClosed()) {
            throw new ConnectionClosedException("MessageConnection.receive: \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u043e.");
        }
        boolean error = false;
        ObjectQueue objectQueue = queue = this.inboundMessages;
        synchronized (queue) {
            Message result;
            while (true) {
                if (!queue.isEmpty()) {
                    result = (Message)queue.peekHeadObject();
                    queue.removeHeadElement();
                    break;
                }
                if (this.isConnectionClosed()) {
                    error = true;
                    result = null;
                    break;
                }
                try {
                    queue.wait();
                }
                catch (InterruptedException e) {
                    e.printRealStackTrace();
                }
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (error) {
                throw new InterruptedIOException("MessageConnection.receive: \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u043e.");
            }
            return result;
        }
    }

    public Message newMessage(String type) {
        if ("binary".equals(type)) {
            return new BinaryShortMessage(this, false, super.getURL(), null, Long.MIN_VALUE, null);
        }
        if ("text".equals(type)) {
            return new TextShortMessage(this, false, super.getURL(), null, Long.MIN_VALUE, null);
        }
        throw new IllegalArgumentException("MessageConnection.newMessage: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 type \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
    }

    public Message newMessage(String type, String address) {
        if ("binary".equals(type)) {
            return new BinaryShortMessage(this, false, super.getURL(), address, Long.MIN_VALUE, null);
        }
        if ("text".equals(type)) {
            return new TextShortMessage(this, false, super.getURL(), address, Long.MIN_VALUE, null);
        }
        throw new IllegalArgumentException("MessageConnection.newMessage: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 type \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void receiveData(Object data) {
        ObjectQueue queue;
        if (!(data instanceof Message)) return;
        ObjectQueue objectQueue = queue = this.inboundMessages;
        synchronized (queue) {
            queue.addTailElement(data);
            queue.notifyAll();
            // ** MonitorExit[var4_3] (shouldn't be in output)
            MessageListener listener = this.listener;
            if (listener == null) return;
            listener.notifyIncomingMessage((MessageConnection)this);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeConnection() throws IOException {
        ObjectQueue monitor;
        ObjectQueue objectQueue = monitor = this.inboundMessages;
        synchronized (monitor) {
            monitor.notifyAll();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.listener = null;
            InboundConnections.instance.unregisterInboundConnection(1, this.localPort);
            return;
        }
    }
}

