/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.compression.zlib;

import malik.emulator.compression.zlib.Adler32;
import malik.emulator.compression.zlib.Checksum32;
import malik.emulator.compression.zlib.Deflate;
import malik.emulator.compression.zlib.Inflate;
import malik.emulator.compression.zlib.Zlib;

public class ZStream
extends Zlib {
    int dataType;
    int nextInIndex;
    int availIn;
    int nextOutIndex;
    int availOut;
    long totalIn;
    long totalOut;
    byte[] nextIn;
    byte[] nextOut;
    Deflate dstate;
    Inflate istate;
    Checksum32 adler = new Adler32();
    String message;

    public void free() {
        this.nextIn = null;
        this.nextOut = null;
        this.message = null;
    }

    public void setAvailableIn(int availableIn) {
        this.availIn = availableIn;
    }

    public void setAvailableOut(int availableOut) {
        this.availOut = availableOut;
    }

    public void setNextIn(byte[] nextIn) {
        this.nextIn = nextIn;
    }

    public void setNextInIndex(int nextInIndex) {
        this.nextInIndex = nextInIndex;
    }

    public void setNextOut(byte[] nextOut) {
        this.nextOut = nextOut;
    }

    public void setNextOutIndex(int nextOutIndex) {
        this.nextOutIndex = nextOutIndex;
    }

    public void setInput(byte[] src) {
        this.setInput(src, 0, src == null ? 0 : src.length, false);
    }

    public void setInput(byte[] src, boolean append) {
        this.setInput(src, 0, src == null ? 0 : src.length, append);
    }

    public void setInput(byte[] src, int offset, int count, boolean append) {
        if (count <= 0 && append && this.nextIn != null) {
            return;
        }
        if (this.availIn > 0 && append) {
            byte[] tmp = new byte[this.availIn + count];
            Array.copy((byte[])this.nextIn, (int)this.nextInIndex, (byte[])tmp, (int)0, (int)this.availIn);
            Array.copy((byte[])src, (int)offset, (byte[])tmp, (int)this.availIn, (int)count);
            this.nextIn = tmp;
            this.nextInIndex = 0;
            this.availIn += count;
        } else {
            this.nextIn = src;
            this.nextInIndex = offset;
            this.availIn = count;
        }
    }

    public void setOutput(byte[] dst) {
        this.setOutput(dst, 0, dst == null ? 0 : dst.length);
    }

    public void setOutput(byte[] dst, int offset, int length) {
        this.nextOut = dst;
        this.nextOutIndex = offset;
        this.availOut = length;
    }

    public boolean inflateFinished() {
        return this.istate != null && this.istate.mode == 12;
    }

    public int inflateInit() {
        return this.inflateInit(15, false);
    }

    public int inflateInit(boolean nowrap) {
        return this.inflateInit(15, nowrap);
    }

    public int inflateInit(int wbits) {
        return this.inflateInit(wbits, false);
    }

    public int inflateInit(int wbits, boolean nowrap) {
        this.istate = new Inflate(this);
        return this.istate.inflateInit(nowrap ? -wbits : wbits);
    }

    public int inflateSync() {
        return this.istate == null ? -2 : this.istate.inflateSync();
    }

    public int inflateSyncPoint() {
        return this.istate == null ? -2 : this.istate.inflateSyncPoint();
    }

    public int inflateSetDictionary(byte[] dictionary, int dictLength) {
        return this.istate == null ? -2 : this.istate.inflateSetDictionary(dictionary, dictLength);
    }

    public int inflate(int flush) {
        return this.istate == null ? -2 : this.istate.inflate(flush);
    }

    public int inflateEnd() {
        if (this.istate == null) {
            return -2;
        }
        int result = this.istate.inflateEnd();
        this.istate = null;
        return result;
    }

    public int deflateInit(int level) {
        return this.deflateInit(level, 15, false);
    }

    public int deflateInit(int level, boolean nowrap) {
        return this.deflateInit(level, 15, nowrap);
    }

    public int deflateInit(int level, int bits) {
        return this.deflateInit(level, bits, false);
    }

    public int deflateInit(int level, int bits, boolean nowrap) {
        this.dstate = new Deflate(this);
        return this.dstate.deflateInit(level, nowrap ? -bits : bits);
    }

    public int deflateInit(int level, int bits, int memlevel) {
        this.dstate = new Deflate(this);
        return this.dstate.deflateInit(level, bits, memlevel);
    }

    public int deflateParams(int level, int strategy) {
        return this.dstate == null ? -2 : this.dstate.deflateParams(level, strategy);
    }

    public int deflateSetDictionary(byte[] dictionary, int dictLength) {
        return this.dstate == null ? -2 : this.dstate.deflateSetDictionary(dictionary, dictLength);
    }

    public int deflate(int flush) {
        return this.dstate == null ? -2 : this.dstate.deflate(flush);
    }

    public int deflateEnd() {
        if (this.dstate == null) {
            return -2;
        }
        int result = this.dstate.deflateEnd();
        this.dstate = null;
        return result;
    }

    public int getAdler() {
        return this.adler.value();
    }

    public int getAvailableIn() {
        return this.availIn;
    }

    public int getAvailableOut() {
        return this.availOut;
    }

    public int getNextInIndex() {
        return this.nextInIndex;
    }

    public int getNextOutIndex() {
        return this.nextOutIndex;
    }

    public long getTotalIn() {
        return this.totalIn;
    }

    public long getTotalOut() {
        return this.totalOut;
    }

    public byte[] getNextIn() {
        return this.nextIn;
    }

    public byte[] getNextOut() {
        return this.nextOut;
    }

    public String getMessage() {
        return this.message;
    }

    final void flushPending() {
        int len = this.dstate.pending;
        if (len > this.availOut) {
            len = this.availOut;
        }
        if (len == 0) {
            return;
        }
        Array.copy((byte[])this.dstate.pendingBuf, (int)this.dstate.pendingOut, (byte[])this.nextOut, (int)this.nextOutIndex, (int)len);
        this.nextOutIndex += len;
        this.dstate.pendingOut += len;
        this.totalOut += (long)len;
        this.availOut -= len;
        this.dstate.pending -= len;
        if (this.dstate.pending == 0) {
            this.dstate.pendingOut = 0;
        }
    }

    final int readBuf(byte[] dst, int offset, int count) {
        int length = this.availIn;
        if (length > count) {
            length = count;
        }
        if (length == 0) {
            return 0;
        }
        this.availIn -= length;
        if (this.dstate.wrap != 0) {
            this.adler.update(this.nextIn, this.nextInIndex, length);
        }
        Array.copy((byte[])this.nextIn, (int)this.nextInIndex, (byte[])dst, (int)offset, (int)length);
        this.nextInIndex += length;
        this.totalIn += (long)length;
        return length;
    }
}

