/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.fileformats.graphics.png;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import malik.emulator.compression.zlib.CRC32;
import malik.emulator.compression.zlib.Checksum32;
import malik.emulator.compression.zlib.Zlib;
import malik.emulator.fileformats.EmptyAdapterException;
import malik.emulator.fileformats.ExtendedDataOutputStream;
import malik.emulator.fileformats.InvalidDataFormatException;
import malik.emulator.fileformats.UnsupportedDataException;
import malik.emulator.fileformats.graphics.ImageEncoder;

public final class PNGEncoder
implements ImageEncoder {
    public static final long SIGNATURE = -8552249625308161526L;
    private static final int IHDR = 1229472850;
    private static final int PLTE = 1347179589;
    private static final int TRNS = 1951551059;
    private static final int TEXT = 1950701684;
    private static final int IDAT = 1229209940;
    private static final int IEND = 1229278788;
    private boolean alpha;
    private int level;
    private int width;
    private int height;
    private int[] pixels;

    private static void writeChunk(DataOutputStream stream, ByteArrayOutputStream chunk, Checksum32 checksum) throws IOException {
        byte[] chunkBytes = chunk.toByteArray();
        int chunkBytesLength = chunkBytes.length;
        checksum.reset();
        checksum.update(chunkBytes, 0, chunkBytesLength);
        stream.writeInt(chunkBytesLength - 4);
        ((OutputStream)stream).write(chunkBytes);
        stream.writeInt(checksum.value());
    }

    private static void writeTag(DataOutputStream stream, ByteArrayOutputStream chunkStream, DataOutputStream chunkData, Checksum32 checksum, String tag, String value) throws IOException {
        chunkStream.reset();
        chunkData.writeInt(1950701684);
        ((OutputStream)chunkData).write(tag.getBytes());
        chunkData.write(0);
        ((OutputStream)chunkData).write(value.getBytes());
        PNGEncoder.writeChunk(stream, chunkStream, checksum);
    }

    public PNGEncoder() {
        this.level = 7;
    }

    public PNGEncoder(int compressionLevel) {
        this.level = compressionLevel < 0 ? 0 : (compressionLevel > 9 ? 9 : compressionLevel);
    }

    public void saveToOutputStream(OutputStream stream) throws IOException {
        this.saveToDataStream(new ExtendedDataOutputStream(stream));
    }

    public void saveToDataStream(ExtendedDataOutputStream stream) throws IOException {
        int components;
        int pixelType;
        int bitDepth;
        boolean useAlpha = this.alpha;
        int compressionLevel = this.level;
        int imageWidth = this.width;
        int imageHeight = this.height;
        int[] imagePixels = this.pixels;
        if (imagePixels == null) {
            throw new EmptyAdapterException("PNGEncoder.saveToOutputStream: \u043a\u043e\u0434\u0435\u0440 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0434\u0430\u043d\u043d\u044b\u0435.");
        }
        int imagePixelsLength = imagePixels.length;
        int paletteLength = 0;
        int[] palette = new int[256];
        boolean usePalette = true;
        int i = 0;
        while (i < imagePixelsLength) {
            int pixel;
            int n;
            if (useAlpha) {
                n = imagePixels[i];
            } else {
                int n2 = i;
                n = pixel = (imagePixels[n2] = imagePixels[n2] & 0xFFFFFF);
            }
            if (paletteLength <= 0 || Array.findb((int[])palette, (int)(paletteLength - 1), (int)pixel) < 0) {
                if (paletteLength >= 256) {
                    paletteLength = 0;
                    palette = null;
                    usePalette = false;
                    break;
                }
                palette[paletteLength++] = pixel;
            }
            ++i;
        }
        if (usePalette) {
            bitDepth = paletteLength <= 2 ? 1 : (paletteLength <= 4 ? 2 : (paletteLength <= 16 ? 4 : 8));
            pixelType = 3;
            components = 1;
            if (useAlpha) {
                useAlpha = false;
                i = paletteLength;
                while (i-- > 0) {
                    if (palette[i] >>> 24 >= 255) continue;
                    useAlpha = true;
                    break;
                }
            }
        } else {
            bitDepth = 8;
            if (!useAlpha) {
                pixelType = 2;
                components = 3;
            } else {
                useAlpha = false;
                i = imagePixelsLength;
                while (i-- > 0) {
                    if (imagePixels[i] >>> 24 >= 255) continue;
                    useAlpha = true;
                    break;
                }
                if (useAlpha) {
                    pixelType = 6;
                    components = 4;
                } else {
                    pixelType = 2;
                    components = 3;
                }
            }
        }
        int lineSize = bitDepth < 8 ? imageWidth * bitDepth + 7 >> 3 : imageWidth * components;
        byte[] rawPixels = new byte[imageHeight * (1 + lineSize)];
        int imageOffset = 0;
        int rawOffset = 0;
        int y = 0;
        while (y < imageHeight) {
            rawPixels[rawOffset++] = 1;
            int subOffset = rawOffset;
            int x = 0;
            while (x < imageWidth) {
                int pixel = imagePixels[imageOffset++];
                block0 : switch (pixelType) {
                    default: {
                        break;
                    }
                    case 2: {
                        rawPixels[subOffset++] = (byte)(pixel >> 16);
                        rawPixels[subOffset++] = (byte)(pixel >> 8);
                        rawPixels[subOffset++] = (byte)pixel;
                        break;
                    }
                    case 3: {
                        pixel = Array.findf((int[])palette, (int)0, (int)pixel);
                        switch (bitDepth) {
                            case 1: {
                                int shift = x & 7 ^ 7;
                                rawPixels[subOffset] = (byte)(rawPixels[subOffset] & ~(1 << shift) | pixel << shift);
                                if (shift != 0) break block0;
                                ++subOffset;
                                break;
                            }
                            case 2: {
                                int shift = (x & 3 ^ 3) << 1;
                                rawPixels[subOffset] = (byte)(rawPixels[subOffset] & ~(3 << shift) | pixel << shift);
                                if (shift != 0) break block0;
                                ++subOffset;
                                break;
                            }
                            case 4: {
                                int shift = (x & 1 ^ 1) << 2;
                                rawPixels[subOffset] = (byte)(rawPixels[subOffset] & ~(15 << shift) | pixel << shift);
                                if (shift != 0) break block0;
                                ++subOffset;
                                break;
                            }
                            case 8: {
                                rawPixels[subOffset++] = (byte)pixel;
                            }
                        }
                        break;
                    }
                    case 6: {
                        rawPixels[subOffset++] = (byte)(pixel >> 16);
                        rawPixels[subOffset++] = (byte)(pixel >> 8);
                        rawPixels[subOffset++] = (byte)pixel;
                        rawPixels[subOffset++] = (byte)(pixel >> 24);
                    }
                }
                ++x;
            }
            int lim = rawOffset + components;
            int j = rawOffset += lineSize;
            while (j-- > lim) {
                rawPixels[j] = (byte)(rawPixels[j] - rawPixels[j - components]);
            }
            ++y;
        }
        rawPixels = Zlib.compress(rawPixels, compressionLevel);
        CRC32 checksum = new CRC32();
        ByteArrayOutputStream chunkStream = new ByteArrayOutputStream(16);
        DataOutputStream chunkData = new DataOutputStream(chunkStream);
        stream.writeLong(-8552249625308161526L);
        chunkStream.reset();
        chunkData.writeInt(1229472850);
        chunkData.writeInt(imageWidth);
        chunkData.writeInt(imageHeight);
        chunkData.writeByte(bitDepth);
        chunkData.writeByte(pixelType);
        chunkData.writeByte(0);
        chunkData.writeByte(0);
        chunkData.writeByte(0);
        PNGEncoder.writeChunk((DataOutputStream)stream, chunkStream, checksum);
        if (usePalette) {
            chunkStream.reset();
            chunkData.writeInt(1347179589);
            i = 0;
            while (i < paletteLength) {
                int colour = palette[i];
                chunkData.writeByte(colour >> 16);
                chunkData.writeByte(colour >> 8);
                chunkData.writeByte(colour);
                ++i;
            }
            PNGEncoder.writeChunk((DataOutputStream)stream, chunkStream, checksum);
            if (useAlpha) {
                int len = paletteLength;
                int i2 = paletteLength;
                while (i2-- > 0) {
                    if (palette[i2] >>> 24 >= 255) continue;
                    len = i2 + 1;
                    break;
                }
                chunkStream.reset();
                chunkData.writeInt(1951551059);
                i2 = 0;
                while (i2 < len) {
                    chunkData.writeByte(palette[i2] >> 24);
                    ++i2;
                }
                PNGEncoder.writeChunk((DataOutputStream)stream, chunkStream, checksum);
            }
        }
        PNGEncoder.writeTag((DataOutputStream)stream, chunkStream, chunkData, checksum, "Software", "Malik Emulator https://malik-elaborarer.ru/emulator/");
        int rawLength = rawPixels.length;
        int chunksCount = rawLength + (-rawLength & 0xFFFF) >> 16;
        int lim = (rawLength & 0xFFFF) <= 0 ? chunksCount : chunksCount - 1;
        int i3 = 0;
        while (i3 < chunksCount) {
            chunkStream.reset();
            chunkData.writeInt(1229209940);
            chunkData.write(rawPixels, i3 << 16, i3 < lim ? 65536 : rawLength & 0xFFFF);
            PNGEncoder.writeChunk((DataOutputStream)stream, chunkStream, checksum);
            ++i3;
        }
        chunkStream.reset();
        chunkData.writeInt(1229278788);
        PNGEncoder.writeChunk((DataOutputStream)stream, chunkStream, checksum);
    }

    public void clear() {
        this.alpha = false;
        this.width = 0;
        this.height = 0;
        this.pixels = null;
    }

    public void setPixels(boolean alpha, int width, int height, int[] pixels) throws InvalidDataFormatException, UnsupportedDataException {
        if (pixels == null) {
            throw new NullPointerException("PNGEncoder.setPixels: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 pixels \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (width < 1 || height < 1) {
            throw new InvalidDataFormatException("PNGEncoder.setPixels: \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u043c\u043e\u0433\u0443\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c\u0438.");
        }
        long area = (long)width * (long)height;
        if ((long)pixels.length < area) {
            throw new InvalidDataFormatException("PNGEncoder.setPixels: \u0434\u043b\u0438\u043d\u0430 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u0430 pixels \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 \u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0440\u0430\u0437\u043c\u0435\u0440\u043e\u0432.");
        }
        if (area > 0x100000L) {
            throw new UnsupportedDataException("PNGEncoder.setPixels: \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u0432\u0435\u043b\u0438\u043a\u0438.");
        }
        int[] nArray = pixels;
        int iarea = (int)area;
        pixels = new int[iarea];
        Array.copy((int[])nArray, (int)0, (int[])pixels, (int)0, (int)iarea);
        this.alpha = alpha;
        this.width = width;
        this.height = height;
        this.pixels = pixels;
    }

    public boolean alphaSupported() {
        return true;
    }

    public boolean isEmpty() {
        return this.pixels == null;
    }

    public void setCompressionLevel(int compressionLevel) {
        this.level = compressionLevel < 0 ? 0 : (compressionLevel > 9 ? 9 : compressionLevel);
    }

    public int getCompressionLevel() {
        return this.level;
    }
}

