/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.midp;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Choice;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Input;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.MIDletProxy;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.lcdui.Ticker;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import malik.emulator.application.Run;
import malik.emulator.fileformats.text.mapped.AttributableMappedTextDecoder;
import malik.emulator.io.cloud.FileInputStream;
import malik.emulator.io.j2me.VirtualSystemGUI;
import malik.emulator.media.text.RasterFont;
import malik.emulator.midp.ButtonSet;
import malik.emulator.midp.ConsoleCommand;
import malik.emulator.midp.ConsoleScreen;
import malik.emulator.midp.FormSettings;
import malik.emulator.midp.ImageCommand;
import malik.emulator.midp.KeyCodeSet;
import malik.emulator.midp.LaunchScreen;
import malik.emulator.midp.SoundCommand;
import malik.emulator.midp.SystemConsole;
import malik.emulator.util.ThreadTerminationListener;

public class SystemGUI
implements CommandListener,
ItemCommandListener,
ItemStateListener,
VirtualSystemGUI,
ThreadTerminationListener {
    public static final Command APPLY_SETTINGS_COMMAND = new Command("\u041f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c", 1, Integer.MAX_VALUE);
    public static final Command BACK_TO_SETTINGS_COMMAND = new Command("\u041d\u0430\u0437\u0430\u0434", 2, Integer.MIN_VALUE);
    private static final int NAME = 0;
    private static final int ICON = 1;
    private static final int CLASS = 2;
    private static final int SETTABLE_KEY_CODES = 7;
    private static final int NATIVE_SYSTEM_SETTINGS = 3;
    private static final int[] KEYS;
    private static final int[] DEVICE_KEYS;
    private static final KeyCodeSet[] KEY_CODE_SETS;
    private static final String YES = "\u0414\u0430";
    private static final String NO = "\u041d\u0435\u0442";
    private boolean midletStarted;
    private String[] midletClassNames;
    private Displayable[] screensOfSettings;
    private String midletName;
    private Command commandLaunch;
    private Command commandExit;
    private Command commandSettings;
    private Command commandAboutApplication;
    private Command commandAboutImplementation;
    private Command commandProperties;
    private Command commandDeleteAll;
    private Command commandDelete;
    private Command commandUpdate;
    private Command commandBack;
    private Command commandYes;
    private Command commandNo;
    private Ticker tickerLaunch;
    private Ticker tickerSettings;
    private Gauge itemFrequency;
    private ChoiceGroup itemModelSelect;
    private ChoiceGroup itemSystemSettings;
    private StringItem itemRecordName;
    private StringItem itemRecordSize;
    private StringItem itemRecordNumRecords;
    private StringItem itemRecordLastModified;
    private StringItem itemRecordVersion;
    private ButtonSet itemKeypad;
    private StringItem itemKeyDescription;
    private StringItem itemKeyEquivalent;
    private StringItem itemLibraryList;
    private List screenMIDlets;
    private List screenSettings;
    private Form screenSettingControl;
    private Form screenSettingKeyCodes;
    private Form screenSettingFonts;
    private Form screenSettingFrequency;
    private Form screenSettingSystem;
    private List screenSettingRecords;
    private Form screenSettingKeypad;
    private Form screenRecordProperties;
    private Alert screenRecordDelete;
    private Alert screenRecordDeleteAll;
    private Alert screenRecordDeletionError;
    private Form screenAboutApplication;
    private Form screenAboutImplementation;
    private Form screenError;
    private Alert screenExit;
    private ConsoleScreen screenConsole;

    static {
        int[] nArray = new int[53];
        nArray[1] = 27;
        nArray[2] = 112;
        nArray[3] = 113;
        nArray[4] = 114;
        nArray[5] = 115;
        nArray[6] = 116;
        nArray[7] = 117;
        nArray[8] = 118;
        nArray[9] = 119;
        nArray[10] = 120;
        nArray[11] = 121;
        nArray[12] = 122;
        nArray[13] = 123;
        nArray[14] = 124;
        nArray[15] = 125;
        nArray[16] = 126;
        nArray[17] = 127;
        nArray[18] = 128;
        nArray[19] = 129;
        nArray[20] = 130;
        nArray[21] = 131;
        nArray[22] = 132;
        nArray[23] = 133;
        nArray[24] = 134;
        nArray[25] = 135;
        nArray[26] = 13;
        nArray[27] = 32;
        nArray[28] = 45;
        nArray[29] = 46;
        nArray[30] = 36;
        nArray[31] = 35;
        nArray[32] = 33;
        nArray[33] = 34;
        nArray[34] = 38;
        nArray[35] = 40;
        nArray[36] = 37;
        nArray[37] = 39;
        nArray[38] = 107;
        nArray[39] = 109;
        nArray[40] = 106;
        nArray[41] = 111;
        nArray[42] = 110;
        nArray[43] = 96;
        nArray[44] = 97;
        nArray[45] = 98;
        nArray[46] = 99;
        nArray[47] = 100;
        nArray[48] = 101;
        nArray[49] = 102;
        nArray[50] = 103;
        nArray[51] = 104;
        nArray[52] = 105;
        KEYS = nArray;
        DEVICE_KEYS = new int[]{38, 36, 40, 41, 43, 37, 39, 44, 46, 49, 50, 51, 52, 53, 54, 55, 56, 57, 42, 48, 35};
        KEY_CODE_SETS = new KeyCodeSet[]{new KeyCodeSet("\u0421\u0432\u043e\u0438 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438", 0, 0, 0, 0, 0, 0, 0), new KeyCodeSet("Nokia (\u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e)", -1, -2, -3, -4, -5, -6, -7), new KeyCodeSet("Motorola", -1, -6, -2, -5, -20, -21, -22), new KeyCodeSet("Siemens", -59, -60, -61, -62, -26, -1, -4)};
    }

    public static Image loadImage(String fileName) {
        Image result;
        try {
            FileInputStream stream = new FileInputStream(fileName);
            stream.checkOpenError();
            try {
                result = Image.createImage((InputStream)stream);
            }
            finally {
                stream.close();
            }
        }
        catch (IOException e) {
            e.printRealStackTrace();
            result = null;
        }
        return result;
    }

    public static Image loadMIDletIcon(AttributableMappedTextDecoder descriptor) {
        String iconRes = descriptor.get("MIDlet-Icon");
        if (iconRes == null) {
            return null;
        }
        if (iconRes.length() > 0 && iconRes.charAt(0) == '/') {
            iconRes = iconRes.substring(1);
        }
        return SystemGUI.loadImage("/res/".concat(iconRes));
    }

    private static int toFontSize(int systemGUISize) {
        return systemGUISize == 2 ? 2 : systemGUISize ^ 1;
    }

    private static int indexOfKey(int key) {
        int[] keys = KEYS;
        int i = KEYS.length;
        while (i-- > 1) {
            if (keys[i] != key) continue;
            return i;
        }
        return 0;
    }

    private static int indexOfFont(RasterFont font) {
        int i = RasterFont.getRasterFontsCount();
        while (i-- > 0) {
            if (RasterFont.getRasterFontAtIndex((int)i) != font) continue;
            return i;
        }
        return -1;
    }

    private static String[] fillMIDletList(Choice dst, AttributableMappedTextDecoder descriptor) {
        String[] attr;
        int len = 0;
        Object[] result = new String[1];
        dst.deleteAll();
        int i = 0;
        while ((attr = descriptor.getAttributes("MIDlet-" + (i + 1))) != null && attr.length >= 3) {
            String iconRes = attr[1];
            if (iconRes != null) {
                String midletName;
                String className;
                if (iconRes.length() > 0 && iconRes.charAt(0) == '/') {
                    iconRes = iconRes.substring(1);
                }
                if ((className = attr[2]) != null && (midletName = attr[0]) != null) {
                    if (len == result.length) {
                        Object[] objectArray = result;
                        result = new String[(len << 1) + 1];
                        Array.copy((Object[])objectArray, (int)0, (Object[])result, (int)0, (int)len);
                    }
                    result[len++] = className;
                    dst.append(midletName, SystemGUI.loadImage("/res/".concat(iconRes)));
                }
            }
            ++i;
        }
        if (len != result.length) {
            Object[] objectArray = result;
            result = new String[len];
            Array.copy((Object[])objectArray, (int)0, (Object[])result, (int)0, (int)len);
        }
        return result;
    }

    public SystemGUI() {
        String parameterKey;
        String parameterValue;
        String midletName;
        AttributableMappedTextDecoder descriptor = MIDletProxy.getInstance().getMIDletDescriptor();
        Run.getInstance().setThreadProxy((ThreadTerminationListener)this);
        List scr = this.getScreenMIDlets();
        this.midletClassNames = SystemGUI.fillMIDletList((Choice)scr, descriptor);
        this.midletName = midletName = descriptor.get("MIDlet-Name");
        SystemConsole console = new SystemConsole("\u041a\u043e\u043d\u0441\u043e\u043b\u044c Java 2 ME", this);
        this.screenConsole = console;
        scr.setTitle(midletName);
        this.getScreenExit();
        console.addConsoleCommand(new ImageCommand());
        console.addConsoleCommand(new SoundCommand());
        int i = 1;
        while ((parameterValue = System.getSystemProperty((String)(parameterKey = "malik.emulator.microedition.console.command.".concat(Integer.toString(i))))) != null) {
            try {
                console.addConsoleCommand((ConsoleCommand)Class.forName(parameterValue).newInstance());
            }
            catch (Exception e) {
                e.printRealStackTrace();
            }
            ++i;
        }
    }

    public void commandAction(Command command, Displayable screen) {
        MIDletProxy proxy = MIDletProxy.getInstance();
        Display display = proxy.getEmulatorScreen();
        if (command == APPLY_SETTINGS_COMMAND) {
            List list = this.getScreenSettings();
            this.applySettingsFromScreen(list.getSelectedIndex());
            display.setCurrent((Displayable)list);
            return;
        }
        if (command == BACK_TO_SETTINGS_COMMAND) {
            display.setCurrent((Displayable)this.getScreenSettings());
            return;
        }
        List list = this.screenMIDlets;
        if (screen == list) {
            if (command == this.commandLaunch) {
                this.launchSelectedMIDlet((Choice)list);
                return;
            }
            if (command == this.commandSettings) {
                display.setCurrent((Displayable)this.getScreenSettings());
                return;
            }
            if (command == this.commandAboutApplication) {
                display.setCurrent(this.getScreenAboutApplication());
                return;
            }
            if (command == this.commandAboutImplementation) {
                display.setCurrent(this.getScreenAboutImplementation());
                return;
            }
            if (command == this.commandExit) {
                Run.getInstance().terminate();
            }
            return;
        }
        list = this.screenSettings;
        if (screen == list) {
            if (command == List.SELECT_COMMAND) {
                int sel = list.getSelectedIndex();
                if (sel == list.size() - 1) {
                    Run.getInstance().showMessage("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a\u2026");
                    proxy.saveMIDletProperties();
                    display.setCurrent((Displayable)this.screenMIDlets);
                    return;
                }
                this.updateSettingsScreen(sel);
                display.setCurrent(this.screensOfSettings[sel]);
                return;
            }
            if (command == this.commandBack) {
                display.setCurrent((Displayable)this.screenMIDlets);
            }
            return;
        }
        list = this.screenSettingRecords;
        if (screen == list) {
            if (command == this.commandProperties) {
                this.showSelectedRecordProperties((Choice)list, display);
                return;
            }
            if (command == this.commandDelete) {
                this.showSelectedRecordDeleteDialog((Choice)list, display);
                return;
            }
            if (command == this.commandDeleteAll) {
                display.setCurrent(this.getScreenRecordDeleteAll());
                return;
            }
            if (command == this.commandUpdate) {
                this.updateRecordList();
            }
            return;
        }
        if (screen == this.screenRecordProperties && command == this.commandBack) {
            display.setCurrent((Displayable)this.screenSettingRecords);
            return;
        }
        if (screen == this.screenRecordDelete) {
            if (command == this.commandYes) {
                this.deleteSelectedRecord(display);
                return;
            }
            if (command == this.commandNo) {
                display.setCurrent((Displayable)this.screenSettingRecords);
            }
            return;
        }
        if (screen == this.screenRecordDeleteAll) {
            if (command == this.commandYes) {
                this.deleteAllRecords(display);
                return;
            }
            if (command == this.commandNo) {
                display.setCurrent((Displayable)this.screenSettingRecords);
            }
            return;
        }
        if (screen == this.screenRecordDeletionError && command == Alert.DISMISS_COMMAND) {
            this.updateRecordList();
            display.setCurrent((Displayable)this.screenSettingRecords);
            return;
        }
        if ((screen == this.screenAboutApplication || screen == this.screenAboutImplementation) && command == this.commandBack) {
            display.setCurrent((Displayable)this.screenMIDlets);
            return;
        }
        if (screen == this.screenConsole && command == ConsoleScreen.BACK_COMMAND) {
            display.hideSystemScreen();
            return;
        }
        if (screen == this.screenExit) {
            if (command != null && YES.equals(command.getLabel())) {
                this.stopMIDlet();
                return;
            }
            display.hideSystemScreen();
            return;
        }
        if (screen == this.screenError && command == this.commandExit) {
            Run.getInstance().terminate();
        }
    }

    public void commandAction(Command command, Item item) {
        if (command != List.SELECT_COMMAND) {
            return;
        }
        Displayable[] screens = this.screensOfSettings;
        int i = this.screensOfSettings.length;
        while (i-- > 0) {
            Displayable scr = screens[i];
            if (!(scr instanceof FormSettings)) continue;
            FormSettings form = (FormSettings)scr;
            if (item == form.getApplyButton()) {
                this.commandAction(APPLY_SETTINGS_COMMAND, (Displayable)form);
                break;
            }
            if (item != form.getBackButton()) continue;
            this.commandAction(BACK_TO_SETTINGS_COMMAND, (Displayable)form);
            break;
        }
    }

    public void itemStateChanged(Item item) {
        ChoiceGroup list = this.itemModelSelect;
        if (item == list) {
            Form form = this.screenSettingKeyCodes;
            int[] codes = KEY_CODE_SETS[list.getSelectedIndex()].getKeyCodesAsArray();
            int i = codes.length;
            while (i-- > 0) {
                int code = codes[i];
                if (code == 0) continue;
                ((Input)form.get(i + 1)).setString(Integer.toString(code));
            }
            return;
        }
        ButtonSet keypad = this.itemKeypad;
        if (item == keypad) {
            MIDletProxy proxy = MIDletProxy.getInstance();
            int code = keypad.getPressedButtonID();
            switch (code) {
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.itemKeyDescription.setText(String.valueOf(proxy.getKeyName(proxy.getKeyCodeFor(code))) + "\n\u041a\u043e\u0434 \u043a\u043b\u0430\u0432\u0438\u0448\u0438: " + Integer.toString(proxy.getKeyCodeFor(code)) + "\n\u041d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435: \u043f\u043e\u0441\u044b\u043b\u0430\u0435\u0442 \u0432 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u043a\u043e\u0434 \u043a\u043b\u0430\u0432\u0438\u0448\u0438.");
                    break;
                }
                case 35: {
                    this.itemKeyDescription.setText(String.valueOf(proxy.getKeyName(proxy.getKeyCodeFor(code))) + "\n\u041a\u043e\u0434 \u043a\u043b\u0430\u0432\u0438\u0448\u0438: " + Integer.toString(proxy.getKeyCodeFor(code)) + "\n\u041d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435: \u043f\u043e\u0441\u044b\u043b\u0430\u0435\u0442 \u0432 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u043a\u043e\u0434 \u043a\u043b\u0430\u0432\u0438\u0448\u0438." + "\n\u041f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0435: \u044d\u0442\u0430 \u043a\u043b\u0430\u0432\u0438\u0448\u0430 \u043f\u043e\u0437\u0432\u043e\u043b\u044f\u0435\u0442 \u043f\u043e\u043b\u043d\u043e\u0441\u0442\u044c\u044e \u043f\u0440\u043e\u0441\u043c\u043e\u0442\u0440\u0435\u0442\u044c \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0439 " + "\u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0438\u0441\u043a\u0430. \u0415\u0441\u043b\u0438 \u043d\u0430 \u044d\u043a\u0440\u0430\u043d\u0435 \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0435\u0442\u0441\u044f \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u044b\u0439 \u0441\u043f\u0438\u0441\u043e\u043a " + "\u043a\u0430\u043a\u0438\u0445-\u043d\u0438\u0431\u0443\u0434\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0441\u0440\u0435\u0434\u0438 \u043d\u0438\u0445 \u0435\u0441\u0442\u044c \u0442\u0430\u043a\u0438\u0435, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0437\u0430\u043a\u0430\u043d\u0447\u0438\u0432\u0430\u044e\u0442\u0441\u044f " + "\u043d\u0430 \u043c\u043d\u043e\u0433\u043e\u0442\u043e\u0447\u0438\u0435 (\u2026), \u0432\u044b\u0434\u0435\u043b\u0438\u0442\u0435 \u0442\u0430\u043a\u043e\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0438 \u043d\u0430\u0436\u043c\u0438\u0442\u0435 \u044d\u0442\u0443 \u043a\u043b\u0430\u0432\u0438\u0448\u0443. \u041f\u043e\u043a\u0430 " + "\u0432\u044b \u0435\u0451 \u0443\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0435, \u043d\u0430 \u044d\u043a\u0440\u0430\u043d\u0435 \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0435\u0442\u0441\u044f \u043f\u043e\u043b\u043d\u044b\u0439 \u0442\u0435\u043a\u0441\u0442 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0433\u043e " + "\u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430, \u0431\u0435\u0437 \u043c\u043d\u043e\u0433\u043e\u0442\u043e\u0447\u0438\u044f.");
                    break;
                }
                case 44: {
                    this.itemKeyDescription.setText("\u0412\u044b\u0437\u043e\u0432 \u043a\u043e\u043d\u0441\u043e\u043b\u0438\n\u041d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435: \u0432\u044b\u0437\u043e\u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u043e\u0439 \u043a\u043e\u043d\u0441\u043e\u043b\u0438 (\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u0432\u043e \u0432\u0440\u0435\u043c\u044f \u0440\u0430\u0431\u043e\u0442\u044b \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f).");
                    break;
                }
                case 46: {
                    this.itemKeyDescription.setText("\u0412\u044b\u0445\u043e\u0434 \u0438\u0437 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f\n\u041d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435: \u0432\u044b\u0437\u043e\u0432 \u0434\u0438\u0430\u043b\u043e\u0433\u0430 \u0432\u044b\u0445\u043e\u0434\u0430 \u0438\u0437 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f (\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u0432\u043e \u0432\u0440\u0435\u043c\u044f \u0440\u0430\u0431\u043e\u0442\u044b \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f).");
                    break;
                }
                default: {
                    return;
                }
            }
            this.itemKeyEquivalent.setText(MIDletProxy.getSystemKeyName((int)proxy.getKeyUsedAs(code)));
        }
    }

    public void showStartScreen(Display display) {
        display.setCurrent((Displayable)this.screenMIDlets);
    }

    public void showConsole(Display display) {
        if (display.isClientInForeground()) {
            display.setCurrent((Displayable)this.screenConsole);
        }
    }

    public void showExitScreen(Display display) {
        if (display.isClientInForeground()) {
            display.setCurrent((Displayable)this.screenExit);
        }
    }

    public void onMIDletStarted() {
    }

    public void onMIDletDestroyed() {
        Run.getInstance().terminate();
    }

    public void onAppTerminate() {
    }

    public void threadTerminated(Thread terminatedThread, Throwable exitThrowable) {
        if (exitThrowable == null) {
            return;
        }
        exitThrowable.printRealStackTrace();
        MIDletProxy.getInstance().getEmulatorScreen().setCurrent(this.getScreenError(exitThrowable));
        RecordStore.closeAllRecordStores();
    }

    public void onAboutImplementationScreenShow() {
    }

    public void onSettingsScreenShow() {
    }

    public void onSettingsUpdate(Displayable screen) {
    }

    public void onSettingsApply(Displayable screen) {
    }

    public void onSystemSettingsScreenShow() {
    }

    public void onSystemSettingsUpdate() {
    }

    public void onSystemSettingsApply() {
    }

    public void startMIDlet(Class midletClass) {
        MIDletProxy.getInstance().getEmulatorScreen().setCurrent((Displayable)new LaunchScreen(this, midletClass));
    }

    public void stopMIDlet() {
        MIDletProxy.getInstance().stopMIDlet();
    }

    public void addConsoleCommand(ConsoleCommand command) {
        this.screenConsole.addConsoleCommand(command);
    }

    public void addThirdPartyLibraryInformation(String libraryNameAndJSR) {
        StringItem list = this.itemLibraryList;
        if (list == null) {
            throw new IllegalStateException("SystemGUI.addThirdPartyLibraryInformation: \u044d\u043a\u0440\u0430\u043d \u0441\u0432\u0435\u0434\u0435\u043d\u0438\u0439 \u043e \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u0435\u0449\u0451 \u043d\u0435 \u0441\u043e\u0437\u0434\u0430\u043d.");
        }
        if (libraryNameAndJSR == null) {
            throw new NullPointerException("SystemGUI.addThirdPartyLibraryInformation: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 libraryNameAndJSR \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        list.setText(String.valueOf(list.getText()) + "\n" + libraryNameAndJSR);
    }

    public void addSettingScreen(String label, Image icon, Displayable screen) {
        List settings;
        Object[] screens = this.screensOfSettings;
        if (this.screensOfSettings == null || (settings = this.screenSettings) == null) {
            throw new IllegalStateException("SystemGUI.addSettingScreen: \u044d\u043a\u0440\u0430\u043d \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a \u0435\u0449\u0451 \u043d\u0435 \u0441\u043e\u0437\u0434\u0430\u043d.");
        }
        if (label == null) {
            throw new NullPointerException("SystemGUI.addSettingScreen: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 label \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (screen == null) {
            throw new NullPointerException("SystemGUI.addSettingScreen: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 screen \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int len = settings.size() - 1;
        if (len == screens.length) {
            Object[] objectArray = screens;
            this.screensOfSettings = new Displayable[(len << 1) + 1];
            screens = this.screensOfSettings;
            Array.copyReferences((Object[])objectArray, (int)0, (Object[])this.screensOfSettings, (int)0, (int)len);
        }
        screens[len] = screen;
        settings.insert(len, label, icon);
    }

    public int addSystemSetting(String label, String description, Image icon) {
        ChoiceGroup list = this.itemSystemSettings;
        if (list == null) {
            throw new IllegalStateException("SystemGUI.addSystemSetting: \u044d\u043a\u0440\u0430\u043d \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0435\u0449\u0451 \u043d\u0435 \u0441\u043e\u0437\u0434\u0430\u043d.");
        }
        if (label == null) {
            throw new NullPointerException("SystemGUI.addSystemSetting: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 label \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        String text = description == null ? label : String.valueOf(label) + "\n\n" + description;
        return list.append(text, icon) - 3;
    }

    public final void setSystemSetting(int index, boolean value) {
        ChoiceGroup list = this.itemSystemSettings;
        if (list == null) {
            throw new IllegalStateException("SystemGUI.setSystemSetting: \u044d\u043a\u0440\u0430\u043d \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0435\u0449\u0451 \u043d\u0435 \u0441\u043e\u0437\u0434\u0430\u043d.");
        }
        if ((index += 3) < 3 || index >= list.size()) {
            throw new IndexOutOfBoundsException("SystemGUI.setSystemSetting: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 index \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        list.setSelectedIndex(index, value);
    }

    public final boolean getSystemSetting(int index) {
        ChoiceGroup list = this.itemSystemSettings;
        if (list == null) {
            throw new IllegalStateException("SystemGUI.getSystemSetting: \u044d\u043a\u0440\u0430\u043d \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0435\u0449\u0451 \u043d\u0435 \u0441\u043e\u0437\u0434\u0430\u043d.");
        }
        if ((index += 3) < 3 || index >= list.size()) {
            throw new IndexOutOfBoundsException("SystemGUI.getSystemSetting: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 index \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return list.isSelected(index);
    }

    public final String getMIDletName() {
        return this.midletName;
    }

    protected void prepareForStartMIDlet() {
        this.midletClassNames = null;
        this.screensOfSettings = null;
        this.midletName = null;
        this.commandLaunch = null;
        this.commandExit = null;
        this.commandSettings = null;
        this.commandAboutApplication = null;
        this.commandAboutImplementation = null;
        this.commandProperties = null;
        this.commandDeleteAll = null;
        this.commandDelete = null;
        this.commandUpdate = null;
        this.commandBack = null;
        this.commandYes = null;
        this.commandNo = null;
        this.tickerLaunch = null;
        this.tickerSettings = null;
        this.itemFrequency = null;
        this.itemModelSelect = null;
        this.itemSystemSettings = null;
        this.itemRecordName = null;
        this.itemRecordSize = null;
        this.itemRecordNumRecords = null;
        this.itemRecordLastModified = null;
        this.itemRecordVersion = null;
        this.itemKeypad = null;
        this.itemKeyDescription = null;
        this.itemKeyEquivalent = null;
        this.itemLibraryList = null;
        this.screenMIDlets = null;
        this.screenSettings = null;
        this.screenSettingControl = null;
        this.screenSettingKeyCodes = null;
        this.screenSettingFonts = null;
        this.screenSettingFrequency = null;
        this.screenSettingSystem = null;
        this.screenSettingRecords = null;
        this.screenSettingKeypad = null;
        this.screenRecordProperties = null;
        this.screenRecordDelete = null;
        this.screenRecordDeleteAll = null;
        this.screenRecordDeletionError = null;
        this.screenAboutApplication = null;
        this.screenAboutImplementation = null;
    }

    private void launchSelectedMIDlet(Choice midletList) {
        if (this.midletStarted) {
            return;
        }
        this.midletStarted = true;
        try {
            this.startMIDlet(Class.forName(this.midletClassNames[midletList.getSelectedIndex()]));
        }
        catch (Throwable cause) {
            cause.printRealStackTrace();
            MIDletProxy.getInstance().getEmulatorScreen().setCurrent(this.getScreenError(cause));
        }
    }

    private void showSelectedRecordProperties(Choice recordList, Display display) {
        Calendar lastModified = Calendar.getInstance();
        Displayable screen = this.getScreenRecordProperties();
        try {
            RecordStore record = RecordStore.openRecordStore((String)recordList.getString(recordList.getSelectedIndex()), (boolean)false);
            try {
                lastModified.setTime(new Date(record.getLastModified()));
                this.itemRecordName.setText(record.getName());
                this.itemRecordSize.setText(Integer.toString(record.getSize()).concat(" \u0431\u0430\u0439\u0442"));
                this.itemRecordNumRecords.setText(Integer.toString(record.getNumRecords()));
                this.itemRecordLastModified.setText(((Object)lastModified).toString());
                this.itemRecordVersion.setText(Integer.toString(record.getVersion()));
            }
            finally {
                record.closeRecordStore();
            }
        }
        catch (RecordStoreException e) {
            e.printRealStackTrace();
            this.itemRecordName.setText("(\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043f\u0440\u0438 \u0441\u0447\u0438\u0442\u044b\u0432\u0430\u043d\u0438\u0438 \u0441\u0432\u043e\u0439\u0441\u0442\u0432 \u0437\u0430\u043f\u0438\u0441\u0438.)");
            this.itemRecordSize.setText(null);
            this.itemRecordNumRecords.setText(null);
            this.itemRecordLastModified.setText(null);
            this.itemRecordVersion.setText(null);
        }
        display.setCurrent(screen);
    }

    private void showSelectedRecordDeleteDialog(Choice recordList, Display display) {
        Displayable screen = this.getScreenRecordDelete();
        this.screenRecordDelete.setString("\u041e\u0441\u0442\u043e\u0440\u043e\u0436\u043d\u043e: \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043e\u0434\u043d\u043e\u0439 \u0437\u0430\u043f\u0438\u0441\u0438 \u043c\u043e\u0436\u0435\u0442 \u043f\u0440\u0438\u0432\u0435\u0441\u0442\u0438 \u043a \u043e\u0448\u0438\u0431\u043a\u0430\u043c \u0432 \u0440\u0430\u0431\u043e\u0442\u0435 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f. \u0423\u0434\u0430\u043b\u044f\u0439\u0442\u0435 \u0437\u0430\u043f\u0438\u0441\u0438 \u0442\u043e\u043b\u044c\u043a\u043e \u0435\u0441\u043b\u0438 \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0432\u0441\u0451 \u0434\u0435\u043b\u0430\u0435\u0442\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e. \u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0437\u0430\u043f\u0438\u0441\u044c " + recordList.getString(recordList.getSelectedIndex()) + "?");
        display.setCurrent(screen);
    }

    private void deleteSelectedRecord(Display display) {
        try {
            List list = this.screenSettingRecords;
            RecordStore.deleteRecordStore((String)list.getString(list.getSelectedIndex()));
            this.updateRecordList();
            display.setCurrent((Displayable)list);
        }
        catch (RecordStoreException e) {
            e.printRealStackTrace();
            display.setCurrent(this.getScreenRecordDeletionError());
        }
    }

    private void deleteAllRecords(Display display) {
        try {
            String[] list = RecordStore.listRecordStores();
            int i = list == null ? 0 : list.length;
            while (i-- > 0) {
                RecordStore.deleteRecordStore((String)list[i]);
            }
            this.updateRecordList();
            display.setCurrent((Displayable)this.screenSettingRecords);
        }
        catch (RecordStoreException e) {
            e.printRealStackTrace();
            display.setCurrent(this.getScreenRecordDeletionError());
        }
    }

    private void createSettingsScreens() {
        this.screensOfSettings = new Displayable[]{this.getScreenSettingControl(), this.getScreenSettingKeyCodes(), this.getScreenSettingFonts(), this.getScreenSettingFrequency(), this.getScreenSettingSystem(), this.getScreenSettingRecords(), this.getScreenSettingKeypad()};
    }

    private void applySettingsFromScreen(int screenIndex) {
        MIDletProxy proxy = MIDletProxy.getInstance();
        switch (screenIndex) {
            default: {
                this.onSettingsApply(this.screensOfSettings[screenIndex]);
            }
            case 5: 
            case 6: {
                return;
            }
            case 0: {
                int[] keys = KEYS;
                int[] deviceKeys = DEVICE_KEYS;
                Form form = this.screenSettingControl;
                int i = deviceKeys.length;
                while (i-- > 0) {
                    int key = keys[((Choice)form.get(i)).getSelectedIndex()];
                    if (key == 0) continue;
                    proxy.setKeyUsedAs(deviceKeys[i], key);
                }
                return;
            }
            case 1: {
                int[] deviceKeys = DEVICE_KEYS;
                Form form = this.screenSettingKeyCodes;
                int i = 7;
                while (i-- > 0) {
                    int keyCode;
                    String representation = ((Input)form.get(i + 1)).getString();
                    if (representation == null || representation.length() <= 0 || (keyCode = Integer.parseInt(representation)) == 0) continue;
                    proxy.setKeyCodeFor(deviceKeys[i], keyCode);
                }
                return;
            }
            case 2: {
                Form form = this.screenSettingFonts;
                int i = form.size();
                while (i-- > 0) {
                    proxy.setFont(SystemGUI.toFontSize(i >> 2), i & 3, RasterFont.getRasterFontAtIndex((int)((Choice)form.get(i)).getSelectedIndex()));
                }
                return;
            }
            case 3: {
                proxy.setMaximumFrequency(Math.max(this.itemFrequency.getValue(), 1));
                return;
            }
            case 4: 
        }
        ChoiceGroup list = this.itemSystemSettings;
        proxy.setEnableStackTrace(list.isSelected(0));
        proxy.setKeyRepeatedEvent(list.isSelected(1));
        proxy.setSerializeRepaint(list.isSelected(2));
        this.onSystemSettingsApply();
    }

    private void updateSettingsScreen(int screenIndex) {
        MIDletProxy proxy = MIDletProxy.getInstance();
        switch (screenIndex) {
            default: {
                this.onSettingsUpdate(this.screensOfSettings[screenIndex]);
            }
            case 6: {
                return;
            }
            case 0: {
                int[] deviceKeys = DEVICE_KEYS;
                Form form = this.screenSettingControl;
                int i = deviceKeys.length;
                while (i-- > 0) {
                    ((Choice)form.get(i)).setSelectedIndex(SystemGUI.indexOfKey(proxy.getKeyUsedAs(deviceKeys[i])), true);
                }
                return;
            }
            case 1: {
                int[] deviceKeys = DEVICE_KEYS;
                Form form = this.screenSettingKeyCodes;
                this.itemModelSelect.setSelectedIndex(0, true);
                int i = 7;
                while (i-- > 0) {
                    ((Input)form.get(i + 1)).setString(Integer.toString(proxy.getKeyCodeFor(deviceKeys[i])));
                }
                return;
            }
            case 2: {
                Form form = this.screenSettingFonts;
                int i = form.size();
                while (i-- > 0) {
                    ((Choice)form.get(i)).setSelectedIndex(SystemGUI.indexOfFont(proxy.getFont(SystemGUI.toFontSize(i >> 2), i & 3)), true);
                }
                return;
            }
            case 3: {
                this.itemFrequency.setValue(proxy.getMaximumFrequency());
            }
            case 4: {
                ChoiceGroup list = this.itemSystemSettings;
                list.setSelectedIndex(0, proxy.isEnableStackTrace());
                list.setSelectedIndex(1, proxy.isKeyRepeatedEvent());
                list.setSelectedIndex(2, proxy.isSerializeRepaint());
                this.onSystemSettingsUpdate();
                return;
            }
            case 5: 
        }
        this.updateRecordList();
    }

    private void updateRecordList() {
        List list = this.screenSettingRecords;
        String[] records = RecordStore.listRecordStores();
        int len = records == null ? 0 : records.length;
        int sel = list.getSelectedIndex();
        list.deleteAll();
        Command cmd1 = this.getCommandDelete();
        list.removeCommand(cmd1);
        Command cmd2 = this.getCommandDeleteAll();
        list.removeCommand(cmd2);
        int i = 0;
        while (i < len) {
            String rec = records[i];
            list.append(rec == null ? "" : rec, null);
            if (i == 0) {
                list.addCommand(cmd1);
                list.addCommand(cmd2);
            }
            ++i;
        }
        if (sel >= 0 && --len >= 0) {
            list.setSelectedIndex(Math.min(sel, len), true);
        }
    }

    private Command getCommandLaunch() {
        Command result = this.commandLaunch;
        if (result == null) {
            result = this.commandLaunch = new Command("\u0417\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c", 4, 0);
        }
        return result;
    }

    private Command getCommandExit() {
        Command result = this.commandExit;
        if (result == null) {
            result = this.commandExit = new Command("\u0412\u044b\u0445\u043e\u0434", 7, 0);
        }
        return result;
    }

    private Command getCommandSettings() {
        Command result = this.commandSettings;
        if (result == null) {
            result = this.commandSettings = new Command("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438", 1, 0);
        }
        return result;
    }

    private Command getCommandAboutApplication() {
        Command result = this.commandAboutApplication;
        if (result == null) {
            result = this.commandAboutApplication = new Command("\u041e \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0438", 1, 0);
        }
        return result;
    }

    private Command getCommandAboutImplementation() {
        Command result = this.commandAboutImplementation;
        if (result == null) {
            result = this.commandAboutImplementation = new Command("\u041e\u0431 \u044d\u0442\u043e\u0439 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 J2ME", 1, 0);
        }
        return result;
    }

    private Command getCommandBack() {
        Command result = this.commandBack;
        if (result == null) {
            result = this.commandBack = new Command("\u041d\u0430\u0437\u0430\u0434", 2, 0);
        }
        return result;
    }

    private Command getCommandYes() {
        Command result = this.commandYes;
        if (result == null) {
            result = this.commandYes = new Command(YES, 4, 0);
        }
        return result;
    }

    private Command getCommandNo() {
        Command result = this.commandNo;
        if (result == null) {
            result = this.commandNo = new Command(NO, 2, 0);
        }
        return result;
    }

    private Command getCommandProperties() {
        Command result = this.commandProperties;
        if (result == null) {
            result = this.commandProperties = new Command("\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430", 4, 0);
        }
        return result;
    }

    private Command getCommandDeleteAll() {
        Command result = this.commandDeleteAll;
        if (result == null) {
            result = this.commandDeleteAll = new Command("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u0441\u0435", 1, 0);
        }
        return result;
    }

    private Command getCommandDelete() {
        Command result = this.commandDelete;
        if (result == null) {
            result = this.commandDelete = new Command("\u0423\u0434\u0430\u043b\u0438\u0442\u044c", 1, 0);
        }
        return result;
    }

    private Command getCommandUpdate() {
        Command result = this.commandUpdate;
        if (result == null) {
            result = this.commandUpdate = new Command("\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c", 1, 0);
        }
        return result;
    }

    private Ticker getTickerLaunch() {
        Ticker result = this.tickerLaunch;
        if (result == null) {
            result = this.tickerLaunch = new Ticker("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u0438 \u043d\u0430\u0436\u043c\u0438\u0442\u0435 \u043a\u043d\u043e\u043f\u043a\u0443 \u00ab\u0417\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c\u00bb. \u0415\u0441\u043b\u0438 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u0437\u0430\u043f\u0443\u0449\u0435\u043d\u043e \u0432\u043f\u0435\u0440\u0432\u044b\u0435 (\u043f\u043e\u0441\u043b\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438), \u043d\u0430\u0436\u043c\u0438\u0442\u0435 \u043a\u043d\u043e\u043f\u043a\u0443 \u00ab\u041c\u0435\u043d\u044e\u00bb \u0438 \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0443\u043d\u043a\u0442 \u00ab\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438\u00bb.");
        }
        return result;
    }

    private Ticker getTickerSettings() {
        Ticker result = this.tickerSettings;
        if (result == null) {
            result = this.tickerSettings = new Ticker("\u042d\u0442\u043e \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f. \u0412\u0410\u0416\u041d\u041e: \u043d\u0435 \u0437\u0430\u0431\u0443\u0434\u044c\u0442\u0435 \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438. \u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0448\u0440\u0438\u0444\u0442\u043e\u0432 \u043f\u0440\u0438\u043c\u0435\u043d\u044f\u044e\u0442\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u0441\u043b\u0435 \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u043a\u0430 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b.");
        }
        return result;
    }

    private List getScreenMIDlets() {
        List result = this.screenMIDlets;
        if (result == null) {
            Command[] commands = new Command[]{this.getCommandExit(), this.getCommandSettings(), this.getCommandAboutApplication(), this.getCommandAboutImplementation()};
            result = this.screenMIDlets = new List(false, null, this.getTickerLaunch(), commands, this.getCommandLaunch(), (CommandListener)this, 3, new String[0], null, "(\u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0439 \u043d\u0435\u0442)");
        }
        return result;
    }

    private List getScreenSettings() {
        List result = this.screenSettings;
        if (result == null) {
            Run.getInstance().showMessage("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a\u2026");
            String[] elements = new String[]{"\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435", "\u041a\u043e\u0434\u044b \u043a\u043b\u0430\u0432\u0438\u0448", "\u0428\u0440\u0438\u0444\u0442\u044b", "\u0427\u0430\u0441\u0442\u043e\u0442\u0430 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u044d\u043a\u0440\u0430\u043d\u0430", "\u0421\u0438\u0441\u0442\u0435\u043c\u0430", "\u0417\u0430\u043f\u0438\u0441\u0438", "\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u043a\u043b\u0430\u0432\u0438\u0430\u0442\u0443\u0440\u0443", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438"};
            Command[] commands = new Command[]{this.getCommandBack()};
            result = this.screenSettings = new List(false, "\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438", this.getTickerSettings(), commands, List.SELECT_COMMAND, (CommandListener)this, 3, elements, null);
            this.createSettingsScreens();
            this.onSettingsScreenShow();
        }
        return result;
    }

    private Displayable getScreenSettingControl() {
        Form result = this.screenSettingControl;
        if (result == null) {
            int[] k = KEYS;
            int i = KEYS.length;
            String[] stringArray = new String[i];
            String[] elements = stringArray;
            stringArray[0] = "\u0421\u0432\u043e\u0438 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438";
            while (i-- > 1) {
                elements[i] = MIDletProxy.getSystemKeyName((int)k[i]);
            }
            k = DEVICE_KEYS;
            int len = DEVICE_KEYS.length;
            Item[] items = new Item[len];
            MIDletProxy proxy = MIDletProxy.getInstance();
            i = len;
            while (i-- > 0) {
                String keyName;
                int key = k[i];
                switch (key) {
                    case 44: {
                        keyName = "\u0412\u044b\u0437\u043e\u0432 \u043a\u043e\u043d\u0441\u043e\u043b\u0438";
                        break;
                    }
                    case 46: {
                        keyName = "\u0412\u044b\u0445\u043e\u0434 \u0438\u0437 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f";
                        break;
                    }
                    default: {
                        keyName = proxy.getKeyName(proxy.getKeyCodeFor(key));
                    }
                }
                items[i] = new ChoiceGroup(256, keyName, null, null, 4, elements, null);
            }
            Command[] commands = new Command[]{BACK_TO_SETTINGS_COMMAND, APPLY_SETTINGS_COMMAND};
            result = this.screenSettingControl = new FormSettings("\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435", null, commands, this, "\u0417\u0434\u0435\u0441\u044c \u043c\u043e\u0436\u043d\u043e \u0437\u0430\u0434\u0430\u0442\u044c \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0435 \u043c\u0435\u0436\u0434\u0443 \u043a\u043b\u0430\u0432\u0438\u0448\u0430\u043c\u0438 \u0432\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 \u0438 \u043a\u043b\u0430\u0432\u0438\u0448\u0430\u043c\u0438 \u043a\u043e\u043c\u043f\u044c\u044e\u0442\u0435\u0440\u0430.\n\u0412\u0410\u0416\u041d\u041e: \u0441\u043b\u0435\u0434\u0438\u0442\u0435, \u0447\u0442\u043e\u0431\u044b \u0432 \u0440\u0430\u0437\u043d\u044b\u0445 \u043f\u043e\u043b\u044f\u0445 \u0431\u044b\u043b\u0438 \u0440\u0430\u0437\u043d\u044b\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u044f \u043a\u043b\u0430\u0432\u0438\u0448 \u043a\u043e\u043c\u043f\u044c\u044e\u0442\u0435\u0440\u0430, \u0442\u0430\u043a \u043a\u0430\u043a \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430 \u044d\u0442\u043e\u0433\u043e \u043d\u0435 \u043f\u0440\u043e\u0432\u0435\u0440\u044f\u0435\u0442.\n\u0420\u0430\u0441\u0448\u0438\u0444\u0440\u043e\u0432\u043a\u0430 \u043d\u0435\u043f\u043e\u043d\u044f\u0442\u043d\u044b\u0445 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0439 \u043a\u043b\u0430\u0432\u0438\u0448 \u043a\u043e\u043c\u043f\u044c\u044e\u0442\u0435\u0440\u0430:\n  SPACE \u2013 \u043f\u0440\u043e\u0431\u0435\u043b\n  UP \u2013 \u2191\n  DOWN \u2013 \u2193\n  LEFT \u2013 \u2190\n  RIGHT \u2013 \u2192\n  NUM_PLUS \u2013 Num +\n  NUM_MINUS \u2013 Num -\n  NUM_STAR \u2013 Num *\n  NUM_DIVIDE \u2013 Num /\n  NUM_DECIMAL \u2013 Num .\n\u041e\u043f\u0446\u0438\u044f \u00ab\u0421\u0432\u043e\u0438 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438\u00bb \u043d\u0435 \u0438\u0437\u043c\u0435\u043d\u044f\u0435\u0442 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0443\u044e \u043a\u043b\u0430\u0432\u0438\u0448\u0443 \u043f\u0440\u0438 \u043d\u0430\u0436\u0430\u0442\u0438\u0438 \u043a\u043d\u043e\u043f\u043a\u0438 \u00ab\u041f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c\u00bb, \u043e\u0441\u0442\u0430\u0432\u043b\u044f\u044f \u0442\u0443 \u043a\u043b\u0430\u0432\u0438\u0448\u0443, \u043a\u043e\u0442\u043e\u0440\u0430\u044f \u0431\u044b\u043b\u0430 \u0437\u0430\u0434\u0430\u043d\u0430 \u0440\u0430\u043d\u043d\u0435\u0435. \u042d\u0442\u0430 \u043e\u043f\u0446\u0438\u044f \u0431\u044b\u043b\u0430 \u0441\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d\u0430 \u043d\u0430 \u0441\u043b\u0443\u0447\u0430\u0439, \u043a\u043e\u0433\u0434\u0430 \u0444\u0430\u0439\u043b \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a /midlet.properties \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043b\u0441\u044f \u0432\u0440\u0443\u0447\u043d\u0443\u044e.", items, this, null);
            int w = result.getWidth();
            i = len;
            while (i-- > 0) {
                items[i].setPreferredSize(w, -1);
            }
        }
        return result;
    }

    private Displayable getScreenSettingKeyCodes() {
        Form result = this.screenSettingKeyCodes;
        if (result == null) {
            int[] deviceKeys = DEVICE_KEYS;
            KeyCodeSet[] sets = KEY_CODE_SETS;
            int len = KEY_CODE_SETS.length;
            String[] elements = new String[len];
            int i = len;
            while (i-- > 0) {
                elements[i] = sets[i].getName();
            }
            len = 8;
            Item[] items = new Item[8];
            MIDletProxy proxy = MIDletProxy.getInstance();
            this.itemModelSelect = new ChoiceGroup(256, "\u041f\u0440\u0435\u0434\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438", null, null, 4, elements, null);
            items[0] = this.itemModelSelect;
            i = 7;
            while (i-- > 0) {
                items[i + 1] = new TextField(256, -1, proxy.getKeyName(proxy.getKeyCodeFor(deviceKeys[i])), null, null, null, "", 12, 2);
            }
            Command[] commands = new Command[]{BACK_TO_SETTINGS_COMMAND, APPLY_SETTINGS_COMMAND};
            result = this.screenSettingKeyCodes = new FormSettings("\u041a\u043e\u0434\u044b \u043a\u043b\u0430\u0432\u0438\u0448", null, commands, this, "\u0417\u0434\u0435\u0441\u044c \u043c\u043e\u0436\u043d\u043e \u0437\u0430\u0434\u0430\u0442\u044c \u043a\u043e\u0434\u044b \u0442\u0435\u0445 \u043a\u043b\u0430\u0432\u0438\u0448, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043d\u0435 \u0431\u044b\u043b\u0438 \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u044b \u0441\u043f\u0435\u0446\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0435\u0439 MIDP, \u0432 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0435 \u0447\u0435\u0433\u043e \u043a\u043e\u0434\u044b \u044d\u0442\u0438\u0445 \u043a\u043b\u0430\u0432\u0438\u0448 \u0441\u0442\u0430\u043b\u0438 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u044b\u043c\u0438 \u043e\u0442 \u043a\u043e\u043d\u043a\u0440\u0435\u0442\u043d\u044b\u0445 \u043c\u043e\u0434\u0435\u043b\u0435\u0439 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432. \u041e\u0441\u043e\u0431\u0435\u043d\u043d\u043e \u044d\u0442\u043e \u043a\u0430\u0441\u0430\u0435\u0442\u0441\u044f \u0442\u0435\u0445 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0439, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0440\u0430\u0431\u043e\u0442\u0430\u044e\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u043d\u0430 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430\u0445 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0451\u043d\u043d\u044b\u0445 \u043c\u043e\u0434\u0435\u043b\u0435\u0439. \u0412\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u0437\u0430\u0434\u0430\u0442\u044c \u043e\u0441\u043e\u0431\u044b\u0435 \u0447\u0438\u0441\u043b\u043e\u0432\u044b\u0435 \u043a\u043e\u0434\u044b \u0434\u043b\u044f \u043a\u043b\u0430\u0432\u0438\u0448 \u0438\u043b\u0438 \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u043f\u0440\u0435\u0434\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0435 \u043a\u043e\u0434\u044b \u043a\u043b\u0430\u0432\u0438\u0448 \u0434\u043b\u044f \u043d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u043c\u043e\u0434\u0435\u043b\u0435\u0439 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432.", items, this, this);
            int w = result.getWidth();
            i = len;
            while (i-- > 0) {
                items[i].setPreferredSize(w, -1);
            }
        }
        return result;
    }

    private Displayable getScreenSettingFonts() {
        Form result = this.screenSettingFonts;
        if (result == null) {
            String[] fontTypes = new String[]{"\u041c\u0435\u043b\u043a\u0438\u0439 \u043d\u043e\u0440\u043c\u0430\u043b\u044c\u043d\u044b\u0439", "\u041c\u0435\u043b\u043a\u0438\u0439 \u0436\u0438\u0440\u043d\u044b\u0439", "\u041c\u0435\u043b\u043a\u0438\u0439 \u043a\u0443\u0440\u0441\u0438\u0432", "\u041c\u0435\u043b\u043a\u0438\u0439 \u0436\u0438\u0440\u043d\u044b\u0439 \u043a\u0443\u0440\u0441\u0438\u0432", "\u0421\u0440\u0435\u0434\u043d\u0438\u0439 \u043d\u043e\u0440\u043c\u0430\u043b\u044c\u043d\u044b\u0439", "\u0421\u0440\u0435\u0434\u043d\u0438\u0439 \u0436\u0438\u0440\u043d\u044b\u0439", "\u0421\u0440\u0435\u0434\u043d\u0438\u0439 \u043a\u0443\u0440\u0441\u0438\u0432", "\u0421\u0440\u0435\u0434\u043d\u0438\u0439 \u0436\u0438\u0440\u043d\u044b\u0439 \u043a\u0443\u0440\u0441\u0438\u0432", "\u041a\u0440\u0443\u043f\u043d\u044b\u0439 \u043d\u043e\u0440\u043c\u0430\u043b\u044c\u043d\u044b\u0439", "\u041a\u0440\u0443\u043f\u043d\u044b\u0439 \u0436\u0438\u0440\u043d\u044b\u0439", "\u041a\u0440\u0443\u043f\u043d\u044b\u0439 \u043a\u0443\u0440\u0441\u0438\u0432", "\u041a\u0440\u0443\u043f\u043d\u044b\u0439 \u0436\u0438\u0440\u043d\u044b\u0439 \u043a\u0443\u0440\u0441\u0438\u0432"};
            int rcnt = RasterFont.getRasterFontsCount();
            String[] elements = new String[rcnt];
            int i = rcnt;
            while (i-- > 0) {
                elements[i] = RasterFont.getRasterFontAtIndex((int)i).getName();
            }
            int len = fontTypes.length;
            Item[] items = new Item[len];
            i = len;
            while (i-- > 0) {
                ChoiceGroup list = new ChoiceGroup(256, fontTypes[i], null, null, 4, elements, null);
                items[i] = list;
                int j = rcnt;
                while (j-- > 0) {
                    list.setFont(j, Font.getRasterFont((int)j));
                }
            }
            Command[] commands = new Command[]{BACK_TO_SETTINGS_COMMAND, APPLY_SETTINGS_COMMAND};
            result = this.screenSettingFonts = new FormSettings("\u0428\u0440\u0438\u0444\u0442\u044b", null, commands, this, "\u0417\u0434\u0435\u0441\u044c \u043c\u043e\u0436\u043d\u043e \u0437\u0430\u0434\u0430\u0442\u044c \u0448\u0440\u0438\u0444\u0442\u044b, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u0431\u0443\u0434\u0435\u0442 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0434\u043b\u044f \u0432\u044b\u0432\u043e\u0434\u0430 \u0442\u0435\u043a\u0441\u0442\u0430.\n\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0448\u0440\u0438\u0444\u0442\u043e\u0432 \u0432\u0441\u0442\u0443\u043f\u044f\u0442 \u0432 \u0441\u0438\u043b\u0443 \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u0441\u043b\u0435 \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u043a\u0430 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b.", items, this, null);
            int w = result.getWidth();
            i = len;
            while (i-- > 0) {
                items[i].setPreferredSize(w, -1);
            }
        }
        return result;
    }

    private Displayable getScreenSettingFrequency() {
        Form result = this.screenSettingFrequency;
        if (result == null) {
            Command[] commands = new Command[]{BACK_TO_SETTINGS_COMMAND, APPLY_SETTINGS_COMMAND};
            Item[] itemArray = new Item[1];
            this.itemFrequency = new Gauge(0, -1, -1, "\u041c\u0430\u043a\u0441\u0438\u043c\u0443\u043c \u043a\u0430\u0434\u0440\u043e\u0432 \u0432 \u0441\u0435\u043a\u0443\u043d\u0434\u0443", null, null, (ItemCommandListener)this, true, 100, 25);
            itemArray[0] = this.itemFrequency;
            Item[] items = itemArray;
            result = new FormSettings("\u0427\u0430\u0441\u0442\u043e\u0442\u0430 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u044d\u043a\u0440\u0430\u043d\u0430", null, commands, this, "\u0417\u0434\u0435\u0441\u044c \u043c\u043e\u0436\u043d\u043e \u0437\u0430\u0434\u0430\u0442\u044c \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u0443\u044e \u0447\u0430\u0441\u0442\u043e\u0442\u0443 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u044d\u043a\u0440\u0430\u043d\u0430 (\u043c\u0430\u043a\u0441\u0438\u043c\u0443\u043c \u043a\u0430\u0434\u0440\u043e\u0432 \u0432 \u0441\u0435\u043a\u0443\u043d\u0434\u0443). \u0420\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u2013 25 \u043a\u0430\u0434\u0440\u043e\u0432 \u0432 \u0441\u0435\u043a\u0443\u043d\u0434\u0443. \u0411\u043e\u043b\u044c\u0448\u0438\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f (> 50) \u043c\u043e\u0433\u0443\u0442 \u043f\u0440\u0438\u0432\u0435\u0441\u0442\u0438 \u043a \u00ab\u043f\u043e\u0434\u0432\u0438\u0441\u0430\u043d\u0438\u044e\u00bb \u043d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c.", items, this, this);
        }
        return result;
    }

    private Displayable getScreenSettingSystem() {
        Form result = this.screenSettingSystem;
        if (result == null) {
            String[] elements = new String[]{"\u0422\u0440\u0430\u0441\u0441\u0438\u0440\u043e\u0432\u043a\u0430 \u0441\u0442\u0435\u043a\u0430 \u0432 \u0438\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f\u0445\n\n\u041e\u0442\u043a\u043b\u044e\u0447\u0438\u0442\u0435 \u044d\u0442\u0443 \u043e\u043f\u0446\u0438\u044e, \u0435\u0441\u043b\u0438 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442 \u0441 \u043e\u0448\u0438\u0431\u043a\u0430\u043c\u0438 \u0438 \u0433\u0435\u043d\u0435\u0440\u0438\u0440\u0443\u0435\u0442 \u043c\u043d\u043e\u0433\u043e \u0438\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0439, \u0443\u0432\u0435\u043b\u0438\u0447\u0438\u0432\u0430\u044f \u0440\u0430\u0437\u043c\u0435\u0440 \u0444\u0430\u0439\u043b\u0430 /err.txt. \u0412 \u043f\u0440\u043e\u0442\u0438\u0432\u043d\u043e\u043c \u0441\u043b\u0443\u0447\u0430\u0435 \u044d\u0442\u0443 \u043e\u043f\u0446\u0438\u044e \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u0442\u0441\u044f \u0432\u043a\u043b\u044e\u0447\u0438\u0442\u044c (\u0434\u043b\u044f \u043e\u0442\u0441\u043b\u0435\u0436\u0438\u0432\u0430\u043d\u0438\u044f \u043e\u0448\u0438\u0431\u043e\u043a \u0432 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0435).", "\u0412\u044b\u0437\u043e\u0432 \u043c\u0435\u0442\u043e\u0434\u0430 Canvas.keyRepeated(int)\n\n\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044f \u044d\u0442\u043e\u0433\u043e \u0444\u043b\u0430\u0433\u0430 \u043c\u043e\u0436\u0435\u0442 \u043f\u0440\u0438\u0432\u0435\u0441\u0442\u0438 \u043a \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u043f\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u0432 \u0442\u043e\u0442 \u043c\u043e\u043c\u0435\u043d\u0442, \u043a\u043e\u0433\u0434\u0430 \u0432\u044b \u0443\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0435 \u043d\u0430\u0436\u0430\u0442\u043e\u0439 \u043a\u0430\u043a\u0443\u044e-\u043d\u0438\u0431\u0443\u0434\u044c \u043a\u043b\u0430\u0432\u0438\u0448\u0443. \u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 \u0438\u043b\u0438 \u0441\u043d\u0438\u043c\u0438\u0442\u0435 \u044d\u0442\u043e\u0442 \u0444\u043b\u0430\u0433 \u0432 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0438 \u0441 \u0432\u0430\u0448\u0438\u043c\u0438 \u043f\u0440\u0435\u0434\u043f\u043e\u0447\u0442\u0435\u043d\u0438\u044f\u043c\u0438.", "\u0412\u044b\u0437\u043e\u0432 \u043c\u0435\u0442\u043e\u0434\u0430 Canvas.paint(Graphics) \u0432 \u043f\u043e\u0440\u044f\u0434\u043a\u0435 \u043e\u0431\u0449\u0435\u0439 \u043e\u0447\u0435\u0440\u0435\u0434\u0438 \u0441\u043e\u0431\u044b\u0442\u0438\u0439\n\n\u041f\u043e\u0434\u0430\u0432\u043b\u044f\u044e\u0449\u0435\u0435 \u0431\u043e\u043b\u044c\u0448\u0438\u043d\u0441\u0442\u0432\u043e \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0439 \u0442\u0440\u0435\u0431\u0443\u044e\u0442 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u044d\u0442\u043e\u0433\u043e \u0444\u043b\u0430\u0433\u0430. \u0415\u0441\u043b\u0438, \u043f\u043e \u0432\u0430\u0448\u0435\u043c\u0443 \u043c\u043d\u0435\u043d\u0438\u044e, \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u043d\u0435 \u0440\u0438\u0441\u0443\u0435\u0442 \u043d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043a\u0430\u0434\u0440\u044b \u0430\u043d\u0438\u043c\u0430\u0446\u0438\u0438, \u043f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u0441\u043d\u044f\u0442\u044c \u044d\u0442\u043e\u0442 \u0444\u043b\u0430\u0433. \u0415\u0441\u043b\u0438 \u043f\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u0435 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u043f\u0440\u0438 \u044d\u0442\u043e\u043c \u043d\u0435 \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u0441\u044f \u0438\u043b\u0438 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u0431\u0443\u0434\u0435\u0442 \u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c \u0441 \u043e\u0448\u0438\u0431\u043a\u0430\u043c\u0438, \u0441\u043d\u043e\u0432\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 \u044d\u0442\u043e\u0442 \u0444\u043b\u0430\u0433."};
            Item[] itemArray = new Item[1];
            this.itemSystemSettings = new ChoiceGroup(0, "\u041f\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u0435 \u0441\u0438\u0441\u0442\u0435\u043c\u044b", null, null, 2, elements, null);
            itemArray[0] = this.itemSystemSettings;
            Item[] items = itemArray;
            Command[] commands = new Command[]{BACK_TO_SETTINGS_COMMAND, APPLY_SETTINGS_COMMAND};
            result = this.screenSettingSystem = new FormSettings("\u0421\u0438\u0441\u0442\u0435\u043c\u0430", null, commands, this, "\u0417\u0434\u0435\u0441\u044c \u043c\u043e\u0436\u043d\u043e \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u043f\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u0435 \u0441\u0438\u0441\u0442\u0435\u043c\u044b, \u0443\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u044f \u0438\u043b\u0438 \u0441\u043d\u0438\u043c\u0430\u044f \u0444\u043b\u0430\u0433\u0438. \u0412\u044b\u0434\u0435\u043b\u0438\u0442\u0435 \u043e\u043f\u0446\u0438\u044e, \u0437\u0430\u0442\u0435\u043c \u043d\u0430\u0436\u043c\u0438\u0442\u0435 \u0438 \u0443\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0439\u0442\u0435 \u043a\u043b\u0430\u0432\u0438\u0448\u0443 #, \u0447\u0442\u043e\u0431\u044b \u0443\u0432\u0438\u0434\u0435\u0442\u044c \u043f\u043e\u043b\u043d\u043e\u0435 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u0439 \u043e\u043f\u0446\u0438\u0438.", items, this, null);
            items[0].setPreferredSize(result.getWidth(), -1);
            this.onSystemSettingsScreenShow();
        }
        return result;
    }

    private Displayable getScreenSettingRecords() {
        List result = this.screenSettingRecords;
        if (result == null) {
            Command[] commands = new Command[]{BACK_TO_SETTINGS_COMMAND, this.getCommandUpdate()};
            result = this.screenSettingRecords = new List(false, "\u0417\u0430\u043f\u0438\u0441\u0438", null, commands, this.getCommandProperties(), (CommandListener)this, 3, new String[0], null, "(\u0437\u0430\u043f\u0438\u0441\u0435\u0439 \u043d\u0435\u0442)");
        }
        return result;
    }

    private Displayable getScreenSettingKeypad() {
        Form result = this.screenSettingKeypad;
        if (result == null) {
            ButtonSet keypad;
            Item[] itemArray = new Item[3];
            this.itemKeypad = keypad = new ButtonSet(515, null, SystemGUI.loadImage("/ui/keypad.png"));
            itemArray[0] = keypad;
            this.itemKeyDescription = new StringItem(512, -1, -1, "\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435", null, null, null, "\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043a\u043b\u0430\u0432\u0438\u0448\u0443 \u043d\u0430 \u044d\u0442\u043e\u0439 \u0432\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u043e\u0439 \u043a\u043b\u0430\u0432\u0438\u0430\u0442\u0443\u0440\u0435, \u0447\u0442\u043e\u0431\u044b \u0443\u0432\u0438\u0434\u0435\u0442\u044c \u0435\u0451 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0437\u0434\u0435\u0441\u044c.", null, 0);
            itemArray[1] = this.itemKeyDescription;
            this.itemKeyEquivalent = new StringItem(0, -1, -1, "\u042d\u043a\u0432\u0438\u0432\u0430\u043b\u0435\u043d\u0442\u043d\u0430\u044f \u043a\u043b\u0430\u0432\u0438\u0448\u0430", null, null, null, "(\u043a\u043b\u0430\u0432\u0438\u0448\u0430 \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u0430)", null, 0);
            itemArray[2] = this.itemKeyEquivalent;
            Item[] items = itemArray;
            try {
                FileInputStream stream = new FileInputStream("/ui/keypad.dat");
                stream.checkOpenError();
                try {
                    DataInputStream data = new DataInputStream((InputStream)stream);
                    while (data.available() >= 5) {
                        int devkey = data.readUnsignedByte();
                        int left = data.readUnsignedByte();
                        int top = data.readUnsignedByte();
                        int width = data.readUnsignedByte();
                        int height = data.readUnsignedByte();
                        keypad.addButton(devkey, left, top, width, height);
                    }
                }
                finally {
                    stream.close();
                }
            }
            catch (IOException e) {
                e.printRealStackTrace();
            }
            Command[] commands = new Command[]{BACK_TO_SETTINGS_COMMAND};
            result = this.screenSettingKeypad = new Form("\u0412\u043d\u0435\u0448\u043d\u0438\u0439 \u0432\u0438\u0434 \u043a\u043b\u0430\u0432\u0438\u0430\u0442\u0443\u0440\u044b", null, commands, (CommandListener)this, items, (ItemStateListener)this);
        }
        return result;
    }

    private Displayable getScreenRecordProperties() {
        Form result = this.screenRecordProperties;
        if (result == null) {
            Item[] itemArray = new Item[5];
            this.itemRecordName = new StringItem(512, -1, -1, "\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", null, null, null, null, null, 0);
            itemArray[0] = this.itemRecordName;
            this.itemRecordSize = new StringItem(512, -1, -1, "\u0420\u0430\u0437\u043c\u0435\u0440", null, null, null, null, null, 0);
            itemArray[1] = this.itemRecordSize;
            this.itemRecordNumRecords = new StringItem(512, -1, -1, "\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u043e\u0434\u0437\u0430\u043f\u0438\u0441\u0435\u0439", null, null, null, null, null, 0);
            itemArray[2] = this.itemRecordNumRecords;
            this.itemRecordLastModified = new StringItem(512, -1, -1, "\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435", null, null, null, null, null, 0);
            itemArray[3] = this.itemRecordLastModified;
            this.itemRecordVersion = new StringItem(512, -1, -1, "\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439", null, null, null, null, null, 0);
            itemArray[4] = this.itemRecordVersion;
            Item[] items = itemArray;
            Command[] commands = new Command[]{this.getCommandBack()};
            result = this.screenRecordProperties = new Form("\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430 \u0437\u0430\u043f\u0438\u0441\u0438", null, commands, (CommandListener)this, items, null);
        }
        return result;
    }

    private Displayable getScreenRecordDelete() {
        Alert result = this.screenRecordDelete;
        if (result == null) {
            Command[] commands = new Command[]{this.getCommandNo()};
            result = this.screenRecordDelete = new Alert("\u0423\u0434\u0430\u043b\u0438\u0442\u044c", null, commands, this.getCommandYes(), (CommandListener)this, null, null, AlertType.WARNING, null);
        }
        return result;
    }

    private Displayable getScreenRecordDeleteAll() {
        Alert result = this.screenRecordDeleteAll;
        if (result == null) {
            Command[] commands = new Command[]{this.getCommandNo()};
            result = this.screenRecordDeleteAll = new Alert("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u0441\u0435", null, commands, this.getCommandYes(), (CommandListener)this, "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0432\u0441\u0435\u0445 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 \u043f\u0440\u0438\u0432\u0435\u0434\u0451\u0442 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u043a \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044e, \u0432 \u043a\u043e\u0442\u043e\u0440\u043e\u043c \u043e\u043d\u043e \u043d\u0430\u0445\u043e\u0434\u0438\u043b\u043e\u0441\u044c \u0441\u0440\u0430\u0437\u0443 \u043f\u043e\u0441\u043b\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438. \u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u0441\u0435 \u0437\u0430\u043f\u0438\u0441\u0438?", null, AlertType.CONFIRMATION, null);
        }
        return result;
    }

    private Displayable getScreenRecordDeletionError() {
        Alert result = this.screenRecordDeletionError;
        if (result == null) {
            result = this.screenRecordDeletionError = new Alert("\u041e\u0448\u0438\u0431\u043a\u0430", null, null, Alert.DISMISS_COMMAND, (CommandListener)this, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 \u0437\u0430\u043f\u0438\u0441\u0438.", null, AlertType.ERROR, null);
        }
        return result;
    }

    private Displayable getScreenAboutApplication() {
        Form result = this.screenAboutApplication;
        if (result == null) {
            AttributableMappedTextDecoder descriptor = MIDletProxy.getInstance().getMIDletDescriptor();
            String[] list = this.midletClassNames;
            int len = this.midletClassNames.length - 1;
            StringBuffer classNames = new StringBuffer();
            int i = 0;
            while (i <= len) {
                classNames.append(list[i]);
                if (i < len) {
                    classNames.append('\n');
                }
                ++i;
            }
            Item[] items = new Item[]{new ImageItem(512, null, null, null, null, SystemGUI.loadMIDletIcon(descriptor), null, 0), new StringItem(512, -1, -1, null, null, null, null, String.valueOf(this.midletName) + "\n\u0412\u0435\u0440\u0441\u0438\u044f: " + descriptor.get("MIDlet-Version") + "\n\u041f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a: " + descriptor.get("MIDlet-Vendor") + "\n\u041f\u0440\u043e\u0444\u0438\u043b\u044c: " + descriptor.get("MicroEdition-Profile") + "\n\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f: " + descriptor.get("MicroEdition-Configuration"), Font.getFont((int)0, (int)0, (int)0), 0), new StringItem(0, -1, -1, "\u041a\u043b\u0430\u0441\u0441 \u043c\u0438\u0434\u043b\u0435\u0442\u0430", null, null, null, classNames.toString(), Font.getFont((int)0, (int)0, (int)8), 0)};
            Command[] commands = new Command[]{this.getCommandBack()};
            result = this.screenAboutApplication = new Form("\u041e \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0438", null, commands, (CommandListener)this, items, null);
        }
        return result;
    }

    private Displayable getScreenAboutImplementation() {
        Form result = this.screenAboutImplementation;
        if (result == null) {
            Font font = Font.getFont((int)0, (int)0, (int)8);
            Item[] itemArray = new Item[4];
            itemArray[0] = new StringItem(512, -1, -1, null, null, null, null, "\u0420\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u0441\u043f\u0435\u0446\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 Mobile Information Device Profile \u0434\u043b\u044f \u041c\u0430\u043b\u0438\u043a \u042d\u043c\u0443\u043b\u044f\u0442\u043e\u0440\u0430 \u043e\u0442 \u041c\u0430\u043b\u0438\u043a \u0420\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430\n\u0412\u0435\u0440\u0441\u0438\u044f: " + System.getProperty("software.version") + "\n\u041f\u0440\u043e\u0444\u0438\u043b\u044c: " + System.getProperty("microedition.profiles") + "\n\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f: " + System.getProperty("microedition.configuration"), Font.getFont((int)0, (int)0, (int)0), 0);
            this.itemLibraryList = new StringItem(512, -1, -1, "\u041f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u0430 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u043e\u0432 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0439", null, null, null, "MIDP 2.1 (JSR-120)\nMMAPI 1.2 (JSR-135)\nWMA 1.1 (JSR-118)", font, 0);
            itemArray[1] = this.itemLibraryList;
            itemArray[2] = new StringItem(0, -1, -1, "\u0412\u0430\u0436\u043d\u044b\u0435 \u043a\u043b\u0430\u0441\u0441\u044b", null, null, null, String.valueOf(MIDletProxy.getInstance().getClass().getCanonicalName()) + "\n" + this.getClass().getCanonicalName(), font, 0);
            itemArray[3] = new StringItem(0, -1, -1, "\u041b\u0438\u0446\u0435\u043d\u0437\u0438\u0438", null, null, null, "GNU LGPL 3\nZLib", font, 0);
            Item[] items = itemArray;
            Command[] commands = new Command[]{this.getCommandBack()};
            result = this.screenAboutImplementation = new Form("\u041e\u0431 \u044d\u0442\u043e\u0439 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 J2ME", null, commands, (CommandListener)this, items, null);
            this.onAboutImplementationScreenShow();
        }
        return result;
    }

    private Displayable getScreenError(Throwable cause) {
        String name = cause.getClass().getCanonicalName();
        String message = cause.getRealMessage();
        String text = message == null ? name : String.valueOf(message) + "\n\n\u2013 " + name;
        Form result = this.screenError;
        if (result == null) {
            Item[] items = new Item[]{new StringItem(0, -1, -1, null, null, null, null, text, Font.getFont((int)0, (int)0, (int)8), 0)};
            Command[] commands = new Command[]{this.getCommandExit()};
            result = this.screenError = new Form("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f", null, commands, (CommandListener)this, items, null);
        } else {
            ((StringItem)result.get(0)).setText(text);
        }
        return result;
    }

    private Displayable getScreenExit() {
        Alert result = this.screenExit;
        if (result == null) {
            Command[] commands = new Command[]{this.getCommandNo()};
            result = this.screenExit = new Alert("\u0412\u044b\u0445\u043e\u0434 \u0438\u0437 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f", null, commands, this.getCommandYes(), (CommandListener)this, "\u0412\u044b\u0439\u0442\u0438 \u0438\u0437 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f " + this.midletName + "?\n\u0412\u0441\u0435 \u043d\u0435\u0441\u043e\u0445\u0440\u0430\u043d\u0451\u043d\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u0431\u0443\u0434\u0443\u0442 \u043f\u043e\u0442\u0435\u0440\u044f\u043d\u044b.", null, AlertType.WARNING, null);
        }
        return result;
    }
}

