/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.midp.console;

import javax.microedition.lcdui.MIDletProxy;
import malik.emulator.midp.ConsoleCommand;
import malik.emulator.midp.ConsoleScreen;

public class SetKeyUsedAsCommand
extends ConsoleCommand {
    private static final int[] DEVICE_KEY_CODES = new int[]{49, 50, 51, 52, 53, 54, 55, 56, 57, 42, 48, 35, 38, 36, 40, 41, 43, 37, 39, 44, 46};
    private static final String[] DEVICE_KEY_NAMES = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "*", "0", "#", "\u0432\u0432\u0435\u0440\u0445", "\u0432\u043d\u0438\u0437", "\u0432\u043b\u0435\u0432\u043e", "\u0432\u043f\u0440\u0430\u0432\u043e", "\u0432\u044b\u0431\u043e\u0440", "\u043b\u043a\u0432", "\u043f\u043a\u0432", "\u043a\u043e\u043d\u0441\u043e\u043b\u044c", "\u0432\u044b\u0445\u043e\u0434"};

    private static int getDeviceKey(String name) {
        if (name == null) {
            return 0;
        }
        int i = DEVICE_KEY_NAMES.length;
        while (i-- > 0) {
            if (!name.equals(DEVICE_KEY_NAMES[i])) continue;
            return DEVICE_KEY_CODES[i];
        }
        return 0;
    }

    private static int getComputerKey(String name) {
        return name == null ? 0 : MIDletProxy.getSystemKeyCode((String)name.toUpperCase());
    }

    public SetKeyUsedAsCommand() {
        super("\u043a\u043b\u0430\u0432\u0438\u0448\u0430", "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435:\n  \u043a\u043b\u0430\u0432\u0438\u0448\u0430\n  \u043a\u043b\u0430\u0432\u0438\u0448\u0430 <\u043a\u043b\u0430\u0432\u0438\u0448\u0430 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430>\n  \u043a\u043b\u0430\u0432\u0438\u0448\u0430 <\u043a\u043b\u0430\u0432\u0438\u0448\u0430 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430> <\u043a\u043b\u0430\u0432\u0438\u0448\u0430 \u043a\u043e\u043c\u043f\u044c\u044e\u0442\u0435\u0440\u0430>\n\u0412\u0430\u0440\u0438\u0430\u043d\u0442 \u0431\u0435\u0437 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u2013 \u0432\u044b\u0432\u043e\u0434 \u043d\u0430 \u043a\u043e\u043d\u0441\u043e\u043b\u044c \u0432\u0441\u0435\u0445 \u043a\u043b\u0430\u0432\u0438\u0448 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 \u0441 \u044d\u043a\u0432\u0438\u0432\u0430\u043b\u0435\u043d\u0442\u043d\u044b\u043c\u0438 \u043a\u043b\u0430\u0432\u0438\u0448\u0430\u043c\u0438 \u043a\u043e\u043c\u043f\u044c\u044e\u0442\u0435\u0440\u0430.\n\u0412\u0430\u0440\u0438\u0430\u043d\u0442 \u0441 \u043e\u0434\u043d\u0438\u043c \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u043e\u043c \u2013 \u0432\u044b\u0432\u043e\u0434 \u043d\u0430 \u043a\u043e\u043d\u0441\u043e\u043b\u044c \u0442\u0435\u043a\u0443\u0449\u0435\u0439 \u044d\u043a\u0432\u0438\u0432\u0430\u043b\u0435\u043d\u0442\u043d\u043e\u0439 \u043a\u043b\u0430\u0432\u0438\u0448\u0438 \u043a\u043e\u043c\u043f\u044c\u044e\u0442\u0435\u0440\u0430 \u0434\u043b\u044f \u0437\u0430\u0434\u0430\u043d\u043d\u043e\u0439 \u043a\u043b\u0430\u0432\u0438\u0448\u0438 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430.\n\u0412\u0430\u0440\u0438\u0430\u043d\u0442 \u0441 \u0434\u0432\u0443\u043c\u044f \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u0430\u043c\u0438 \u0443\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u0442 \u043d\u043e\u0432\u0443\u044e \u044d\u043a\u0432\u0438\u0432\u0430\u043b\u0435\u043d\u0442\u043d\u0443\u044e \u043a\u043b\u0430\u0432\u0438\u0448\u0443 \u043a\u043e\u043c\u043f\u044c\u044e\u0442\u0435\u0440\u0430 \u0434\u043b\u044f \u0437\u0430\u0434\u0430\u043d\u043d\u043e\u0439 \u043a\u043b\u0430\u0432\u0438\u0448\u0438 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430. \u0421\u043b\u0435\u0434\u0438\u0442\u0435 \u0437\u0430 \u0442\u0435\u043c, \u0447\u0442\u043e\u0431\u044b \u0434\u043b\u044f \u0440\u0430\u0437\u043d\u044b\u0445 \u043a\u043b\u0430\u0432\u0438\u0448 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 \u0431\u044b\u043b\u0438 \u0437\u0430\u0434\u0430\u043d\u044b \u0440\u0430\u0437\u043d\u044b\u0435 \u043a\u043b\u0430\u0432\u0438\u0448\u0438 \u043a\u043e\u043c\u043f\u044c\u044e\u0442\u0435\u0440\u0430.");
    }

    public void run(String[] arguments) {
        ConsoleScreen console = this.getConsoleScreen();
        if (console == null) {
            return;
        }
        MIDletProxy proxy = MIDletProxy.getInstance();
        int len = arguments.length;
        if (len <= 0) {
            len = DEVICE_KEY_NAMES.length;
            int i = 0;
            while (i < len) {
                console.print(DEVICE_KEY_NAMES[i]);
                console.print(" \u2013 ");
                console.print(MIDletProxy.getSystemKeyName((int)proxy.getKeyUsedAs(DEVICE_KEY_CODES[i])));
                console.println();
                ++i;
            }
            return;
        }
        if (len == 1) {
            String argument = arguments[0];
            int deviceKey = SetKeyUsedAsCommand.getDeviceKey(argument);
            if (deviceKey == 0) {
                console.print("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043a\u043b\u0430\u0432\u0438\u0448\u0430 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 ".concat(argument));
                console.println();
                return;
            }
            console.print("\u042d\u043a\u0432\u0438\u0432\u0430\u043b\u0435\u043d\u0442\u043d\u0430\u044f \u043a\u043b\u0430\u0432\u0438\u0448\u0430 \u2013 ".concat(MIDletProxy.getSystemKeyName((int)proxy.getKeyUsedAs(deviceKey))));
            console.println();
            return;
        }
        String argument = arguments[0];
        int deviceKey = SetKeyUsedAsCommand.getDeviceKey(argument);
        if (deviceKey == 0) {
            console.print("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043a\u043b\u0430\u0432\u0438\u0448\u0430 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 ".concat(argument));
            console.println();
            return;
        }
        argument = arguments[1];
        int computerKey = SetKeyUsedAsCommand.getComputerKey(argument);
        if (computerKey == 0) {
            console.print("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043a\u043b\u0430\u0432\u0438\u0448\u0430 \u043a\u043e\u043c\u043f\u044c\u044e\u0442\u0435\u0440\u0430 ".concat(argument));
            console.println();
            return;
        }
        proxy.setKeyUsedAs(deviceKey, computerKey);
    }
}

