/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.midp.protocol;

import java.io.ByteArrayOutputStream;

public class URLParser {
    public static final int EMPTY_PORT = -1;
    public static final String SEPARATOR = "://";
    protected static final int PROTOCOL = 0;
    protected static final int USER_INFO = 1;
    protected static final int HOST_NAME = 2;
    protected static final int PATH = 3;
    protected static final int QUERY = 4;
    protected int port;
    protected String[] components = new String[5];
    protected ByteArrayOutputStream data = new ByteArrayOutputStream();

    public void parse(String url) {
        int len;
        if (url == null) {
            throw new IllegalArgumentException("Connector.open: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 url \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        this.port = -1;
        String[] c = this.components;
        int i = this.components.length;
        while (i-- > 0) {
            c[i] = null;
        }
        i = this.parsePath(url, this.parseTarget(url, this.parseSeparator(url, this.parseProtocol(url, 0))));
        if (i < (len = url.length()) && url.charAt(i) == '?') {
            i = this.parseQuery(url, i);
        }
        if (i < len) {
            throw new IllegalArgumentException("Connector.open: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 url.");
        }
    }

    public int getPort() {
        return this.port;
    }

    public String getHostName() {
        String[] c = this.components;
        return this.components == null ? null : c[2];
    }

    public String getProtocol() {
        String[] c = this.components;
        return this.components == null ? null : c[0];
    }

    public String getUserInfo() {
        String[] c = this.components;
        return this.components == null ? null : c[1];
    }

    public String getPath() {
        String[] c = this.components;
        return this.components == null ? null : c[3];
    }

    public String getQuery() {
        String[] c = this.components;
        return this.components == null ? null : c[4];
    }

    protected int parseProtocol(String url, int startIndex) {
        ByteArrayOutputStream out = this.data;
        out.reset();
        int len = url.length();
        int i = startIndex;
        while (i <= len) {
            char c;
            char c2 = c = i < len ? url.charAt(i) : (char)'\u0000';
            if (!(i != startIndex || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z')) {
                throw new IllegalArgumentException("Connector.open: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 url.");
            }
            if (!(i <= startIndex || c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '+' || c == '-' || c == '.')) break;
            out.write(c);
            ++i;
        }
        this.components[0] = out.toString();
        return i;
    }

    protected int parseSeparator(String url, int startIndex) {
        int len = SEPARATOR.length();
        if (url.length() - startIndex < len) {
            throw new IllegalArgumentException("Connector.open: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 url.");
        }
        int i = startIndex;
        int j = 0;
        while (j < len) {
            if (url.charAt(i) != SEPARATOR.charAt(j)) {
                throw new IllegalArgumentException("Connector.open: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 url.");
            }
            ++i;
            ++j;
        }
        return i;
    }

    protected int parseUserInfo(String url, int startIndex) {
        ByteArrayOutputStream out = this.data;
        out.reset();
        int len = url.length();
        int i = startIndex;
        while (i <= len) {
            char c;
            char c2 = c = i < len ? url.charAt(i) : (char)'\u0000';
            if (c2 >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '-' || c == '_' || c == '.' || c == '!' || c == '~' || c == '*' || c == '\'' || c == '(' || c == ')' || c == ';' || c == ':' || c == '&' || c == '=' || c == '+' || c == '$' || c == ',') {
                out.write(c);
            } else {
                int val;
                if (c != '%') break;
                if (++i > len - 2) {
                    throw new IllegalArgumentException("Connector.open: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 url.");
                }
                if ((c = url.charAt(i++)) >= '0' && c <= '9') {
                    val = c - 48;
                } else if (c >= 'A' && c <= 'F') {
                    val = c - 55;
                } else if (c >= 'a' && c <= 'f') {
                    val = c - 87;
                } else {
                    throw new IllegalArgumentException("Connector.open: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 url.");
                }
                c = url.charAt(i);
                if (c >= '0' && c <= '9') {
                    val = val << 4 | c - 48;
                } else if (c >= 'A' && c <= 'F') {
                    val = val << 4 | c - 55;
                } else if (c >= 'a' && c <= 'f') {
                    val = val << 4 | c - 87;
                } else {
                    throw new IllegalArgumentException("Connector.open: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 url.");
                }
                out.write(val);
            }
            ++i;
        }
        this.components[1] = out.toString();
        return i;
    }

    protected int parseHostName(String url, int startIndex) {
        ByteArrayOutputStream out = this.data;
        out.reset();
        int len = url.length();
        int i = startIndex;
        while (i <= len) {
            char c;
            char c2 = c = i < len ? url.charAt(i) : (char)'\u0000';
            if (!(c2 >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '+' || c == '-') && c != '.') break;
            out.write(c);
            ++i;
        }
        this.components[2] = out.toString();
        return i;
    }

    protected int parsePort(String url, int startIndex) {
        int val = 0;
        int len = url.length();
        int i = startIndex;
        while (i <= len) {
            char c;
            char c2 = c = i < len ? url.charAt(i) : (char)'\u0000';
            if (i == startIndex && (c < '0' || c > '9')) {
                throw new IllegalArgumentException("Connector.open: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 url.");
            }
            if (i > startIndex && (c < '0' || c > '9')) break;
            if ((val = val * 10 + (c - 48)) > 65535) {
                throw new IllegalArgumentException("Connector.open: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 url.");
            }
            ++i;
        }
        this.port = val;
        return i;
    }

    protected int parsePath(String url, int startIndex) {
        ByteArrayOutputStream out = this.data;
        out.reset();
        int len = url.length();
        int i = startIndex;
        while (i <= len) {
            char c;
            char c2 = c = i < len ? url.charAt(i) : (char)'\u0000';
            if (c2 >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '-' || c == '_' || c == '.' || c == '!' || c == '~' || c == '*' || c == '\'' || c == '(' || c == ')' || c == ':' || c == '@' || c == '&' || c == '=' || c == '+' || c == '$' || c == ',' || c == ';' || c == '/') {
                out.write(c);
            } else {
                int val;
                if (c != '%') break;
                if (++i > len - 2) {
                    throw new IllegalArgumentException("Connector.open: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 url.");
                }
                if ((c = url.charAt(i++)) >= '0' && c <= '9') {
                    val = c - 48;
                } else if (c >= 'A' && c <= 'F') {
                    val = c - 55;
                } else if (c >= 'a' && c <= 'f') {
                    val = c - 87;
                } else {
                    throw new IllegalArgumentException("Connector.open: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 url.");
                }
                c = url.charAt(i);
                if (c >= '0' && c <= '9') {
                    val = val << 4 | c - 48;
                } else if (c >= 'A' && c <= 'F') {
                    val = val << 4 | c - 55;
                } else if (c >= 'a' && c <= 'f') {
                    val = val << 4 | c - 87;
                } else {
                    throw new IllegalArgumentException("Connector.open: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 url.");
                }
                out.write(val);
            }
            ++i;
        }
        this.components[3] = out.toString();
        return i;
    }

    protected int parseQuery(String url, int startIndex) {
        ByteArrayOutputStream out = this.data;
        out.reset();
        int len = url.length();
        int i = startIndex;
        while (i <= len) {
            char c;
            char c2 = c = i < len ? url.charAt(i) : (char)'\u0000';
            if (c2 >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '-' || c == '_' || c == '.' || c == '!' || c == '~' || c == '*' || c == '\'' || c == '(' || c == ')' || c == ';' || c == '/' || c == '?' || c == ':' || c == '@' || c == '&' || c == '=' || c == '+' || c == '$' || c == ',') {
                out.write(c);
            } else {
                int val;
                if (c != '%') break;
                if (++i > len - 2) {
                    throw new IllegalArgumentException("Connector.open: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 url.");
                }
                if ((c = url.charAt(i++)) >= '0' && c <= '9') {
                    val = c - 48;
                } else if (c >= 'A' && c <= 'F') {
                    val = c - 55;
                } else if (c >= 'a' && c <= 'f') {
                    val = c - 87;
                } else {
                    throw new IllegalArgumentException("Connector.open: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 url.");
                }
                c = url.charAt(i);
                if (c >= '0' && c <= '9') {
                    val = val << 4 | c - 48;
                } else if (c >= 'A' && c <= 'F') {
                    val = val << 4 | c - 55;
                } else if (c >= 'a' && c <= 'f') {
                    val = val << 4 | c - 87;
                } else {
                    throw new IllegalArgumentException("Connector.open: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 url.");
                }
                out.write(val);
            }
            ++i;
        }
        this.components[4] = out.toString();
        return i;
    }

    protected int parseTarget(String url, int startIndex) {
        int finishIndex;
        int atIndex = -1;
        int colonIndex = -1;
        int len = url.length();
        int i = startIndex;
        while (i <= len) {
            char c = i < len ? url.charAt(i) : (char)'\u0000';
            if (c == '/' || c == '?' || c == '\u0000') break;
            switch (c) {
                case '@': {
                    atIndex = i;
                    break;
                }
                case ':': {
                    colonIndex = i;
                }
            }
            ++i;
        }
        if (colonIndex < atIndex) {
            colonIndex = -1;
        }
        if (atIndex >= 0) {
            if (colonIndex >= 0) {
                if (this.parseUserInfo(url, startIndex) != atIndex || this.parseHostName(url, atIndex + 1) != colonIndex) {
                    throw new IllegalArgumentException("Connector.open: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 url.");
                }
                finishIndex = this.parsePort(url, colonIndex + 1);
            } else {
                if (this.parseUserInfo(url, startIndex) != atIndex) {
                    throw new IllegalArgumentException("Connector.open: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 url.");
                }
                finishIndex = this.parseHostName(url, atIndex + 1);
            }
        } else if (colonIndex >= 0) {
            if (this.parseHostName(url, startIndex) != colonIndex) {
                throw new IllegalArgumentException("Connector.open: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 url.");
            }
            finishIndex = this.parsePort(url, colonIndex + 1);
        } else {
            finishIndex = this.parseHostName(url, startIndex);
        }
        return finishIndex;
    }
}

