/*
 * Decompiled with CFR 0.152.
 */
package javax.bluetooth;

import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DiscoveryDevicesThread;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.DiscoveryServicesThread;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.UUID;

public class DiscoveryAgent {
    public static final int CACHED = 0;
    public static final int PREKNOWN = 1;
    public static final int LIAC = 10390272;
    public static final int GIAC = 10390323;
    public static final int NOT_DISCOVERABLE = 0;
    static final int MIN_DISCOVERABLE = 10390272;
    static final int MAX_DISCOVERABLE = 10390335;
    private boolean discoveryDevicesMode;
    private boolean discoveryServicesMode;
    private RemoteDevice[] emptyRemoteDevicesList = new RemoteDevice[0];
    private DiscoveryDevicesThread discoveryDevicesThread;
    private DiscoveryServicesThread discoveryServicesThread;
    private Object lock = new Object();

    DiscoveryAgent() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelInquiry(DiscoveryListener listener) {
        boolean result;
        if (listener == null) {
            throw new NullPointerException("DiscoveryAgent.cancelInquiry: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 listener \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Object object = this.lock;
        synchronized (object) {
            DiscoveryDevicesThread discovery = this.discoveryDevicesThread;
            result = this.discoveryDevicesMode && discovery != null && discovery.getListener() == listener;
            if (result) {
                discovery.interrupt();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelServiceSearch(int transactionID) {
        boolean result;
        Object object = this.lock;
        synchronized (object) {
            DiscoveryServicesThread discovery = this.discoveryServicesThread;
            result = this.discoveryServicesMode && discovery != null && discovery.getTransactionID() == transactionID;
            if (result) {
                discovery.interrupt();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startInquiry(int accessCode, DiscoveryListener listener) throws BluetoothStateException {
        if (accessCode < 10390272 || accessCode > 10390335) {
            throw new IllegalArgumentException("DiscoveryAgent.startInquiry: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 accessCode.");
        }
        if (listener == null) {
            throw new NullPointerException("DiscoveryAgent.startInquiry: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 listener \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.discoveryDevicesMode) {
                error = true;
            } else {
                DiscoveryDevicesThread discovery;
                this.discoveryDevicesMode = true;
                this.discoveryDevicesThread = discovery = new DiscoveryDevicesThread(this, listener);
                discovery.start();
            }
        }
        if (error) {
            throw new BluetoothStateException("DiscoveryAgent.startInquiry: \u043f\u043e\u0438\u0441\u043a bluetooth-\u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432 \u0443\u0436\u0435 \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f.");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int searchServices(int[] attributes, UUID[] uuids, RemoteDevice deviceInfo, DiscoveryListener listener) throws BluetoothStateException {
        int result;
        int i;
        int[] attrsCopy;
        int attrsLen;
        if (uuids == null) {
            throw new NullPointerException("DiscoveryAgent.searchServices: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 uuids \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (deviceInfo == null) {
            throw new NullPointerException("DiscoveryAgent.searchServices: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 deviceInfo \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (listener == null) {
            throw new NullPointerException("DiscoveryAgent.searchServices: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 listener \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (attributes == null) {
            attrsLen = -1;
        } else {
            attrsLen = attributes.length;
            if (attrsLen <= 0) {
                throw new IllegalArgumentException("DiscoveryAgent.searchServices: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 attributes \u0438\u043c\u0435\u0435\u0442 \u043d\u0443\u043b\u0435\u0432\u0443\u044e \u0434\u043b\u0438\u043d\u0443.");
            }
        }
        int uuidsLen = uuids.length;
        if (uuidsLen <= 0) {
            throw new IllegalArgumentException("DiscoveryAgent.searchServices: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 uuids \u0438\u043c\u0435\u0435\u0442 \u043d\u0443\u043b\u0435\u0432\u0443\u044e \u0434\u043b\u0438\u043d\u0443.");
        }
        if (attrsLen > 0) {
            attrsCopy = new int[attrsLen];
            Array.copy((int[])attributes, (int)0, (int[])attrsCopy, (int)0, (int)attrsLen);
        } else {
            attrsCopy = null;
        }
        int j = attrsLen;
        while (j-- > 1) {
            int attrTemp = attrsCopy[j];
            i = j;
            while (i-- > 0) {
                if (attrsCopy[i] != attrTemp) continue;
                throw new IllegalArgumentException("DiscoveryAgent.searchServices: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 attributes \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0434\u0443\u0431\u043b\u0438\u043a\u0430\u0442\u044b.");
            }
        }
        Object[] uuidsCopy = new UUID[uuidsLen];
        Array.copy((Object[])uuids, (int)0, (Object[])uuidsCopy, (int)0, (int)uuidsLen);
        j = 0;
        while (j < uuidsLen) {
            Object uuidTemp = uuidsCopy[j];
            if (uuidTemp == null) {
                throw new NullPointerException("DiscoveryAgent.searchServices: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 uuids \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043d\u0443\u043b\u0435\u0432\u044b\u0435 \u0441\u0441\u044b\u043b\u043a\u0438.");
            }
            i = j;
            while (i-- > 0) {
                if (!((UUID)uuidTemp).isRealEquals((UUID)uuidsCopy[i])) continue;
                throw new IllegalArgumentException("DiscoveryAgent.searchServices: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 uuids \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0434\u0443\u0431\u043b\u0438\u043a\u0430\u0442\u044b.");
            }
            ++j;
        }
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.discoveryServicesMode) {
                error = true;
                result = 0;
            } else {
                DiscoveryServicesThread discovery;
                this.discoveryServicesMode = true;
                result = 1;
                this.discoveryServicesThread = discovery = new DiscoveryServicesThread(this, listener, 1);
                discovery.start();
            }
        }
        if (error) {
            throw new BluetoothStateException("DiscoveryAgent.searchServices: \u043f\u043e\u0438\u0441\u043a bluetooth-\u0441\u0435\u0440\u0432\u0438\u0441\u043e\u0432 \u0443\u0436\u0435 \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f.");
        }
        return result;
    }

    public RemoteDevice[] retrieveDevices(int option) {
        if (option != 0 && option != 1) {
            throw new IllegalArgumentException("DiscoveryAgent.retrieveDevices: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 option.");
        }
        return this.emptyRemoteDevicesList;
    }

    public String selectService(UUID uuid, int security, boolean master) throws BluetoothStateException {
        if (uuid == null) {
            throw new NullPointerException("DiscoveryAgent.selectService: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 uuid \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (security != 0 && security != 1 && security != 2) {
            throw new IllegalArgumentException("DiscoveryAgent.selectService: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 security.");
        }
        throw new BluetoothStateException("DiscoveryAgent.selectService: \u0441\u0438\u0441\u0442\u0435\u043c\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u043d\u0430\u0447\u0430\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void endDevicesDiscovery() {
        Object object = this.lock;
        synchronized (object) {
            this.discoveryDevicesMode = false;
            this.discoveryDevicesThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void endServicesDiscovery() {
        Object object = this.lock;
        synchronized (object) {
            this.discoveryServicesMode = false;
            this.discoveryServicesThread = null;
        }
    }
}

