/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mid.ui;

import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectGraphicsExtension;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import malik.emulator.fileformats.graphics.ImageDecoder;
import malik.emulator.io.j2me.ImplementationManager;

public class DirectUtils {
    private static final Class DIRECT_GRAPHICS_IMPLEMENTATION;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.nokia.mid.ui.DirectGraphicsExtension");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DIRECT_GRAPHICS_IMPLEMENTATION = clazz;
    }

    public static Image createImage(int width, int height, int colorARGB) {
        Image result = Image.createImage((int)width, (int)height);
        int[] pixels = result.getBuffer().getPixels();
        int i = pixels.length;
        while (i-- > 0) {
            pixels[i] = colorARGB;
        }
        return result;
    }

    public static Image createImage(byte[] src, int offset, int length) {
        ImageDecoder decoder;
        if (src == null) {
            throw new NullPointerException("DirectUtils.createImage: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int lim = offset + length;
        int len = src.length;
        if (lim > len || lim < offset || offset > len || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("DirectUtils.createImage: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(src, offset, length);
            decoder = ImplementationManager.getImageDecoder((InputStream)stream);
            if (decoder == null) {
                throw new IllegalArgumentException("DirectUtils.createImage: \u043e\u0448\u0438\u0431\u043a\u0430 \u0434\u0435\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f.");
            }
            decoder.loadFromInputStream((InputStream)stream);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("DirectUtils.createImage: \u043e\u0448\u0438\u0431\u043a\u0430 \u0434\u0435\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f.");
        }
        if (decoder.isEmpty()) {
            throw new IllegalArgumentException("DirectUtils.createImage: \u043e\u0448\u0438\u0431\u043a\u0430 \u0434\u0435\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f.");
        }
        Image result = Image.createImage((int)decoder.getWidth(), (int)decoder.getHeight());
        int[] pixels = result.getBuffer().getPixels();
        len = pixels.length;
        Array.copy((int[])decoder.getPixels(), (int)0, (int[])pixels, (int)0, (int)len);
        if (!decoder.isAlphaSupported()) {
            int i = len;
            while (i-- > 0) {
                int n = i;
                pixels[n] = pixels[n] | 0xFF000000;
            }
        }
        return result;
    }

    public static DirectGraphics getDirectGraphics(Graphics render) {
        if (render == null) {
            throw new NullPointerException("DirectUtils.getDirectGraphics: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 render \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Object graphicsExtension = render.getExtension(DIRECT_GRAPHICS_IMPLEMENTATION);
        if (graphicsExtension != null) {
            return (DirectGraphics)graphicsExtension;
        }
        DirectGraphicsExtension result = new DirectGraphicsExtension(render);
        render.addExtension((Object)result);
        return result;
    }

    private DirectUtils() {
    }
}

