{
    TranslateApplication переводит некоторые ресурсные строки на язык приложения.

    Copyright © 2016, 2019, 2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять её и/или
    изменять её на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она может быть полезна,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЁННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <http://www.gnu.org/licenses/>.
}

unit TranslateApplication;

{$MODE DELPHI}

interface

uses
    Lang;

implementation

{%region private }
var
    TRANSLATE_LIST: AnsiString_Array2d;
{%endregion}

{%region routine }
    function translateResourceString(name, value: AnsiString; hash: int; arg: Pointer): AnsiString;
    var
        i: int;
        s: AnsiString;
    begin
        s := toLowerCase(name);
        for i := 0 to length(TRANSLATE_LIST) - 1 do begin
            if s = toLowerCase(TRANSLATE_LIST[i][0]) then begin
                result := TRANSLATE_LIST[i][1];
                exit;
            end;
        end;
        result := value;
    end;
{%endregion}

initialization {%region}
    {
        Список ресурсных строк на изменение. Каждая строка имеет вид:
        toStringArray1d(['<имя модуля>.<имя ресурсной строки>', '<желаемое значение>'])
    }
    TRANSLATE_LIST := toStringArray2d([
        toStringArray1d(['LCLStrConsts.rsMbYes', '&Да']),
        toStringArray1d(['LCLStrConsts.rsMbNo', '&Нет']),
        toStringArray1d(['LCLStrConsts.rsMbOK', 'OK']),
        toStringArray1d(['LCLStrConsts.rsMbCancel', 'Отмена']),
        toStringArray1d(['LCLStrConsts.rsMbAbort', 'Прервать']),
        toStringArray1d(['LCLStrConsts.rsMbRetry', '&Повторить']),
        toStringArray1d(['LCLStrConsts.rsMbIgnore', '&Игнорировать']),
        toStringArray1d(['LCLStrConsts.rsMbAll', '&Все']),
        toStringArray1d(['LCLStrConsts.rsMbNoToAll', 'Нет для всех']),
        toStringArray1d(['LCLStrConsts.rsMbYesToAll', 'Да для &всех']),
        toStringArray1d(['LCLStrConsts.rsMbHelp', '&Справка']),
        toStringArray1d(['LCLStrConsts.rsMbClose', '&Закрыть'])
    ]);
    setResourceStrings(translateResourceString, nil);
{%endregion}

end.

