/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package javax.bluetooth;

import java.io.*;
import javax.microedition.io.*;

public class RemoteDevice extends Object
{
	private static final int ADDRESS_LENGTH = 12;

	public static RemoteDevice getRemoteDevice(Connection connection)
			throws IOException
	{
		throw new IllegalArgumentException("RemoteDevice.getRemoteDevice: " +
				"недопустимое значение параметра connection.");
	}


	private String address;

	protected RemoteDevice(String address)
	{
		char c;
		int i;
		if(address == null)
		{
			throw new NullPointerException("RemoteDevice: " +
					"параметр address равен нулевой ссылке.");
		}
		if(address.length() != ADDRESS_LENGTH)
		{
			throw new IllegalArgumentException("RemoteDevice: " +
					"параметр address имеет недопустимую длину (может быть только " +
					ADDRESS_LENGTH + " символов).");
		}
		for(i = ADDRESS_LENGTH; i-- > 0; )
		{
			if(((c = address.charAt(i)) < '0' || c > '9') && (c < 'A' || c > 'F') &&
					(c < 'a' || c > 'f'))
			{
				throw new IllegalArgumentException("RemoteDevice: " +
						"недопустимое значение параметра address.");
			}
		}
		try
		{
			if(address.equalsIgnoreCase(LocalDevice.getLocalDevice().getBluetoothAddress()))
			{
				throw new IllegalArgumentException("RemoteDevice: " +
						"параметр address равен адресу локального устройства.");
			}
		}
		catch(BluetoothStateException e)
		{
			throw new RuntimeException("RemoteDevice: " +
					"система Bluetooth-соединений не проинициализирована.");
		}
		this.address = address;
	}

	public boolean equals(Object ref)
	{
		return ref == this || ref instanceof RemoteDevice &&
				address.equals(((RemoteDevice) ref).address);
	}

	public int hashCode()
	{
		return address.hashCode();
	}

	public boolean authenticate()
			throws IOException
	{
		return false;
	}

	public boolean authorize(Connection connection)
			throws IOException
	{
		throw new IllegalArgumentException("RemoteDevice.authorize: " +
				"недопустимое значение параметра connection.");
	}

	public boolean encrypt(Connection connection, boolean on)
			throws IOException
	{
		throw new IllegalArgumentException("RemoteDevice.encrypt: " +
				"недопустимое значение параметра connection.");
	}

	public boolean isAuthenticated()
	{
		return false;
	}

	public boolean isAuthorized(Connection connection)
			throws IOException
	{
		throw new IllegalArgumentException("RemoteDevice.isAuthorized: " +
				"недопустимое значение параметра connection.");
	}

	public boolean isEncrypted()
	{
		return false;
	}

	public boolean isTrustedDevice()
	{
		return false;
	}

	public String getFriendlyName(boolean ask)
			throws IOException
	{
		throw new IOException("RemoteDevice.getFriendlyName: " +
				"удалённое устройство недоступно.");
	}

	public final String getBluetoothAddress()
	{
		return address;
	}
}
