/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package java.io;

public class DataOutputStream extends OutputStream
		implements DataOutput
{
	public static int writeUTF(DataOutput stream, String src)
			throws IOException
	{
		int length;
		int strlen;
		int c1;
		int i;
		char[] c;
		byte[] result;
		if(stream == null)
		{
			throw new NullPointerException("DataOutputStream.writeUTF: " +
					"параметр stream равен нулевой ссылке.");
		}
		if(src == null)
		{
			throw new NullPointerException("DataOutputStream.writeUTF: " +
					"параметр src равен нулевой ссылке.");
		}
		src.getChars(0, strlen = src.length(), c = new char[strlen], 0);
		length = 0;
		for(i = strlen; i-- > 0; )
		{
			length += ((c1 = (int) c[i]) >= 0x0001 && c1 < 0x0080 ? 1 : (c1 < 0x0800 ? 2 : 3));
		}
		if(length >= 0x00010000)
		{
			throw new UTFDataFormatException("DataOutputStream.writeUTF: " +
					"размер данных, закодированных кодировкой UTF-8, не может превышать 64 КБ.");
		}
		result = new byte[length];
		length = 0;
		for(i = 0; i < strlen; i++)
		{
			if((c1 = (int) c[i]) >= 0x0001 && c1 < 0x0080)
			{
				result[length++] = (byte) c1;
				continue;
			}
			if(c1 < 0x0800)
			{
				result[length++] = (byte) (0xc0 | ((c1 >> 6) & 0x1f));
				result[length++] = (byte) (0x80 | (c1 & 0x3f));
				continue;
			}
			result[length++] = (byte) (0xe0 | ((c1 >> 12) & 0x0f));
			result[length++] = (byte) (0x80 | ((c1 >> 6) & 0x3f));
			result[length++] = (byte) (0x80 | (c1 & 0x3f));
		}
		stream.writeShort(length);
		stream.write(result, 0, length);
		return length + 2;
	}


	protected OutputStream out;

	public DataOutputStream(OutputStream stream)
	{
		this.out = stream;
	}

	public void close()
			throws IOException
	{
		out.close();
	}

	public void flush()
			throws IOException
	{
		out.flush();
	}

	public void write(int src)
			throws IOException
	{
		out.write(src);
	}

	public void write(byte[] src)
			throws IOException
	{
		out.write(src);
	}

	public void write(byte[] src, int offset, int length)
			throws IOException
	{
		out.write(src, offset, length);
	}

	public final void writeBoolean(boolean src)
			throws IOException
	{
		writeByte(src ? 1 : 0);
	}

	public final void writeChar(int src)
			throws IOException
	{
		writeShort(src);
	}

	public final void writeFloat(float src)
			throws IOException
	{
		writeInt(Float.floatToIntBits(src));
	}

	public final void writeDouble(double src)
			throws IOException
	{
		writeLong(Double.doubleToLongBits(src));
	}

	public final void writeByte(int src)
			throws IOException
	{
		write(src);
	}

	public final void writeShort(int src)
			throws IOException
	{
		write(src >> 8);
		write(src);
	}

	public final void writeInt(int src)
			throws IOException
	{
		write(src >> 24);
		write(src >> 16);
		write(src >> 8);
		write(src);
	}

	public final void writeLong(long src)
			throws IOException
	{
		write((int) (src >> 56));
		write((int) (src >> 48));
		write((int) (src >> 40));
		write((int) (src >> 32));
		write((int) (src >> 24));
		write((int) (src >> 16));
		write((int) (src >> 8));
		write((int) src);
	}

	public final void writeUTF(String src)
			throws IOException
	{
		writeUTF(this, src);
	}

	public final void writeChars(String src)
			throws IOException
	{
		int i;
		int len;
		if(src == null)
		{
			throw new NullPointerException("DataOutputStream.writeChars: " +
					"параметр src равен нулевой ссылке.");
		}
		for(len = src.length(), i = 0; i < len; i++)
		{
			writeShort((int) src.charAt(i));
		}
	}
}
