/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package malik.emulator.i18n;

import java.io.*;

public abstract class StreamReader extends Reader
{
    InputStream stream;

    protected StreamReader() {
        super(null);
    }

    protected StreamReader(Object lock) {
        super(lock);
    }

    public abstract int read(char[] dst, int offset, int length) throws IOException;

    public void close() throws IOException {
        InputStream stream;
        if((stream = this.stream) != null)
        {
            this.stream = null;
            stream.close();
        }
    }

    public boolean ready() throws IOException {
        InputStream stream;
        return (stream = this.stream) != null && stream.available() > 0;
    }

    protected final InputStream getInputStream() throws IOException {
        InputStream result;
        if((result = stream) == null)
        {
            throw new IOException("InputStreamReader: символьный поток ввода закрыт.");
        }
        return result;
    }

    final Reader setInputStream(InputStream stream) {
        this.stream = stream;
        return this;
    }
}
