/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package javax.microedition.lcdui;

import malik.emulator.application.*;

public abstract class CustomBackgroundScreen extends Displayable
{
    protected static final byte ALL = Displayable.ALL;
    protected static final byte NONE = Displayable.NONE;
    protected static final byte PANEL = Displayable.PANEL;
    protected static final byte CLIENT = Displayable.CLIENT;
    protected static final byte TITLE = Displayable.TITLE;
    protected static final byte TICKER = Displayable.TICKER;

    protected CustomBackgroundScreen(String title) {
        super(title, null, false);
    }

    protected CustomBackgroundScreen(String title, Ticker ticker, boolean fullScreen) {
        super(title, ticker, fullScreen);
    }

    public void setFullScreenMode(boolean fullScreen) {
        super.setFullScreenMode(fullScreen);
    }

    public boolean isFullScreenMode() {
        return super.isFullScreenMode();
    }

    public int getWidth() {
        return getTotalWidth();
    }

    public int getHeight() {
        return getClientHeight();
    }

    protected abstract void paintBackground(Graphics render, int width, int height, byte visibleElements, byte drawingElements);

    protected abstract void paintTicker(Graphics render, int width, int height, Ticker ticker);

    protected abstract void paintTitle(Graphics render, int width, int height, String title);

    protected abstract void paintClient(Graphics render, int width, int height);

    protected abstract void paintPanel(Graphics render, int width, int height, Command[] commands, int pressedCommandIndex);

    protected abstract int getPanelCommandIndex(int x, int y, int width, int height);

    protected float getTickerScroll() {
        return super.getTickerScroll();
    }

    protected int getTickerHeight() {
        return super.getTickerHeight();
    }

    protected int getTitleHeight() {
        return super.getTitleHeight();
    }

    protected int getPanelHeight() {
        return super.getPanelHeight();
    }

    protected Font getTickerFont() {
        return super.getTickerFont();
    }

    protected Font getTitleFont() {
        return super.getTitleFont();
    }

    protected Font getNormalCommandFont() {
        return super.getNormalCommandFont();
    }

    protected Font getDefaultCommandFont() {
        return super.getDefaultCommandFont();
    }

    protected void showNotify() {
    }

    protected void hideNotify() {
    }

    protected void keyboardNotify(KeyboardEvent event) {
    }

    protected void pointerNotify(PointerEvent event) {
    }

    protected void commandNotify(Command command) {
    }

    protected final void repaint() {
        requestPaint(CLIENT);
    }

    protected final void repaint(int clipLeft, int clipTop, int clipWidth, int clipHeight) {
        requestPaintClient(clipLeft, clipTop, clipWidth, clipHeight);
    }

    protected final void repaint(byte elements) {
        requestPaint(elements);
    }

    protected final void repaintAll() {
        requestPaintAll();
    }

    protected final void serviceRepaints() {
        servicePaint();
    }

    void paint(ScreenGraphics render) {
        paintClient(render, getTotalWidth(), getClientHeight());
    }

    void paintBackground(ScreenGraphics render, int width, int height, byte visibleElements, byte drawingElements) {
        paintBackground((Graphics) render, width, height, visibleElements, drawingElements);
    }

    void paintTicker(ScreenGraphics render, int width, int height, Ticker ticker) {
        paintTicker((Graphics) render, width, height, ticker);
    }

    void paintTitle(ScreenGraphics render, int width, int height, String title) {
        paintTitle((Graphics) render, width, height, title);
    }

    void paintPanel(ScreenGraphics render, int width, int height, Command[] commands, int pressedCommandIndex) {
        paintPanel((Graphics) render, width, height, commands, pressedCommandIndex);
    }

    void onShow() {
        showNotify();
    }

    void onHide() {
        hideNotify();
    }

    void onCommandAction(Command command) {
        try
        {
            commandNotify(command);
        }
        catch(RuntimeException e)
        {
            e.printRealStackTrace();
        }
        super.onCommandAction(command);
    }

    boolean onKeyboardEvent(KeyboardEvent event) {
        if(!super.onKeyboardEvent(event)) keyboardNotify(event);
        return true;
    }

    boolean onPointerEvent(PointerEvent event) {
        if(!super.onPointerEvent(event))
        {
            int ty = 0;
            int elements;
            if(((elements = getElements()) & TICKER) != 0) ty += getTickerHeight();
            if((elements & TITLE) != 0) ty += getTitleHeight();
            event.translate(0, ty);
            pointerNotify(event);
        }
        return true;
    }

    int getCommandIndexAt(int x, int y, int panelWidth, int panelHeight) {
        return getPanelCommandIndex(x, y, panelWidth, panelHeight);
    }
}
