/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package javax.microedition.lcdui;

public class Spacer extends Item
{
    private long minimumSize;

    public Spacer(int minimumWidth, int minimumHeight) {
        if(minimumWidth < 0)
        {
            throw new IllegalArgumentException("Spacer: аргумент minimumWidth не может быть отрицательным.");
        }
        if(minimumHeight < 0)
        {
            throw new IllegalArgumentException("Spacer: аргумент minimumHeight не может быть отрицательным.");
        }
        this.minimumSize = (long) minimumHeight << 32 | (long) minimumWidth;
    }

    public void addCommand(Command command) {
        throw new IllegalStateException("Spacer.addCommand: команды не поддерживаются этим элементом.");
    }

    public void setDefaultCommand(Command command) {
        throw new IllegalStateException("Spacer.setDefaultCommand: команды не поддерживаются этим элементом.");
    }

    public void setLabel(String label) {
        throw new IllegalStateException("Spacer.setLabel: метка не поддерживается этим элементом.");
    }

    public void setMinimumSize(int minimumWidth, int minimumHeight) {
        if(minimumWidth < 0)
        {
            throw new IllegalArgumentException("Spacer.setMinimumSize: аргумент minimumWidth не может быть отрицательным.");
        }
        if(minimumHeight < 0)
        {
            throw new IllegalArgumentException("Spacer.setMinimumSize: аргумент minimumHeight не может быть отрицательным.");
        }
        this.minimumSize = (long) minimumHeight << 32 | (long) minimumWidth;
        requestInvalidate();
    }

    void paint(Graphics render, int contentWidth, int contentHeight) {
    }

    int getMinimumContentWidth() {
        return (int) minimumSize;
    }

    int getMinimumContentHeight() {
        return (int) (minimumSize >> 32);
    }

    int getPreferredContentWidth(int contentHeight) {
        return 0;
    }

    int getPreferredContentHeight(int contentWidth) {
        return 0;
    }
}
