/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package javax.microedition.media.protocol;

import java.io.*;
import javax.microedition.media.*;

public abstract class DataSource extends Object implements Controllable
{
    private final String locator;

    public DataSource(String locator) {
        this.locator = locator;
    }

    public abstract Control[] getControls();

    public abstract Control getControl(String controlTypeName);

    public abstract void connect() throws IOException;

    public abstract void disconnect();

    public abstract void start() throws IOException;

    public abstract void stop() throws IOException;

    public abstract SourceStream[] getStreams();

    public abstract String getContentType();

    public String getLocator() {
        return locator;
    }
}
