/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package malik.emulator.io.cloud;

import malik.emulator.io.vfs.*;

final class CloudFileEnumerator extends FileEnumerator
{
	private int handle;
	private char[] fileName;
	private FileInfoDescriptor descriptor;

	CloudFileEnumerator(int handle, char[] fileName, FileInfoDescriptor descriptor)
	{
		setFileInfo(fileName, descriptor);
		this.handle = handle;
		this.fileName = fileName;
		this.descriptor = descriptor;
	}

	public void close()
	{
		int h;
		synchronized(descriptor)
		{
			if((h = handle) != 0)
			{
				MalikSystem.syscall((long) h, 0x001a);
				handle = 0;
			}
		}
	}

	public boolean findNext()
	{
		boolean result;
		int h;
		FileInfoDescriptor descriptor;
		synchronized(descriptor = this.descriptor)
		{
			label0:
			{
				if((h = handle) == 0 || ((int) MalikSystem.syscall(h,
						descriptor.getDescriptorAddress(), 0x0019)) == 0)
				{
					result = false;
					break label0;
				}
				setFileInfo(fileName, descriptor);
				result = true;
			}
		}
		return result;
	}

	protected void $finalize$()
	{
		close();
	}

	private void setFileInfo(char[] fileName, FileInfoDescriptor descriptor)
	{
		setFileInfo(
				CloudFileSystem.computeTime(descriptor.creationTime),
				CloudFileSystem.computeTime(descriptor.lastAccessTime),
				CloudFileSystem.computeTime(descriptor.lastWriteTime),
				descriptor.attributes, descriptor.size,
				new String(fileName, 0, Array.findf(fileName, 0, '\0')));
	}
}
