﻿/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package malik.emulator.i18n.encoding;

import malik.emulator.i18n.*;

public abstract class OneByteCodec extends Object
		implements Codec
{
	protected OneByteCodec()
	{
	}

	public final char[] decode(byte[] src, int offset, int length)
	{
		int i;
		int j;
		char[] result = new char[length];
		for(j = offset + length, i = length; i-- > 0; )
		{
			j--;
			result[i] = (char) decode(src[j] & 0xff);
		}
		return result;
	}

	public final byte[] encode(char[] src, int offset, int length)
	{
		int i;
		int j;
		byte[] result = new byte[length];
		for(j = offset + length, i = length; i-- > 0; )
		{
			j--;
			result[i] = (byte) encode((int) src[j]);
		}
		return result;
	}

	protected abstract int decode(int byteValue);

	protected abstract int encode(int charCode);
}
