/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package javax.microedition.lcdui;

import javax.microedition.media.*;
import malik.emulator.io.cloud.*;

public class AlertType extends Object
{
	public static final AlertType ALARM;
	public static final AlertType CONFIRMATION;
	public static final AlertType ERROR;
	public static final AlertType INFO;
	public static final AlertType WARNING;

	static
	{
		ALARM = new AlertTypeSystem(getIcon("/ui/icon_alarm.png"),
				getSound("/ui/sound_alarm.wav"));
		CONFIRMATION = new AlertTypeSystem(getIcon("/ui/icon_confirmation.png"),
				getSound("/ui/sound_confirmation.wav"));
		ERROR = new AlertTypeSystem(getIcon("/ui/icon_error.png"),
				getSound("/ui/sound_error.wav"));
		INFO = new AlertTypeSystem(getIcon("/ui/icon_info.png"),
				getSound("/ui/sound_info.wav"));
		WARNING = new AlertTypeSystem(getIcon("/ui/icon_warning.png"),
				getSound("/ui/sound_warning.wav"));
	}

	private static Image getIcon(String fileName)
	{
		Image result = null;
		FileInputStream stream = new FileInputStream(fileName);
		try
		{
			if(stream.hasOpenError())
			{
				return null;
			}
			try
			{
				result = Image.createImage(stream);
			}
			finally
			{
				stream.close();
			}
		}
		catch(Exception e)
		{
			e.printRealStackTrace();
		}
		return result;
	}

	private static Player getSound(String fileName)
	{
		Player result = null;
		FileInputStream stream = new FileInputStream(fileName);
		try
		{
			if(stream.hasOpenError())
			{
				return null;
			}
			try
			{
				result = Manager.createPlayer(stream, "audio/x-wav");
			}
			finally
			{
				stream.close();
			}
		}
		catch(Exception e)
		{
			e.printRealStackTrace();
		}
		return result;
	}


	private boolean system;
	private Player sound;
	private Image icon;

	protected AlertType()
	{
	}

	AlertType(boolean system, Image icon, Player sound)
	{
		this.system = system;
		this.sound = sound;
		this.icon = icon;
	}

	public boolean playSound(Display display)
	{
		boolean result;
		Player sound;
		if(display == null)
		{
			throw new NullPointerException("AlertType.playSound: " +
					"параметр display равен нулевой ссылке.");
		}
		result = false;
		if(display.isClientInForeground() && (sound = this.sound) != null)
		{
			try
			{
				sound.start();
				result = true;
			}
			catch(MediaException e)
			{
				e.printRealStackTrace();
			}
		}
		return result;
	}

	final boolean isSystem()
	{
		return system;
	}

	final Image getIcon()
	{
		return icon;
	}
}
