/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package javax.microedition.lcdui;

import malik.emulator.media.graphics.*;

public class GraphicsClipRestricted extends Graphics
{
	private boolean restricted;
	private int left;
	private int top;
	private int width;
	private int height;

	GraphicsClipRestricted(GraphicBuffer buffer)
	{
		super(buffer);
		this.width = buffer.getWidth();
		this.height = buffer.getHeight();
	}

	GraphicsClipRestricted(RasterCanvas canvas)
	{
		super(canvas);
		this.width = canvas.getWidth();
		this.height = canvas.getHeight();
	}

	public void reset()
	{
		super.reset();
		RasterCanvas canvas;
		restricted = false;
		left = 0;
		top = 0;
		width = (canvas = getCanvas()).getWidth();
		height = canvas.getHeight();
	}

	public void setClip(int left, int top, int width, int height)
	{
		super.setClip(left, top, width, height);
		if(restricted)
		{
			clipRect(this.left - getTranslateX(), this.top - getTranslateY(), this.width, this.height);
		}
	}

	public void restrictClipRect(int left, int top, int width, int height)
	{
		int absLeft = left + getTranslateX();
		int absTop = top + getTranslateY();
		int clipLeft = this.left;
		int clipTop = this.top;
		int clipWidth = this.width;
		int clipHeight = this.height;
		this.restricted = true;
		this.width = Math.min(absLeft + width, clipLeft + clipWidth) -
				(this.left = Math.max(absLeft, clipLeft));
		this.height = Math.min(absTop + height, clipTop + clipHeight) -
				(this.top = Math.max(absTop, clipTop));
		clipRect(left, top, width, height);
	}
}
