/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package javax.microedition.lcdui.game;

import javax.microedition.lcdui.*;

public abstract class GameCanvas extends Canvas
{
	public static final int UP_PRESSED = 0x0002;
	public static final int LEFT_PRESSED = 0x0004;
	public static final int RIGHT_PRESSED = 0x0020;
	public static final int DOWN_PRESSED = 0x0040;
	public static final int FIRE_PRESSED = 0x0100;
	public static final int GAME_A_PRESSED = 0x0200;
	public static final int GAME_B_PRESSED = 0x0400;
	public static final int GAME_C_PRESSED = 0x0800;
	public static final int GAME_D_PRESSED = 0x1000;


	private Image offScreenBuffer;

	protected GameCanvas(boolean suppressKeyEvents)
	{
		super(false, suppressKeyEvents);
		Display display = MIDletProxy.getInstance().getEmulatorScreen();
		this.offScreenBuffer = Image.createImage(display.getWidth(), display.getHeight());
	}

	public void paint(Graphics render)
	{
		render.drawImage(offScreenBuffer, 0, 0, 0);
	}

	public void flushGraphics()
	{
		MIDletProxy.getInstance().getEmulatorScreen().flushGraphics(this, offScreenBuffer,
				0, 0, super.getWidth(), super.getHeight());
	}

	public void flushGraphics(int left, int top, int width, int height)
	{
		MIDletProxy.getInstance().getEmulatorScreen().flushGraphics(this, offScreenBuffer,
				left, top, width, height);
	}

	public int getKeyStates()
	{
		return keyStates;
	}

	protected Graphics getGraphics()
	{
		return offScreenBuffer.getGraphics();
	}
}
