/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package malik.emulator.midp;

import java.lang.ref.*;
import javax.microedition.lcdui.*;

public class FormSettings extends Form
{
	private static final class HelpButtonsListener extends WeakReference
			implements ItemCommandListener
	{
		HelpButtonsListener(FormSettings thisScreen)
		{
			super(thisScreen);
		}

		public void commandAction(Command command, Item item)
		{
			FormSettings thisScreen;
			if((thisScreen = (FormSettings) get()) == null || command != List.SELECT_COMMAND)
			{
				return;
			}
			if(item == thisScreen.helpShowButton)
			{
				thisScreen.showHelp();
				return;
			}
			if(item == thisScreen.helpHideButton)
			{
				thisScreen.hideHelp();
			}
		}
	}

	private static Item[] concatItems(Item item1, Item item2, Item[] items, Item item3, Item item4)
	{
		int len;
		int alen = items != null ? items.length : 0;
		Item[] result = new Item[len = alen + 4];
		if(alen > 0)
		{
			Array.copy(items, 0, result, 2, alen);
		}
		result[0] = item1;
		result[1] = item2;
		result[len - 2] = item3;
		result[len - 1] = item4;
		return result;
	}


	private boolean helpVisible;
	private Item helpSeparator;
	private StringItem helpShowButton;
	private StringItem helpHideButton;
	private StringItem helpContents;
	private StringItem applyButton;
	private StringItem backButton;

	public FormSettings(String title, Ticker ticker, Command[] commands, CommandListener listener,
			String helpContents, Item[] items, ItemCommandListener buttonListener,
			ItemStateListener itemListener)
	{
		super(title, ticker, commands, listener, concatItems(
						new StringItem(Item.LAYOUT_LEFT | Item.LAYOUT_NEWLINE_AFTER, -1, -1,
								null, null, List.SELECT_COMMAND, null,
								"Показать справку >", null, Item.BUTTON),
						new Spacer(Item.LAYOUT_NEWLINE_AFTER, 1, 16), items,
						new StringItem(Item.LAYOUT_NEWLINE_BEFORE | Item.LAYOUT_RIGHT, -1, -1,
								null, null, List.SELECT_COMMAND, buttonListener,
								"Применить", null, Item.BUTTON),
						new StringItem(Item.LAYOUT_RIGHT, -1, -1,
								null, null, List.SELECT_COMMAND, buttonListener,
								"Назад", null, Item.BUTTON)
				), itemListener);
		int len;
		ItemCommandListener helpListener = new HelpButtonsListener(this);
		StringItem helpShowButton = (StringItem) super.get(0);
		Font helpFont = Font.getFont(Font.FACE_SYSTEM, Font.STYLE_PLAIN, Font.SIZE_SMALL);
		helpShowButton.setItemCommandListener(helpListener);
		this.helpSeparator = super.get(1);
		this.helpShowButton = helpShowButton;
		this.helpHideButton = new StringItem(Item.LAYOUT_RIGHT | Item.LAYOUT_NEWLINE_AFTER,
				-1, -1, null, null, List.SELECT_COMMAND, helpListener, "< Скрыть справку", null,
				Item.BUTTON);
		this.helpContents = new StringItem(Item.LAYOUT_NEWLINE_AFTER, -1, -1, "Справка", null,
				null, null, helpContents, helpFont, Item.BUTTON);
		this.applyButton = (StringItem) super.get((len = super.size()) - 2);
		this.backButton = (StringItem) super.get(len - 1);
	}

	public void set(int itemIndex, Item item)
	{
		super.set(itemIndex < 0 || itemIndex >= super.size() - 4 ? -1 : itemIndex + 2, item);
	}

	public void insert(int itemIndex, Item item)
	{
		super.insert(itemIndex < 0 || itemIndex > super.size() - 4 ? -1 : itemIndex + 2, item);
	}

	public void delete(int itemIndex)
	{
		super.delete(itemIndex < 0 || itemIndex >= super.size() - 4 ? -1 : itemIndex + 2);
	}

	public void deleteAll()
	{
		super.deleteAll();
		if(helpVisible)
		{
			super.append(helpContents);
			super.append(helpHideButton);
		} else
		{
			super.append(helpShowButton);
			super.append(helpSeparator);
		}
		super.append(applyButton);
		super.append(backButton);
	}

	public int append(Item item)
	{
		int result = super.size() - 4;
		super.insert(result + 2, item);
		return result;
	}

	public int append(Image image)
	{
		int result = super.size() - 4;
		super.insert(result + 2,
				new ImageItem(null, image, Item.LAYOUT_DEFAULT, null, Item.PLAIN));
		return result;
	}

	public int append(String text)
	{
		int result = super.size() - 4;
		super.insert(result + 2, new StringItem(null, text, Item.PLAIN));
		return result;
	}

	public int size()
	{
		return super.size() - 4;
	}

	public Item get(int itemIndex)
	{
		return super.get(itemIndex < 0 || itemIndex >= super.size() - 4 ? -1 : itemIndex + 2);
	}

	public void setButtonListener(ItemCommandListener buttonListener)
	{
		this.applyButton.setItemCommandListener(buttonListener);
		this.backButton.setItemCommandListener(buttonListener);
	}

	public void setHelpContents(String helpContents)
	{
		this.helpContents.setText(helpContents);
	}
	
	public StringItem getApplyButton()
	{
		return applyButton;
	}

	public StringItem getBackButton()
	{
		return backButton;
	}
	
	public String getHelpContents()
	{
		return helpContents.getText();
	}

	protected void sizeChanged(int width, int height)
	{
		int w1;
		int w2;
		Item btn1 = applyButton;
		Item btn2 = backButton;
		if((w1 = btn1.getPreferredWidth()) == (w2 = btn2.getPreferredWidth()))
		{
			return;
		}
		else if(w1 > w2)
		{
			btn2.setPreferredSize(w1, -1);
			return;
		}
		else
		{
			btn1.setPreferredSize(w2, -1);
			return;
		}
	}

	private void showHelp()
	{
		super.set(0, helpContents);
		super.set(1, helpHideButton);
	}

	private void hideHelp()
	{
		super.set(0, helpShowButton);
		super.set(1, helpSeparator);
	}
}
