/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package malik.emulator.midp;

import java.io.*;
import java.lang.ref.*;
import javax.microedition.lcdui.*;

public final class SystemConsole extends ConsoleScreen
{
	private static final class Printer extends WeakReference
			implements PrintListener
	{
		private int color;
		
		Printer(ConsoleScreen thisScreen, int color)
		{
			super(thisScreen);
			this.color = color;
		}
		
		public void write(byte[] src, int offset, int length)
		{
			ConsoleScreen thisScreen;
			if((thisScreen = (ConsoleScreen) get()) != null)
			{
				thisScreen.setColor(color);
				thisScreen.write(src, offset, length);
			}
		}
		
		public void print(char src)
		{
			ConsoleScreen thisScreen;
			if((thisScreen = (ConsoleScreen) get()) != null)
			{
				thisScreen.setColor(color);
				thisScreen.print(src);
			}
		}
		
		public void print(char[] src)
		{
			ConsoleScreen thisScreen;
			if((thisScreen = (ConsoleScreen) get()) != null)
			{
				thisScreen.setColor(color);
				thisScreen.print(src);
			}
		}
		
		public void print(String src)
		{
			ConsoleScreen thisScreen;
			if((thisScreen = (ConsoleScreen) get()) != null)
			{
				thisScreen.setColor(color);
				thisScreen.print(src);
			}
		}
		
		public void println()
		{
			ConsoleScreen thisScreen;
			if((thisScreen = (ConsoleScreen) get()) != null)
			{
				thisScreen.setColor(color);
				thisScreen.println();
			}
		}
	}

	private static final int OUT_COLOR = 0x00c000;
	private static final int ERR_COLOR = 0xff4040;


	private boolean greeted;
	private boolean doubleOutput;
	private PrintListener outListener;
	private PrintListener errListener;

	SystemConsole(String title, CommandListener listener)
	{
		super(title, listener);
		PrintListener outListener = new Printer(this, OUT_COLOR);
		PrintListener errListener = new Printer(this, ERR_COLOR);
		System.out.addPrintListener(outListener);
		System.err.addPrintListener(errListener);
		this.doubleOutput = true;
		this.outListener = outListener;
		this.errListener = errListener;
	}

	public void printHelp()
	{
		setColor(OUT_COLOR);
		print("Этим цветом");
		setColor(getOutputColor());
		print(" печатается то, что было выведено приложением через System.out\n");
		setColor(ERR_COLOR);
		print("Этим цветом");
		setColor(getOutputColor());
		print(" печатается то, что было выведено приложением через System.err\n");
		super.printHelp();
	}

	public void setDoubleOutput(boolean doubleOutput)
	{
		if(this.doubleOutput = doubleOutput)
		{
			System.out.addPrintListener(outListener);
			System.err.addPrintListener(errListener);
		} else
		{
			System.out.removePrintListener(outListener);
			System.err.removePrintListener(errListener);
		}
	}

	public boolean isDoubleOutput()
	{
		return doubleOutput;
	}

	public int getWidth()
	{
		return super.getWidth();
	}

	public int getHeight()
	{
		return super.getHeight();
	}

	protected void $finalize$()
	{
		System.out.removePrintListener(outListener);
		System.err.removePrintListener(errListener);
	}

	protected void onShow()
	{
		super.onShow();
		if(!greeted)
		{
			greeted = true;
			setColor(DEFAULT_OUTPUT_COLOR);
			print("Добро пожаловать в " + super.getTitle() +
					"!\nВведите команду «?» на консоли, чтобы увидеть список доступных команд.\n");
		}
	}
}
