/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package malik.emulator.midp.console;

import javax.microedition.lcdui.*;
import malik.emulator.midp.*;

public class SetKeyUsedAsCommand extends ConsoleCommand
{
	private static final int[] DEVICE_KEY_CODES;
	private static final String[] DEVICE_KEY_NAMES;

	static
	{
		DEVICE_KEY_CODES = new int[] {
				MIDletProxy.DEVICE_KEY_1,
				MIDletProxy.DEVICE_KEY_2,
				MIDletProxy.DEVICE_KEY_3,
				MIDletProxy.DEVICE_KEY_4,
				MIDletProxy.DEVICE_KEY_5,
				MIDletProxy.DEVICE_KEY_6,
				MIDletProxy.DEVICE_KEY_7,
				MIDletProxy.DEVICE_KEY_8,
				MIDletProxy.DEVICE_KEY_9,
				MIDletProxy.DEVICE_KEY_STAR,
				MIDletProxy.DEVICE_KEY_0,
				MIDletProxy.DEVICE_KEY_POUND,
				MIDletProxy.DEVICE_KEY_UP,
				MIDletProxy.DEVICE_KEY_DOWN,
				MIDletProxy.DEVICE_KEY_LEFT,
				MIDletProxy.DEVICE_KEY_RIGHT,
				MIDletProxy.DEVICE_KEY_SELECT,
				MIDletProxy.DEVICE_KEY_SOFT1,
				MIDletProxy.DEVICE_KEY_SOFT2,
				MIDletProxy.DEVICE_KEY_CONSOLE,
				MIDletProxy.DEVICE_KEY_EXITAPP
		};
		DEVICE_KEY_NAMES = new String[] {
				"1", "2", "3", "4", "5", "6", "7", "8", "9", "*", "0", "#",
				"вверх", "вниз", "влево", "вправо", "выбор", "лкв", "пкв", "консоль", "выход"
		};
	}

	private static int getDeviceKey(String name)
	{
		int i;
		if(name == null)
		{
			return 0;
		}
		for(i = DEVICE_KEY_NAMES.length; i-- > 0; )
		{
			if(name.equals(DEVICE_KEY_NAMES[i]))
			{
				return DEVICE_KEY_CODES[i];
			}
		}
		return 0;
	}

	private static int getComputerKey(String name)
	{
		return name == null ? 0 : MIDletProxy.getSystemKeyCode(name.toUpperCase());
	}


	public SetKeyUsedAsCommand()
	{
		super("клавиша",
				"Использование:\n" +
				"  клавиша\n" +
				"  клавиша <клавиша устройства>\n" +
				"  клавиша <клавиша устройства> <клавиша компьютера>\n" +
				"Вариант без аргументов – вывод на консоль всех клавиш устройства с " +
				"эквивалентными клавишами компьютера.\n" +
				"Вариант с одним аргументом – вывод на консоль текущей эквивалентной клавиши " +
				"компьютера для заданной клавиши устройства.\n" +
				"Вариант с двумя аргументами устанавливает новую эквивалентную клавишу " +
				"компьютера для заданной клавиши устройства. Следите за тем, чтобы для " +
				"разных клавиш устройства были заданы разные клавиши компьютера.");
	}

	public void run(String[] arguments)
	{
		int i;
		int len;
		int deviceKey;
		int computerKey;
		ConsoleScreen console;
		MIDletProxy proxy;
		String argument;
		if((console = getConsoleScreen()) == null)
		{
			return;
		}
		proxy = MIDletProxy.getInstance();
		if((len = arguments.length) <= 0)
		{
			/* Вывод на консоль всех клавиш устройства с эквивалентными клавишами компьютера. */
			for(len = DEVICE_KEY_NAMES.length, i = 0; i < len; i++)
			{
				console.print(DEVICE_KEY_NAMES[i]);
				console.print(" – ");
				console.print(MIDletProxy.getSystemKeyName(
						proxy.getKeyUsedAs(DEVICE_KEY_CODES[i])));
				console.println();
			}
			return;
		}
		if(len == 1)
		{
			/* Вывод на консоль текущей эквивалентной клавиши компьютера для заданной клавиши
			 * устройства. */
			if((deviceKey = getDeviceKey(argument = arguments[0])) == 0)
			{
				console.print("Неизвестная клавиша устройства ".concat(argument));
				console.println();
				return;
			}
			console.print("Эквивалентная клавиша – ".concat(MIDletProxy.getSystemKeyName(
					proxy.getKeyUsedAs(deviceKey))));
			console.println();
			return;
		}
		/* Установка новой эквивалентной клавиши компьютера для заданной клавиши устройства. */
		if((deviceKey = getDeviceKey(argument = arguments[0])) == 0)
		{
			console.print("Неизвестная клавиша устройства ".concat(argument));
			console.println();
			return;
		}
		if((computerKey = getComputerKey(argument = arguments[1])) == 0)
		{
			console.print("Неизвестная клавиша компьютера ".concat(argument));
			console.println();
			return;
		}
		proxy.setKeyUsedAs(deviceKey, computerKey);
	}
}
