/*
	Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
	и других спецификаций для функционирования компактных приложений на языке
	Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

	Copyright © 2016, 2019 Малик Разработчик

	Это свободная программа: вы можете перераспространять ее и/или изменять
	ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
	в каком она была опубликована Фондом свободного программного обеспечения;
	либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

	Эта программа распространяется в надежде, что она будет полезной,
	но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
	или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
	общественной лицензии GNU.

	Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
	вместе с этой программой. Если это не так, см.
	<https://www.gnu.org/licenses/>.
*/


package com.nokia.mid.ui;

import javax.microedition.lcdui.*;

public abstract class FullCanvas extends Canvas
{
	public static final int KEY_UP_ARROW = -1;
	public static final int KEY_DOWN_ARROW = -2;
	public static final int KEY_LEFT_ARROW = -3;
	public static final int KEY_RIGHT_ARROW = -4;
	public static final int KEY_SOFTKEY3 = -5;
	public static final int KEY_SOFTKEY1 = -6;
	public static final int KEY_SOFTKEY2 = -7;
	public static final int KEY_SEND = -10;
	public static final int KEY_END = -11;


	protected FullCanvas()
	{
		super(true, false);
	}

	public void addCommand(Command command)
	{
		throw new IllegalStateException("FullCanvas.addCommand: " +
				"полноэкранная канва не поддерживает добавление команд.");
	}

	public void setCommandListener(CommandListener listener)
	{
		throw new IllegalStateException("FullCanvas.setCommandListener: " +
				"полноэкранная канва не поддерживает добавление команд.");
	}

	protected abstract void paint(Graphics render);
}
