/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package java.io;

import malik.emulator.util.*;

public abstract class Reader extends Object
{
    protected Object lock;

    protected Reader() {
        this.lock = this;
    }

    protected Reader(Object lock) {
        this.lock = lock;
    }

    public abstract void close() throws IOException;

    public abstract int read(char[] dst, int offset, int length) throws IOException;

    public void reset() throws IOException {
        throw new IOException((new StringBuilder()).append("Reader.reset: класс ").append(getClass().getName()).append(" не поддерживает метод reset.").toString());
    }

    public void mark(int readLimit) throws IOException {
        throw new IOException((new StringBuilder()).append("Reader.mark: класс ").append(getClass().getName()).append(" не поддерживает метод mark.").toString());
    }

    public boolean markSupported() {
        return false;
    }

    public boolean ready() throws IOException {
        return false;
    }

    public int read() throws IOException {
        char[] buf;
        return read(buf = new char[1], 0, 1) == 1 ? buf[0] : -1;
    }

    public int read(char[] dst) throws IOException {
        return read(dst, 0, dst == null ? 0 : dst.length);
    }

    public long skip(long quantity) throws IOException {
        long result;
        long remaining;
        char[] buf;
        if(quantity < 0L)
        {
            throw new IllegalArgumentException("Reader.skip: аргумент quantity не может быть отрицательным.");
        }
        if(quantity == 0L) return 0L;
        for(buf = new char[0x0100], remaining = quantity, result = 0L; result < quantity; )
        {
            long readed;
            try
            {
                if((readed = (long) read(buf, 0, remaining < 0x0100L ? (int) remaining : 0x0100)) < 0L) break;
            }
            catch(IOException e)
            {
                if(result > 0L) break;
                throw e;
            }
            remaining -= readed;
            result += readed;
        }
        return result;
    }
}
