/*
    Реализация спецификаций CLDC версии 1.1 (JSR-139), MIDP версии 2.1 (JSR-118)
    и других спецификаций для функционирования компактных приложений на языке
    Java (мидлетов) в среде программного обеспечения Малик Эмулятор.

    Copyright © 2016–2017, 2019–2022 Малик Разработчик

    Это свободная программа: вы можете перераспространять ее и/или изменять
    ее на условиях Меньшей Стандартной общественной лицензии GNU в том виде,
    в каком она была опубликована Фондом свободного программного обеспечения;
    либо версии 3 лицензии, либо (по вашему выбору) любой более поздней версии.

    Эта программа распространяется в надежде, что она будет полезной,
    но БЕЗО ВСЯКИХ ГАРАНТИЙ; даже без неявной гарантии ТОВАРНОГО ВИДА
    или ПРИГОДНОСТИ ДЛЯ ОПРЕДЕЛЕННЫХ ЦЕЛЕЙ. Подробнее см. в Меньшей Стандартной
    общественной лицензии GNU.

    Вы должны были получить копию Меньшей Стандартной общественной лицензии GNU
    вместе с этой программой. Если это не так, см.
    <https://www.gnu.org/licenses/>.
*/

package java.io;

public abstract class Writer extends Object
{
    protected Object lock;

    protected Writer() {
        this.lock = this;
    }

    protected Writer(Object lock) {
        this.lock = lock;
    }

    public abstract void close() throws IOException;

    public abstract void flush() throws IOException;

    public abstract void write(char[] src, int offset, int length) throws IOException;

    public void write(int charData) throws IOException {
        write(new char[] { (char) charData }, 0, 1);
    }

    public void write(char[] src) throws IOException {
        write(src, 0, src == null ? 0 : src.length);
    }

    public void write(String string) throws IOException {
        char[] c;
        if(string == null) return;
        write(c = string.toCharArray(), 0, c.length);
    }

    public void write(String string, int offset, int length) throws IOException {
        long bounds;
        char[] c;
        if(string == null) return;
        offset = (int) (bounds = Array.intersectBound(string.length(), offset, length));
        length = (int) (bounds >> 32);
        string.getChars(offset, offset + length, c = new char[length], 0);
        write(c, 0, length);
    }
}
